<!-- Copyright (c) 2005-2009 by Cisco Systems, Inc. -->
// discover.js for cbs31x0 devices 


function INFERION1G(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/inferion1_6.gif";
	drawLeds_1G(dev) ;
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 186;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 14 internal ports
	for(i=0; i<14; i++) {
		
		if(i%2 == 0) {
			yPortCoord = 31;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    	}
	//add 4 gig rj45 ports	
	xPortCoord = 350;
	yPortCoord = 42;
	xPortGap = 5;
	for(var i=14; i<18; i++) 
	{
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += portWidth + xPortGap;
	}
	
	//this code for for stack ports
	xPortCoord=476;
	for(i=18;i<20;i++){
		if(i%2==0){
		yPortCoord=38;	
		port=new top.stackPort(portvimg);
		}
		else{
		yPortCoord=53;	
		port=new top.stackPort(portvimg);
		}
		port.index=i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);	
	}
	var lbl = new top.label(110,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
function drawLeds_1G(dev) {
		
        // Create System LEDs
		var ledImages1=top.ledImages();
        var ledImages = top.hbportImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 79;
        tempLed.y = 17;
		tempLed.width=10;
		tempLed.height=9;
        tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;
		
		// Create the Mode Btn
        var modeBtn = new top.modebtn("/images/hb_mode_small.gif");
        modeBtn.x = 100;
        modeBtn.y = 58;
        modeBtn.height = 9;
        modeBtn.width = 9;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;
		//create master led
		var tempLed = new top.led(ledImages);
        tempLed.x = 100;
        tempLed.y = 17;
		tempLed.width=10;
		tempLed.height=9;
        tempLed.id = "master_led";
        tempLed.device = dev;
	    dev.sysleds["MASTER"] = tempLed;
		
		tempLed = new top.led(ledImages);
	 	tempLed.x = 79;
		tempLed.y = 40;
		tempLed.width = 10;
		tempLed.height = 9;
		tempLed.id = "stack_led";
		tempLed.device = dev;
		dev.sysleds["STACK"] = tempLed;
      	
		// Create Fa0 LED
	    tempLed = new top.led(ledImages1);
		tempLed.x = 71;
		tempLed.y = 74;
		
		tempLed.id = "fa_0";
		tempLed.device = dev;
		tempLed.showPopup = true;
		dev.sysleds["FA0"] = tempLed;

}
function INFERION10G(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/inferion10_6.gif";
	drawLeds_10G(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 186;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	 //Add the 14 internal ports.
	for(i=0; i<14; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 31;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 45;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==13) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
		}
	//Code  x2 port
	var intNames = new Array();
	var portInd =14;
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
	}
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/15") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 367;
		yPortCoord = 41;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		portInd+=1;
		addLabel_inferion(dev, 1);
	}
	else if(interfaces.indexOf("0/15") != -1) { //when hamm module is present
		xPortCoord = 367;
		for(var i=14; i<16; i++) {
			yPortCoord = 41;
			xPortGap = 1;
			portWidth = 21;
			port = new top.SFPport(int_status[portInd][6], portImages);
			port.index = portInd;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + portInd;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
			portInd++;
		}
		addLabel_inferion(dev, 15, 16);
	}
	
	//add two stack ports	
   xPortCoord=476;
	//ports are displayed in reverse order - 2 at top and 1 at bottom, so start from 1
	for(var i=1;i<3;i++){
		
		if(i%2!=0){
		yPortCoord=38;	
		port=new top.stackPort(portvimg);
		}
		else{
		yPortCoord=53;	
		port=new top.stackPort(portvimg);
		}
		port.index=portInd; //i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + portInd; //i;
		dev.addPort(port);
		portInd++;
	}
	var lbl = new top.label(110,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
function drawLeds_10G(dev) {
		
        // Create System LEDs
		var ledImages1=top.ledImages();
        var ledImages = top.hbportImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 79;
        tempLed.y = 17;
		tempLed.width=10;
		tempLed.height=9;
        tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;
		
		// Create the Mode Btn
        var modeBtn = new top.modebtn("/images/hb_mode_small.gif");
        modeBtn.x = 100;
        modeBtn.y = 58;
        modeBtn.height = 9;
        modeBtn.width = 9;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;
		//create master led
		
        var tempLed = new top.led(ledImages);
        tempLed.x = 100;
        tempLed.y = 17;
		tempLed.width=10;
		tempLed.height=9;
        tempLed.id = "master_led";
        tempLed.device = dev;
	    dev.sysleds["MASTER"] = tempLed;
		
		tempLed = new top.led(ledImages);
	 	tempLed.x = 79;
		tempLed.y = 40;
		tempLed.width=10;
		tempLed.height=9;
		tempLed.id = "stack_led";
		tempLed.device = dev;
		dev.sysleds["STACK"] = tempLed;
		
		// Create Fa0 LED
	    tempLed = new top.led(ledImages1);
		tempLed.x =72;
		tempLed.y =74;
		tempLed.id = "fa_0";
		tempLed.device = dev;
		tempLed.showPopup = true;
		dev.sysleds["FA0"] = tempLed;
    

}
function HYPERION1G(int_status, media_type){
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/Hyperion1_4.gif";
	drawLeds_HYP1G(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 144;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 18 internal ports
	for(i=0; i<18; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 23;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 38;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	//Code  add four sfp ports	
	xPortCoord = 340;
	xPortGap = 1;
	portWidth = 21;
	for(i=18;i<20;i++){	
			yPortCoord = 34;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	xPortCoord = 392;
	for(i=20;i<22;i++){	
			yPortCoord = 34;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	//end sfp ports
	//add four gig rj45 ports
	xPortCoord =452;
	
	for(var i=22; i<26; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =17;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =33;		
		port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth+xPortGap-2) ;
		}
		dev.addPort(port);
	}
	
	//add two stack ports	
	xPortCoord=504;	
	for(var i=26;i<28;i++){
		if(i%2==0){
			yPortCoord=38;
		    port=new top.stackPort(portvimg);
		}	
		else{
			yPortCoord=53;
		    port=new top.stackPort(portvimg);
		}	
		port.index=i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
	}
	var lbl = new top.label(10,-2,300,20);
	lbl.color="BLACK";
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","STACK");	
	return dev;
}
function HYPERION1G_CISCO(int_status, media_type){
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/Hyperion1_4_cisco.gif";
	drawLeds_HYP1G(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 144;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 18 internal ports
	for(i=0; i<18; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 23;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 38;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	//Code  add four sfp ports	
	xPortCoord = 340;
	xPortGap = 1;
	portWidth = 21;
	for(i=18;i<20;i++){	
			yPortCoord = 34;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	xPortCoord = 392;
	for(i=20;i<22;i++){	
			yPortCoord = 34;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	//end sfp ports
	//add four gig rj45 ports
	xPortCoord =452;
	
	for(var i=22; i<26; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =17;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =33;		
		port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth+xPortGap-2) ;
		}
		dev.addPort(port);
	}
	
	//add two stack ports	
	xPortCoord=504;	
	for(var i=26;i<28;i++){
		if(i%2==0){
			yPortCoord=38;
		    port=new top.stackPort(portvimg);
		}	
		else{
			yPortCoord=53;
		    port=new top.stackPort(portvimg);
		}	
		port.index=i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
	}
	var lbl = new top.label(10,-2,300,20);
	lbl.color="BLACK";
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","STACK");	
	return dev;
}
function HYPERION10G(int_status, media_type){
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/Hyperion10_4.gif";
	drawLeds_HYP1G(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 144;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	
	//add 18 internal ports
	for(i=0; i<18; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 23;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 37;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	//add the ports for x2/sfp modules
	var intNames = new Array();
	var portInd = 18;
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/19") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 340;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 33;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,19,20);
	}
	
	if (interfaces.indexOf("0/21") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 391;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 33;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,21,22);
	}
	
	
	xPortCoord =452;
	
	for(var i=22; i<26; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =17;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =33;		
		port = new top.rj45port(portImages);
		}
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		if(i%2 != 0) {
			xPortCoord += 20 ;
		}
		portInd+=1;
		dev.addPort(port);
	}
	
	if (interfaces.indexOf("0/19") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 340;
		yPortCoord = 33;
		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/21") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 391;
		yPortCoord = 33;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		portInd+=1;
		addLabel(dev,2);
	}
	//add two stack ports
	
	xPortCoord=504;	
	for(var i=26;i<28;i++){
		if(i%2==0){
			yPortCoord=38;
		    port=new top.stackPort(portvimg);
		}	
		else{
			yPortCoord=53;
		    port=new top.stackPort(portvimg);
		}	
		port.index=portInd;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + portInd;
		portInd+=1;
		dev.addPort(port);
	}
	var lbl = new top.label(10,-2,300,20);
	lbl.color="BLACK";
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","STACK");	
	return dev;
}
function HYPERION10G_CISCO(int_status, media_type){
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/Hyperion10_4_cisco.gif";
	drawLeds_HYP1G(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 144;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	
	//add 18 internal ports
	for(i=0; i<18; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 23;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 37;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	//add the ports for x2/sfp modules
	var intNames = new Array();
	var portInd = 18;
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/19") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 340;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 33;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,19,20);
	}
	
	if (interfaces.indexOf("0/21") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 391;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 33;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel(dev,21,22);
	}
	
	
	xPortCoord =452;
	
	for(var i=22; i<26; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =17;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =33;		
		port = new top.rj45port(portImages);
		}
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		if(i%2 != 0) {
			xPortCoord += 20 ;
		}
		portInd+=1;
		dev.addPort(port);
	}
	
	if (interfaces.indexOf("0/19") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 340;
		yPortCoord = 33;
		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		addLabel(dev,1);
		portInd+=1;
	}
	if (interfaces.indexOf("0/21") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 391;
		yPortCoord = 33;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		portInd+=1;
		addLabel(dev,2);
	}
	//add two stack ports
	
	xPortCoord=504;	
	for(var i=26;i<28;i++){
		if(i%2==0){
			yPortCoord=38;
		    port=new top.stackPort(portvimg);
		}	
		else{
			yPortCoord=53;
		    port=new top.stackPort(portvimg);
		}	
		port.index=portInd;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + portInd;
		portInd+=1;
		dev.addPort(port);
	}
	var lbl = new top.label(10,-2,300,20);
	lbl.color="BLACK";
	lbl.id = "lbl0";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","STACK");	
	return dev;
}
function drawLeds_HYP1G(dev) {
		
        // Create System LEDs
		var ledImages1=top.ledImages();
        var ledImages = top.ledImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 37;
        tempLed.y = 28;
		tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;
		
		// Create the Mode Btn
        var modeBtn = new top.modebtn("/images/hb_mode.gif");
        modeBtn.x = 59;
        modeBtn.y = 51;
        modeBtn.height = 18;
        modeBtn.width = 18;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;
		//create master led
		
        var tempLed = new top.led(ledImages);
        tempLed.x = 37;
        tempLed.y = 44;
		tempLed.id = "master_led";
        tempLed.device = dev;
	    dev.sysleds["MASTER"] = tempLed;
				
		tempLed = new top.led(ledImages);
	 	tempLed.x = 37;
		tempLed.y = 36;
		tempLed.id = "stack_led";
		tempLed.device = dev;
		dev.sysleds["STACK"] = tempLed;
		
		ledImages = top.hbportImages();
		tempLed = new top.led(ledImages);
        tempLed.x = 64;
        tempLed.y = 15;
        tempLed.width = 9;
        tempLed.height = 9;
        tempLed.id = "uid_led";
        tempLed.device = dev;
        dev.sysleds["UID"] = tempLed;

        tempLed = new top.led(ledImages);
        tempLed.x = 64;
        tempLed.y = 40;
        tempLed.width = 9;
        tempLed.height = 9;
        tempLed.id = "health_led";
        tempLed.device = dev;
        dev.sysleds["HEALTH"] = tempLed;
		
		// Create Fa0 LED
	    tempLed = new top.led(ledImages1);
		tempLed.x = 123;
		tempLed.y = 73;
		tempLed.id = "fa_0";
		tempLed.device = dev;
		tempLed.showPopup = true;
		dev.sysleds["FA0"] = tempLed;
}
function DELPHINIUM10G(int_status, media_type)
{
   var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/delphinium10_2.gif";
	drawLeds_DELPH(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 145;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 18 internal ports
	for(i=0; i<16; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 24;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 38;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	xPortCoord =330;
	
	for(var i=16; i<20; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =22;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =39;		
		port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += 20 ;
		}
		portInd+=1;
		dev.addPort(port);
	}
	//add the ports for x2/sfp modules
	var intNames = new Array();
	var portInd = 20;
	var pos=0;
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
	}
	
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/21") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 389;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 40;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel_delphinium(dev,21,22);
	}
	
	if (interfaces.indexOf("0/23") != -1)
	{
		// Add the 2 sfp ports
		xPortCoord = 441;
		xPortGap = 1;
		portWidth = 21;
		for(i=portInd; i<portInd+2; i++) 
		{       
			yPortCoord = 40;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
		}
		portInd+=2;
		addLabel_delphinium(dev,23,24);
	}
	

	
	if (interfaces.indexOf("0/21") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 389;
		yPortCoord = 40;
		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		portInd+=1;
		addLabel_delphinium(dev,1);
		
	}
		if (interfaces.indexOf("0/23") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 441;
		yPortCoord = 40;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		portInd+=1;
		addLabel_delphinium(dev,2);
		
	}
	//add two stack ports
		
		
	xPortCoord=500;	
	for(var i=24;i<26;i++){
		if(i%2==0){
			yPortCoord=32;
		    port=new top.stackPort(portvimg);
		}	
		else{
			yPortCoord=47;
		    port=new top.stackPort(portvimg);
		}	
		port.index=portInd;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + portInd;
		portInd+=1;
		dev.addPort(port);
	}
	var lbl = new top.label(70,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","STACK");	
	return dev;
	}
function DELPHINIUM1G(int_status, media_type)
{
   var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/delphinium1_2.gif";
	drawLeds_DELPH(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();	
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 145;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 18 internal ports
	for(i=0; i<16; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 24;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 38;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	xPortCoord =330;
	
	for(var i=16; i<20; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =22;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =39;		
		port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += 20 ;
		}
		dev.addPort(port);
	}
	xPortCoord = 389;
	xPortGap = 1;
	portWidth = 21;
	for(i=20;i<22;i++){	
			yPortCoord = 39;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	xPortCoord = 441;
	for(i=22;i<24;i++){	
			yPortCoord = 39;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	//add two stack ports
		
		
	xPortCoord=500;	
	for(var i=24;i<26;i++){
		if(i%2==0){
			yPortCoord=29;
		    port=new top.stackPort(portvimg);
		}	
		else{
			yPortCoord=44;
		    port=new top.stackPort(portvimg);
		}	
		port.index=i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
	}
	var lbl = new top.label(70,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED","STACK");	
	return dev;
}	
function DELPHINIUM1_NONSTACK(int_status, media_type)
{
   var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/delphinium1_2_Nonstack.gif";
	drawLeds_DELPH_NONSTACK(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portImages1=top.rj45portInvImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();	
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 145;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 18 internal ports
	for(i=0; i<16; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 24;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 38;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
	}
	xPortCoord =330;
	
	for(var i=16; i<20; i++) 
	{
		
		if(i%2==0) {
		yPortCoord =22;	
		port = new top.rj45port(portImages1);
		}
		else{
		yPortCoord =39;		
		port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += 20 ;
		}
		dev.addPort(port);
	}
	xPortCoord = 389;
	xPortGap = 1;
	portWidth = 21;
	for(i=20;i<22;i++){	
			yPortCoord = 39;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	xPortCoord = 441;
	for(i=22;i<24;i++){	
			yPortCoord = 39;		
			port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
	}
	var lbl = new top.label(70,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl); 
		dev.modeAliases = new Array ("STATUS","DUPLEX","SPEED");	
	return dev;
}
function drawLeds_DELPH_NONSTACK(dev){
		
        // Create System LEDs
		var ledImages1= top.hbportImages();
        var ledImages = top.ledImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 88;
        tempLed.y = 50;
		tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;
		
		// Create the Mode Btn
        var modeBtn = new top.modebtn("/images/hb_mode.gif");
        modeBtn.x = 42;
        modeBtn.y = 27;
        modeBtn.height = 18;
        modeBtn.width = 18;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;
		
      
		// Create Fa0 LED
	    tempLed = new top.led(ledImages);
		tempLed.x = 133;
		tempLed.y = 72;
		tempLed.id = "fa_0";
		tempLed.device = dev;
		tempLed.showPopup = true;
		dev.sysleds["FA0"] = tempLed;
		
		//power led
		var tempLed = new top.led(ledImages1);
		tempLed.x = 14;
		tempLed.y = 4;
		tempLed.width=10;
		tempLed.height=9;
		tempLed.id = "power_led";
		tempLed.device = dev;
		dev.sysleds["POWER"] = tempLed;
		//Dell status led
		var tempLed = new top.led(ledImages1);
		tempLed.x = 14;
		tempLed.y = 18;
		tempLed.width=10;
		tempLed.height=9;
		tempLed.id = "dellstatus_led";
		tempLed.device = dev;
		dev.sysleds["DELLSTATUS"] = tempLed;
}			
function drawLeds_DELPH(dev){
		
        // Create System LEDs
		var ledImages1= top.hbportImages();
		var ledImages = top.ledImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 94;
        tempLed.y = 25;
		tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;
		
		// Create the Mode Btn
        var modeBtn = new top.modebtn("/images/hb_mode.gif");
        modeBtn.x = 42;
        modeBtn.y = 27;
        modeBtn.height = 18;
        modeBtn.width = 18;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;
		//create master led
		
        var tempLed = new top.led(ledImages);
        tempLed.x = 94;
        tempLed.y = 41;
		tempLed.id = "master_led";
        tempLed.device = dev;
	    dev.sysleds["MASTER"] = tempLed;
				
		tempLed = new top.led(ledImages);
	 	tempLed.x = 94;
		tempLed.y = 33;
		tempLed.id = "stack_led";
		tempLed.device = dev;
		dev.sysleds["STACK"] = tempLed;
				
		// Create Fa0 LED
	    tempLed = new top.led(ledImages);
		tempLed.x = 133;
		tempLed.y = 72;
		tempLed.id = "fa_0";
		tempLed.device = dev;
		tempLed.showPopup = true;
		dev.sysleds["FA0"] = tempLed;
		//power led
		var tempLed = new top.led(ledImages1);
		tempLed.x = 14;
		tempLed.y = 4;
		tempLed.width=10;
		tempLed.height=9;
		tempLed.id = "power_led";
		tempLed.device = dev;
		dev.sysleds["POWER"] = tempLed;
		//Dell status led
		var tempLed = new top.led(ledImages1);
		tempLed.x = 14;
		tempLed.y = 18;
		tempLed.width=10;
		tempLed.height=9;
		tempLed.id = "dellstatus_led";
		tempLed.device = dev;
		dev.sysleds["DELLSTATUS"] = tempLed;
}		
function INFERION1G_TELCO(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/inferion1_6_Telco.gif";
	drawLeds_1G(dev) ;
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 215;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 14 internal ports
	for(i=0; i<8; i++) {
		
		if(i%2 == 0) {
			yPortCoord = 30;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    	}
	//add 4 gig rj45 ports	
	xPortCoord = 350;
	yPortCoord = 42;
	xPortGap = 5;
	for(var i=8; i<12; i++) 
	{
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += portWidth + xPortGap;
	}
	
	//this code for for stack ports
	xPortCoord=476;
	for(i=12;i<14;i++){
		if(i%2==0){
		yPortCoord=38;	
		port=new top.stackPort(portvimg);
		}
		else{
		yPortCoord=53;	
		port=new top.stackPort(portvimg);
		}
		port.index=i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);	
	}
	var lbl = new top.label(110,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
function INFERION10G_TELCO(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/inferion10_6_Telco.gif";
	drawLeds_10G(dev);
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portximages=top.fxportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 215;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	 //Add the 14 internal ports.
	for(i=0; i<8; i++) {
		if(i%2 == 0) {
			
			yPortCoord = 30;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==7) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
		}
	//Code  x2 port
	var intNames = new Array();
	var portInd =8;
	for (i=0; i< int_status.length; i++)
	{
		intNames[i] = int_status[i][0];
	}
	var interfaces = "#"+intNames.join('#')+"#";
	if (interfaces.indexOf("0/9") == -1)
	{
		
		// Add the 1 10G X2 module
		xPortCoord = 367;
		yPortCoord = 41;		
		port = new top.tenGbSFPport(int_status[portInd][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		portInd+=1;
		addLabel_inferion(dev,1);
	}
	else if(interfaces.indexOf("0/9") != -1) { //when hamm module is present
		xPortCoord = 367;
		for(var i=8; i<10; i++) {
			yPortCoord = 41;
			xPortGap = 1;
			portWidth = 21;
			port = new top.SFPport(int_status[portInd][6], portImages);
			port.index = portInd;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + portInd;
			xPortCoord += (portWidth + xPortGap);
			dev.addPort(port);
			portInd++;
		}
		addLabel_inferion(dev,9,10);
	}
	
	//add two stack ports	
   xPortCoord=476;
	for(var i=1;i<3;i++){
		
		if(i%2!=0){
		yPortCoord=38;	
		port=new top.stackPort(portvimg);
		}
		else{
		yPortCoord=53;	
		port=new top.stackPort(portvimg);
		}
		port.index=portInd; //i;
		port.x=xPortCoord;
		port.y=yPortCoord;
		port.id = "port_" + portInd; //i;
		dev.addPort(port);
		portInd++;
	}
	var lbl = new top.label(110,0,400,15);
	lbl.color="WHITE";
	lbl.id = "lbl0";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
//Code for Dagger BCE
function DAGGER(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/dagger_bce.gif";
	drawLeds_Dagger(dev) ;
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 230;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 14 internal ports
	for(var i=0;i<14;i++) {
		if(i%2 == 0) {
			yPortCoord = 20;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 34;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    	}
	//add 4 gig rj45 ports	
	xPortCoord = 415;
	yPortCoord = 29;
	xPortGap = 5;
	for(var i=14; i<18; i++) 
	{
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += portWidth + xPortGap;
	}
	var lbl = new top.label(390,68,200,5);
	lbl.color="WHITE";
	lbl.id = "dev_id";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);

	var slot_lbl = new top.label(100,0,420,15);
	slot_lbl.color="WHITE";
	slot_lbl.id = "lbl1";
	slot_lbl.fontsize = "7pt";
	dev.addLabel(slot_lbl); 

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}
//Code for Dagger BCT
function DAGGER_TELCO(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/dagger_bct.gif";
	drawLeds_Dagger(dev) ;
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 214;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 8 internal ports
	for(var i=0;i<8;i++) {
		if(i%2 == 0) {
			yPortCoord = 30;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    	}
	//add 4 gig rj45 ports	
	xPortCoord = 350;
	yPortCoord = 42;
	xPortGap = 5;
	for(var i=8; i<12; i++) 
	{
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += portWidth + xPortGap;
	}
	var lbl = new top.label(390,68,200,5);
	lbl.color="WHITE";
	lbl.id = "dev_id";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}
//Code for Dagger BCS
function DAGGER_BCS(int_status, media_type) {
	var dev = new top.device();
	dev.x=0;
	dev.y=0;
	dev.image = "images/dagger_bcs.gif";
	drawLeds_Dagger(dev) ;
	// Create the ports
	var port;
	var portWidth = 15;
	var portImages = top.rj45portImages();
	var portInvImages = top.internalportImages();
	var portvimg=top.stackPortImages();
	var xPortGap = 5;
	var xPortGroupGap = 6;
	var xPortStartPos = 214;
	var xPortCoord = xPortStartPos;
	var yPortCoord;
	//add 6 internal ports
	for(var i=0;i<6;i++) {		
		if(i%2 == 0) {
			yPortCoord = 30;
			port = new top.internalport(portInvImages);
		} else {
			yPortCoord = 44;
			port = new top.internalport(portInvImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		dev.addPort(port);
    	}
	//add 4 gig rj45 ports	
	xPortCoord = 350;
	yPortCoord = 42;
	xPortGap = 5;
	for(var i=6; i<10; i++) 
	{
		port = new top.rj45port(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		xPortCoord += portWidth + xPortGap;
	}
	var lbl = new top.label(390,68,200,5);
	lbl.color="WHITE";
	lbl.id = "dev_id";
	lbl.fontsize = "7pt";
	dev.addLabel(lbl);
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}
//Led Construction for dagger
function drawLeds_Dagger(dev) {
		
        // Create System LEDs
		var ledImages1=top.ledImages();
        var ledImages = top.hbportImages();
        var tempLed = new top.led(ledImages);
        tempLed.x = 79;
        tempLed.y = 17;
		tempLed.width=10;
		tempLed.height=9;
        tempLed.id = "system_led";
        tempLed.device = dev;
	    dev.sysleds["SYSTEM"] = tempLed;
		
		// Create the Mode Btn
        var modeBtn = new top.modebtn("/images/hb_mode_small.gif");
        modeBtn.x = 97;
        modeBtn.y = 58;
        modeBtn.height = 9;
        modeBtn.width = 9;
        modeBtn.id = "CHGESM_mode";
        modeBtn.device = dev;
        dev.modebtn = modeBtn;
				     	
		// Create Fa0 LED
	    tempLed = new top.led(ledImages1);
		tempLed.x = 71;
		tempLed.y = 74;
		tempLed.id = "fa_0";
		tempLed.device = dev;
		tempLed.showPopup = true;
		dev.sysleds["FA0"] = tempLed;
		
		//Fault
		tempLed = new top.led(ledImages);
        tempLed.x = 79;
        tempLed.y = 40;
		tempLed.width=10;
		tempLed.height=9;
        tempLed.id = "Falult_led";
        tempLed.device = dev;
	    dev.sysleds["FAULT"] = tempLed;
}		
function addLabel( dev, label1, label2 )
{
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(360,24, 2, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(411, 24, 3, 5, image1);
	        	portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 19:
			// Adding the top port label1
		        var portlbl = new top.portLabel(347, 24, 6, 5, image1);
	        	portlbl.id = "portlbl1";
		        dev.addPortLabel(portlbl);

		        // Adding the top port label2
		        var portlbl2 = new top.portLabel(368,24, 7, 5, image2);
	        	portlbl2.id = "portlbl2";
		        dev.addPortLabel(portlbl2);
			break;
		case 21:
		        // Adding the bottom port label1
		        var portlbl3 = new top.portLabel(399, 24, 6, 5, image1);
		        portlbl3.id = "portlbl3";
		        dev.addPortLabel(portlbl3);

		        // Adding the bottom port label2
		        var portlbl4 = new top.portLabel(421, 24, 7, 5, image2);
		        portlbl4.id = "portlbl4";
		        dev.addPortLabel(portlbl4);
	}
}

function addLabel_inferion( dev, label1, label2 ) {
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(386,32, 2, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 9:
			// Adding the ten gb port label2
			var portlbl = new top.portLabel(375, 32, 3, 5, image1);
	        portlbl.id = "portlbl1";
		    dev.addPortLabel(portlbl);

		    // Adding the top port label2
		    var portlbl2 = new top.portLabel(396,32, 6, 5, image2);
	       	portlbl2.id = "portlbl2";
		    dev.addPortLabel(portlbl2);
			break;
		case 15:
			// Adding the ten gb port label2
			var portlbl = new top.portLabel(375, 32, 6, 5, image1);
	        portlbl.id = "portlbl1";
		    dev.addPortLabel(portlbl);

		    // Adding the top port label2
		    var portlbl2 = new top.portLabel(396,32, 6, 5, image2);
	       	portlbl2.id = "portlbl2";
		    dev.addPortLabel(portlbl2);
			break;
	}
}
function addLabel_delphinium( dev, label1, label2 )
{	
	var image1 = "images/port_label_"+label1+".gif";
	var image2= "";
	if (label2 != null ) image2= "images/port_label_"+label2+".gif";
	switch (label1)
	{
		case 1:
			
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(409,29, 2, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(460, 29, 3, 5, image1);
	        	portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 21:
			// Adding the left port label1
		        var portlbl = new top.portLabel(397, 29, 6, 5, image1);
	        	portlbl.id = "portlbl1";
		        dev.addPortLabel(portlbl);

		        // Adding the right port label2
		        var portlbl2 = new top.portLabel(419,29, 7, 5, image2);
	        	portlbl2.id = "portlbl2";
		        dev.addPortLabel(portlbl2);
			break;
		case 23:
		        // Adding the left port label1
		        var portlbl3 = new top.portLabel(449, 29, 7, 5, image1);
		        portlbl3.id = "portlbl3";
		        dev.addPortLabel(portlbl3);

		        // Adding the right port label2
		        var portlbl4 = new top.portLabel(471, 29, 7, 5, image2);
		        portlbl4.id = "portlbl4";
		        dev.addPortLabel(portlbl4);
	}
}
function createDevice(int_status, media_type, deviceType) {
	
	var device = null;
	if(deviceType == null)
		return device;	
	
	if(deviceType == "WS-CBS3110G-S" || deviceType == "WS-CBS3110G-S-I") {
		device = new INFERION1G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3110";
	}
	else if(deviceType == "WS-CBS3110X-S" || deviceType == "WS-CBS3110X-S-I"){
		device = new INFERION10G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3110";
	}
	else if(deviceType == "WS-CBS3110G-S-TEL" || deviceType == "WS-CBS3110G-S-I-TEL"){
		device = new INFERION1G_TELCO(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3110";
	}
	else if(deviceType == "WS-CBS3110X-S-TEL" || deviceType == "WS-CBS3110X-S-I-TEL"){
		device = new INFERION10G_TELCO(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3110";
	}
	else if(deviceType == "WS-CBS3110G-S-HT-TEL" || deviceType == "WS-CBS3110G-S-I-HT-TEL") {
		device = new INFERION1G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3110";
		
	}
	else if(deviceType == "WS-CBS3110X-S-HT-TEL" || deviceType == "WS-CBS3110X-S-I-HT-TEL"){
		device = new INFERION10G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3110";
	}
	else if(deviceType == "WS-CBS3120G-S"){
		device = new HYPERION1G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3120";
	}
	else if(deviceType == "WS-CBS3120X-S"){
		device = new HYPERION10G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3120";
	}
	else if(deviceType == "WS-CBS3130X-S" || deviceType == "WS-CBS3130X-S-F"){
	
		device = new DELPHINIUM10G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3130";
	}
	else if(deviceType == "WS-CBS3130G-S" || deviceType == "WS-CBS3130G-S-F"){
		device = new DELPHINIUM1G(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3130";
	}
	else if(deviceType == "WS-CBS3032-DEL"|| deviceType == "WS-CBS3032-DEL-F"){
		device = new DELPHINIUM1_NONSTACK(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3032";
	}
	else if(deviceType == "WS-CBS3012-IBM"|| deviceType == "WS-CBS3012-IBM-I"){
		device = new DAGGER(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3012";
	}
	else if(deviceType == "WS-CBS3012-IBM-TEL"|| deviceType == "WS-CBS3012-IBM-I-TEL"){
		device = new DAGGER_TELCO(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3012";
	}
	else if(deviceType == "WS-CBS3012-IBM-HT-TEL"|| deviceType == "WS-CBS3012-IBM-I-HT-TEL"){
		device = new DAGGER(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3012";
	}
	else if(deviceType == "WS-CBS3012-IBM-BCS"|| deviceType == "WS-CBS3012-IBM-I-BCS"){
		device = new DAGGER_BCS(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3012";
	}
	else if(deviceType == "WS-CBS3125G-S"){
		device = new HYPERION1G_CISCO(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3125";
	}
	else if(deviceType == "WS-CBS3125X-S"){
		device = new HYPERION10G_CISCO(int_status, media_type);
		device.type = deviceType;
		device.family = "Catalyst Blade Switch 3125";
	}
	return device;
}
