/*
 *------------------------------------------------------------------
 * portstats.js -- Parsing code for port statistics.  
 *
 * Copyright (c) 2004-2005, 2008 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

function parseData(details, intStatus, interfaceData) {
	var tempBuffer;
	var intArray = split("\n", trim_string(token_string("Duplex  Speed Type",1,intStatus)));
	var portName= "" ;
	for (var i = 0; i<intArray.length; i++) {
	   var row = new Array();
	   var tmp = split(" ", compact_line(intArray[i]));
	   if ( tmp.length > 4 && tmp[0].indexOf("Po") < 0){
		  portNames[i] = tmp[0];
	   }
	}
	
	var tmpDetails = split('Transmit',details);
	var device = top.getSelectedDevice();
	if ( tmpDetails.length != portNames.length)  {
		details = new Array();
		var i = 0;
		var j = 0;
		while ( i < tmpDetails.length) {
			details[j] = tmpDetails[i];
			i += 2;
			j += 1;
		}
	} else {
		details = tmpDetails;
	}
	totalPorts = details.length;
	
	total_Bytes_Trans = new Array(totalPorts);
	total_Bytes_Recev = new Array(totalPorts);
	total_Pkts_Trans = new Array(totalPorts);
	total_Pkts_Recev = new Array(totalPorts);
	unicast_Trans = new Array(totalPorts);
	unicast_Recev = new Array(totalPorts);
	multicast_Trans = new Array(totalPorts);
	multicast_Recev = new Array(totalPorts);
	broadcast_Trans = new Array(totalPorts);
	broadcast_Recev = new Array(totalPorts);
	total_Error_Trans = new Array(totalPorts);
	total_Error_Recev = new Array(totalPorts);
	total_Collision = new Array(totalPorts)
	xcess_Collision  = new Array(totalPorts);
	late_Collision = new Array(totalPorts);
	FCS_Error = new Array(totalPorts);
	alignment_Error = new Array(totalPorts);
	collision_Fragments = new Array(totalPorts);
	oversize_Pkts = new Array(totalPorts);
	undersize_Pkts = new Array(totalPorts);
	
	for( i = 0; i < totalPorts; i++ ) {
	
	// getting total Bytes;
		tempBuffer = grep_string('Bytes', details[i]);
		tempArr = split('Bytes',tempBuffer);
		total_Bytes_Trans[i] = trim_string(tempArr[0]);
		total_Bytes_Recev[i] = trim_string(tempArr[1]);
		// getting the Unicast Pkts.
		tempBuffer = grep_string('Unicast frames', details[i]);
		if ( tempBuffer == null) {
			tempBuffer = grep_string('Frames', details[i]);
			tempArr = split('Frames',tempBuffer);
		} else {
			tempArr = split('Unicast frames',tempBuffer);
		}
		unicast_Trans[i] = trim_string(tempArr[0]);
		unicast_Recev[i] = trim_string(tempArr[1]);
		//getting the Multicast Pkts.
		tempBuffer = multi_grep_string('Multicast frames', details[i]);
		if ( tempBuffer.length == 1) {
			tempArr = split('Multicast frames',tempBuffer[0]);
			multicast_Trans[i] = trim_string(tempArr[0]);
			multicast_Recev[i] = trim_string(tempArr[1]);
		} else {
			tempArr = split('Multicast frames',tempBuffer[0]);
			multicast_Trans[i] = trim_string(tempArr[0]);
			tempArr = split(' ',compact_line(tempBuffer[1]));
			if ( tempArr.length > 4 ) {
				multicast_Recev[i] = trim_string(tempArr[3]);
			} else {
				multicast_Recev[i] = 0;
			}
		}								
		// getting the Broadcast Pkts.
		tempBuffer = multi_grep_string('Broadcast frames', details[i]);
		if ( tempBuffer.length == 1) {
			tempArr = split('Broadcast frames',tempBuffer[0]);
			broadcast_Trans[i] = trim_string(tempArr[0]);
			broadcast_Recev[i] = trim_string(tempArr[1]);
		} else {
			tempArr = split('Broadcast frames',tempBuffer[0]);
			broadcast_Trans[i] = trim_string(tempArr[0]);
			tempArr = split(' ',compact_line(tempBuffer[1]));
			if ( tempArr.length > 4 ) {
				broadcast_Recev[i] = trim_string(tempArr[3]);
			} else {
				broadcast_Recev[i] = 0;
			}
		}
		// calculating the total tranmitted and Received Packets..
		total_Pkts_Trans[i] = parseInt(unicast_Trans[i]) + parseInt(multicast_Trans[i]) + parseInt(broadcast_Trans[i]);
		total_Pkts_Recev[i] = parseInt(unicast_Recev[i]) + parseInt(multicast_Recev[i]) + parseInt(broadcast_Recev[i]);
		// calculating the total Collisions...
		
		tempBuffer = multi_grep_string('collision frames', details[i]);
		var temp = 0;
		for( j = 0; j< tempBuffer.length;j++) {
			tempArr = split((j+1)+' collision frames',tempBuffer[j])
			temp += parseInt(trim_string(tempArr[0]));
		}
		total_Collision[i] = temp;
		
		
	//  Exceissive collision
		tempBuffer = grep_string('Excessive collisions', details[i]);
		tempArr = split('Excessive collisions',tempBuffer);
		xcess_Collision[i] = trim_string(tempArr[0]);
	// Late Collisions	
		tempBuffer = grep_string('Late collisions', details[i]);
		tempArr = split('Late collisions',tempBuffer);
		late_Collision[i] = trim_string(tempArr[0])
	//  FCS_Error
		tempBuffer = grep_string('FCS errors', details[i]);
		tempBuffer = compact_line(tempBuffer)
		FCS_Error[i] = token_string(" ",4,tempBuffer);
		if ( FCS_Error[i] == "FCS" ) {
			FCS_Error[i] = token_string(" ",3,tempBuffer);
		}
	// Alignment Error
		tempBuffer = grep_string('Alignment errors', details[i]);
		tempBuffer = compact_line(tempBuffer)
		alignment_Error[i] = token_string(" ",4,tempBuffer);
		if ( alignment_Error[i] == "Alignment" ) {
			alignment_Error[i] = token_string(" ",3,tempBuffer);
		}
	
	// Total Error calculation 
		total_Error_Trans[i] = parseInt(total_Collision[i]) + parseInt(late_Collision[i]) + parseInt(xcess_Collision[i]);
		total_Error_Recev[i] = parseInt(FCS_Error[i]) + parseInt(alignment_Error[i]);
	// undersize Packets
                tempBuffer = grep_string('Valid frames, too small', details[i]);
                if (tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Valid frames, too smal', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        undersize_Pkts[i] = parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        undersize_Pkts[i] = 0;
                }
                //Fix for CSCsi62687
                /*tempBuffer = grep_string('Invalid frames, too small', details[i]);
                if ( tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Invalid frames, too smal', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        undersize_Pkts[i] += parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        undersize_Pkts[i] += 0;
                }*/
        // oversize packets
                tempBuffer = grep_string('Valid frames, too large', details[i]);
                if ( tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Valid frames, too larg', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        oversize_Pkts[i] = parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        oversize_Pkts[i] = 0;
                }
                tempBuffer = grep_string('Invalid frames, too large', details[i]);
                if ( tempBuffer != null) {
                        tempBuffer = compact_line(token_string('Invalid frames, too larg', 0, tempBuffer));
                        var tmpArray = split(" ",tempBuffer);
                        oversize_Pkts[i] += parseInt(tmpArray[tmpArray.length-1]);
                } else {
                        oversize_Pkts[i] += 0;
                }
	// Collision Fragments
		tempBuffer = grep_string('Collision fragments', details[i]);
		if ( tempBuffer != null) {
			tempBuffer = compact_line(tempBuffer)
			collision_Fragments[i] = token_string(" ",4,tempBuffer);
		} else {
			collision_Fragments[i] = 0;
		}
	}
	// oversize packets...
	var interface_Data = split('\n',interfaceData);
	for(j=0; j < interface_Data.length; j+=2) {
		if(interface_Data[j].indexOf("Vlan") == -1 && interface_Data[j].indexOf("Port-channel") == -1) {
			totalPortArray.push(token_string(" ",0,interface_Data[j]));
			tempBuffer = token_string(",",1,interface_Data[j+1]);
		}
	}
}																											
