 <!-- Copyright (c) 2005, 2007-2009 by Cisco Systems, Inc. -->
// discover.js for XMen2-Cisco devices.

function magneto4(int_status, media_type, moduleTypeArray, brand) 
{
	var dev = new top.device();
	var module1 = "";
	var module2 = "";
	dev.noofports = 4;
	dev.x=0;
	var portcount = 0;
	dev.y=0;
	dev.image = "images/magneto_4.gif";

	drawLeds(dev);

	if ( moduleTypeArray.length == 1){
		module1 = moduleTypeArray[0];
	}
	else if (moduleTypeArray.length == 2){
		module1 = moduleTypeArray[0];
		module2 = moduleTypeArray[1];
	}

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portSideImages();
	var portInvImages = top.rj45portInvSideImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 155;
	var xPortCoord = xPortStartPos;
	var yPortCoord=14;

	// Add the 4 FastEthernet ports in 2 groups of 2 each.
	for(var i=0; i<4; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i==1 ) yPortCoord = 108;
		else yPortCoord += 25;
	}
	portcount = 4;
	//Add module for expander1;
	if ( module1 == "FE" ){
		magneto_8_FE(1, 200, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module1 == "FX" ){
		magneto_8_FX(1, 200, portcount, dev, brand);
		portcount += 8;
	}

	//Add module for expander2;
	if ( module2 == "FE" ){
		magneto_8_FE(2, 300, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module2 == "FX" ){
		magneto_8_FX(2, 300, portcount, dev, brand);
		portcount += 8;
	}

	//Add two dual ports
	xPortCoord = 26;
	yPortCoord = 144;
        for(i=portcount; i<portcount+2; i++) 
        {
                var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
                port = new top.rj45Compositeport(intType,portInvImages,true,"sideinverse");
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.width = 33;
                port.height = 19;
                port.sfpx = 18;
                port.sfpy = 0;
                port.rj45x = 0;
                port.rj45y = 0;
                port.id = "port_" + i;
                dev.addPort(port);
                yPortCoord += 24;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "SMARTPORTS");
	return dev;
}

function magneto8(int_status, media_type, moduleTypeArray, brand) 
{
	var dev = new top.device();
	var module1 = "";
	var module2 = "";
	dev.noofports = 4;
	var portcount = 0;
	dev.x=0;
	dev.y=0;
	dev.image = "images/magneto_8.gif";

	drawLeds(dev);

	if ( moduleTypeArray.length == 1){
		module1 = moduleTypeArray[0];
	}
	else if (moduleTypeArray.length == 2){
		module1 = moduleTypeArray[0];
		module2 = moduleTypeArray[1];
	}

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portSideImages();
	var portInvImages = top.rj45portInvSideImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 134;
	var xPortCoord = xPortStartPos;
	var yPortCoord=40;

	// Add the 4 FastEthernet ports in 2 groups of 2 each.
	for(var i=0; i<4; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i==1 ) yPortCoord = 134;
		else yPortCoord += 25;
	}
	xPortCoord = 155;
	var yPortCoord=14;
	// Add the 4 FastEthernet ports in 2 groups of 2 each.
	for(var i=4; i<8; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i==5 ) yPortCoord = 108;
		else yPortCoord += 25;
	}
	portcount = 8;
	//Add module for expander1;
	if ( module1 == "FE" ){
		magneto_8_FE(1, 200, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module1 == "FX" ){
		magneto_8_FX(1, 200, portcount, dev, brand);
		portcount += 8;
	}

	//Add module for expander2;
	if ( module2 == "FE" ){
		magneto_8_FE(2, 300, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module2 == "FX" ){
		magneto_8_FX(2, 300, portcount, dev, brand);
		portcount += 8;
	}

	//Add two dual ports
	xPortCoord = 26;
	yPortCoord = 144;
        for(i=portcount; i<portcount+2; i++) 
        {
                var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
                port = new top.rj45Compositeport(intType,portInvImages,true,"sideinverse");
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.width = 33;
                port.height = 19;
                port.sfpx = 18;
                port.sfpy = 0;
                port.rj45x = 0;
                port.rj45y = 1;
                port.id = "port_" + i;
                dev.addPort(port);
                yPortCoord += 24;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "SMARTPORTS");
	return dev;
}

function magneto4_rock(int_status, media_type, moduleTypeArray, brand, imageType) 
{
	var dev = new top.device();
	var module1 = "";
	var module2 = "";
	dev.noofports = 4;
	dev.x=0;
	var portcount = 0;
	dev.y=0;
	dev.image = "images/magneto_rock_4.gif";
	if(imageType == "L3") dev.image = "images/magneto_rock_4_L3.gif";

	drawLeds(dev);

	if ( moduleTypeArray.length == 1){
		module1 = moduleTypeArray[0];
	}
	else if (moduleTypeArray.length == 2){
		module1 = moduleTypeArray[0];
		module2 = moduleTypeArray[1];
	}

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portSideImages();
	var portInvImages = top.rj45portInvSideImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 155;
	var xPortCoord = xPortStartPos;
	var yPortCoord=14;

	// Add the 4 FastEthernet ports in 2 groups of 2 each.
	for(var i=0; i<4; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i==1 ) yPortCoord = 108;
		else yPortCoord += 25;
	}
	portcount = 4;
	//Add module for expander1;
	if ( module1 == "FE" ){
		magneto_8_FE(1, 200, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module1 == "FX" ){
		magneto_8_FX(1, 200, portcount, dev, brand);
		portcount += 8;
	}

	//Add module for expander2;
	if ( module2 == "FE" ){
		magneto_8_FE(2, 300, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module2 == "FX" ){
		magneto_8_FX(2, 300, portcount, dev, brand);
		portcount += 8;
	}

	//Add two dual ports
	xPortCoord = 26;
	yPortCoord = 144;
        for(i=portcount; i<portcount+2; i++) 
        {
                var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
                port = new top.rj45Compositeport(intType,portInvImages,true,"sideinverse");
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.width = 33;
                port.height = 19;
                port.sfpx = 18;
                port.sfpy = 0;
                port.rj45x = 0;
                port.rj45y = 0;
                port.id = "port_" + i;
                dev.addPort(port);
                yPortCoord += 24;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "SMARTPORTS");
	return dev;
}

function magneto8_rock(int_status, media_type, moduleTypeArray, brand, imageType) 
{
	var dev = new top.device();
	var module1 = "";
	var module2 = "";
	dev.noofports = 4;
	var portcount = 0;
	dev.x=0;
	dev.y=0;
	dev.image = "images/magneto_rock_8.gif";
	if(imageType == "L3") dev.image = "images/magneto_rock_8_L3.gif";

	drawLeds(dev);

	if ( moduleTypeArray.length == 1){
		module1 = moduleTypeArray[0];
	}
	else if (moduleTypeArray.length == 2){
		module1 = moduleTypeArray[0];
		module2 = moduleTypeArray[1];
	}

	// Parameters for port construction
	var port;
	var portWidth = 19;
	var portImages = top.rj45portSideImages();
	var portInvImages = top.rj45portInvSideImages();
	var xPortGap = 1;
	var xPortGroupGap = 20;
	var xPortStartPos = 134;
	var xPortCoord = xPortStartPos;
	var yPortCoord=40;

	// Add the 4 FastEthernet ports in 2 groups of 2 each.
	for(var i=0; i<4; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i==1 ) yPortCoord = 134;
		else yPortCoord += 25;
	}
	xPortCoord = 155;
	var yPortCoord=14;
	// Add the 4 FastEthernet ports in 2 groups of 2 each.
	for(var i=4; i<8; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i==5 ) yPortCoord = 108;
		else yPortCoord += 25;
	}
	portcount = 8;
	//Add module for expander1;
	if ( module1 == "FE" ){
		magneto_8_FE(1, 200, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module1 == "FX" ){
		magneto_8_FX(1, 200, portcount, dev, brand);
		portcount += 8;
	}

	//Add module for expander2;
	if ( module2 == "FE" ){
		magneto_8_FE(2, 300, portcount, dev, brand);
		portcount += 8;
	}
	else if ( module2 == "FX" ){
		magneto_8_FX(2, 300, portcount, dev, brand);
		portcount += 8;
	}

	//Add two dual ports
	xPortCoord = 26;
	yPortCoord = 144;
        for(i=portcount; i<portcount+2; i++) 
        {
                var intType = int_status[i][6].indexOf("SFP") != -1 ? int_status[i][6] + "-10/100/1000BaseTX" : int_status[i][6];
                port = new top.rj45Compositeport(intType,portInvImages,true,"sideinverse");
                port.index = i;
                port.x = xPortCoord;
                port.y = yPortCoord;
                port.width = 33;
                port.height = 19;
                port.sfpx = 18;
                port.sfpy = 0;
                port.rj45x = 0;
                port.rj45y = 1;
                port.id = "port_" + i;
                dev.addPort(port);
                yPortCoord += 24;
        }
	dev.modeAliases = new Array ( "STATUS", "DUPLEX", "SPEED", "SMARTPORTS");
	return dev;
}

function magneto_8_FE(expandernum, expanderstartpos, startportnum, dev, brand){
	switch (brand){
		case "Cisco":
			if (expandernum == 1 ) dev.expander1 = "images/magneto_8_FE.gif";
			else dev.expander2 = "images/magneto_8_FE.gif";
			break;
		case "Rockwell":
			if (expandernum == 1 ) dev.expander1 = "images/magneto_rock_8_FE.gif";
			else dev.expander2 = "images/magneto_rock_8_FE.gif";
			break;
	}
	var portImages = top.rj45portSideImages();
	var portInvImages = top.rj45portInvSideImages();
	var port;
	var xPortCoord = expanderstartpos + 34;
	var yPortCoord=40;
	for(var i=startportnum; i<startportnum+4; i++) 
	{       
		port = new top.rj45portInvSide(portInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if (  i == startportnum+1 ) yPortCoord = 134;
		else yPortCoord += 25;
	}
	xPortCoord = expanderstartpos + 55;
	yPortCoord=14;
	for(var i=startportnum+4; i<startportnum+8; i++) 
	{       
		port = new top.rj45portSide(portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i == startportnum+5 ) yPortCoord = 108;
		else yPortCoord += 25;
	}
}

function magneto_8_FX(expandernum, expanderstartpos, startportnum, dev, brand){
	switch (brand){
		case "Cisco":
			if (expandernum == 1 ) dev.expander1 = "images/magneto_8_FX.gif";
			else dev.expander2 = "images/magneto_8_FX.gif";
			break;
		case "Rockwell":
			if (expandernum == 1 ) dev.expander1 = "images/magneto_rock_8_FX.gif";
			else dev.expander2 = "images/magneto_rock_8_FX.gif";
			break;
	}
	var fxportImages = top.fxportSideImages();
	var fxportInvImages = top.fxportInvSideImages();
	var port;
	xPortCoord = expanderstartpos + 34;
	yPortCoord=25;
	for(var i=startportnum; i<startportnum+4; i++) 
	{       
		port = new top.fxportInvside(fxportInvImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i == startportnum+1 ) yPortCoord = 135;
		else yPortCoord += 25;
	}
	xPortCoord = expanderstartpos +55;
	yPortCoord=25;
	for(var i=startportnum+4; i<startportnum+8; i++) 
	{       
		port = new top.fxportside(fxportImages);		
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		dev.addPort(port);
		if ( i == startportnum+5 ) yPortCoord = 135;
		else yPortCoord += 25;
	}

}

function drawLeds(dev) 
{
	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 74;
	tempLed.y = 120;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	// Create ALARM LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 74;
	tempLed.y = 127;
	tempLed.id = "alarm_led";
	tempLed.device = dev;
	dev.sysleds["ALARM"] = tempLed;

	// Create SETUP LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 74;
	tempLed.y = 134;
	tempLed.id = "setup_led";
	tempLed.device = dev;
	dev.sysleds["SETUP"] = tempLed;

	// Create POWERA LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 83;
	tempLed.y = 120;
	tempLed.id = "powera_led";
	tempLed.device = dev;
	dev.sysleds["POWERA"] = tempLed;

	// Create POWERB LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 83;
	tempLed.y = 127;
	tempLed.id = "powerb_led";
	tempLed.device = dev;
	dev.sysleds["POWERB"] = tempLed;

	// Create POWERC LEDs
	/*tempLed = new top.led(ledImages);
	tempLed.x = 83;
	tempLed.y = 134;
	tempLed.id = "powerc_led";
	tempLed.device = dev;
	dev.sysleds["POWERC"] = tempLed;
	*/
}

function createDevice(int_status, media_type, deviceType, moduleTypeArray, brand, imageType) 
{
	var device = null;
	if(deviceType == null)
		return device;
	switch (brand){
		case "Cisco":
			if(deviceType == "Magneto 4" || deviceType == "IE-3000-4TC" || deviceType == "IE-3000-4TC-E") 
			{
				device = new magneto4(int_status, media_type, moduleTypeArray, brand);
			}
			else if(deviceType == "Magneto 8" || deviceType == "IE-3000-8TC" || deviceType == "IE-3000-8TC-E") 
			{
				device = new magneto8(int_status, media_type, moduleTypeArray, brand);
			}
			break;
		case "Rockwell":
			if(deviceType == "Magneto 4" || deviceType == "1783-MS06T" || deviceType == "1783-RMS06T") 
			{
				
				device = new magneto4_rock(int_status, media_type, moduleTypeArray, brand, imageType);
			}
			else if(deviceType == "Magneto 8" || deviceType == "1783-MS10T" || deviceType == "1783-RMS10T") 
			{
				device = new magneto8_rock(int_status, media_type, moduleTypeArray, brand, imageType);
			}
			break;
	}
	
	if(imageType == "L3") deviceType = deviceType + imageType;
	if(device != null) 
	{
		device.type = deviceType;
		device.brand = brand;
		device.family = "Magneto";
	}
	return device;
}
