/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.SnmpCounter;
import Snmp.SnmpException;
import Snmp.SnmpGauge;
import Snmp.SnmpInt;
import Snmp.SnmpIpAddress;
import Snmp.SnmpOID;
import Snmp.SnmpOpaque;
import Snmp.SnmpString;
import Snmp.SnmpTimeticks;
import Snmp.SnmpVar;
import java.util.Enumeration;

public class LeafSyntax {
    public String name;
    public String description;
    public byte type;
    public String equivName;
    public int[] enumInt;
    public int size = Integer.MAX_VALUE;
    public long MIN = Integer.MIN_VALUE;
    public long MAX = Integer.MAX_VALUE;

    public LeafSyntax(String string, byte by) {
        this.name = string;
        this.type = by;
        if (by == 64) {
            this.size = 4;
        }
        if (by == 66) {
            this.MIN = 0L;
            this.MAX = -1L;
        }
        if (by == 65) {
            this.MIN = 0L;
            this.MAX = -1L;
        }
        if (by == 67) {
            this.MIN = 0L;
            this.MAX = -1L;
        }
    }

    public SnmpVar createVariable(String string) throws SnmpException {
        if (this.type == 4) {
            return new SnmpString(string);
        }
        if (this.type == 64) {
            return new SnmpIpAddress(string);
        }
        if (this.type == 68) {
            return new SnmpOpaque(string);
        }
        if (this.type == 6) {
            return new SnmpOID(string);
        }
        if (this.type == 2) {
            int n;
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + string);
            }
            return new SnmpInt(n);
        }
        if (this.type == 67) {
            long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + string);
            }
            return new SnmpTimeticks(l);
        }
        if (this.type == 65) {
            long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + string);
            }
            return new SnmpCounter(l);
        }
        if (this.type == 66) {
            long l;
            try {
                l = new Long(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SnmpException("Invalid format for : " + string);
            }
            return new SnmpGauge(l);
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String toTagString() {
        return this.description;
    }

    public boolean checkValue(int n) {
        if (this.enumInt != null) {
            int n2 = 0;
            while (n2 < this.enumInt.length) {
                if (this.enumInt[n2] == n) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if ((long)n < this.MIN) {
            return false;
        }
        return (long)n <= this.MAX;
    }

    String nextUsefulToken(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("{") || string.equals("}") || string.equals("(") || string.equals(")") || string.equals(",") || string.equals("|") || string.equals(".")) continue;
            return string;
        }
        return null;
    }
}

