/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.SnmpClient;
import Snmp.SnmpPDU;
import Snmp.SnmpSession;
import java.util.Enumeration;
import java.util.Vector;

class SnmpCallback
extends Thread {
    Vector responses = new Vector();

    void enQ(SnmpClient snmpClient, SnmpSession snmpSession, SnmpPDU snmpPDU, int n) {
        CallbackArgs callbackArgs = snmpPDU != null ? new CallbackArgs(snmpClient, snmpSession, snmpPDU.copy(), n) : new CallbackArgs(snmpClient, snmpSession, null, n);
        this.responses.addElement(callbackArgs);
        this.notifyAll();
    }

    public void run() {
        while (true) {
            Enumeration enumeration = this.responses.elements();
            while (enumeration.hasMoreElements()) {
                CallbackArgs callbackArgs = (CallbackArgs)enumeration.nextElement();
                if (!callbackArgs.client.callback(callbackArgs.session, callbackArgs.pdu, callbackArgs.reqid) && callbackArgs.pdu != null) {
                    callbackArgs.session.enQ(callbackArgs.session.responseList, callbackArgs.pdu);
                }
                this.responses.removeElement(callbackArgs);
            }
            try {
                this.wait();
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    class CallbackArgs {
        SnmpClient client;
        SnmpSession session;
        SnmpPDU pdu;
        int reqid;

        public CallbackArgs(SnmpClient snmpClient, SnmpSession snmpSession, SnmpPDU snmpPDU, int n) {
            SnmpCallback.this = SnmpCallback.this;
            this.client = snmpClient;
            this.session = snmpSession;
            this.pdu = snmpPDU;
            this.reqid = n;
        }
    }
}

