/*
 * Decompiled with CFR 0.152.
 */
package Snmp;

import Snmp.ASNTypes;
import Snmp.SnmpException;
import Snmp.SnmpOID;
import Snmp.SnmpVar;
import java.io.ByteArrayInputStream;

public class SnmpInt
extends SnmpVar {
    protected int value;
    protected byte[] byteValue;

    public SnmpInt(int n) {
        this.value = n;
        this.Type = (byte)2;
    }

    public Object toValue() {
        return new Integer(this.value);
    }

    public int intValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public String toEnumString(SnmpOID snmpOID) {
        String string = null;
        string = string == null ? Integer.toString(this.value) : String.valueOf(string) + " (" + Integer.toString(this.value) + ")";
        return string;
    }

    public String toTagString() {
        return new String("INTEGER: " + Integer.toString(this.value));
    }

    public String toEnumTagString(SnmpOID snmpOID) {
        return new String("INTEGER: " + this.toEnumString(snmpOID));
    }

    public byte[] toBytes() {
        return this.byteValue;
    }

    byte[] encode() {
        int n = 4;
        int n2 = 4;
        int n3 = this.value;
        int n4 = 511 << 8 * (n - 1) - 1;
        while (((n3 & n4) == 0 || (n3 & n4) == n4) && n2 > 1) {
            --n2;
            n3 <<= 8;
        }
        byte[] byArray = ASNTypes.build_header((byte)2, n2);
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = new byte[byArray.length + n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n5 = byArray.length;
        n4 = 255 << 8 * (n - 1);
        while (n2-- > 0) {
            byArray2[n5++] = (byte)((n3 & n4) >> 8 * (n - 1));
            n3 <<= 8;
        }
        return byArray2;
    }

    boolean decode(ByteArrayInputStream byteArrayInputStream, int n) throws SnmpException {
        byte by;
        int n2 = 4;
        long l = 0L;
        ASNTypes.checkStream(byteArrayInputStream, n);
        if (n > n2) {
            System.err.println("Parse error: integer too large");
            return false;
        }
        this.byteValue = new byte[n];
        int n3 = 0;
        if (n-- > 0) {
            this.byteValue[n3] = by = (byte)byteArrayInputStream.read();
            ++n3;
            if ((by & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            l = l << 8 | (long)by;
        }
        while (n-- > 0) {
            this.byteValue[n3] = by = (byte)byteArrayInputStream.read();
            ++n3;
            l = l << 8 | (long)ASNTypes.byteToInt(by);
        }
        this.value = (int)l;
        return true;
    }
}

