/*
 * Decompiled with CFR 0.152.
 */
import Snmp.SnmpException;
import Snmp.SnmpInt;
import Snmp.SnmpOID;
import Snmp.SnmpPDU;
import Snmp.SnmpSession;
import Snmp.SnmpUnsignedInt;
import Snmp.SnmpVarBind;
import java.applet.Applet;
import java.util.StringTokenizer;
import java.util.Vector;

public class CollectorRequest
extends Applet
implements Runnable {
    String ipAddress = "0.0.0.0";
    String SnmpRead = "public";
    Vector expressionList;
    Vector indexList;
    boolean requestActive = false;
    Thread requestThread;
    int interval = 10;
    int vbIndex;
    CollectorCallbackIf callback;
    SnmpSession session;
    DataCollector dataColl;
    public static final byte REQUEST_OK = 0;
    public static final byte REQUEST_NON_NUMERIC_TYPE = 1;
    public static final byte REQUEST_SNMP_ERROR = 2;
    public static final byte REQUEST_INTERVAL_TIMEOUT = 3;
    public static final byte REQUEST_EXPRESSION_SYNTAX = 4;
    public static final byte REQUEST_UNKNOWN_MIB_VAR = 5;
    private static int dcounter = 1;

    public CollectorRequest(DataCollector dataCollector, String string, String string2) {
        this.ipAddress = string;
        this.vbIndex = 0;
        this.dataColl = dataCollector;
        this.SnmpRead = string2;
        this.session = new SnmpSession(this.dataColl.api);
        this.session.peername = string;
        this.session.community = this.SnmpRead;
        System.out.println(this.session.community);
        this.session.timeout = 5000;
        this.session.retries = 1;
        try {
            this.session.open();
        }
        catch (SnmpException snmpException) {
            System.err.println(snmpException.getMessage());
        }
        this.expressionList = new Vector();
        this.indexList = new Vector();
        this.dataColl.activeRequests.addElement(this);
    }

    public byte addDataItem(String string, int n) {
        return this.addDataItem(string, new Integer(n));
    }

    public byte addDataItem(String string, String string2) {
        return this.addDataItem(string, (Object)string2);
    }

    public byte addDataItem(String string, Object object) {
        ExpressionParser expressionParser = new ExpressionParser(string, this.vbIndex);
        if (expressionParser.parse()) {
            Vector vector = expressionParser.symbols();
            int n = 0;
            while (n < vector.size()) {
                String string2 = this.baseSymbol((String)vector.elementAt(n));
                if (this.dataColl.mibStore.getMibVar(string2) == null) {
                    return 5;
                }
                ++n;
            }
            this.expressionList.addElement(expressionParser);
            this.indexList.addElement(object);
            this.vbIndex += vector.size();
            return 0;
        }
        return 4;
    }

    public boolean startRequest(int n, CollectorCallbackIf collectorCallbackIf) {
        if (this.requestActive) {
            return false;
        }
        this.callback = collectorCallbackIf;
        this.interval = n;
        this.requestThread = new Thread((Runnable)this, "DataCollector-" + dcounter++);
        this.requestActive = true;
        this.requestThread.start();
        return true;
    }

    public void run() {
        SymbolEvaluator symbolEvaluator;
        int n;
        Object object;
        SnmpPDU snmpPDU = null;
        SnmpPDU snmpPDU2 = new SnmpPDU(this.dataColl.api);
        snmpPDU2.command = (byte)-96;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < this.expressionList.size()) {
            object = (ExpressionParser)this.expressionList.elementAt(n2);
            Vector vector2 = ((ExpressionParser)object).symbols();
            n = 0;
            while (n < vector2.size()) {
                String string = (String)vector2.elementAt(n);
                vector.addElement(string);
                String string2 = this.isQualifiedSymbol(string) ? String.valueOf(this.dataColl.mibStore.getMibVar(this.baseSymbol(string))) + this.symbolQualifier(string) : String.valueOf(this.dataColl.mibStore.getMibVar(string)) + "." + this.indexList.elementAt(n2);
                symbolEvaluator = new SnmpOID(string2);
                snmpPDU2.addNull((SnmpOID)symbolEvaluator);
                ++n;
            }
            ++n2;
        }
        object = new SymbolEvaluator(vector);
        while (this.requestActive) {
            int n3;
            block19: {
                Object object2;
                Object object3;
                int n4;
                n3 = 0;
                try {
                    n4 = this.session.send(snmpPDU2);
                }
                catch (SnmpException snmpException) {
                    System.out.println("SNMP error: " + snmpException.getMessage());
                    this.callback.errorReturn((byte)2);
                    break block19;
                }
                boolean bl = false;
                n3 = 0;
                do {
                    try {
                        Thread.sleep(100L);
                        ++n3;
                    }
                    catch (InterruptedException interruptedException) {}
                    if (!this.requestActive) {
                        return;
                    }
                    snmpPDU = this.session.receive(n4);
                    bl = this.session.checkTimeout(n4);
                } while (snmpPDU == null && !bl);
                if (bl) {
                    this.callback.errorReturn((byte)3);
                } else if (snmpPDU.errstat != 0) {
                    byte by = (byte)snmpPDU.errstat;
                    object3 = SnmpException.exceptionString((byte)by);
                    System.out.println("Response PDU error: " + (String)object3);
                    int n5 = 0;
                    while (n5 < snmpPDU.variables.size()) {
                        object2 = (SnmpVarBind)snmpPDU.variables.elementAt(n5);
                        System.out.println(" for sysObjectID: " + ((SnmpVarBind)object2).oid.toString());
                        ++n5;
                    }
                    this.callback.errorReturn((byte)2);
                } else {
                    symbolEvaluator = new SymbolEvaluator(vector, (SymbolEvaluator)object);
                    object = symbolEvaluator;
                    n2 = 0;
                    while (n2 < snmpPDU.variables.size()) {
                        symbolEvaluator.setValueOf(n2, this.mibVarValue((SnmpVarBind)snmpPDU.variables.elementAt(n2)));
                        ++n2;
                    }
                    object3 = new long[this.expressionList.size()];
                    n = 0;
                    while (n < this.expressionList.size()) {
                        ExpressionParser expressionParser = (ExpressionParser)this.expressionList.elementAt(n);
                        object2 = expressionParser.parseTree();
                        object3[n] = ((ParseNode)object2).value(symbolEvaluator);
                        if (this.dataColl.debug) {
                            System.out.println("DC sending: '" + expressionParser.expression + "' index: '" + this.indexList.elementAt(n) + "' symbols: " + symbolEvaluator.symbolString());
                        }
                        ++n;
                    }
                    this.callback.dataReturn((long[])object3);
                }
            }
            try {
                int n6 = Math.max((this.interval * 10 - n3) * 100, 2000);
                Thread.sleep(n6);
            }
            catch (InterruptedException interruptedException) {
                if (this.requestActive) continue;
                return;
            }
        }
    }

    public void cancelRequest() {
        block5: {
            try {
                if (this.requestActive) {
                    System.out.println("Canceling request: " + this.requestThread);
                    this.requestActive = false;
                    this.requestThread.stop();
                }
                if (this.session == null) break block5;
                System.out.println("Closing session: " + this.session);
                try {
                    this.session.close();
                }
                catch (SecurityException securityException) {
                    System.out.println("Ignoring bogus SNMP security exception");
                }
                this.session = null;
                return;
            }
            catch (Exception exception) {
                System.out.println("Caught exception in cancelRequest: " + exception);
            }
        }
    }

    private void suspendRequest() {
        if (this.requestActive) {
            this.requestThread.suspend();
        }
    }

    private void resumeRequest() {
        if (this.requestActive) {
            this.requestThread.resume();
        }
    }

    private String baseSymbol(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            return stringTokenizer.nextToken();
        }
        return "";
    }

    private boolean isQualifiedSymbol(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            return !string2.equals(string);
        }
        return false;
    }

    private String symbolQualifier(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            return string.substring(string2.length());
        }
        return "";
    }

    private long mibVarValue(SnmpVarBind snmpVarBind) {
        long l = 0L;
        switch (snmpVarBind.variable.Type) {
            case 2: {
                SnmpInt snmpInt = (SnmpInt)snmpVarBind.variable;
                l = snmpInt.intValue();
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                SnmpUnsignedInt snmpUnsignedInt = (SnmpUnsignedInt)snmpVarBind.variable;
                l = snmpUnsignedInt.longValue();
                break;
            }
        }
        return l;
    }
}

