/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;
import netscape.javascript.JSObject;

public class DrawGraph
extends Applet
implements Runnable,
ItemListener {
    public static final int CANVAS_WIDTH = 420;
    public static final int XAXIS_CANVAS_WIDTH = 485;
    public static final int NUM_LABELS = 8;
    public static final int NUM_POINTS = 100;
    public static final double POINT_MULTIPLIER = 4.21;
    public static final int MAX_EXPRESSIONS = 4;
    public static final int LINK_UTIL_TYPE = 0;
    public static final int LINK_BYTES_TYPE = 1;
    public static final int LINK_PACKETS_TYPE = 2;
    public static final int LINK_ERRORS_TYPE = 3;
    public static final int DEVICE_BANDWIDTH_TYPE = 4;
    public static final int MAX_DISPLAY_TYPE = 4;
    Thread starter;
    Vector timeData = new Vector();
    Vector[] yData = new Vector[4];
    Double topVal = new Double(0.04);
    Double highPoint = new Double(0.04);
    int nNumTimeouts;
    int nNumSnmpErrors;
    int nNumSyntaxErrors;
    int nNumMibVarErrors;
    int sDataStarted;
    boolean bFirstDCdata = true;
    boolean bInitialTopVal = true;
    String windowTitle;
    String graphSelector0 = "% Utilization";
    String graphSelector1 = "Total Bytes";
    String graphSelector2 = "Total Packets";
    String graphSelector3 = "Total Errors";
    public int graphSelectorNum = 1;
    public int pollInterval = 2;
    String devIpAddr;
    String devName;
    String devInterface;
    String graphType;
    String graphTitle;
    String hostName;
    String SnmpRead;
    String[] expression = new String[4];
    String[] expressionLabel = new String[4];
    int numExpressions;
    int ifIndex;
    String sModPortIndex;
    DrawCanvas mainCanvas;
    Label titleLabel;
    Panel titlePanel;
    Panel canvasPanel;
    Panel legendPanel;
    LegendCanvas lCanvas;
    XAxisCanvas xCanvas;
    YAxisCanvas yCanvas;
    Choice typeSelector;
    DataCollector DCollector;
    CollectorRequest CRequest;
    DataCollectorCallback DCcallBack;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_KB = 1024L;
    public double lastGCTime = System.currentTimeMillis();

    public void pollIntervalSet(String string) {
        Integer n = new Integer(string);
        this.pollInterval = n;
        if (this.pollInterval < 5) {
            this.pollInterval = 5;
        }
        if (this.pollInterval > 60) {
            this.pollInterval = 60;
        }
    }

    public void graphTypeSet(String string) {
        Integer n = new Integer(string);
        this.graphSelectorNum = n;
        if (this.graphSelectorNum > 4 || this.graphSelectorNum < 0) {
            this.graphSelectorNum = 0;
        }
    }

    private int ReadHtmlParams() {
        this.SnmpRead = this.getParameter("snmp");
        this.devIpAddr = this.getParameter("DevIpAddr");
        this.devName = this.getParameter("DevName");
        this.devInterface = this.getParameter("DevInterface");
        this.graphType = this.getParameter("GraphType");
        this.hostName = this.getParameter("HostName");
        this.devName = this.devName.replace('~', ' ');
        this.devInterface = this.devInterface.replace('~', ' ');
        this.graphType = this.graphType.replace('~', ' ');
        JSObject jSObject = JSObject.getWindow((Applet)this);
        Object[] objectArray = new Object[]{new Integer(0)};
        jSObject.call("getDefaults", objectArray);
        return 0;
    }

    private void SetExpressions(int n) {
        if (n == 0) {
            this.graphTitle = new String("% Utilization");
            this.expressionLabel[0] = new String("% Utilization");
            this.expression[0] = new String("DELTA ( ifInOctets ) + DELTA ( ifOutOctets )");
            this.expressionLabel[1] = new String("ifSpeed");
            this.expression[1] = new String("ifSpeed");
            this.expressionLabel[2] = new String("sysUpTime");
            this.expression[2] = new String("DELTA ( sysUpTime.0 )");
            this.numExpressions = 3;
        } else if (n == 1) {
            this.graphTitle = new String("Bytes Sent & Received / second");
            this.expressionLabel[0] = new String("Total Bytes");
            this.expression[0] = new String("DELTA ( ifInOctets ) + DELTA ( ifOutOctets )");
            this.expressionLabel[1] = new String("Total Received");
            this.expression[1] = new String("DELTA ( ifInOctets )");
            this.expressionLabel[2] = new String("Total Transmitted");
            this.expression[2] = new String("DELTA ( ifOutOctets )");
            this.expressionLabel[3] = new String("sysUpTime");
            this.expression[3] = new String("DELTA ( sysUpTime.0 )");
            this.numExpressions = 4;
        } else if (n == 2) {
            this.graphTitle = new String("Packets Sent & Received / second");
            this.expressionLabel[0] = new String("Ttl Packets");
            this.expression[0] = new String("DELTA ( ifInUcastPkts ) + DELTA ( ifOutUcastPkts ) + DELTA ( ifInNUcastPkts ) + DELTA ( ifOutNUcastPkts )");
            this.expressionLabel[1] = new String("Ttl Bcast&Mcast");
            this.expression[1] = new String("DELTA ( ifInNUcastPkts ) + DELTA ( ifOutNUcastPkts )");
            this.expressionLabel[2] = new String("sysUpTime");
            this.expression[2] = new String("DELTA ( sysUpTime.0 )");
            this.numExpressions = 3;
        } else if (n == 3) {
            this.graphTitle = new String("Total Errors (cumulative)");
            this.expressionLabel[0] = new String("Total Errors");
            this.expression[0] = new String("ifInErrors");
            this.expressionLabel[1] = new String("Total Packets Dropped");
            this.expression[1] = new String("c2900PortRxNoBwFrames + c2900PortRxNoBufferFrames + c2900PortRxNoDestUniFrames + c2900PortRxNoDestMultiFrames + c2900PortRxSuppressBcastFrames");
            this.numExpressions = 2;
        } else if (n == 4) {
            this.graphTitle = new String("Bandwidth Used");
            this.expressionLabel[0] = new String("Bandwidth Used (Mbps)");
            this.expression[0] = new String("c2900BandwidthUsageCurrent");
            this.numExpressions = 1;
        }
        int n2 = 0;
        while (n2 < this.numExpressions) {
            ++n2;
        }
    }

    private int StartDataCollector() {
        this.CRequest = new CollectorRequest(this.DCollector, this.devIpAddr, this.SnmpRead);
        int n = 0;
        while (n < this.numExpressions) {
            byte by = this.expressionLabel[n].equals("Total Packets Dropped") ? this.CRequest.addDataItem(this.expression[n], this.sModPortIndex) : this.CRequest.addDataItem(this.expression[n], this.ifIndex);
            if (by != 0) {
                return -1;
            }
            ++n;
        }
        this.DCcallBack = new DataCollectorCallback();
        boolean bl = this.CRequest.startRequest(this.pollInterval, this.DCcallBack);
        if (!bl) {
            System.out.println("DrawGraph::StartDataCollector(): CollectorRequest.startRequest() Failed!");
            return -1;
        }
        return 0;
    }

    private void CancelCollectorRequest() {
        try {
            this.CRequest.cancelRequest();
        }
        catch (Exception exception) {
            System.out.println("DrawGraph: CancelCollectorRequest():: cancelRequest threw exception " + exception);
            exception.printStackTrace();
        }
        this.CRequest = null;
    }

    private void CenterTitle() {
        Font font = new Font("Dialog", 1, 12);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.titleLabel.setFont(font);
        this.windowTitle = this.graphType.equals("device") ? String.valueOf(this.graphTitle) + " on " + this.hostName : String.valueOf(this.graphTitle) + " on " + this.devInterface;
        this.titleLabel.setText(this.windowTitle);
        int n = fontMetrics.stringWidth(this.windowTitle);
        this.titlePanel.setBounds(Math.max((this.getSize().width - n) / 2, 0) - 4, 5, n + 12, 22);
        this.titleLabel.setBounds(2, 0, n + 8, 22);
    }

    private void CenterLegend() {
        int n = 10;
        int n2 = 16;
        int n3 = 8;
        Font font = new Font("Dialog", 0, 12);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        if (this.numExpressions == 1 || this.graphSelectorNum == 0) {
            n = fontMetrics.stringWidth(this.expressionLabel[0]) + n2 + n3;
        } else if (this.numExpressions == 2) {
            int n4 = fontMetrics.stringWidth(this.expressionLabel[0]);
            int n5 = fontMetrics.stringWidth(this.expressionLabel[1]);
            n = n4 + n5 + n2 * 2 + n3 * 2;
        } else if (this.numExpressions == 3 && this.graphSelectorNum == 2) {
            int n6 = fontMetrics.stringWidth(this.expressionLabel[0]);
            int n7 = fontMetrics.stringWidth(this.expressionLabel[1]);
            n = n6 + n7 + n2 * 2 + n3 * 2;
        } else if (this.numExpressions == 3) {
            int n8 = fontMetrics.stringWidth(this.expressionLabel[0]);
            int n9 = fontMetrics.stringWidth(this.expressionLabel[1]);
            int n10 = fontMetrics.stringWidth(this.expressionLabel[2]);
            n = n8 + n9 + n10 + n2 * 3 + n3 * 3;
        } else if (this.numExpressions == 4 && this.graphSelectorNum == 1) {
            int n11 = fontMetrics.stringWidth(this.expressionLabel[0]);
            int n12 = fontMetrics.stringWidth(this.expressionLabel[1]);
            int n13 = fontMetrics.stringWidth(this.expressionLabel[2]);
            n = n11 + n12 + n13 + n2 * 3 + n3 * 3;
        }
        this.lCanvas.setBounds((this.getSize().width - n) / 2, 325, n + 20, 22);
    }

    public void init() {
        this.timeData.removeAllElements();
        int n = 0;
        while (n < 100) {
            this.timeData.addElement(new Double(0.0));
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            this.yData[n2] = new Vector();
            this.yData[n2].removeAllElements();
            int n3 = 0;
            while (n3 < 100) {
                this.yData[n2].addElement(new Double(-1.0));
                ++n3;
            }
            ++n2;
        }
        if (this.ReadHtmlParams() == -1) {
            return;
        }
        if (this.graphType.equals("device")) {
            this.graphSelectorNum = 4;
        }
        this.SetExpressions(this.graphSelectorNum);
        this.setLayout(null);
        this.setSize(520, 360);
        this.setBackground(new Color(187, 204, 221));
        this.titlePanel = new Panel();
        this.titlePanel.setLayout(null);
        this.titlePanel.setBackground(new Color(230, 232, 250));
        this.titleLabel = new Label("empty");
        this.CenterTitle();
        this.titleLabel.setBackground(new Color(230, 232, 250));
        this.titlePanel.add(this.titleLabel);
        this.add(this.titlePanel);
        this.typeSelector = new Choice();
        this.typeSelector.setBounds(407, 3, 94, 25);
        this.typeSelector.addItem(this.graphSelector0);
        this.typeSelector.addItem(this.graphSelector1);
        this.typeSelector.addItem(this.graphSelector2);
        this.typeSelector.addItem(this.graphSelector3);
        this.typeSelector.setEnabled(false);
        if (!this.graphType.equals("device")) {
            this.typeSelector.select(this.graphSelectorNum);
            this.add(this.typeSelector);
        }
        this.lCanvas = new LegendCanvas();
        this.lCanvas.setBackground(new Color(230, 232, 250));
        this.add(this.lCanvas);
        this.CenterLegend();
        this.canvasPanel = new Panel();
        this.canvasPanel.setLayout(null);
        this.canvasPanel.setBounds(15, 34, 485, 282);
        this.canvasPanel.setBackground(new Color(173, 234, 234));
        this.yCanvas = new YAxisCanvas();
        this.yCanvas.setBounds(2, 2, 38, 250);
        this.yCanvas.setBackground(new Color(173, 234, 234));
        this.canvasPanel.add(this.yCanvas);
        this.xCanvas = new XAxisCanvas();
        this.xCanvas.setBounds(0, 250, 485, 20);
        this.xCanvas.setBackground(new Color(173, 234, 234));
        this.canvasPanel.add(this.xCanvas);
        this.mainCanvas = new DrawCanvas(this.xCanvas, this.yCanvas);
        this.mainCanvas.setBounds(40, 10, 420, 240);
        this.mainCanvas.setBackground(Color.white);
        this.canvasPanel.add(this.mainCanvas);
        this.add(this.canvasPanel);
        this.typeSelector.addItemListener(this);
        this.DCollector = new DataCollector();
        this.starter = new Thread((Runnable)this, "DrawGraph starter");
        this.starter.start();
    }

    public void run() {
        IndexMapper indexMapper = new IndexMapper(this.devIpAddr, this.SnmpRead);
        while (!indexMapper.infoReady) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        if (this.graphType.equals("device")) {
            this.ifIndex = 0;
            this.sModPortIndex = null;
        } else if (indexMapper.infoReady) {
            this.ifIndex = indexMapper.mapToIfIndex(this.devInterface);
            this.sModPortIndex = indexMapper.mapToModulePortIndex(this.devInterface);
        } else {
            System.out.println("DrawGraph::starter-run(): FATAL ERROR!!!  IndexMapper.infoReady is still FALSE!!!");
        }
        if (this.StartDataCollector() == -1) {
            System.out.println("DrawGraph::starter-run(): StartDataCollector() FAILED!");
        }
        this.typeSelector.setEnabled(true);
        this.starter.stop();
    }

    public void stop() {
        try {
            this.DCollector.stop();
            return;
        }
        catch (Exception exception) {
            System.out.println("DrawGraph: stop()::  DCollector.stop() threw exception " + exception);
            exception.printStackTrace();
            return;
        }
    }

    public void destroy() {
        try {
            this.DCollector.destroy();
            return;
        }
        catch (Exception exception) {
            System.out.println("DrawGraph: destroy()::  DCollector.destroy() threw exception " + exception);
            exception.printStackTrace();
            return;
        }
    }

    private void ResetVariables() {
        this.typeSelector.setEnabled(false);
        this.CancelCollectorRequest();
        this.nNumTimeouts = 0;
        this.nNumSnmpErrors = 0;
        this.nNumSyntaxErrors = 0;
        this.nNumMibVarErrors = 0;
        this.sDataStarted = 0;
        this.bFirstDCdata = true;
        this.bInitialTopVal = true;
        this.topVal = new Double(0.04);
        this.highPoint = new Double(0.04);
        this.timeData.removeAllElements();
        int n = 0;
        while (n < 100) {
            this.timeData.addElement(new Double(0.0));
            ++n;
        }
        int n2 = 0;
        while (n2 < 4) {
            this.yData[n2].removeAllElements();
            int n3 = 0;
            while (n3 < 100) {
                this.yData[n2].addElement(new Double(-1.0));
                ++n3;
            }
            ++n2;
        }
        this.SetExpressions(this.graphSelectorNum);
        this.CenterTitle();
        this.CenterLegend();
        this.lCanvas.redraw();
        if (this.StartDataCollector() == -1) {
            System.out.println("DrawGraph::ResetVariables(): StartDataCollector() FAILED!");
        }
        this.typeSelector.setEnabled(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = (String)itemEvent.getItem();
        int n = this.graphSelectorNum;
        if (string.equals(this.graphSelector0)) {
            this.graphSelectorNum = 0;
        } else if (string.equals(this.graphSelector1)) {
            this.graphSelectorNum = 1;
        } else if (string.equals(this.graphSelector2)) {
            this.graphSelectorNum = 2;
        } else if (string.equals(this.graphSelector3)) {
            this.graphSelectorNum = 3;
        }
        this.typeSelector.select(this.graphSelectorNum);
        if (this.graphSelectorNum != n) {
            this.ResetVariables();
        }
    }

    private class LegendCanvas
    extends Canvas {
        public void paint(Graphics graphics) {
            Font font = new Font("Dialog", 0, 12);
            FontMetrics fontMetrics = this.getFontMetrics(font);
            int n = 16;
            int n2 = 8;
            if (DrawGraph.this.numExpressions == 1 || DrawGraph.this.graphSelectorNum == 0) {
                int n3 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[0]) + n + n2;
                graphics.setColor(Color.blue);
                graphics.fillRect((this.getSize().width - n3) / 2 - 4, 8, n, 2);
                graphics.setColor(Color.black);
                graphics.drawString(DrawGraph.this.expressionLabel[0], (this.getSize().width - n3) / 2 + 22, 15);
                return;
            }
            if (DrawGraph.this.numExpressions == 2) {
                int n4 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[0]);
                int n5 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[1]);
                int n6 = n4 + n5 + n * 2 + n2 * 2;
                graphics.setColor(Color.blue);
                graphics.fillRect((this.getSize().width - n6) / 2 - 4, 8, n, 2);
                graphics.setColor(Color.red);
                graphics.fillRect((this.getSize().width - n6) / 2 + n4 + n + n2, 8, n, 2);
                graphics.setColor(Color.black);
                graphics.drawString(DrawGraph.this.expressionLabel[0], (this.getSize().width - n6) / 2 + n, 15);
                graphics.drawString(DrawGraph.this.expressionLabel[1], (this.getSize().width - n6) / 2 + n4 + n * 2 + n2 * 2, 15);
                return;
            }
            if (DrawGraph.this.numExpressions == 3 && DrawGraph.this.graphSelectorNum == 2) {
                int n7 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[0]);
                int n8 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[1]);
                int n9 = n7 + n8 + n * 2 + n2 * 2;
                graphics.setColor(Color.blue);
                graphics.fillRect((this.getSize().width - n9) / 2 - 4, 8, n, 2);
                graphics.setColor(Color.red);
                graphics.fillRect((this.getSize().width - n9) / 2 + n7 + n + n2, 8, n, 2);
                graphics.setColor(Color.black);
                graphics.drawString(DrawGraph.this.expressionLabel[0], (this.getSize().width - n9) / 2 + n, 15);
                graphics.drawString(DrawGraph.this.expressionLabel[1], (this.getSize().width - n9) / 2 + n7 + n * 2 + n2 * 2, 15);
                return;
            }
            if (DrawGraph.this.numExpressions == 3) {
                int n10 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[0]);
                int n11 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[1]);
                int n12 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[2]);
                int n13 = n10 + n11 + n12 + n * 3 + n2 * 3;
                graphics.setColor(Color.blue);
                graphics.fillRect((this.getSize().width - n13) / 2 - 4, 8, n, 2);
                graphics.setColor(Color.red);
                graphics.fillRect((this.getSize().width - n13) / 2 + n10 + n + n2, 8, n, 2);
                graphics.setColor(Color.darkGray);
                graphics.fillRect((this.getSize().width - n13) / 2 + n10 + n11 + n * 2 + n2 * 3, 8, n, 2);
                graphics.setColor(Color.black);
                graphics.drawString(DrawGraph.this.expressionLabel[0], (this.getSize().width - n13) / 2 + n, 15);
                graphics.drawString(DrawGraph.this.expressionLabel[1], (this.getSize().width - n13) / 2 + n10 + n * 2 + n2 * 2, 15);
                graphics.drawString(DrawGraph.this.expressionLabel[2], (this.getSize().width - n13) / 2 + n10 + n11 + n * 3 + n2 * 4, 15);
                return;
            }
            if (DrawGraph.this.numExpressions == 4 && DrawGraph.this.graphSelectorNum == 1) {
                int n14 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[0]);
                int n15 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[1]);
                int n16 = fontMetrics.stringWidth(DrawGraph.this.expressionLabel[2]);
                int n17 = n14 + n15 + n16 + n * 3 + n2 * 3;
                graphics.setColor(Color.blue);
                graphics.fillRect((this.getSize().width - n17) / 2 - 4, 8, n, 2);
                graphics.setColor(Color.red);
                graphics.fillRect((this.getSize().width - n17) / 2 + n14 + n + n2, 8, n, 2);
                graphics.setColor(Color.darkGray);
                graphics.fillRect((this.getSize().width - n17) / 2 + n14 + n15 + n * 2 + n2 * 3, 8, n, 2);
                graphics.setColor(Color.black);
                graphics.drawString(DrawGraph.this.expressionLabel[0], (this.getSize().width - n17) / 2 + n, 15);
                graphics.drawString(DrawGraph.this.expressionLabel[1], (this.getSize().width - n17) / 2 + n14 + n * 2 + n2 * 2, 15);
                graphics.drawString(DrawGraph.this.expressionLabel[2], (this.getSize().width - n17) / 2 + n14 + n15 + n * 3 + n2 * 4, 15);
            }
        }

        public void redraw() {
            this.repaint();
        }

        LegendCanvas() {
            DrawGraph.this = DrawGraph.this;
        }
    }

    private class XAxisCanvas
    extends Canvas {
        private GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        private SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
        private Date dat;
        private Integer[] labelLocation = new Integer[8];
        private double lastTime;
        private double time;

        public void paint(Graphics graphics) {
            this.dat = new Date(0L);
            this.cal.setTime(this.dat);
            String string = this.df.format(this.dat);
            graphics.setColor(Color.black);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < 8) {
                n2 = (n4 + 1) * 59 - 16;
                this.labelLocation[n++] = new Integer(n2);
                graphics.drawLine(n2, 0, n2, 4);
                ++n4;
            }
            int n5 = 0;
            while (n5 < 8) {
                Double d;
                n3 = (int)((double)n5 * 14.28);
                if (n3 >= 100) {
                    n3 = 100;
                }
                if ((d = (Double)DrawGraph.this.timeData.elementAt(n3)).longValue() != 0L) {
                    this.dat = new Date(d.longValue());
                    this.cal.setTime(this.dat);
                    string = this.df.format(this.dat);
                    graphics.drawString(string, this.labelLocation[n5] - 24, 16);
                }
                ++n5;
            }
            this.addTimeStamp();
        }

        public void redraw() {
            this.repaint();
        }

        public void addTimeStamp() {
            double d = System.currentTimeMillis();
            DrawGraph.this.timeData.removeElementAt(0);
            DrawGraph.this.timeData.addElement(new Double(d));
            if (d - DrawGraph.this.lastGCTime > 300000.0) {
                System.out.println("Running Garbage Collector");
                DrawGraph.this.lastGCTime = d;
                System.gc();
            }
        }

        XAxisCanvas() {
            DrawGraph.this = DrawGraph.this;
        }
    }

    private class YAxisCanvas
    extends Canvas {
        String[] label = new String[5];

        public void paint(Graphics graphics) {
            boolean bl = false;
            this.getBounds();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.setColor(Color.black);
            graphics.drawLine(35, 9, 38, 9);
            graphics.drawLine(35, 68, 38, 68);
            graphics.drawLine(35, 128, 38, 128);
            graphics.drawLine(35, 188, 38, 188);
            graphics.drawLine(35, 246, 38, 246);
            if (DrawGraph.this.graphSelectorNum == 0) {
                graphics.drawString("%", 18, 32);
                graphics.drawString("%", 18, 149);
            }
            int n = DrawGraph.this.topVal.intValue();
            String string = new String("");
            long l = 1L;
            if ((long)n > 0x100000L) {
                l = 0x100000L;
                string = "M";
            } else if ((long)n > 1024L) {
                l = 1024L;
                string = "K";
            } else {
                l = 1L;
                string = "";
            }
            int n2 = 3 - string.length();
            double d = DrawGraph.this.topVal;
            double d2 = d / (double)l;
            bl = d2 > 9.0;
            if (bl) {
                this.label[0] = String.valueOf(new Integer((int)d2).toString()) + string;
                this.label[1] = String.valueOf(new Integer((int)(d2 * 0.75)).toString()) + string;
                this.label[2] = String.valueOf(new Integer((int)(d2 * 0.5)).toString()) + string;
                this.label[3] = String.valueOf(new Integer((int)(d2 * 0.25)).toString()) + string;
                this.label[4] = new String("0");
            } else {
                new String();
                this.label[0] = new Double(d2).toString();
                this.label[1] = new Double(0.75 * d2).toString();
                this.label[2] = new Double(0.5 * d2).toString();
                this.label[3] = new Double(0.25 * d2).toString();
                this.label[4] = new String("0.0");
            }
            int n3 = 13;
            int n4 = 0;
            while (n4 < 5) {
                int n5;
                if (!bl) {
                    int n6 = this.label[n4].indexOf(46);
                    int n7 = this.label[n4].length();
                    this.label[n4] = n7 - n6 > n2 + 1 ? String.valueOf(this.label[n4].substring(0, n6 + n2 + 1)) + string : String.valueOf(this.label[n4]) + string;
                }
                if ((n5 = 33 - fontMetrics.stringWidth(this.label[n4])) < 0) {
                    n5 = 0;
                }
                graphics.drawString(this.label[n4], n5, n3);
                n3 += 59;
                ++n4;
            }
        }

        public void redraw() {
            this.repaint();
        }

        YAxisCanvas() {
            DrawGraph.this = DrawGraph.this;
        }
    }

    private class DrawCanvas
    extends Canvas {
        private XAxisCanvas xCanvas;
        private YAxisCanvas yCanvas;
        private Double[] dDataToAdd = new Double[4];
        protected int shadow = 4;
        protected boolean raised = true;

        public DrawCanvas(XAxisCanvas xAxisCanvas, YAxisCanvas yAxisCanvas) {
            DrawGraph.this = DrawGraph.this;
            this.xCanvas = xAxisCanvas;
            this.yCanvas = yAxisCanvas;
            int n = 0;
            while (n < DrawGraph.this.numExpressions) {
                this.dDataToAdd[n] = new Double(-1.0);
                ++n;
            }
        }

        public void paint(Graphics graphics) {
            Rectangle rectangle = this.getBounds();
            int n = rectangle.height / 60;
            boolean bl = false;
            graphics.setColor(new Color(239, 239, 247));
            int n2 = 1;
            while (n2 <= n) {
                graphics.drawLine(0, n2 * 60, rectangle.width, n2 * 60);
                ++n2;
            }
            graphics.setColor(Color.lightGray);
            graphics.fillRect(0, 0, rectangle.width, 2);
            graphics.fillRect(0, 0, 2, rectangle.height);
            graphics.setColor(Color.gray);
            graphics.fillRect(0, rectangle.height - 2, rectangle.width, 2);
            graphics.fillRect(rectangle.width - 2, 0, 2, rectangle.height);
            if (DrawGraph.this.nNumTimeouts > 2 || DrawGraph.this.nNumSnmpErrors > 2 || DrawGraph.this.nNumSyntaxErrors > 2 || DrawGraph.this.nNumMibVarErrors > 2) {
                String string = DrawGraph.this.nNumTimeouts > 2 ? new String("No response from device...") : (DrawGraph.this.nNumSnmpErrors > 2 ? new String("Invalid SNMP expression...") : (DrawGraph.this.nNumSyntaxErrors > 2 ? new String("DataColl expression syntax error...") : new String("Unknown MIB variable...")));
                Font font = new Font("Dialog", 3, 18);
                graphics.setFont(font);
                graphics.setColor(Color.black);
                graphics.drawString(string, rectangle.height / 2 - 20, rectangle.width / 3);
                graphics.setColor(Color.blue);
                graphics.drawString(string, rectangle.height / 2 - 21, rectangle.width / 3 - 1);
            }
            if (DrawGraph.this.sDataStarted == 0) {
                return;
            }
            bl = false;
            int n3 = 0;
            while (n3 < DrawGraph.this.numExpressions) {
                if (n3 > 0 && DrawGraph.this.graphSelectorNum == 0 || n3 > 1 && DrawGraph.this.graphSelectorNum == 2 || n3 > 2 && DrawGraph.this.graphSelectorNum == 1) break;
                Double d = (Double)DrawGraph.this.yData[n3].elementAt(0);
                if (d >= DrawGraph.this.highPoint) {
                    bl = true;
                    Double d2 = new Double(0.0);
                    int n4 = 0;
                    while (n4 < DrawGraph.this.numExpressions) {
                        int n5 = 1;
                        while (n5 < 100) {
                            Double d3 = (Double)DrawGraph.this.yData[n4].elementAt(n5);
                            if (d3 > d2) {
                                d2 = d3;
                            }
                            ++n5;
                        }
                        ++n4;
                    }
                    DrawGraph.this.highPoint = d2;
                }
                if (DrawGraph.this.highPoint < this.dDataToAdd[n3]) {
                    DrawGraph.this.highPoint = this.dDataToAdd[n3];
                    bl = true;
                }
                ++n3;
            }
            if (bl) {
                DrawGraph.this.topVal = new Double(1.1 * DrawGraph.this.highPoint);
                if (DrawGraph.this.topVal.intValue() > 15) {
                    DrawGraph.this.topVal = new Double(DrawGraph.this.topVal - DrawGraph.this.topVal % 10.0);
                }
            }
            this.xCanvas.redraw();
            this.yCanvas.redraw();
            int n6 = 0;
            while (n6 < DrawGraph.this.numExpressions) {
                if (!(n6 > 0 && DrawGraph.this.graphSelectorNum == 0 || n6 > 1 && DrawGraph.this.graphSelectorNum == 2 || n6 > 2 && DrawGraph.this.graphSelectorNum == 1)) {
                    if (n6 == 0) {
                        graphics.setColor(Color.blue);
                    } else if (n6 == 1) {
                        graphics.setColor(Color.red);
                    } else if (n6 == 2) {
                        graphics.setColor(Color.darkGray);
                    }
                    double d = this.dDataToAdd[n6];
                    DrawGraph.this.yData[n6].removeElementAt(0);
                    if (d == -1.0E-4) {
                        DrawGraph.this.yData[n6].addElement(new Double(-1.0));
                    } else {
                        DrawGraph.this.yData[n6].addElement(new Double(d));
                    }
                    if (DrawGraph.this.sDataStarted == 1) {
                        DrawGraph.this.yData[n6].removeElementAt(0);
                        DrawGraph.this.yData[n6].addElement(new Double(d));
                    }
                    int n7 = 1;
                    while (n7 < 100) {
                        if (DrawGraph.this.topVal <= 0.0) break;
                        Double d4 = (Double)DrawGraph.this.yData[n6].elementAt(n7 - 1);
                        Double d5 = (Double)DrawGraph.this.yData[n6].elementAt(n7);
                        if (d4.intValue() != -1 && d5.intValue() != -1) {
                            Double d6 = new Double((double)rectangle.height - (double)rectangle.height * (d4 / DrawGraph.this.topVal));
                            Double d7 = new Double((double)rectangle.height - (double)rectangle.height * (d5 / DrawGraph.this.topVal));
                            if (d5.intValue() != -1) {
                                int n8 = (int)((double)n7 * 4.21) - 4;
                                int n9 = (int)((double)n8 + 4.21);
                                if (n7 == 99) {
                                    ++n9;
                                }
                                if (n8 < 2) {
                                    n8 = 2;
                                }
                                graphics.drawLine(n8, d6.intValue(), n9, d7.intValue());
                                if (d4 == 0.0 && d5 == 0.0) {
                                    graphics.drawOval(n9 - 3, d7.intValue() - 3, 6, 6);
                                }
                            }
                        }
                        ++n7;
                    }
                }
                ++n6;
            }
            if (DrawGraph.this.sDataStarted == 1) {
                this.xCanvas.addTimeStamp();
                DrawGraph.this.sDataStarted = 2;
            }
        }

        public void redraw(Double[] doubleArray) {
            this.dDataToAdd = doubleArray;
            this.repaint();
        }

        public int getNumValidExpressions(int n) {
            int n2 = 0;
            switch (n) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
                default: {
                    n2 = DrawGraph.this.numExpressions;
                }
            }
            return n2;
        }
    }

    private class DataCollectorCallback
    implements CollectorCallbackIf {
        public void dataReturn(long[] lArray) {
            if (DrawGraph.this.bFirstDCdata) {
                DrawGraph.this.bFirstDCdata = false;
                return;
            }
            if (DrawGraph.this.sDataStarted == 0) {
                DrawGraph.this.sDataStarted = 1;
            }
            DrawGraph.this.nNumTimeouts = 0;
            DrawGraph.this.nNumSnmpErrors = 0;
            DrawGraph.this.nNumSyntaxErrors = 0;
            DrawGraph.this.nNumMibVarErrors = 0;
            Double[] doubleArray = new Double[4];
            if (DrawGraph.this.graphSelectorNum == 0) {
                if (lArray[0] == 0L || lArray[1] == 0L || lArray[2] == 0L) {
                    doubleArray[0] = new Double(0.0);
                } else {
                    double d = (double)lArray[0] * 8.0;
                    double d2 = (double)lArray[2] / 100.0;
                    double d3 = lArray[1];
                    doubleArray[0] = new Double(d * 100.0 / (d2 * d3));
                    doubleArray[0] = doubleArray[0] > 100.0 ? new Double(100.0) : doubleArray[0];
                }
                System.out.println("DataCollectorCallback::dataReturn(): values[0] = " + lArray[0] + " values[1] = " + lArray[1] + " values[2] = " + lArray[2] + ", real %util = " + doubleArray[0]);
                doubleArray[1] = new Double(-1.0);
            } else if (DrawGraph.this.graphSelectorNum == 1 || DrawGraph.this.graphSelectorNum == 2) {
                int n = 0;
                while (n < DrawGraph.this.numExpressions) {
                    if (n == DrawGraph.this.numExpressions - 1) {
                        doubleArray[n] = new Double(-1.0);
                        System.out.println("DataCollectorCallback::dataReturn(): values[" + n + "] = " + lArray[n] + " (sysUpTime)");
                    } else {
                        doubleArray[n] = new Double((double)lArray[n] / ((double)lArray[DrawGraph.this.numExpressions - 1] / 100.0));
                        System.out.println("DataCollectorCallback::dataReturn(): values[" + n + "] = " + lArray[n] + " dValue[i] = " + doubleArray[n]);
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < DrawGraph.this.numExpressions) {
                    doubleArray[n] = new Double(lArray[n]);
                    System.out.println("DataCollectorCallback::dataReturn(): values[" + n + "] = " + lArray[n]);
                    ++n;
                }
            }
            DrawGraph.this.mainCanvas.redraw(doubleArray);
        }

        public void errorReturn(byte by) {
            if (by == 0) {
                return;
            }
            Double[] doubleArray = new Double[4];
            int n = 0;
            while (n < DrawGraph.this.numExpressions) {
                doubleArray[n] = new Double(-1.0);
                ++n;
            }
            switch (by) {
                case 3: {
                    System.out.println("DataCollectorCallback::errorReturn(): errCode = REQUEST_INTERVAL_TIMEOUT");
                    ++DrawGraph.this.nNumTimeouts;
                    break;
                }
                case 1: {
                    System.out.println("DataCollectorCallback::errorReturn(): errCode = REQUEST_NON_NUMERIC_TYPE");
                    break;
                }
                case 2: {
                    System.out.println("DataCollectorCallback::errorReturn(): errCode = REQUEST_SNMP_ERROR");
                    ++DrawGraph.this.nNumSnmpErrors;
                    break;
                }
                case 4: {
                    System.out.println("DataCollectorCallback::errorReturn(): errCode = REQUEST_EXPRESSION_SYNTAX");
                    ++DrawGraph.this.nNumSyntaxErrors;
                    break;
                }
                case 5: {
                    System.out.println("DataCollectorCallback::errorReturn(): errCode = REQUEST_UNKNOWN_MIB_VAR");
                    ++DrawGraph.this.nNumMibVarErrors;
                    break;
                }
            }
            DrawGraph.this.mainCanvas.redraw(doubleArray);
        }

        DataCollectorCallback() {
            DrawGraph.this = DrawGraph.this;
        }
    }
}

