/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import netscape.javascript.JSObject;

class StackTopoPanel
extends Panel
implements Runnable {
    public Node centerNode;
    public JSObject docWindow;
    public boolean bLabel;
    public boolean bIsBrowserIE;
    private final int MAX_EDGES = 60;
    private final int MAX_NODES = 40;
    private final int MAX_STACK_NODES = 10;
    private Dimension mySize;
    private Frame myFrame;
    private Applet myApplet;
    private StackTopo sTopo;
    private int nStackNodes;
    private int nnodes;
    private Hashtable nodes = new Hashtable(20);
    private Hashtable stackNodes = new Hashtable(20);
    private int nedges;
    private Hashtable edges = new Hashtable(20);
    private Node curNode;
    private Edge curEdge;
    private Node currSelNode;
    private Node endNode;
    private Point curPoint = new Point(0, 0);
    private boolean bCurrSelNodeFixed;
    private String selectedInterface;
    private String endNodeInterface;
    private Thread initialDrawThread;
    private boolean bDeviceClicked = false;
    private boolean bLinkClicked = false;
    private boolean layoutCompleted = false;
    private Graphics offgraphics;
    private Image offscreen;
    private Dimension offscreensize;
    private final Color fixedColor = Color.cyan;
    private final Color selectColor = Color.pink;
    private final Color edgeColor = Color.black;
    private final Color nodeColor = new Color(250, 220, 100);
    private final Color ciscoBlue = new Color(84, 116, 140);
    private final Color medGray = new Color(204, 204, 204);
    private boolean nodeCapacityReached = false;
    private boolean edgeCapacityReached = false;
    private final int EDGE_LEN = 150;
    private final int ABOVE = 0;
    private final int BELOW = 1;
    private final int LEFT = 2;
    private final int RIGHT = 3;
    private static final int MENU_TYPE_RESET = -2;
    private static final int MENU_TYPE_NONE = -1;
    private static final int MENU_TYPE_SNODE = 0;
    private static final int MENU_TYPE_LINK = 1;
    private static final int MENU_TYPE_ENODE = 2;
    private static final int MAX_MENUS = 3;
    private static final int SUBMENU_TYPE_REPORT = 0;
    private static final int SUBMENU_TYPE_CONSOLE = 1;
    private String[][] SubMenu;
    private String[][] SubMenuURL;
    private int[] MenuAreaX = new int[3];
    private int[] MenuAreaY = new int[3];
    private int[] MAWidth = new int[3];
    private int[] MAHeight = new int[3];
    private int semLeftMouseInfo;
    private int curMenu = -1;
    private int curSubMenu;
    private String curURL;
    private int[] numItems = new int[]{2, 1, 1};
    private Font f;
    private FontMetrics fm;
    private int currOldX = -1;
    private int currOldY = -1;

    public StackTopoPanel(StackTopo stackTopo) {
        int n;
        this.sTopo = stackTopo;
        Container container = stackTopo;
        while (container != null) {
            if (this.myApplet == null && container instanceof Applet) {
                this.myApplet = container;
            }
            if (this.myFrame == null && container instanceof Frame) {
                this.myFrame = (Frame)container;
            }
            container = ((Component)container).getParent();
        }
        this.myApplet.getAppletContext().showStatus("Cisco Stack Topology Map");
        this.setBackground(Color.lightGray);
        int n2 = 0;
        while (n2 <= 3) {
            this.SubMenu = new String[n2][];
            this.SubMenuURL = new String[n2][];
            ++n2;
        }
        int n3 = 0;
        while (n3 < 3) {
            this.SubMenu[n3] = new String[this.numItems[n3]];
            this.SubMenuURL[n3] = new String[this.numItems[n3]];
            ++n3;
        }
        this.SubMenu[0][0] = "Device Report...";
        this.SubMenu[0][1] = "Switch Manager...";
        this.SubMenu[1][0] = "Link Report...";
        this.SubMenu[2][0] = "Device Web Page...";
        this.SubMenuURL[0][0] = "Display Device Inventory";
        this.SubMenuURL[0][1] = "Launch Web Console";
        this.SubMenuURL[1][0] = "Display Link Characteristics";
        this.SubMenuURL[2][0] = "Display Device Web Page";
        int n4 = n = 15;
        while (n4 > 3) {
            this.f = new Font("Dialog", 0, n4);
            this.fm = this.getFontMetrics(this.f);
            if (this.fm.getHeight() <= n) break;
            --n4;
        }
        n4 = 0;
        while (n4 < 3) {
            this.MAWidth[n4] = 150;
            this.MAHeight[n4] = (this.fm.getAscent() + 2) * this.numItems[n4] + 4;
            ++n4;
        }
    }

    public int findNode(String string) {
        int n;
        Node node = this.getNode(string);
        if (node != null) {
            n = node.nodeNum;
        } else {
            n = -1;
            System.out.println("StackTopoPanel: findNode(" + string + ") FAILED!!!");
        }
        return n;
    }

    public int addNode(String string, String string2, URL uRL, URL uRL2, Image image) {
        Node node = null;
        if (this.nodes.get(string) == null) {
            node = new Node();
            node.x = 10.0;
            node.y = 10.0;
            node.ipLbl = string;
            node.deviceLbl = string2;
            node.devUrl = uRL;
            node.consoleUrl = uRL2;
            node.img = image;
            node.bFixed = false;
            node.bStack = false;
            node.bPlaced = false;
            node.bNeighborsPlaced = false;
            node.nodeNum = this.nnodes++;
            this.nodes.put(string, node);
        }
        return this.nnodes;
    }

    public void addEdge(String string, String string2, int n, String string3, String string4) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.nedges == 60) {
            if (!this.edgeCapacityReached) {
                this.edgeCapacityReached = true;
                String string5 = "Maximum device limit reached\n\n";
                string5 = String.valueOf(string5) + "Some devices in your network may not appear properly in the Network View!";
                AttentionDialog attentionDialog = new AttentionDialog("Warning!", string5);
                attentionDialog.show();
            }
            return;
        }
        int n2 = this.findNode(string);
        int n3 = this.findNode(string2);
        if (n2 == -1 || n3 == -1 || n2 == n3) {
            return;
        }
        Edge edge = this.getEdge(String.valueOf(string) + string2);
        if (edge != null) {
            bl2 = true;
            if (edge.fromPortLbl.compareTo(string3) == 0) {
                return;
            }
            bl = true;
            edge.bDontLabelMe = true;
        } else {
            edge = this.getEdge(String.valueOf(string2) + string);
            if (edge != null) {
                bl2 = true;
                if (edge.fromPortLbl.compareTo(string4) == 0) {
                    return;
                }
                bl = true;
                edge.bDontLabelMe = true;
            }
        }
        Edge edge2 = new Edge();
        edge2.from = n2;
        edge2.to = n3;
        edge2.len = n;
        edge2.fromLbl = string;
        edge2.toLbl = string2;
        edge2.fromPortLbl = string3;
        edge2.toPortLbl = string4;
        edge2.bFastEthChannel = bl;
        edge2.bDontLabelMe = bl;
        if (!bl2) {
            this.getNode((String)edge2.fromLbl).neighbors.addElement(edge2.toLbl);
            this.getNode((String)edge2.toLbl).neighbors.addElement(edge2.fromLbl);
        }
        this.edges.put(String.valueOf(string) + string2, edge2);
        ++this.nedges;
    }

    public void addStackNode(String string) {
        Node node = this.getNode(string);
        if (node != null && this.getStackNode(string) == null) {
            node.bStack = true;
            node.bFixed = true;
            ++this.nStackNodes;
            this.stackNodes.put(string, node);
        }
    }

    public Edge getEdge(String string) {
        return (Edge)this.edges.get(string);
    }

    public Node getNode(String string) {
        return (Node)this.nodes.get(string);
    }

    public Node getStackNode(String string) {
        return (Node)this.stackNodes.get(string);
    }

    private int computePositionRelToCaptain(Node node) {
        int n = node.primaryEdgeLen;
        double d = (node.y - this.centerNode.y) / (double)n;
        int n2 = 4;
        if (node != this.centerNode) {
            n2 = d > -0.707 && d < 0.707 ? (node.x < this.centerNode.x ? 2 : 3) : (node.y < this.centerNode.y ? 0 : 1);
        }
        return n2;
    }

    private int getNumNeighbors(Node node) {
        return node.neighbors.size();
    }

    private int getNumStackNeighbors(Node node) {
        int n = this.getNumNeighbors(node);
        int n2 = 0;
        Node node2 = null;
        int n3 = 0;
        while (n3 < n) {
            node2 = this.getNode((String)node.neighbors.elementAt(n3));
            if (node2 != null && node2.bStack) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private boolean isDeviceOutOfBounds(Node node) {
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (node.x > (double)dimension.width || (int)node.x < 0 || node.y > (double)dimension.height || (int)node.y < 0) {
            bl = true;
        }
        return bl;
    }

    private void computeCoordinates(Node node, Node node2, int n, double d) {
        node.x = node2.x + (double)n * Math.cos(d);
        node.y = node2.y - (double)n * Math.sin(d);
        node.posWRTPrimaryNeighbor = d;
    }

    private boolean isLinkOnAnotherLink(Node node, Node node2, double d) {
        boolean bl = false;
        int n = this.getNumNeighbors(node2);
        double d2 = Math.PI * 2;
        int n2 = 0;
        while (n2 < n && !bl) {
            Node node3 = this.getNode((String)node2.neighbors.elementAt(n2));
            if (node3 != node && node3.bPlaced && node.posWRTPrimaryNeighbor % d2 == node3.posWRTPrimaryNeighbor % d2) {
                bl = true;
            }
            ++n2;
        }
        return bl;
    }

    public void setCoordinates(Node node, Node node2, int n, double d, double d2) {
        double d3 = 1.0;
        double d4 = 0.25;
        double d5 = d;
        double d6 = d2;
        int n2 = 0;
        double d7 = n;
        if (!node.bPlaced || node.bStack && node2.bStack) {
            this.computeCoordinates(node, node2, (int)d7, d5);
            while (this.isLinkOnAnotherLink(node, node2, d5) || this.isDeviceOutOfBounds(node) || this.isDeviceUnderCursor(node)) {
                if ((double)(++n2) * d6 >= Math.PI * 2) {
                    d6 = d2 * d3;
                    d3 -= d4;
                    n2 = 0;
                    if (d6 < 0.17453292519943295) {
                        if (d7 == 1.5 * (double)n) {
                            System.out.println("Topology too crowded.. Giving up");
                            break;
                        }
                        d7 = d7 == (double)n ? (double)n * 0.5 : (double)n * 1.5;
                        d6 = d2;
                        d5 = d;
                        this.computeCoordinates(node, node2, (int)d7, d5);
                    }
                }
                this.computeCoordinates(node, node2, (int)d7, d5 += d6);
            }
            d = d5;
            node.bPlaced = true;
            node.primaryEdgeLen = (int)d7;
        }
    }

    private synchronized void placeNeighbors(Node node) {
        int n = this.getNumNeighbors(node);
        int n2 = this.getNumStackNeighbors(node);
        double d = 0.0;
        double d2 = 0.0;
        Node node2 = null;
        int n3 = 0;
        double d3 = 0.0;
        int n4 = n - n2;
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 1;
        int n6 = 1;
        int n7 = n > 6 ? (int)(120.0 * (double)n / 6.0) : 120;
        int n8 = 0;
        if (node == this.centerNode) {
            int n9 = n7 = n > 12 ? (int)((double)(150 * n) / 12.0) : 150;
        }
        if (!node.bNeighborsPlaced) {
            n3 = this.computePositionRelToCaptain(node);
            d5 = Math.PI;
            double d6 = n2 > 1 ? d5 / (double)(n2 - 1) : 0.7853981633974483;
            double d7 = n4 > 1 ? d5 / (double)(n4 - 1) : 0.7853981633974483;
            switch (n3) {
                case 0: {
                    d = Math.PI;
                    n5 = -1;
                    n6 = -1;
                    break;
                }
                case 1: {
                    d = -Math.PI;
                    break;
                }
                case 3: {
                    d = 1.5707963267948966;
                    n5 = -1;
                    n6 = -1;
                    break;
                }
                case 2: {
                    d = 1.5707963267948966;
                    break;
                }
                default: {
                    d5 = Math.PI * 2;
                    d = 1.5707963267948966;
                    d6 = n2 > 1 ? d5 / (double)n2 : 0.7853981633974483;
                    d7 = n4 > 1 ? d5 / (double)n4 : 0.7853981633974483;
                }
            }
            d2 = d;
            d3 = d6 *= (double)n6;
            d4 = d7 *= (double)n5;
            int n10 = 0;
            while (n10 < n) {
                node2 = this.getNode((String)node.neighbors.elementAt(n10));
                if (!node2.bPlaced && node2.bStack) {
                    n8 = node2.neighbors.size() > 6 ? n7 * node2.neighbors.size() / 6 : n7;
                    this.setCoordinates(node2, node, n8, d2, d3);
                    d2 += d6;
                }
                ++n10;
            }
            d2 = d;
            int n11 = 0;
            while (n11 < n) {
                node2 = this.getNode((String)node.neighbors.elementAt(n11));
                if (!node2.bPlaced && !node2.bStack) {
                    n8 = node2.neighbors.size() > 6 ? n7 * node2.neighbors.size() / 6 : n7;
                    this.setCoordinates(node2, node, n8, d2, d4);
                    d2 += d7;
                }
                ++n11;
            }
            node.bNeighborsPlaced = true;
            int n12 = 0;
            while (n12 < n) {
                node2 = this.getNode((String)node.neighbors.elementAt(n12));
                this.placeNeighbors(node2);
                ++n12;
            }
        }
    }

    private synchronized void drawInitialNodes() {
        this.centerNode.x = 400.0;
        this.centerNode.y = 400.0;
        this.centerNode.bPlaced = true;
        this.centerNode.posWRTPrimaryNeighbor = -1.0;
        this.placeNeighbors(this.centerNode);
        this.layoutCompleted = true;
    }

    private void paintNode(Graphics graphics, Node node, FontMetrics fontMetrics) {
        String string;
        int n = (int)node.x;
        int n2 = (int)node.y;
        String string2 = string = this.bLabel ? node.deviceLbl : node.ipLbl;
        Color color = node == this.currSelNode ? this.selectColor : (node.bFixed ? this.fixedColor : this.nodeColor);
        graphics.setColor(color);
        int n3 = 0;
        int n4 = 0;
        if (node.img != null) {
            n4 = node.img.getWidth(this);
            n3 = node.img.getHeight(this);
            graphics.drawImage(node.img, n - n4 / 2, n2 - n3 / 2, n4, n3, Color.black, this);
        }
        int n5 = fontMetrics.stringWidth(string) + 10;
        int n6 = fontMetrics.getHeight() + 4;
        int n7 = n - n5 / 2;
        int n8 = n2 + n3 / 2 + 10;
        graphics.fillRect(n7, n8, n5, n6);
        graphics.setColor(Color.black);
        graphics.drawRect(n7, n8, n5 - 1, n6 - 1);
        graphics.drawString(string, n7 + 5, n8 + fontMetrics.getAscent() + 2);
    }

    private void paintEdge(Graphics graphics, Edge edge, FontMetrics fontMetrics) {
        int n = (int)this.getNode((String)edge.fromLbl).x;
        int n2 = (int)this.getNode((String)edge.fromLbl).y;
        int n3 = (int)this.getNode((String)edge.toLbl).x;
        int n4 = (int)this.getNode((String)edge.toLbl).y;
        if (edge.bFastEthChannel) {
            graphics.setColor(this.ciscoBlue);
            graphics.drawLine(n - 3, n2, n3 - 3, n4);
            graphics.drawLine(n - 2, n2, n3 - 2, n4);
            graphics.drawLine(n - 1, n2, n3 - 1, n4);
            graphics.drawLine(n + 1, n2, n3 + 1, n4);
            graphics.drawLine(n + 2, n2, n3 + 2, n4);
            graphics.drawLine(n + 3, n2, n3 + 3, n4);
            graphics.drawLine(n, n2 - 3, n3, n4 - 3);
            graphics.drawLine(n, n2 - 2, n3, n4 - 2);
            graphics.drawLine(n, n2 - 1, n3, n4 - 1);
            graphics.drawLine(n, n2 + 1, n3, n4 + 1);
            graphics.drawLine(n, n2 + 2, n3, n4 + 2);
            graphics.drawLine(n, n2 + 3, n3, n4 + 3);
            graphics.setColor(Color.yellow);
            graphics.drawLine(n, n2, n3, n4);
        } else if (!this.getNode((String)edge.toLbl).bStack) {
            graphics.setColor(this.edgeColor);
            graphics.drawLine(n, n2, n3, n4);
        } else {
            graphics.setColor(this.ciscoBlue);
            graphics.drawLine(n - 2, n2, n3 - 2, n4);
            graphics.drawLine(n - 1, n2, n3 - 1, n4);
            graphics.drawLine(n, n2, n3, n4);
            graphics.drawLine(n + 1, n2, n3 + 1, n4);
            graphics.drawLine(n + 2, n2, n3 + 2, n4);
            graphics.drawLine(n, n2 - 2, n3, n4 - 2);
            graphics.drawLine(n, n2 - 1, n3, n4 - 1);
            graphics.drawLine(n, n2 + 1, n3, n4 + 1);
            graphics.drawLine(n, n2 + 2, n3, n4 + 2);
        }
        if (this.bLabel && !edge.bDontLabelMe) {
            int n5 = fontMetrics.stringWidth(edge.fromPortLbl) + 10;
            int n6 = fontMetrics.getHeight() + 4;
            int n7 = fontMetrics.stringWidth(edge.toPortLbl) + 10;
            int n8 = n + (n3 - n) / 3;
            int n9 = n2 + (n4 - n2) / 3;
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n8 - n5 / 2, n9 - n6 / 2, n5, n6);
            graphics.setColor(Color.black);
            graphics.drawString(edge.fromPortLbl, n8 - (n5 - 10) / 2, n9 - (n6 - 4) / 2 + fontMetrics.getAscent());
            n8 = n + 2 * (n3 - n) / 3;
            n9 = n2 + 2 * (n4 - n2) / 3;
            graphics.setColor(Color.lightGray);
            graphics.fillRect(n8 - n7 / 2, n9 - n6 / 2, n7, n6);
            graphics.setColor(Color.black);
            graphics.drawString(edge.toPortLbl, n8 - (n7 - 10) / 2, n9 - (n6 - 4) / 2 + fontMetrics.getAscent());
        }
    }

    private void drawLeftMouseInfo(Graphics graphics) {
        graphics.setFont(this.f);
        String string = new String("Use the right mouse button");
        String string2 = new String("to access the menu for real-time");
        String string3 = new String("reports.");
        int n = this.fm.stringWidth(string2) + 20;
        int n2 = this.fm.getHeight() + 4;
        int n3 = this.curPoint.x - n / 2;
        int n4 = this.curPoint.y - n2 * 3;
        graphics.setColor(Color.cyan);
        graphics.fillRect(n3, n4 - 10, n, n2 * 3);
        graphics.setColor(Color.white);
        graphics.drawLine(n3, n4 - 10, n3 + n, n4 - 10);
        graphics.drawLine(n3, n4 - 10, n3, n4 - 10 + n2 * 3);
        graphics.setColor(Color.black);
        graphics.drawLine(n3, n4 - 10 + n2 * 3, n3 + n, n4 - 10 + n2 * 3);
        graphics.drawLine(n3 + n, n4 - 10, n3 + n, n4 - 10 + n2 * 3);
        graphics.setColor(Color.blue);
        graphics.drawString(string, n3 + 10, n4 + 10);
        graphics.drawString(string2, n3 + 10, n4 + 10 + (this.fm.getAscent() + 2));
        graphics.drawString(string3, n3 + 10, n4 + 10 + 2 * (this.fm.getAscent() + 2));
    }

    private void drawMenu(Graphics graphics) {
        this.MenuAreaX[this.curMenu] = this.curPoint.x - 2;
        this.MenuAreaY[this.curMenu] = this.curPoint.y - 2;
        int n = this.MAWidth[this.curMenu] + this.MenuAreaX[this.curMenu];
        int n2 = this.MAHeight[this.curMenu] + this.MenuAreaY[this.curMenu];
        graphics.setFont(this.f);
        graphics.setColor(this.medGray);
        graphics.fillRect(this.MenuAreaX[this.curMenu], this.MenuAreaY[this.curMenu], this.MAWidth[this.curMenu], this.MAHeight[this.curMenu]);
        graphics.setColor(Color.white);
        graphics.drawLine(this.MenuAreaX[this.curMenu], this.MenuAreaY[this.curMenu], n, this.MenuAreaY[this.curMenu]);
        graphics.drawLine(this.MenuAreaX[this.curMenu], this.MenuAreaY[this.curMenu], this.MenuAreaX[this.curMenu], n2);
        graphics.setColor(Color.black);
        graphics.drawLine(n, this.MenuAreaY[this.curMenu], n, n2);
        graphics.drawLine(this.MenuAreaX[this.curMenu], n2, n, n2);
        if (this.curSubMenu >= 0) {
            int n3 = 0;
            while (n3 < this.numItems[this.curMenu]) {
                if (this.curSubMenu == n3) {
                    graphics.setColor(Color.blue);
                } else if (this.curSubMenu == n3 - 1) {
                    graphics.setColor(Color.black);
                } else {
                    graphics.setColor(Color.black);
                }
                graphics.drawString(this.SubMenu[this.curMenu][n3], this.MenuAreaX[this.curMenu] + 4, this.MenuAreaY[this.curMenu] + (n3 + 1) * (this.fm.getAscent() + 2));
                ++n3;
            }
        }
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension;
        if (!this.layoutCompleted) {
            return;
        }
        this.mySize = dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.offscreensize.width || dimension.height != this.offscreensize.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.offscreensize = dimension;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        int n = 0;
        this.offgraphics.setColor(Color.black);
        this.offgraphics.drawRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        this.offgraphics.setColor(Color.white);
        this.offgraphics.drawRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        this.offgraphics.setColor(Color.black);
        this.offgraphics.drawRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(n, n, dimension.width - 2 * n, dimension.height - 2 * n++);
        FontMetrics fontMetrics = this.offgraphics.getFontMetrics();
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            this.paintEdge(this.offgraphics, (Edge)enumeration.nextElement(), fontMetrics);
        }
        Enumeration enumeration2 = this.nodes.elements();
        while (enumeration2.hasMoreElements()) {
            this.paintNode(this.offgraphics, (Node)enumeration2.nextElement(), fontMetrics);
        }
        if (this.semLeftMouseInfo > 0) {
            this.drawLeftMouseInfo(this.offgraphics);
        }
        if (this.curMenu >= 0) {
            this.drawMenu(this.offgraphics);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    private void ProcessMenuSelection() {
        this.setCursor(new Cursor(3));
        try {
            if (this.curMenu == 2) {
                this.sTopo.getAppletContext().showDocument(this.curNode.consoleUrl, "Document window");
            } else if (this.curMenu == 1 || this.curSubMenu == 0) {
                if (this.curNode.bStack) {
                    JSObject jSObject = (JSObject)this.docWindow.getMember("document");
                    JSObject jSObject2 = (JSObject)jSObject.getMember("DrawGraph");
                    String string = this.removeChars(this.curNode.ipLbl, ".");
                    JSObject jSObject3 = (JSObject)jSObject2.getMember("WindowName");
                    jSObject3.setMember("value", string);
                    JSObject jSObject4 = (JSObject)jSObject2.getMember("DevIpAddr");
                    jSObject4.setMember("value", this.curNode.ipLbl);
                    String string2 = this.curNode.deviceLbl;
                    string2 = string2.replace(' ', '~');
                    JSObject jSObject5 = (JSObject)jSObject2.getMember("DevName");
                    jSObject5.setMember("value", string2);
                    this.selectedInterface = this.selectedInterface != null ? this.selectedInterface.replace(' ', '~') : new String("0");
                    JSObject jSObject6 = (JSObject)jSObject2.getMember("DevInterface");
                    jSObject6.setMember("value", this.selectedInterface);
                    JSObject jSObject7 = (JSObject)jSObject2.getMember("GraphType");
                    String string3 = this.bDeviceClicked ? new String("devReport") : new String("linkReport");
                    jSObject7.setMember("value", string3);
                    if (this.endNode != null) {
                        jSObject4 = (JSObject)jSObject2.getMember("EndIpAddr");
                        jSObject4.setMember("value", this.endNode.ipLbl);
                        string2 = this.endNode.deviceLbl;
                        string2 = string2.replace(' ', '~');
                        jSObject5 = (JSObject)jSObject2.getMember("EndName");
                        jSObject5.setMember("value", string2);
                        if (this.endNodeInterface != null) {
                            this.endNodeInterface = this.endNodeInterface.replace(' ', '~');
                        }
                        jSObject6 = (JSObject)jSObject2.getMember("EndInterface");
                        jSObject6.setMember("value", this.endNodeInterface);
                    }
                    Object[] objectArray = new Object[]{new Integer(0)};
                    this.docWindow.call("startGraph", objectArray);
                } else {
                    this.sTopo.getAppletContext().showDocument(this.curNode.consoleUrl, "Document window");
                }
            } else if (this.curSubMenu == 1) {
                String string = this.removeChars(this.curNode.ipLbl, ".");
                this.sTopo.getAppletContext().showDocument(this.curNode.consoleUrl, string);
            }
        }
        catch (Exception exception) {
            System.out.println("StackTopoPanel: ProcessMenuSelection():: Exception performing popup menu action: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.curSubMenu = -1;
        this.curMenu = -1;
        this.curNode = null;
        this.curEdge = null;
        this.selectedInterface = null;
    }

    private Node deviceClicked(int n, int n2) {
        Node node = null;
        boolean bl = false;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements() && !bl) {
            Node node2 = (Node)enumeration.nextElement();
            String string = this.bLabel ? node2.deviceLbl : node2.ipLbl;
            int n3 = node2.img.getWidth(this);
            int n4 = node2.img.getHeight(this);
            int n5 = this.fm.stringWidth(string) + 10;
            int n6 = this.fm.getHeight() + 4;
            if (!((double)n > node2.x - (double)(n3 / 2) && (double)n < node2.x + (double)(n3 / 2) && (double)n2 > node2.y - (double)(n4 / 2) && (double)n2 < node2.y + (double)(n4 / 2)) && (!((double)n > node2.x - (double)(n5 / 2)) || !((double)n < node2.x + (double)(n5 / 2)) || !((double)n2 > node2.y - (double)(n6 / 2) + 25.0) || !((double)n2 < node2.y + (double)(n6 / 2) + 25.0))) continue;
            bl = true;
            node = node2;
        }
        return node;
    }

    private boolean isDeviceUnderCursor(Node node) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        n = node.img.getWidth(this);
        n2 = node.img.getHeight(this);
        if (n == -1) {
            n = 32;
        }
        if (n2 == -1) {
            n2 = 21;
        }
        String string = this.bLabel ? node.deviceLbl : node.ipLbl;
        int n3 = this.fm.stringWidth(string) + 10;
        int n4 = this.fm.getHeight() + 4;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        rectangle.x = (int)node.x;
        rectangle.y = (int)node.y - n2 / 2;
        rectangle.height = n2;
        rectangle.width = n;
        rectangle2.x = (int)(node.x - (double)(n3 / 2));
        rectangle2.y = (int)(node.y + (double)(n2 / 2) + 10.0);
        rectangle2.width = n3;
        rectangle2.height = n4;
        Rectangle rectangle3 = new Rectangle();
        Rectangle rectangle4 = new Rectangle();
        Node node2 = null;
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements() && !bl) {
            node2 = (Node)enumeration.nextElement();
            if (node2 == node) continue;
            n = node2.img.getWidth(this);
            n2 = node2.img.getHeight(this);
            if (n == -1) {
                n = 32;
            }
            if (n2 == -1) {
                n2 = 21;
            }
            string = this.bLabel ? node2.deviceLbl : node2.ipLbl;
            n3 = this.fm.stringWidth(string) + 10;
            n4 = this.fm.getHeight() + 4;
            rectangle3.x = (int)node2.x;
            rectangle3.y = (int)node2.y - n2 / 2;
            rectangle3.width = n;
            rectangle3.height = n2;
            rectangle4.x = (int)(node2.x - (double)(n3 / 2));
            rectangle4.y = (int)(node2.y + (double)(n2 / 2) + 10.0);
            rectangle4.width = n3;
            rectangle4.height = n4;
            if (rectangle3.intersects(rectangle) || rectangle3.intersects(rectangle2) || rectangle4.intersects(rectangle)) {
                bl = true;
                continue;
            }
            if ((double)rectangle3.x == node.x && (double)rectangle3.y == node.y) {
                bl = true;
                continue;
            }
            rectangle4.intersects(rectangle2);
        }
        return bl;
    }

    boolean isPointOnLink(int n, int n2) {
        this.bLinkClicked = false;
        boolean bl = false;
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            Edge edge = (Edge)enumeration.nextElement();
            bl = false;
            int n3 = (int)this.getNode((String)edge.fromLbl).x;
            int n4 = (int)this.getNode((String)edge.fromLbl).y;
            int n5 = (int)this.getNode((String)edge.toLbl).x;
            int n6 = (int)this.getNode((String)edge.toLbl).y;
            if (n3 == n5) {
                if (n < n3 - 3 || n > n3 + 3) continue;
                if (n6 > n4) {
                    if (n2 < n4 || n2 > n6) continue;
                    this.LinkIsSelected(edge, n, n2);
                    continue;
                }
                if (n4 <= n6 || n2 > n4 || n2 < n6) continue;
                this.LinkIsSelected(edge, n, n2);
                continue;
            }
            double d = (double)(n6 - n4) / (double)(n5 - n3);
            int n7 = (int)((double)n6 - d * (double)n5);
            if (d >= -1.0 && d <= 1.0) {
                int n8 = (int)(d * (double)n + (double)n7);
                if (n2 >= n8 - 3 && n2 <= n8 + 3) {
                    bl = true;
                }
            } else {
                int n9 = (int)((double)(n2 - n7) / d);
                if (n >= n9 - 3 && n <= n9 + 3) {
                    bl = true;
                }
            }
            if (!bl) continue;
            if (n5 > n3 && n >= n3 - 3 && n <= n5 + 3) {
                if (n4 > n6 && n2 >= n6 - 3 && n2 <= n4 + 3) {
                    this.LinkIsSelected(edge, n, n2);
                    continue;
                }
                if (n2 < n4 - 3 || n2 > n6 + 3) continue;
                this.LinkIsSelected(edge, n, n2);
                continue;
            }
            if (n > n3 + 3 || n < n5 - 3) continue;
            if (n4 > n6 && n2 >= n6 - 3 && n2 <= n4 + 3) {
                this.LinkIsSelected(edge, n, n2);
                continue;
            }
            if (n2 < n4 - 3 || n2 > n6 + 3) continue;
            this.LinkIsSelected(edge, n, n2);
        }
        return this.bLinkClicked;
    }

    void LinkIsSelected(Edge edge, int n, int n2) {
        Node node = null;
        Node node2 = null;
        if (this.curMenu > 0) {
            this.curMenu = -1;
            this.curEdge = null;
            this.curNode = null;
            return;
        }
        this.bLinkClicked = true;
        this.curSubMenu = 0;
        this.curMenu = 1;
        this.curPoint.x = n;
        this.curPoint.y = n2;
        this.curEdge = edge;
        node = this.getNode(edge.fromLbl);
        node2 = this.getNode(edge.toLbl);
        if (node.bStack) {
            if (node == this.centerNode && node2.bStack) {
                this.curNode = node2;
                this.endNode = node;
                this.selectedInterface = edge.toPortLbl;
                this.endNodeInterface = edge.fromPortLbl;
                return;
            }
            this.curNode = node;
            this.endNode = node2;
            this.selectedInterface = edge.fromPortLbl;
            this.endNodeInterface = edge.toPortLbl;
            return;
        }
        this.curNode = node;
        this.endNode = node2;
        this.selectedInterface = edge.fromPortLbl;
        this.endNodeInterface = edge.toPortLbl;
    }

    private String removeChars(String string, String string2) {
        String string3 = new String("");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = String.valueOf(string3) + stringTokenizer.nextToken();
        }
        return string3;
    }

    void topoMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.semLeftMouseInfo != -1) {
            this.semLeftMouseInfo = 0;
        }
        if (mouseEvent.getModifiers() != 4) {
            this.curPoint.x = n;
            this.curPoint.y = n2;
            if (this.curMenu >= 0) {
                this.ProcessMenuSelection();
            } else {
                this.currSelNode = null;
                Node node = this.deviceClicked(n, n2);
                if (node != null) {
                    this.currSelNode = node;
                    this.currOldX = (int)node.x;
                    this.currOldY = (int)node.y;
                    if (this.semLeftMouseInfo != -1) {
                        this.semLeftMouseInfo = 1;
                    }
                } else if (this.isPointOnLink(n, n2)) {
                    if (this.semLeftMouseInfo != -1) {
                        this.semLeftMouseInfo = 1;
                    }
                    this.curMenu = -1;
                    this.curEdge = null;
                    this.curNode = null;
                }
                if (this.currSelNode != null) {
                    this.bCurrSelNodeFixed = this.currSelNode.bFixed;
                    this.currSelNode.bFixed = true;
                    if (!this.currSelNode.bStack) {
                        this.setCursor(new Cursor(13));
                    }
                    if (mouseEvent.getClickCount() == 2) {
                        this.setCursor(new Cursor(3));
                        try {
                            String string = this.removeChars(this.currSelNode.ipLbl, ".");
                            System.out.println("Window name = " + string);
                            this.sTopo.getAppletContext().showDocument(this.currSelNode.consoleUrl, string);
                        }
                        catch (Exception exception) {
                            System.out.println("StackTopoPanel: mouseDown():: Exception showing URL! - " + exception.getMessage());
                            exception.printStackTrace();
                        }
                    }
                }
            }
        } else if (mouseEvent.getModifiers() == 4) {
            this.bDeviceClicked = false;
            this.curNode = null;
            this.semLeftMouseInfo = -1;
            Node node = this.deviceClicked(n, n2);
            if (node == null) {
                this.isPointOnLink(n, n2);
            } else if (this.curMenu > 0) {
                this.curMenu = -1;
                this.curNode = null;
            } else {
                this.curSubMenu = 0;
                this.curMenu = node.bStack ? 0 : 2;
                this.curPoint.x = n;
                this.curPoint.y = n2;
                this.curNode = node;
                this.endNode = null;
                this.bDeviceClicked = true;
            }
        }
        this.repaint();
    }

    void topoMouseReleased(MouseEvent mouseEvent) {
        mouseEvent.getX();
        mouseEvent.getY();
        if (this.currSelNode != null) {
            if (this.currSelNode.x < 0.0) {
                this.currSelNode.x = 40.0;
            }
            if (this.currSelNode.x > (double)this.mySize.width) {
                this.currSelNode.x = this.mySize.width - 40;
            }
            if (this.currSelNode.y < 0.0) {
                this.currSelNode.y = 40.0;
            }
            if (this.currSelNode.y > (double)this.mySize.height) {
                this.currSelNode.y = this.mySize.height - 40;
            }
            if (this.isDeviceUnderCursor(this.currSelNode)) {
                this.currSelNode.x = this.currOldX;
                this.currSelNode.y = this.currOldY;
            }
            this.currSelNode.bFixed = this.bCurrSelNodeFixed;
            this.currSelNode = null;
            this.repaint();
        }
        this.setCursor(new Cursor(0));
    }

    void topoMouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.curMenu >= 0) {
            if (n > this.MenuAreaX[this.curMenu] && n < this.MenuAreaX[this.curMenu] + this.MAWidth[this.curMenu] && n2 > this.MenuAreaY[this.curMenu] && n2 < this.MenuAreaY[this.curMenu] + this.MAHeight[this.curMenu] || this.curMenu == n2 / 23) {
                this.curSubMenu = (n2 - this.MenuAreaY[this.curMenu]) / (this.fm.getAscent() + 4);
                if (this.curSubMenu > this.numItems[this.curMenu] - 1) {
                    System.out.println("StackTopoPanel: mouseMove(): curSubMenu ERROR! curMenu=" + this.curMenu + ", curSubMenu=" + this.curSubMenu + ", numItems[" + this.curMenu + "]=" + this.numItems[this.curMenu] + ", y=" + n2 + ", MenuAreaY[" + this.curMenu + "]=" + this.MenuAreaY[this.curMenu] + ", fm.getAscent()=" + this.fm.getAscent());
                    this.curSubMenu = 0;
                }
                this.curURL = this.SubMenuURL[this.curMenu][this.curSubMenu];
            } else {
                this.curMenu = -2;
                this.curNode = null;
                this.curEdge = null;
            }
        }
        this.myApplet.getAppletContext().showStatus("Cisco Stack Topology Map");
        if (this.curMenu >= 0 || this.curMenu == -2) {
            if (this.curMenu == -2) {
                this.curMenu = -1;
            }
            this.repaint();
        }
    }

    void topoMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.curMenu < 0 && this.currSelNode != null && this.currSelNode != this.centerNode) {
            try {
                if (this.semLeftMouseInfo != -1) {
                    this.semLeftMouseInfo = 0;
                }
                this.currSelNode.x = n;
                this.currSelNode.y = n2;
                this.repaint();
                return;
            }
            catch (Exception exception) {
                if (this.currSelNode == null) {
                    System.out.println("StackTopoPanel: mouseDrag():: Exception " + mouseEvent.toString() + " currSelNode=null!\n");
                } else {
                    System.out.println("StackTopoPanel: mouseDrag():: Exception, currSelNode!=null!\n");
                }
                exception.printStackTrace();
                return;
            }
        }
    }

    public void start() {
        this.initialDrawThread = new Thread((Runnable)this, "StackTopoPanel initialDrawThread");
        this.initialDrawThread.start();
    }

    public void stop() {
        this.initialDrawThread.stop();
    }

    public void run() {
        this.drawInitialNodes();
        this.initialDrawThread.stop();
    }

    public Dimension getPreferredSize() {
        return new Dimension(1000, 1000);
    }

    public Dimension getMinimumSize() {
        return new Dimension(200, 200);
    }

    public Dimension getMaximumSize() {
        return new Dimension(1000, 1000);
    }
}

