/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AddrMgmt_JDialog
extends CommonConfig_JDialog
implements ListSelectionListener,
KeyListener {
    JPanel buttons_JPanel = null;
    JButton ok_JButton;
    JButton modify_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JButton removeAll_JButton;
    JTabbedPane addrMgmt_JTabbedPane = null;
    JPanel aging_JPanel = null;
    JLabel aging_JLabel = null;
    JTextField aging_JTextField = null;
    JPanel staticButtons_JPanel = null;
    JPanel secureButtons_JPanel = null;
    JButton forwarding_JButton = null;
    JButton removeSecure_JButton = null;
    JButton removeStatic_JButton = null;
    JButton newSecure_JButton = null;
    JButton newStatic_JButton = null;
    JButton apply_JButton = null;
    TabbedPaneElement dynamicPane = null;
    TabbedPaneElement securePane = null;
    TabbedPaneElement staticPane = null;
    String switchAgingTime;
    String[] l2Interfaces;

    public AddrMgmt_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        super(frame, jApplet, commonSwitchArray, "Address Management", 513, 305);
        this.buildDialog();
    }

    public AddrMgmt_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame, jApplet, commonSwitchArray, commonSwitch, "Address Management", 513, 305);
        this.buildDialog();
    }

    public AddrMgmt_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray);
    }

    public AddrMgmt_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        Object object = actionEvent.getSource();
        if (object == this.devices_JCombo) {
            this.setSelectedSwitch(this.devices_JCombo);
            this.l2Interfaces = this.commonCLI.getL2Interfaces(this.switchID);
            this.updateTables();
        } else if (object == this.aging_JTextField) {
            this.apply_JButton.setEnabled(true);
        } else if (object == this.ok_JButton) {
            boolean bl = this.applyChanges();
            if (bl) {
                ((Component)this).setCursor(new Cursor(0));
                this.dispose();
            }
        } else if (object == this.apply_JButton) {
            boolean bl = this.applyChanges();
            this.apply_JButton.setEnabled(false);
        } else if (object == this.cancel_JButton) {
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else if (object == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"addrwin");
        } else if (object == this.newStatic_JButton || object == this.newSecure_JButton) {
            String string = null;
            AddrMgmt_AddressModel addrMgmt_AddressModel = null;
            if (object == this.newSecure_JButton) {
                string = "secure";
                addrMgmt_AddressModel = (AddrMgmt_AddressModel)this.securePane.getModel();
            } else {
                string = "static";
                addrMgmt_AddressModel = (AddrMgmt_AddressModel)this.staticPane.getModel();
            }
            AddrMgmtNewAddress_JDialog addrMgmtNewAddress_JDialog = new AddrMgmtNewAddress_JDialog(this, this.theApplet, string, this.commonCLI, this.switchID, addrMgmt_AddressModel);
            ModalDialog.show((RootPaneContainer)this, (Dialog)addrMgmtNewAddress_JDialog, null);
        } else if (object == this.removeAll_JButton) {
            TabbedPaneElement tabbedPaneElement = this.getPane();
            AddrMgmt_AddressModel addrMgmt_AddressModel = (AddrMgmt_AddressModel)tabbedPaneElement.getModel();
            addrMgmt_AddressModel.removeAll(this.switchID);
        } else if (object == this.removeSecure_JButton || object == this.removeStatic_JButton) {
            int[] nArray = this.getPane().getTable().getSelectedRows();
            if (nArray.length > 0) {
                TabbedPaneElement tabbedPaneElement = this.getPane();
                AddrMgmt_AddressModel addrMgmt_AddressModel = (AddrMgmt_AddressModel)tabbedPaneElement.getModel();
                addrMgmt_AddressModel.remove(this.switchID, nArray);
            }
        } else if (object == this.forwarding_JButton) {
            TabbedPaneElement tabbedPaneElement = this.getPane();
            AddrMgmt_AddressModel addrMgmt_AddressModel = (AddrMgmt_AddressModel)tabbedPaneElement.getModel();
            int[] nArray = tabbedPaneElement.getTable().getSelectedRows();
            if (nArray.length == 1) {
                int n = nArray[0];
                if (this.commonCLI.getDeviceType(this.switchID).indexOf("WS-C2950") != -1) {
                    StaticForwardModify_JDialog staticForwardModify_JDialog = new StaticForwardModify_JDialog(this, this.theApplet, this.commonCLI, this.switchID, (String)tabbedPaneElement.getTable().getValueAt(n, 0), (String)tabbedPaneElement.getTable().getValueAt(n, 1), this.commonCLI.getVLANInterfaces(this.switchID, (String)tabbedPaneElement.getTable().getValueAt(n, 1)), -1, null, null, this.l2Interfaces);
                    ModalDialog.show((RootPaneContainer)this, (Dialog)staticForwardModify_JDialog, null);
                } else {
                    StaticForward_JDialog staticForward_JDialog = new StaticForward_JDialog(this, this.theApplet, this.commonCLI, this.switchID, addrMgmt_AddressModel, n);
                    ModalDialog.show((RootPaneContainer)this, (Dialog)staticForward_JDialog, null);
                }
            }
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    protected void addDetails() {
        this.addrMgmt_JTabbedPane = new JTabbedPane();
        this.l2Interfaces = this.commonCLI.getL2Interfaces(this.switchID);
        AddrMgmt_AddressModel addrMgmt_AddressModel = new AddrMgmt_AddressModel(this.commonCLI, "dynamic", this.switchID);
        addrMgmt_AddressModel.addTableModelListener(this);
        this.dynamicPane = new TabbedPaneElement(addrMgmt_AddressModel, new BorderLayout(0, 0), "Dynamic Address", this.addrMgmt_JTabbedPane);
        this.dynamicPane.getTable().setRowSelectionAllowed(false);
        this.dynamicPane.getTable().setColumnSelectionAllowed(false);
        addrMgmt_AddressModel = new AddrMgmt_AddressModel(this.commonCLI, "secure", this.switchID);
        addrMgmt_AddressModel.addTableModelListener(this);
        this.securePane = new TabbedPaneElement(addrMgmt_AddressModel, new BorderLayout(0, 0), "Secure Address", this.addrMgmt_JTabbedPane);
        this.securePane.getTable().getSelectionModel().addListSelectionListener(this);
        addrMgmt_AddressModel = new AddrMgmt_AddressModel(this.commonCLI, "static", this.switchID);
        addrMgmt_AddressModel.addTableModelListener(this);
        this.staticPane = new TabbedPaneElement(addrMgmt_AddressModel, new BorderLayout(0, 0), "Static Address", this.addrMgmt_JTabbedPane);
        this.staticPane.getTable().getSelectionModel().addListSelectionListener(this);
        this.aging_JPanel = new JPanel();
        this.aging_JPanel.setBorder(BorderFactory.createTitledBorder("Aging"));
        this.aging_JLabel = new JLabel("Aging Time (10-100000 Seconds):");
        this.switchAgingTime = this.commonCLI.getAddressAgingTime(this.switchID);
        this.aging_JTextField = new JTextField(this.switchAgingTime, 6);
        this.aging_JPanel.add(this.aging_JLabel);
        this.aging_JPanel.add(this.aging_JTextField);
        this.dynamicPane.getPanel().add((Component)this.aging_JPanel, "South");
        this.aging_JTextField.addActionListener(this);
        this.aging_JTextField.addKeyListener(this);
        this.secureButtons_JPanel = new JPanel();
        this.removeSecure_JButton = new JButton("Remove");
        this.newSecure_JButton = new JButton("New");
        this.secureButtons_JPanel.add(this.newSecure_JButton);
        this.secureButtons_JPanel.add(this.removeSecure_JButton);
        this.securePane.getPanel().add((Component)this.secureButtons_JPanel, "South");
        this.staticButtons_JPanel = new JPanel();
        this.newStatic_JButton = new JButton("New");
        this.removeStatic_JButton = new JButton("Remove");
        this.forwarding_JButton = new JButton("Forwarding");
        this.staticButtons_JPanel.add(this.newStatic_JButton);
        this.staticButtons_JPanel.add(this.removeStatic_JButton);
        this.staticButtons_JPanel.add(this.forwarding_JButton);
        this.staticPane.getPanel().add((Component)this.staticButtons_JPanel, "South");
        this.getContentPane().add("Center", this.addrMgmt_JTabbedPane);
        this.buttons_JPanel = new JPanel();
        this.apply_JButton = new JButton("Apply");
        this.apply_JButton.setEnabled(false);
        this.ok_JButton = new JButton("OK");
        this.cancel_JButton = new JButton("Cancel");
        this.removeAll_JButton = new JButton("Remove All");
        this.help_JButton = new JButton("Help");
        this.buttons_JPanel.add(this.apply_JButton);
        this.buttons_JPanel.add(this.ok_JButton);
        this.buttons_JPanel.add(this.cancel_JButton);
        this.buttons_JPanel.add(this.removeAll_JButton);
        this.buttons_JPanel.add(this.help_JButton);
        this.getContentPane().add((Component)this.buttons_JPanel, "South");
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.newSecure_JButton.addActionListener(this);
        this.newStatic_JButton.addActionListener(this);
        this.apply_JButton.addActionListener(this);
        this.removeAll_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        this.removeSecure_JButton.addActionListener(this);
        this.removeStatic_JButton.addActionListener(this);
        this.forwarding_JButton.addActionListener(this);
        this.devices_JCombo.addActionListener(this);
        this.addrMgmt_JTabbedPane.addChangeListener(this);
    }

    protected boolean agingTimeValid(String string) {
        return Validation.isValidInteger(string, 10, 1000000);
    }

    public boolean applyChanges() {
        if (this.changesOccurred()) {
            if (!this.agingTimeValid(this.aging_JTextField.getText())) {
                this.rangeError("Error: Address Management", "Aging Time", "10", "1000000");
                return false;
            }
            this.commonCLI.setAddressAgingTime(this.switchID, this.aging_JTextField.getText());
        }
        return true;
    }

    protected boolean changesOccurred() {
        return this.switchAgingTime.compareTo(this.aging_JTextField.getText()) != 0;
    }

    protected void determineButtonsState() {
        int n = this.addrMgmt_JTabbedPane.getSelectedIndex();
        switch (n) {
            case 1: {
                if (this.securePane.getTable().getSelectedRowCount() > 0) {
                    this.removeSecure_JButton.setEnabled(true);
                    break;
                }
                this.removeSecure_JButton.setEnabled(false);
                break;
            }
            case 2: {
                int n2 = this.staticPane.getTable().getSelectedRowCount();
                if (n2 > 0) {
                    this.removeStatic_JButton.setEnabled(true);
                    if (n2 > 1) {
                        this.forwarding_JButton.setEnabled(false);
                        break;
                    }
                    this.forwarding_JButton.setEnabled(true);
                    break;
                }
                this.removeStatic_JButton.setEnabled(false);
                this.forwarding_JButton.setEnabled(false);
                break;
            }
        }
    }

    public String[] getInterfaces() {
        return this.l2Interfaces;
    }

    public TabbedPaneElement getPane() {
        int n = this.addrMgmt_JTabbedPane.getSelectedIndex();
        TabbedPaneElement tabbedPaneElement = this.dynamicPane;
        switch (n) {
            case 0: {
                tabbedPaneElement = this.dynamicPane;
                break;
            }
            case 1: {
                tabbedPaneElement = this.securePane;
                break;
            }
            case 2: {
                tabbedPaneElement = this.staticPane;
                break;
            }
            default: {
                tabbedPaneElement = this.dynamicPane;
            }
        }
        return tabbedPaneElement;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.apply_JButton.setEnabled(true);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.determineButtonsState();
    }

    protected void updateTable(JTable jTable) {
        ((AddrMgmt_AddressModel)jTable.getModel()).gatherDataFromDevice(this.switchID);
    }

    protected void updateTables() {
        int n = 0;
        while (n < this.switchMembers.length) {
            if (this.switchMembers[n].switchName.equals(this.devices_JCombo.getSelectedItem())) {
                this.commonCLI = this.switchMembers[n].Cli;
                ((AddrMgmt_AddressModel)this.dynamicPane.getTable().getModel()).commonCLI = this.switchMembers[n].Cli;
                ((AddrMgmt_AddressModel)this.securePane.getTable().getModel()).commonCLI = this.switchMembers[n].Cli;
                ((AddrMgmt_AddressModel)this.staticPane.getTable().getModel()).commonCLI = this.switchMembers[n].Cli;
            }
            ++n;
        }
        this.updateTable(this.dynamicPane.getTable());
        this.updateTable(this.securePane.getTable());
        this.updateTable(this.staticPane.getTable());
        this.switchAgingTime = this.commonCLI.getAddressAgingTime(this.switchID);
        this.aging_JTextField.setText(this.switchAgingTime);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.determineButtonsState();
    }
}

