/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CGMP_JDialog
extends CommonConfig_JDialog
implements ListSelectionListener,
KeyListener {
    JLabel cgmpProtocol_JLabel = new JLabel();
    JComboBox cgmpProtocol_JCombo = new JComboBox();
    JLabel cgmpFastLeave_JLabel = new JLabel();
    JComboBox cgmpFastLeave_JCombo = new JComboBox();
    JLabel routerHoldTime_JLabel = new JLabel();
    JTextField routerHoldTime_JTextField = new JTextField();
    JTabbedPane cgmp_JTabbedPane = null;
    TabbedPaneElement mgmtGroupsPane = null;
    TabbedPaneElement routerPortsPane = null;
    JButton apply_JButton = new JButton("Apply");
    JButton ok_JButton;
    JButton remove_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JButton removeAll_JButton;
    String switchHoldTime;
    String userHoldTime = null;
    boolean switchCGMPEnabled;
    boolean userCGMPEnabled = false;
    boolean switchFastLeaveEnabled;
    boolean userFastLeaveEnabled = false;

    public CGMP_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        super(frame, jApplet, commonSwitchArray, "CGMP", 513, 305);
        this.buildDialog();
    }

    public CGMP_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame, jApplet, commonSwitchArray, commonSwitch, "CGMP", 513, 305);
        this.buildDialog();
    }

    public CGMP_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray);
    }

    public CGMP_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        ((Component)this).setCursor(new Cursor(3));
        Object object = actionEvent.getSource();
        if (object == this.devices_JCombo) {
            this.setSelectedSwitch(this.devices_JCombo);
            this.getProtocol();
            this.updateTables();
        } else if (object == this.cgmpProtocol_JCombo) {
            this.apply_JButton.setEnabled(true);
        } else if (object == this.cgmpFastLeave_JCombo) {
            this.apply_JButton.setEnabled(true);
        } else if (object == this.routerHoldTime_JTextField) {
            this.apply_JButton.setEnabled(true);
        } else if (object == this.ok_JButton) {
            boolean bl = this.applyChanges();
            if (bl) {
                ((Component)this).setCursor(new Cursor(0));
                this.dispose();
            }
        } else if (object == this.apply_JButton) {
            boolean bl = this.applyChanges();
            this.apply_JButton.setEnabled(false);
        } else if (object == this.cancel_JButton) {
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else if (object == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"cgmpdg");
        } else if (object == this.remove_JButton) {
            int[] nArray;
            TabbedPaneElement tabbedPaneElement = this.getPane();
            if (tabbedPaneElement != null && (nArray = tabbedPaneElement.getTable().getSelectedRows()).length > 0) {
                CGMP_CustomModel cGMP_CustomModel = (CGMP_CustomModel)tabbedPaneElement.getModel();
                cGMP_CustomModel.remove(this.switchID, nArray);
            }
        } else if (object == this.removeAll_JButton) {
            TabbedPaneElement tabbedPaneElement = this.getPane();
            CGMP_CustomModel cGMP_CustomModel = (CGMP_CustomModel)tabbedPaneElement.getModel();
            cGMP_CustomModel.removeAll(this.switchID);
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    protected void addDetails() {
        this.cgmp_JTabbedPane = new JTabbedPane();
        this.buildProtocolPane();
        CGMP_CustomModel cGMP_CustomModel = new CGMP_MgmtGroupsModel(this.commonCLI, this.switchID);
        cGMP_CustomModel.addTableModelListener(this);
        this.mgmtGroupsPane = new TabbedPaneElement(cGMP_CustomModel, new BorderLayout(), "Management Groups", this.cgmp_JTabbedPane);
        this.mgmtGroupsPane.getTable().getSelectionModel().addListSelectionListener(this);
        cGMP_CustomModel = new CGMP_RouterPortsModel(this.commonCLI, this.switchID);
        cGMP_CustomModel.addTableModelListener(this);
        this.routerPortsPane = new TabbedPaneElement(cGMP_CustomModel, new BorderLayout(), "Router Ports", this.cgmp_JTabbedPane);
        this.routerPortsPane.getTable().getSelectionModel().addListSelectionListener(this);
        this.getContentPane().add(this.cgmp_JTabbedPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.ok_JButton = new JButton("OK");
        this.remove_JButton = new JButton("Remove");
        this.removeAll_JButton = new JButton("Remove All");
        this.cancel_JButton = new JButton("Cancel");
        this.help_JButton = new JButton("Help");
        jPanel.add(this.ok_JButton);
        jPanel.add(this.apply_JButton);
        jPanel.add(this.remove_JButton);
        jPanel.add(this.removeAll_JButton);
        jPanel.add(this.cancel_JButton);
        jPanel.add(this.help_JButton);
        this.remove_JButton.setEnabled(false);
        this.removeAll_JButton.setEnabled(false);
        this.apply_JButton.setEnabled(false);
        this.getContentPane().add((Component)jPanel, "South");
        this.remove_JButton.addActionListener(this);
        this.removeAll_JButton.addActionListener(this);
        this.apply_JButton.addActionListener(this);
        this.ok_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        this.devices_JCombo.addActionListener(this);
        this.cgmp_JTabbedPane.addChangeListener(this);
    }

    protected boolean applyChanges() {
        boolean bl = this.getUserSelections();
        if (!bl) {
            return false;
        }
        if (this.switchCGMPEnabled != this.userCGMPEnabled) {
            this.commonCLI.setCGMPEnabled(this.switchID, this.userCGMPEnabled);
            this.getProtocol();
        } else if (this.switchFastLeaveEnabled != this.userFastLeaveEnabled) {
            this.commonCLI.setCGMPFastLeaveEnabled(this.switchID, this.userFastLeaveEnabled);
            this.getFastLeave();
        }
        if (this.switchHoldTime.compareTo(this.userHoldTime) != 0) {
            this.commonCLI.setCGMPHoldTime(this.switchID, this.userHoldTime);
            this.getHoldTime();
        }
        return true;
    }

    protected void buildProtocolPane() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.cgmpProtocol_JLabel.setText("CGMP Protocol:");
        jPanel.add(this.cgmpProtocol_JLabel);
        this.cgmpProtocol_JLabel.setBounds(8, 31, 180, 24);
        jPanel.add(this.cgmpProtocol_JCombo);
        this.cgmpProtocol_JCombo.setBounds(204, 31, 90, 26);
        this.cgmpProtocol_JCombo.addItem("Enable");
        this.cgmpProtocol_JCombo.addItem("Disable");
        this.cgmpProtocol_JCombo.addActionListener(this);
        this.cgmpFastLeave_JLabel.setText("CGMP Fast Leave:");
        jPanel.add(this.cgmpFastLeave_JLabel);
        this.cgmpFastLeave_JLabel.setBounds(8, 74, 180, 20);
        jPanel.add(this.cgmpFastLeave_JCombo);
        this.cgmpFastLeave_JCombo.setBounds(204, 73, 90, 26);
        this.cgmpFastLeave_JCombo.addItem("Enable");
        this.cgmpFastLeave_JCombo.addItem("Disable");
        this.cgmpFastLeave_JCombo.addActionListener(this);
        this.routerHoldTime_JLabel.setText("Router Hold-Time (10-6000):");
        jPanel.add(this.routerHoldTime_JLabel);
        this.routerHoldTime_JLabel.setBounds(8, 113, 180, 28);
        jPanel.add(this.routerHoldTime_JTextField);
        this.routerHoldTime_JTextField.setBounds(204, 115, 90, 26);
        this.routerHoldTime_JTextField.addActionListener(this);
        this.routerHoldTime_JTextField.addKeyListener(this);
        this.getProtocol();
        this.cgmp_JTabbedPane.add("Protocol", jPanel);
    }

    protected boolean changesOccurred() {
        this.getUserSelections();
        if (this.switchCGMPEnabled != this.userCGMPEnabled) {
            return true;
        }
        if (this.switchFastLeaveEnabled != this.userFastLeaveEnabled) {
            return true;
        }
        return this.switchHoldTime.compareTo(this.userHoldTime) != 0;
    }

    protected void determineRemoveState() {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.cgmp_JTabbedPane.getSelectedIndex();
        switch (n) {
            case 1: {
                if (this.mgmtGroupsPane.getTable().getSelectedRowCount() > 0) {
                    bl = true;
                }
                bl2 = true;
                break;
            }
            case 2: {
                if (this.routerPortsPane.getTable().getSelectedRowCount() > 0) {
                    bl = true;
                }
                bl2 = true;
                break;
            }
        }
        if (!bl) {
            this.remove_JButton.setEnabled(false);
        } else {
            this.remove_JButton.setEnabled(true);
        }
        if (!bl2) {
            this.removeAll_JButton.setEnabled(false);
        } else {
            this.removeAll_JButton.setEnabled(true);
        }
    }

    protected void getCGMP() {
        this.switchCGMPEnabled = this.commonCLI.isCGMPEnabled(this.switchID);
        if (!this.switchCGMPEnabled) {
            this.cgmpProtocol_JCombo.setSelectedIndex(1);
        } else {
            this.cgmpProtocol_JCombo.setSelectedIndex(0);
        }
    }

    protected void getFastLeave() {
        this.switchFastLeaveEnabled = this.commonCLI.isCGMPFastLeaveEnabled(this.switchID);
        if (!this.switchFastLeaveEnabled) {
            this.cgmpFastLeave_JCombo.setSelectedIndex(1);
        } else {
            this.cgmpFastLeave_JCombo.setSelectedIndex(0);
        }
    }

    protected void getHoldTime() {
        this.switchHoldTime = this.commonCLI.getCGMPRouterHoldTime(this.switchID);
        if (this.switchHoldTime != null) {
            this.routerHoldTime_JTextField.setText(this.switchHoldTime);
        } else {
            this.routerHoldTime_JTextField.setText(" ");
        }
    }

    public TabbedPaneElement getPane() {
        int n = this.cgmp_JTabbedPane.getSelectedIndex();
        TabbedPaneElement tabbedPaneElement = null;
        switch (n) {
            case 0: {
                tabbedPaneElement = null;
                break;
            }
            case 1: {
                tabbedPaneElement = this.mgmtGroupsPane;
                break;
            }
            case 2: {
                tabbedPaneElement = this.routerPortsPane;
                break;
            }
            default: {
                tabbedPaneElement = null;
            }
        }
        return tabbedPaneElement;
    }

    protected void getProtocol() {
        this.getCGMP();
        if (this.switchCGMPEnabled) {
            this.cgmpFastLeave_JCombo.setEnabled(true);
            this.getFastLeave();
        } else {
            this.cgmpFastLeave_JCombo.setEnabled(false);
            this.switchFastLeaveEnabled = false;
            this.cgmpFastLeave_JCombo.setSelectedIndex(1);
        }
        this.getHoldTime();
        this.apply_JButton.setEnabled(false);
    }

    protected boolean getUserSelections() {
        int n = 0;
        n = this.cgmpProtocol_JCombo.getSelectedIndex();
        this.userCGMPEnabled = n == 0;
        n = this.cgmpFastLeave_JCombo.getSelectedIndex();
        this.userFastLeaveEnabled = n == 0;
        this.userHoldTime = this.routerHoldTime_JTextField.getText();
        if (!this.routerHoldTimeValid(this.userHoldTime)) {
            this.rangeError("Error: CGMP", "Router Hold-Time", "10", "6000");
            return false;
        }
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.apply_JButton.setEnabled(true);
    }

    protected boolean routerHoldTimeValid(String string) {
        return Validation.isValidInteger(string, 10, 6000);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.determineRemoveState();
    }

    protected void updateTable(JTable jTable) {
        ((CGMP_CustomModel)jTable.getModel()).gatherDataFromDevice(this.switchID);
    }

    protected void updateTables() {
        this.updateTable(this.mgmtGroupsPane.getTable());
        this.updateTable(this.routerPortsPane.getTable());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.determineRemoveState();
    }
}

