/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ClusterConfig_JDialog
extends JDialog
implements ActionListener {
    boolean frameSizeAdjusted = false;
    JPanel button_JPanel;
    JPanel first_JPanel;
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JComboBox commandStatus_JCombo;
    String[] status = new String[]{"Enable", "Disable"};
    JLabel commandStatus_JLabel;
    JLabel clusterName_JLabel;
    JTextField clusterName_JTextField;
    String currentClusterStatus = null;
    JApplet parentApplet;
    CommandCLIs commandCLIs;
    DeviceManager deviceManager;

    public ClusterConfig_JDialog(Frame frame, JApplet jApplet) {
        super(frame);
        this.parentApplet = jApplet;
        this.deviceManager = (DeviceManager)((Object)jApplet);
        this.commandCLIs = new CommandCLIs(this.parentApplet);
        this.currentClusterStatus = this.deviceManager.switchInfo[4];
        this.setTitle("Cluster Configuration");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(336, 198);
        this.setVisible(false);
        this.first_JPanel = new JPanel(new GridLayout(2, 2, 5, 10));
        this.commandStatus_JLabel = new JLabel("Command Switch Status:");
        this.first_JPanel.add(this.commandStatus_JLabel);
        this.commandStatus_JCombo = new JComboBox<String>(this.status);
        this.first_JPanel.add(this.commandStatus_JCombo);
        this.clusterName_JLabel = new JLabel("Cluster Name:");
        this.first_JPanel.add(this.clusterName_JLabel);
        this.clusterName_JTextField = new JTextField(16);
        this.first_JPanel.add(this.clusterName_JTextField);
        this.getContentPane().add((Component)this.first_JPanel, "North");
        this.button_JPanel = new JPanel();
        this.ok_JButton = new JButton("OK");
        this.ok_JButton.addActionListener(this);
        this.button_JPanel.add(this.ok_JButton);
        this.cancel_JButton = new JButton("Cancel");
        this.cancel_JButton.addActionListener(this);
        this.button_JPanel.add(this.cancel_JButton);
        this.help_JButton = new JButton("Help");
        this.help_JButton.addActionListener(this);
        this.button_JPanel.add(this.help_JButton);
        if (this.deviceManager.switchInfo[4].equals("CC")) {
            this.clusterName_JTextField.setText(this.deviceManager.switchInfo[7]);
        } else {
            this.commandStatus_JCombo.setSelectedItem("Disable");
        }
        if (this.commandStatus_JCombo.getSelectedItem().equals("Enable")) {
            this.clusterName_JTextField.setEditable(false);
        }
        this.getContentPane().add((Component)this.button_JPanel, "South");
    }

    public ClusterConfig_JDialog(JApplet jApplet) {
        this(null, jApplet);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            if (this.currentClusterStatus.equals("CC")) {
                if (this.commandStatus_JCombo.getSelectedItem().equals("Disable")) {
                    this.commandCLIs.disableCluster();
                    this.deviceManager.updateDeviceInfo();
                }
                this.dispose();
            } else if (this.currentClusterStatus.equals("UN")) {
                if (this.commandStatus_JCombo.getSelectedItem().equals("Enable")) {
                    if (this.clusterName_JTextField.getText().length() > 0) {
                        if (this.clusterName_JTextField.getText().indexOf("/") != -1 || this.clusterName_JTextField.getText().indexOf("\\") != -1 || this.clusterName_JTextField.getText().indexOf(" ") != -1) {
                            JOptionPane.showMessageDialog(this, "Cluster name contains invalid character.", "Error: Cluster Config", 0);
                        } else {
                            this.commandCLIs.enableCluster(this.clusterName_JTextField.getText());
                            this.deviceManager.updateDeviceInfo();
                            this.dispose();
                        }
                    } else {
                        JOptionPane.showMessageDialog(this, "Cluster name is needed.", "Error: Cluster Config", 0);
                        this.deviceManager.updateDeviceInfo();
                    }
                } else {
                    this.dispose();
                }
            }
        } else if (object == this.cancel_JButton) {
            this.dispose();
        } else if (object == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.parentApplet, (String)"cmdcfg");
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }
}

