/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class DeviceListDialog
extends DeviceDialog
implements ListSelectionListener {
    protected CommonSwitch[] devices;
    protected Vector defaultDevices;
    protected JLabel hostName;
    protected JLabel imageFile;
    protected JLabel imageFile_JLabel;
    protected DefaultListModel availableListModel;
    protected DefaultListModel selectedListModel;
    private DeviceListGui devGui;

    public DeviceListDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(jApplet, commonSwitchArray, null);
    }

    public DeviceListDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, Vector vector) {
        super(jApplet);
        this.devices = commonSwitchArray;
        this.defaultDevices = vector;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.devGui.addButton) {
            this.addButton_Action();
        } else if (object == this.devGui.removeButton) {
            this.removeButton_Action();
        } else if (object == this.devGui.availSelAllButton) {
            this.availSelAllButton_Action();
        } else if (object == this.devGui.selecSelAllButton) {
            this.selecSelAllButton_Action();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected void addAvailableMembers(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n] - n;
            this.selectedListModel.addElement(this.availableListModel.get(n2));
            this.availableListModel.remove(n2);
            ++n;
        }
        this.devGui.addButton.setEnabled(false);
    }

    protected void addButton_Action() {
        int[] nArray = this.devGui.availableList.getSelectedIndices();
        try {
            this.isSelectionCompatible(nArray);
            this.addAvailableMembers(nArray);
        }
        catch (UserInputException userInputException) {}
        this.listsChanged();
    }

    protected void availSelAllButton_Action() {
        this.devGui.availableList.setSelectionInterval(0, this.availableListModel.size() - 1);
    }

    protected DeviceListItem getNewDeviceListItem(CommonSwitch commonSwitch) {
        return new DeviceListItem(commonSwitch);
    }

    public void hookupListeners() {
        super.hookupListeners();
        this.devGui.availableList.addListSelectionListener(this);
        this.devGui.selectedList.addListSelectionListener(this);
        this.devGui.addButton.addActionListener(this);
        this.devGui.removeButton.addActionListener(this);
        this.devGui.availSelAllButton.addActionListener(this);
        this.devGui.selecSelAllButton.addActionListener(this);
    }

    public void initializeMembers() {
        super.initializeMembers();
        this.availableListModel = new DefaultListModel();
        this.selectedListModel = new DefaultListModel();
        this.devGui.availableList.setModel(this.availableListModel);
        this.devGui.selectedList.setModel(this.selectedListModel);
    }

    protected abstract boolean isDeviceSupported(CommonSwitch var1);

    protected abstract void isSelectionCompatible(int[] var1) throws UserInputException;

    protected void layoutWidgets() {
        super.layoutWidgets();
        this.devGui = new DeviceListGui();
        this.devGui.borderAvailablePanel.setBorder(BorderFactory.createTitledBorder("Available Devices"));
        this.devGui.borderSelectedPanel.setBorder(BorderFactory.createTitledBorder("Selected Devices"));
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        if (this.applet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(1, 5, 5));
            jPanel2.add(new JLabel("Host name: "));
            this.hostName = new JLabel();
            jPanel2.add(this.hostName);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(1, 5, 5));
            this.imageFile_JLabel = new JLabel("Image file : ");
            this.imageFile_JLabel.setVisible(false);
            jPanel3.add(this.imageFile_JLabel);
            this.imageFile = new JLabel();
            this.imageFile.setVisible(false);
            jPanel3.add(this.imageFile);
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jPanel3, "South");
            container.add((Component)jPanel, gridBagConstraints);
        } else {
            container.add((Component)this.devGui, gridBagConstraints);
        }
    }

    protected void listsChanged() {
        this.devGui.availSelAllButton.setEnabled(this.availableListModel.isEmpty() ^ true);
        this.devGui.selecSelAllButton.setEnabled(this.selectedListModel.isEmpty() ^ true);
    }

    protected void populateDeviceList() {
        this.setPreventUserOps(true);
        int n = 0;
        while (n < this.devices.length) {
            CommonSwitch commonSwitch = this.devices[n];
            if (!commonSwitch.statusCode.equals("Down") && this.isDeviceSupported(commonSwitch)) {
                this.availableListModel.addElement(this.getNewDeviceListItem(commonSwitch));
            }
            ++n;
        }
        this.selectDefaultDevices();
        if (this.applet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.devGui.availableList.setSelectionInterval(0, this.availableListModel.size() - 1);
            this.addAvailableMembers(this.devGui.availableList.getSelectedIndices());
            System.out.println(((DeviceListItem)this.selectedListModel.get((int)0)).displayString);
            this.hostName.setText(((DeviceListItem)this.selectedListModel.get((int)0)).displayString);
            if (this instanceof SwUpgrade) {
                int n2;
                this.imageFile.setVisible(true);
                this.imageFile_JLabel.setVisible(true);
                String string = this.hostName.getText().trim();
                int n3 = string.indexOf(",");
                String string2 = string;
                if (n3 != -1) {
                    this.hostName.setText(string.substring(0, n3));
                    string2 = string.substring(n3 + 1, string.length());
                }
                if ((n2 = string2.indexOf("flash")) != -1 && n3 != -1) {
                    int n4 = string2.indexOf(",", n2);
                    if (n4 != -1) {
                        this.imageFile.setText(string2.substring(n2, n4));
                    } else {
                        this.imageFile.setText(string2.substring(n2, string2.length()));
                    }
                }
            }
        }
        this.listsChanged();
        this.setPreventUserOps(false);
    }

    protected void removeButton_Action() {
        int[] nArray = this.devGui.selectedList.getSelectedIndices();
        this.removeSelectedMembers(nArray);
        this.listsChanged();
    }

    protected void removeSelectedMembers(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n] - n;
            this.availableListModel.addElement(this.selectedListModel.get(n2));
            this.selectedListModel.remove(n2);
            ++n;
        }
        this.devGui.removeButton.setEnabled(false);
    }

    protected void selecSelAllButton_Action() {
        this.devGui.selectedList.setSelectionInterval(0, this.selectedListModel.size() - 1);
    }

    protected void selectDefaultDevices() {
        if (this.defaultDevices == null) {
            return;
        }
        int n = 0;
        while (n < this.defaultDevices.size()) {
            CommonSwitch commonSwitch = (CommonSwitch)this.defaultDevices.elementAt(n);
            DeviceListItem deviceListItem = this.getNewDeviceListItem(commonSwitch);
            this.availableListModel.removeElement(deviceListItem);
            this.selectedListModel.addElement(deviceListItem);
            ++n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JButton jButton = null;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JList jList = (JList)listSelectionEvent.getSource();
        if (jList == this.devGui.availableList) {
            jButton = this.devGui.addButton;
        } else if (jList == this.devGui.selectedList) {
            jButton = this.devGui.removeButton;
        }
        if (jList.isSelectionEmpty()) {
            jButton.setEnabled(false);
        } else {
            jButton.setEnabled(true);
        }
    }
}

