/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PortStatisticsDialog
extends JDialog
implements ActionListener,
ItemListener {
    boolean frameSizeAdjusted = false;
    boolean isAsc = true;
    int sortingModelIndex = 0;
    JPanel deviceListPanel;
    JComboBox devicesCombo;
    JScrollPane tableScrollPane;
    Component dataPanel;
    JPanel buttonsPane = null;
    JButton okButton;
    JButton refreshButton;
    JButton clearButton;
    JButton helpButton;
    JApplet theApplet;
    CommonSwitch[] switches;
    CommonSwitch theSwitch;
    int switchIndex;
    JTable vdslTable;
    JTable overviewTable;
    JTable transmitTable;
    JTable receiveTable;
    PortStatisticsTableModel portStatisticsTableModel;
    JLabel hostNameLabel = new JLabel("Host Name:");
    JLabel hostName;
    private String VDSL_TAB = "LRE Link";
    private String OVERVIEW_TAB = "Overview";
    private String TRANSMIT_TAB = "Transmit Detail";
    private String RECEIVE_TAB = "Receive Detail";
    private String helpTag = "prtstat";
    private boolean isDataCleared = true;

    public PortStatisticsDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        int n;
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        this.setDefaultCloseOperation(2);
        if (commonSwitch == null) {
            commonSwitch = commonSwitchArray[0];
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                    commonSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        this.switchIndex = 0;
        n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] == commonSwitch) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
        jApplet.setCursor(new Cursor(3));
        this.setTitle("Port Statistics");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(600, 400);
        this.setVisible(false);
        this.deviceListPanel = new JPanel();
        this.deviceListPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("North", this.deviceListPanel);
        this.deviceListPanel.setBounds(0, 0, 513, 62);
        this.deviceListPanel.add(this.hostNameLabel);
        this.devicesCombo = new JComboBox();
        this.deviceListPanel.add(this.devicesCombo);
        this.devicesCombo.setBounds(191, 25, 130, 27);
        if (jApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.hostName = new JLabel(commonSwitch.switchName);
            this.deviceListPanel.add(this.hostName);
            this.devicesCombo.setVisible(false);
            this.deviceListPanel.setBorder(BorderFactory.createTitledBorder(""));
        } else {
            this.deviceListPanel.setBorder(BorderFactory.createTitledBorder("Device List"));
        }
        int n2 = 0;
        while (n2 < commonSwitchArray.length) {
            if (commonSwitchArray[n2].getName().indexOf("C19") == -1 && commonSwitchArray[n2].getName().indexOf("C28") == -1 && commonSwitchArray[n2].statusCode.equals("Up")) {
                this.devicesCombo.addItem(commonSwitchArray[n2].switchName);
            }
            ++n2;
        }
        this.devicesCombo.setSelectedItem(commonSwitchArray[this.switchIndex].switchName);
        this.dataPanel = this.createDataPanel(commonSwitch);
        this.getContentPane().add(this.dataPanel, "Center");
        this.buttonsPane = new JPanel();
        this.okButton = new JButton("OK");
        this.refreshButton = new JButton("Refresh");
        this.clearButton = new JButton("Clear Counters");
        this.helpButton = new JButton("Help");
        this.buttonsPane.add(this.okButton);
        this.buttonsPane.add(this.refreshButton);
        this.buttonsPane.add(this.clearButton);
        this.buttonsPane.add(this.helpButton);
        this.getContentPane().add((Component)this.buttonsPane, "South");
        this.devicesCombo.addItemListener(this);
        this.okButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.refreshButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        jApplet.setCursor(new Cursor(0));
    }

    public PortStatisticsDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public PortStatisticsDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.clickOK();
        } else if (object == this.helpButton) {
            this.clickHelp();
        } else if (object == this.refreshButton) {
            this.clickRefresh();
        } else if (object == this.clearButton) {
            this.clickClear();
        }
    }

    private void clickClear() {
        this.isDataCleared = false;
        this.setWaitingCursor();
        this.portStatisticsTableModel.clearCounter();
    }

    void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)this.helpTag);
    }

    void clickOK() {
        this.dispose();
    }

    private void clickRefresh() {
        this.isDataCleared = false;
        this.setWaitingCursor();
        this.portStatisticsTableModel.refresh();
    }

    private Component createDataPanel(CommonSwitch commonSwitch) {
        final JTabbedPane jTabbedPane = new JTabbedPane();
        final int n = 3;
        this.createStatisticsTables(commonSwitch);
        jTabbedPane.addTab(this.OVERVIEW_TAB, new JScrollPane(this.overviewTable));
        jTabbedPane.addTab(this.TRANSMIT_TAB, new JScrollPane(this.transmitTable));
        jTabbedPane.addTab(this.RECEIVE_TAB, new JScrollPane(this.receiveTable));
        if (commonSwitch.supportVDSL()) {
            jTabbedPane.addTab(this.VDSL_TAB, new JScrollPane(this.vdslTable));
        }
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n2 = jTabbedPane.getSelectedIndex();
                if (n2 == n) {
                    clearButton.setEnabled(false);
                } else {
                    clearButton.setEnabled(true);
                }
            }
        };
        jTabbedPane.addChangeListener(changeListener);
        return jTabbedPane;
    }

    private void createStatisticsTables(CommonSwitch commonSwitch) {
        this.setWaitingCursor();
        this.portStatisticsTableModel = new PortStatisticsTableModel(commonSwitch);
        this.portStatisticsTableModel.addTableModelListener(new CursorSwitcher());
        this.overviewTable = new JTable();
        this.transmitTable = new JTable();
        this.receiveTable = new JTable();
        this.vdslTable = new JTable();
        this.overviewTable.setAutoCreateColumnsFromModel(false);
        this.transmitTable.setAutoCreateColumnsFromModel(false);
        this.receiveTable.setAutoCreateColumnsFromModel(false);
        this.vdslTable.setAutoCreateColumnsFromModel(false);
        this.overviewTable.setModel(this.portStatisticsTableModel);
        this.transmitTable.setModel(this.portStatisticsTableModel);
        this.receiveTable.setModel(this.portStatisticsTableModel);
        this.vdslTable.setModel(this.portStatisticsTableModel);
        this.overviewTable.setRowSelectionAllowed(false);
        this.transmitTable.setRowSelectionAllowed(false);
        this.receiveTable.setRowSelectionAllowed(false);
        this.vdslTable.setRowSelectionAllowed(false);
        this.overviewTable.addColumn(new TableColumn(0));
        this.overviewTable.addColumn(new TableColumn(1));
        this.overviewTable.addColumn(new TableColumn(2));
        this.overviewTable.addColumn(new TableColumn(3));
        this.overviewTable.addColumn(new TableColumn(4));
        this.overviewTable.addColumn(new TableColumn(5));
        this.overviewTable.addColumn(new TableColumn(6));
        this.overviewTable.addColumn(new TableColumn(7));
        this.overviewTable.addColumn(new TableColumn(8));
        this.overviewTable.addColumn(new TableColumn(9));
        this.overviewTable.addColumn(new TableColumn(10));
        this.overviewTable.addColumn(new TableColumn(11));
        this.transmitTable.addColumn(new TableColumn(0));
        this.transmitTable.addColumn(new TableColumn(1));
        this.transmitTable.addColumn(new TableColumn(12));
        this.transmitTable.addColumn(new TableColumn(13));
        this.transmitTable.addColumn(new TableColumn(14));
        this.transmitTable.addColumn(new TableColumn(15));
        this.transmitTable.addColumn(new TableColumn(16));
        this.transmitTable.addColumn(new TableColumn(17));
        this.receiveTable.addColumn(new TableColumn(0));
        this.receiveTable.addColumn(new TableColumn(1));
        this.receiveTable.addColumn(new TableColumn(18));
        this.receiveTable.addColumn(new TableColumn(19));
        this.receiveTable.addColumn(new TableColumn(20));
        this.receiveTable.addColumn(new TableColumn(21));
        this.receiveTable.addColumn(new TableColumn(22));
        this.receiveTable.addColumn(new TableColumn(23));
        this.receiveTable.addColumn(new TableColumn(24));
        this.receiveTable.addColumn(new TableColumn(26));
        this.receiveTable.addColumn(new TableColumn(25));
        if (this.switches[this.switchIndex].supportVDSL()) {
            this.vdslTable.addColumn(new TableColumn(0));
            this.vdslTable.addColumn(new TableColumn(1));
            this.vdslTable.addColumn(new TableColumn(27));
            this.vdslTable.addColumn(new TableColumn(28));
            this.vdslTable.addColumn(new TableColumn(29));
            this.vdslTable.addColumn(new TableColumn(30));
            this.vdslTable.addColumn(new TableColumn(31));
        }
        ColumnListener columnListener = new ColumnListener(this.overviewTable);
        this.overviewTable.getTableHeader().addMouseListener(columnListener);
        this.overviewTable.getTableHeader().addMouseMotionListener(columnListener);
        columnListener = new ColumnListener(this.transmitTable);
        this.transmitTable.getTableHeader().addMouseListener(columnListener);
        this.transmitTable.getTableHeader().addMouseMotionListener(columnListener);
        columnListener = new ColumnListener(this.receiveTable);
        this.receiveTable.getTableHeader().addMouseListener(columnListener);
        this.receiveTable.getTableHeader().addMouseMotionListener(columnListener);
        columnListener = new ColumnListener(this.vdslTable);
        this.vdslTable.getTableHeader().addMouseListener(columnListener);
        this.vdslTable.getTableHeader().addMouseMotionListener(columnListener);
    }

    public PortStatisticsTableModel getPortStatisticsTableModel() {
        return this.portStatisticsTableModel;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.devicesCombo) {
            JComboBox jComboBox = (JComboBox)object;
            String string = (String)jComboBox.getSelectedItem();
            int n = 0;
            int n2 = 0;
            while (n2 < this.switches.length) {
                if (this.switches[n2].switchName.equals(string)) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n == this.switchIndex) {
                return;
            }
            if (this.switches[n].statusCode.equals("Down")) {
                JOptionPane.showMessageDialog(this, "The selected switch is down.", "Port Statistics", 0);
                this.devicesCombo.setSelectedItem(this.switches[this.switchIndex].switchName);
                return;
            }
            this.switchIndex = n;
            this.theSwitch = this.switches[this.switchIndex];
            this.getContentPane().remove(this.dataPanel);
            this.dataPanel = this.createDataPanel(this.theSwitch);
            this.getContentPane().add(this.dataPanel);
            this.validate();
            return;
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.portStatisticsTableModel.isTableFilled()) {
            super.setCursor(cursor);
        } else {
            super.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private void setDefaultCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PortStatisticsDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    private void setWaitingCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PortStatisticsDialog.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    class CursorSwitcher
    implements TableModelListener {
        CursorSwitcher() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (PortStatisticsDialog.this.portStatisticsTableModel.isTableFilled()) {
                PortStatisticsDialog.this.setDefaultCursor();
            } else {
                PortStatisticsDialog.this.setWaitingCursor();
            }
        }
    }

    class ColumnListener
    extends MouseAdapter
    implements MouseMotionListener {
        private JTable l_table;
        private TableColumnModel colModel = null;
        private int modelIndex = -1;

        public ColumnListener(JTable jTable) {
            this.l_table = jTable;
            this.colModel = this.l_table.getColumnModel();
        }

        private int getTableModelIndex(MouseEvent mouseEvent) {
            int n = this.colModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = this.colModel.getColumn(n).getModelIndex();
            return n2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.getTableModelIndex(mouseEvent);
            if (n < 0) {
                return;
            }
            if (n == PortStatisticsDialog.this.sortingModelIndex) {
                PortStatisticsDialog.this.isAsc ^= true;
            } else {
                PortStatisticsDialog.this.sortingModelIndex = n;
                PortStatisticsDialog.this.isAsc = true;
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.modelIndex = this.getTableModelIndex(mouseEvent);
            this.l_table.getTableHeader().setToolTipText(PortStatisticsTableModel.columnNames[this.modelIndex]);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.l_table.getTableHeader().setToolTipText("");
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getTableModelIndex(mouseEvent);
            if (n == this.modelIndex) {
                return;
            }
            this.modelIndex = n;
            this.l_table.getTableHeader().setToolTipText(PortStatisticsTableModel.columnNames[this.modelIndex]);
        }
    }
}

