/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PortSearch_JDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
WindowListener {
    boolean frameSizeAdjusted = false;
    boolean searchThisOnly = true;
    Boolean searching = Boolean.FALSE;
    JTextField searchString_JTextField;
    CustomDualList devices_JPanel;
    JTable results_JTable;
    PortSearchTableModel resultsTableModel;
    Vector openConfigs = new Vector();
    JPanel buttons_JPanel;
    JButton search_JButton;
    JButton config_JButton;
    JButton done_JButton;
    JButton help_JButton;
    JApplet theApplet;
    CommonSwitch[] switches;
    CommonSwitch theSwitch;
    int switchIndex;

    public PortSearch_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        Serializable serializable;
        Serializable serializable2;
        JComponent jComponent;
        this.setDefaultCloseOperation(2);
        this.setTitle("Port Search");
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        JComponent jComponent2 = (JComponent)this.getContentPane();
        jComponent2.setLayout(new BorderLayout());
        jComponent2.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.searchString_JTextField = new JTextField(15);
        this.search_JButton = new JButton("Search");
        this.search_JButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        if (jApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            jPanel2.setBorder(new TitledBorder("Find Ports With Description:"));
            jPanel2.add(this.searchString_JTextField);
            jPanel2.add(this.search_JButton);
            this.searchThisOnly = true;
        } else {
            jPanel2.setLayout(new BorderLayout());
            jComponent = new JPanel();
            this.searchString_JTextField = new JTextField(15);
            jComponent.add(new JLabel("Find Ports With Description: "));
            jComponent.add(this.searchString_JTextField);
            jPanel2.add((Component)jComponent, "North");
            serializable2 = new Vector<String>();
            int n = 0;
            while (n < commonSwitchArray.length) {
                ((Vector)serializable2).add(commonSwitchArray[n].switchName);
                ++n;
            }
            if (commonSwitch != null) {
                serializable = new Vector();
                ((Vector)serializable).add(commonSwitch.switchName);
            } else {
                serializable = (Vector)((Vector)serializable2).clone();
            }
            this.devices_JPanel = new CustomDualList((List)((Object)serializable2), "Devices", (List)((Object)serializable));
            this.devices_JPanel.setBorder(new TitledBorder("On These Devices:"));
            jPanel2.add((Component)this.devices_JPanel, "Center");
            JPanel jPanel3 = new JPanel();
            jPanel3.add(this.search_JButton);
            jPanel2.add((Component)jPanel3, "South");
            this.searchThisOnly = false;
        }
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        this.resultsTableModel = new PortSearchTableModel(this.searchThisOnly);
        this.results_JTable = new JTable(this.resultsTableModel);
        this.results_JTable.getSelectionModel().addListSelectionListener(this);
        this.results_JTable.setColumnSelectionAllowed(false);
        this.results_JTable.setRowSelectionAllowed(true);
        this.results_JTable.setSelectionMode(0);
        this.results_JTable.setPreferredScrollableViewportSize(new Dimension(400, 120));
        jComponent = new JScrollPane(this.results_JTable, 20, 30);
        serializable2 = new JPanel(new BorderLayout());
        ((JComponent)serializable2).setBorder(new TitledBorder("Search Results"));
        ((Container)serializable2).add(jComponent, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(2));
        this.config_JButton = new JButton("View Port Status ...");
        this.config_JButton.setEnabled(false);
        this.config_JButton.addActionListener(this);
        jPanel4.add(this.config_JButton);
        ((Container)serializable2).add(jPanel4, "South");
        jPanel.add((Component)serializable2);
        this.done_JButton = new JButton("Done");
        this.done_JButton.addActionListener(this);
        this.help_JButton = new JButton("Help");
        this.help_JButton.addActionListener(this);
        serializable = new JPanel();
        ((Container)serializable).add(this.done_JButton);
        ((Container)serializable).add(this.help_JButton);
        jComponent2.add((Component)jPanel, "Center");
        jComponent2.add((Component)serializable, "South");
        this.pack();
        if (commonSwitch == null) {
            commonSwitch = commonSwitchArray[0];
            int n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                    commonSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        this.switchIndex = 0;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] == commonSwitch) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
    }

    public PortSearch_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public PortSearch_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.search_JButton) {
            this.clickSearch();
        } else if (object == this.config_JButton) {
            this.clickViewDetails();
        } else if (object == this.done_JButton) {
            this.clickDone();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void clickDone() {
        this.dispose();
    }

    void clickHelp() {
        if (this.theApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"prtvsrch");
        } else {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"prtsrch");
        }
    }

    void clickSearch() {
        String string;
        int n;
        Thread[] threadArray;
        ((Component)this).setCursor(new Cursor(3));
        this.config_JButton.setEnabled(false);
        this.results_JTable.clearSelection();
        String string2 = this.searchString_JTextField.getText();
        Vector<CommonSwitch> vector = new Vector<CommonSwitch>();
        if (this.searchThisOnly) {
            vector.add(this.theSwitch);
        } else {
            threadArray = this.devices_JPanel.selectedListModel;
            n = 0;
            while (n < threadArray.size()) {
                string = (String)threadArray.elementAt(n);
                int n2 = 0;
                while (n2 < this.switches.length) {
                    if (string.equals(this.switches[n2].switchName) && !vector.contains(this.switches[n2])) {
                        vector.add(this.switches[n2]);
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        threadArray = new Thread[this.switches.length];
        this.resultsTableModel.getDataVector().clear();
        this.searching = Boolean.TRUE;
        n = 0;
        while (n < vector.size()) {
            string = (CommonSwitch)vector.elementAt(n);
            threadArray[n] = new Thread((Runnable)new PortFinder((CommonSwitch)string, string2), new String("find" + n));
            threadArray[n].start();
            ++n;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            try {
                threadArray[n3].join();
            }
            catch (InterruptedException interruptedException) {
                Boolean bl = this.searching;
                synchronized (bl) {
                    this.searching = Boolean.FALSE;
                }
            }
            ++n3;
        }
        Boolean bl = this.searching;
        synchronized (bl) {
            this.searching = Boolean.FALSE;
        }
        this.results_JTable.revalidate();
        if (this.results_JTable.getRowCount() <= 0) {
            JOptionPane.showMessageDialog(this, "No ports match description \"" + string2 + ".\"", "No Results For Search", 2);
        }
        this.config_JButton.setEnabled(false);
        ((Component)this).setCursor(new Cursor(0));
    }

    void clickViewDetails() {
        Object object;
        int n = this.results_JTable.getSelectedRow();
        Vector vector = this.resultsTableModel.getDataVector().elementAt(n);
        CommonSwitch commonSwitch = (CommonSwitch)vector.elementAt(0);
        String string = (String)vector.elementAt(1);
        boolean bl = false;
        PortConfig_JDialog portConfig_JDialog = null;
        int n2 = 0;
        while (n2 < this.openConfigs.size()) {
            portConfig_JDialog = (PortConfig_JDialog)this.openConfigs.elementAt(n2);
            if (commonSwitch.switchName.equals(portConfig_JDialog.theSwitch.switchName)) {
                portConfig_JDialog.toFront();
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            portConfig_JDialog = new PortConfig_JDialog(this.theApplet, this.switches, commonSwitch);
            ((CommonApplet)this.theApplet).makeDialogModal((JDialog)portConfig_JDialog);
            portConfig_JDialog.addWindowListener(this);
            this.openConfigs.add(portConfig_JDialog);
        }
        PortConfigTableModel portConfigTableModel = portConfig_JDialog.portConfigTableModel;
        JTable jTable = portConfig_JDialog.actualTable;
        int n3 = 0;
        n3 = 0;
        while (n3 < portConfigTableModel.getRowCount()) {
            object = (String)portConfigTableModel.getValueAt(n3, 0);
            if (((String)object).equals(string)) {
                jTable.setRowSelectionInterval(n3, n3);
                break;
            }
            ++n3;
        }
        portConfig_JDialog.tabPane.setSelectedIndex(1);
        object = new Rectangle(0, jTable.getRowHeight() * n3, 0, 0);
        jTable.scrollRectToVisible((Rectangle)object);
        portConfig_JDialog.setVisible(true);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.config_JButton.setEnabled(this.results_JTable.getSelectedRowCount() > 0);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        PortConfig_JDialog portConfig_JDialog = (PortConfig_JDialog)windowEvent.getWindow();
        this.openConfigs.remove(portConfig_JDialog);
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    class PortFinder
    implements Runnable {
        CommonSwitch thisSwitch;
        String searchString;

        PortFinder(CommonSwitch commonSwitch, String string) {
            this.thisSwitch = commonSwitch;
            this.searchString = string.toLowerCase();
        }

        public void run() {
            boolean bl;
            String[] stringArray = PortSearch_JDialog.this.searching;
            synchronized (stringArray) {
                bl = PortSearch_JDialog.this.searching;
            }
            if (bl) {
                stringArray = this.thisSwitch.Cli.getPortName(this.thisSwitch.esn);
                String[] stringArray2 = this.thisSwitch.Cli.getAllPortDescription(this.thisSwitch.esn);
                int n = 0;
                while (n < stringArray.length) {
                    Serializable serializable = PortSearch_JDialog.this.searching;
                    synchronized (serializable) {
                        bl = PortSearch_JDialog.this.searching;
                    }
                    if (bl && stringArray2[n].toLowerCase().indexOf(this.searchString) >= 0) {
                        serializable = new Vector();
                        ((Vector)serializable).add(this.thisSwitch);
                        ((Vector)serializable).add(new String(stringArray[n]));
                        ((Vector)serializable).add(new String(stringArray2[n]));
                        PortSearch_JDialog.this.resultsTableModel.addRow((Vector)serializable);
                    }
                    ++n;
                }
            }
        }
    }
}

