/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.JOptionPane;

public class SVUpgrade
extends Thread {
    CommonSwitch theSwitch;
    String ESN;
    String command;
    String rcommand;
    String output;
    String tftpServer;
    String newImageName;
    String currentImageName;
    String tarFileName;
    int newImageSize;
    int newImageDRAMSize;
    int newHTMLDirSize;
    boolean keepCurrentImageName;
    boolean failed;
    String status;
    String[] statusArray;
    String hostName;
    int beginIndex;
    int endIndex;
    int totalFlash;
    int availableFlash;
    String switchDeviceType;

    public SVUpgrade(CommonSwitch commonSwitch, String string, String string2, String string3, String string4, String string5, boolean bl, String[] stringArray, String string6, String string7, String string8, String string9, String string10) {
        this.theSwitch = commonSwitch;
        this.ESN = string;
        this.newImageName = string2;
        this.currentImageName = string3;
        this.keepCurrentImageName = bl;
        this.tarFileName = string4;
        this.tftpServer = string5;
        this.statusArray = stringArray;
        this.hostName = string6;
        this.newImageSize = new Integer(string7);
        this.newImageDRAMSize = !string8.equals("") ? new Integer(string8) : 0;
        this.newHTMLDirSize = new Integer(string9) * 1024;
        this.switchDeviceType = string10;
    }

    public void run() {
        if (this.switchDeviceType.indexOf("Catalyst 29") != -1 || this.switchDeviceType.indexOf("Catalyst 35") != -1) {
            this.run_3500_2900();
        } else {
            this.run_2820_1900();
        }
    }

    void run_2820_1900() {
        this.failed = false;
        this.output = this.theSwitch.Cli.upgradeSoftware(this.ESN, this.tftpServer, this.tarFileName);
        if (this.output.indexOf("Timeout") != -1) {
            this.status = "Connection Timed out, check the TFTP server";
        } else if (this.output.indexOf("Error") != -1) {
            this.status = "Software upgrade failed on " + this.hostName;
        } else {
            this.status = "Software upgrade was successful on " + this.hostName + ".";
            this.theSwitch.Cli.rebootSwitch(this.ESN, 5);
        }
        this.statusArray[new Integer((String)this.getName()).intValue()] = this.status;
    }

    void run_3500_2900() {
        this.failed = false;
        this.totalFlash = this.theSwitch.Cli.getTotalFlashSize(this.ESN);
        if (this.totalFlash < 3500000 && this.newImageDRAMSize == 8) {
            this.status = "Software upgrade failed on " + this.hostName + ". Can not copy an image that is for a 8Mb device to a 4Mb device.";
        } else if (this.totalFlash > 3500000 && this.newImageDRAMSize == 4) {
            this.status = "Software upgrade failed on " + this.hostName + ". Copying a 4Mb device image to a 8Mb device is not supported.";
        } else {
            int n;
            int n2;
            this.output = this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, "html", "*");
            this.availableFlash = this.theSwitch.Cli.getNumberOfFreeBytesInFlash(this.ESN);
            int n3 = this.theSwitch.Cli.getFileSize(this.ESN, "flash:/" + this.currentImageName);
            if (this.availableFlash + n3 < (n2 = this.newImageSize + this.newHTMLDirSize)) {
                this.statusArray[new Integer((String)this.getName()).intValue()] = this.status = "Software upgrade failed on " + this.hostName + ".\n" + "\tThere is insufficient flash space available to hold the new image.\n" + "\tTotal free space required is " + n2 + " bytes.\n" + "\tPlease remove unwanted files from the flash and upgrade again.\n" + "WARNING: The files in " + this.hostName + " flash:/html directory have been deleted.";
                return;
            }
            if (this.availableFlash + n3 < n2 + 50000 && (n = JOptionPane.showConfirmDialog(null, "The amount of free space after upgrade will be " + (this.availableFlash + n3 - n2) + " bytes.\n" + "This may affect the switch's performance, since it requires minimum 50000 bytes free.\n" + "Do you want to continue with Software Upgrade ?", "Warning - Low free memory", 0)) != 0) {
                this.statusArray[new Integer((String)this.getName()).intValue()] = this.status = "Software upgrade cancelled by user.\nWARNING: The files in " + this.hostName + " flash:/html directory have been deleted.";
                return;
            }
            if (this.availableFlash < n2) {
                if (!this.currentImageName.equals(this.newImageName)) {
                    this.output = this.theSwitch.Cli.renameFlashFilename(this.ESN, this.currentImageName, this.newImageName);
                    this.output = this.theSwitch.Cli.setNewBootableImage(this.ESN, this.newImageName);
                }
            } else {
                this.output = this.currentImageName.equals(this.newImageName) ? this.theSwitch.Cli.renameFlashFilename(this.ESN, this.currentImageName, String.valueOf(this.currentImageName) + "-original") : this.theSwitch.Cli.setNewBootableImage(this.ESN, this.newImageName);
            }
            this.output = this.theSwitch.Cli.extractAllFilesFromTarToFlash(this.ESN, this.tftpServer, this.tarFileName, null);
            if (this.output.indexOf("Operation timed out") != -1) {
                this.status = "Software upgrade failed on " + this.hostName + ". Operation timed out.";
                this.failed = true;
            } else if (this.output.indexOf("Timed out") != -1) {
                this.status = "Software upgrade failed on " + this.hostName + ". TFTP Server not found.";
                this.failed = true;
            } else if (this.output.indexOf("No such file") != -1) {
                this.status = "Software upgrade failed on " + this.hostName + ". No such file or directory.";
                this.failed = true;
            } else if (this.output.indexOf("Premature end of tar") != -1) {
                this.status = "Software upgrade failed on " + this.hostName + ". TFTP Server failed.";
                this.failed = true;
            } else if (this.output.indexOf("info.ver") == -1) {
                this.status = "Software upgrade failed on " + this.hostName + ". Could not copy all the files to the switch.";
                this.failed = true;
            } else {
                this.status = "Software upgrade was successful on " + this.hostName + ".";
            }
            if (this.failed) {
                if (this.availableFlash < this.newImageSize + this.newHTMLDirSize) {
                    if (!this.currentImageName.equals(this.newImageName)) {
                        this.output = this.theSwitch.Cli.renameFlashFilename(this.ESN, this.newImageName, this.currentImageName);
                        this.output = this.theSwitch.Cli.setNewBootableImage(this.ESN, this.currentImageName);
                    }
                } else if (this.currentImageName.equals(this.newImageName)) {
                    this.output = this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, null, this.newImageName);
                    this.output = this.theSwitch.Cli.renameFlashFilename(this.ESN, String.valueOf(this.currentImageName) + "-original", this.currentImageName);
                    this.output = this.theSwitch.Cli.setNewBootableImage(this.ESN, this.currentImageName);
                } else {
                    this.output = this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, null, this.newImageName);
                    this.output = this.theSwitch.Cli.setNewBootableImage(this.ESN, this.currentImageName);
                }
            } else if (this.keepCurrentImageName) {
                if (this.availableFlash < this.newImageSize + this.newHTMLDirSize) {
                    if (!this.currentImageName.equals(this.newImageName)) {
                        this.output = this.theSwitch.Cli.renameFlashFilename(this.ESN, this.newImageName, this.currentImageName);
                        this.output = this.theSwitch.Cli.setNewBootableImage(this.ESN, this.currentImageName);
                    }
                } else if (this.currentImageName.equals(this.newImageName)) {
                    this.output = this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, null, String.valueOf(this.currentImageName) + "-original");
                } else {
                    this.output = this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, null, this.currentImageName);
                    this.output = this.theSwitch.Cli.renameFlashFilename(this.ESN, this.newImageName, this.currentImageName);
                    this.output = this.theSwitch.Cli.setNewBootableImage(this.ESN, this.currentImageName);
                }
            } else if (this.availableFlash > this.newImageSize + this.newHTMLDirSize) {
                this.output = this.currentImageName.equals(this.newImageName) ? this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, null, String.valueOf(this.currentImageName) + "-original") : this.theSwitch.Cli.deleteFilesFromFlash(this.ESN, null, this.currentImageName);
            }
        }
        this.statusArray[new Integer((String)this.getName()).intValue()] = this.status;
    }
}

