/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Point;
import java.io.Serializable;

public class Transform
implements Serializable {
    private double scaleX;
    private double scaleY;
    private double shiftX;
    private double shiftY;
    protected boolean logXScaling = false;
    protected boolean logYScaling = false;
    static final double LOG_10_E = 0.4342942;

    public Transform(double d, double d2, double d3, double d4, int n, int n2, int n3, int n4) {
        this.scaleX = (double)(n3 - n) / (d3 - d);
        this.scaleY = (double)(n4 - n2) / (d4 - d2);
        this.shiftX = (double)n - this.scaleX * d;
        this.shiftY = (double)n2 - this.scaleY * d2;
    }

    public Transform(double d, double d2, double d3, double d4, Point point, Point point2) {
        this.scaleX = (double)(point2.x - point.x) / (d3 - d);
        this.scaleY = (double)(point2.y - point.y) / (d4 - d2);
        this.shiftX = (double)point.x - this.scaleX * d;
        this.shiftY = (double)point.y - this.scaleY * d2;
    }

    static double log10(double d) {
        return Math.log(d) * 0.4342942;
    }

    public Point point(double d, double d2) {
        double d3;
        int n = !this.logXScaling ? ((d3 = d * this.scaleX + this.shiftX) > 32767.0 ? Short.MAX_VALUE : (d3 < -32768.0 ? Short.MIN_VALUE : (int)d3)) : (int)(Transform.log10(d) * this.scaleX + this.shiftX);
        int n2 = !this.logYScaling ? (int)(d2 * this.scaleY + this.shiftY) : (int)(Transform.log10(d2) * this.scaleY + this.shiftY);
        return new Point(n, n2);
    }

    public Point[] pointList(double[] dArray, double[] dArray2) {
        Point[] pointArray = new Point[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            pointArray[n] = this.point(dArray[n], dArray2[n]);
            ++n;
        }
        return pointArray;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + " shiftX " + this.shiftX + " shiftY " + this.shiftY + " scaleX " + this.scaleX + " scaleY " + this.scaleY + " ]";
    }

    public double xValue(int n) {
        double d = n;
        d = (d - this.shiftX) / this.scaleX;
        if (!this.logXScaling) {
            return d;
        }
        return Transform.log10(d);
    }

    public double yValue(int n) {
        double d = n;
        d = (d - this.shiftY) / this.scaleY;
        if (!this.logYScaling) {
            return d;
        }
        return Transform.log10(d);
    }
}

