/*
 * Decompiled with CFR 0.152.
 */
package custom;

import clairvoyant.InsetDateAxis;
import custom.CiscoArea;
import custom.CiscoBar;
import custom.CiscoStackBar;
import java.awt.Graphics;
import java.awt.Point;
import javachart.chart.Background;
import javachart.chart.Bar;
import javachart.chart.Chart;
import javachart.chart.Dataset;
import javachart.chart.DiscontinuousLine;
import javachart.chart.Legend;
import javachart.chart.Plotarea;
import javachart.chart.StackAxis;

public class CiscoChart
extends Chart {
    DiscontinuousLine line;
    CiscoBar bar;
    CiscoStackBar stackBar;
    CiscoArea area;
    static final int LINE = 0;
    static final int BAR = 1;
    static final int STACK_BAR = 2;
    static final int AREA = 3;
    static final int STACK_AREA = 4;
    int chartType = 0;
    boolean[] datasetVis;
    Dataset[] dataRepresentationSets;

    public CiscoChart() {
    }

    public CiscoChart(String s) {
        super(s);
    }

    public void clearAllDatasets() {
        this.numberOfDatasets = 0;
        int i = 0;
        while (i < 40) {
            this.datasets[i] = null;
            this.dataRepresentationSets[i] = null;
            ++i;
        }
    }

    public void drawGraph(Graphics g) {
        super.drawGraph();
        this.background.draw(g);
        this.plotarea.draw(g);
        if (this.yAxisVisible) {
            this.yAxis.draw(g);
        } else {
            this.yAxis.scale();
        }
        if (this.xAxisVisible) {
            this.xAxis.draw(g);
        }
        int i = 0;
        int j = 0;
        while (i < this.datasetVis.length) {
            if (this.datasetVis[i]) {
                this.dataRepresentationSets[j++] = this.datasets[i];
            }
            ++i;
        }
        Graphics saveG = g;
        g = g.create();
        double llx = this.plotarea.getLlX();
        double urx = this.plotarea.getUrX();
        double lly = this.plotarea.getLlY();
        double ury = this.plotarea.getUrY();
        Point clipLL = new Point((int)(llx * (double)this.width), (int)((double)this.height - lly * (double)this.height + 1.0));
        Point clipUR = new Point((int)(urx * (double)this.width), (int)((double)this.height - ury * (double)this.height));
        g.clipRect(clipLL.x, clipUR.y, clipUR.x - clipLL.x, clipLL.y - clipUR.y);
        switch (this.chartType) {
            case 0: {
                this.line.draw(g);
                break;
            }
            case 1: {
                this.bar.draw(g);
                break;
            }
            case 2: {
                this.stackBar.draw(g);
                break;
            }
            case 3: {
                this.area.draw(g);
                break;
            }
            case 4: {
                this.area.draw(g);
                break;
            }
        }
        g = saveG;
        if (this.legendVisible) {
            this.legend.draw(g);
        }
    }

    public Bar getBar() {
        return this.bar;
    }

    public int getChartType() {
        return this.chartType;
    }

    public DiscontinuousLine getLine() {
        return this.line;
    }

    protected boolean getStackValues() {
        return this.area.stackValues;
    }

    protected void initAxes() {
        this.setXAxis(new InsetDateAxis());
        this.xAxis.setSide(0);
        StackAxis ax = new StackAxis();
        ax.setStackValues(false);
        this.setYAxis(ax);
    }

    protected synchronized void initChart() {
        this.initGlobals();
        this.setPlotarea(new Plotarea());
        this.setBackground(new Background());
        this.initDatasets();
        this.initAxes();
        this.bar = new CiscoBar(this.dataRepresentationSets, this.xAxis, this.yAxis, this.plotarea);
        this.line = new DiscontinuousLine(this.dataRepresentationSets, this.xAxis, this.yAxis, this.plotarea);
        this.stackBar = new CiscoStackBar(this.dataRepresentationSets, this.xAxis, this.yAxis, this.plotarea);
        this.area = new CiscoArea(this.dataRepresentationSets, this.xAxis, this.yAxis, this.plotarea);
        this.setLegend(new Legend(this.datasets, this.globals));
    }

    protected void initDatasets() {
        this.datasets = new Dataset[40];
        this.dataRepresentationSets = new Dataset[40];
        this.datasetVis = new boolean[40];
        int i = 0;
        while (i < this.datasetVis.length) {
            this.datasetVis[i] = true;
            ++i;
        }
    }

    public void setChartType(int type) {
        this.chartType = type;
        this.yAxis.setBarScaling(this.chartType != 0);
        if (this.chartType == 2 || this.chartType == 4) {
            this.setStackValues(true);
        } else {
            this.setStackValues(false);
        }
    }

    protected void setStackValues(boolean stack) {
        ((StackAxis)this.yAxis).setStackValues(stack);
        this.area.stackValues = stack;
        if (this.chartType == 1 && stack) {
            this.chartType = 2;
        }
        if (this.chartType == 2 && !stack) {
            this.chartType = 1;
        }
    }
}

