/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class VMPS_JDialog
extends CustomMinimumSize_JDialog
implements ActionListener,
Runnable {
    boolean frameSizeAdjusted = false;
    JPanel buttons_JPanel;
    JButton ok_JButton;
    JButton apply_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JTabbedPane vmps_TabbedPane;
    JPanel vmpsInfo_JPanel;
    JPanel refresh_JPanel;
    JPanel vmpsInfoMain_JPanel;
    JLabel queryProtocolVersion_JLabel;
    JLabel currentVMPS_JLabel;
    JLabel primaryVMPS_JLabel;
    JLabel retries_JLabel;
    JLabel reConfirmInterval_JLabel;
    JLabel protocolVersionData_JLabel;
    JLabel currVMPSData_JLabel;
    JLabel primVMPSData_JLabel;
    JLabel reconfirmStatusData_JLabel;
    NumericTextField retriesData_JTextField;
    NumericTextField intervalData_JTextField;
    JButton refreshConfirmStatus_JButton;
    JPanel vmpsServer_JPanel;
    JPanel vmpsIP_JPanel;
    JPanel vmpsCurrentServer_JPanel;
    JTextField vmpsIP_JTextField;
    JButton add_JButton;
    JButton remove_JButton;
    JButton primary_JButton;
    ImageIcon addIcon;
    ImageIcon removeIcon;
    JList vmpsServer_JList;
    JApplet theApplet;
    CommonSwitch[] switches;
    CommonSwitch theSwitch;
    int switchIndex;
    String version;
    String currentVmps;
    String primaryVmps;
    String retryCount;
    String reconfirmInterval;
    String status;
    Vector vmpsServerList = new Vector();
    String userPrimaryVmps = "";
    DefaultListModel vmpsServerListModel = new DefaultListModel();
    Thread vmpsThread;
    String[] server;

    public VMPS_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        if (commonSwitch == null) {
            int n = 0;
            while (n < commonSwitchArray.length) {
                String string = commonSwitchArray[n].deviceType;
                if (string.indexOf("WS-C35") != -1 || string.indexOf("WS-C29") != -1 && string.indexOf("WS-C2950") == -1) {
                    commonSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        this.switchIndex = 0;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] == commonSwitch) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
        jApplet.setCursor(new Cursor(3));
        this.setTitle("VMPS Configuration");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(605, 415);
        this.setMinimumWidth(this.getSize().width);
        this.setMinimumHeight(this.getSize().height);
        this.setVisible(false);
        this.vmpsInfo_JPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.vmpsInfo_JPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.queryProtocolVersion_JLabel = new JLabel("VLAN Query Protocol Version:");
        this.vmpsInfo_JPanel.add((Component)this.queryProtocolVersion_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.protocolVersionData_JLabel = new JLabel("1");
        this.protocolVersionData_JLabel.setForeground(Color.black);
        this.vmpsInfo_JPanel.add((Component)this.protocolVersionData_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.currentVMPS_JLabel = new JLabel("Current VMPS:");
        this.vmpsInfo_JPanel.add((Component)this.currentVMPS_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.currVMPSData_JLabel = new JLabel("0.0.0.0");
        this.currVMPSData_JLabel.setForeground(Color.black);
        this.vmpsInfo_JPanel.add((Component)this.currVMPSData_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.primaryVMPS_JLabel = new JLabel("Primary VMPS:");
        this.vmpsInfo_JPanel.add((Component)this.primaryVMPS_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.primVMPSData_JLabel = new JLabel("0.0.0.0");
        this.primVMPSData_JLabel.setForeground(Color.black);
        this.vmpsInfo_JPanel.add((Component)this.primVMPSData_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.retries_JLabel = new JLabel("Number of Retries: [1-10]");
        this.vmpsInfo_JPanel.add((Component)this.retries_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        this.retriesData_JTextField = new NumericTextField("3");
        this.retriesData_JTextField.setColumns(10);
        this.retriesData_JTextField.setMinimumSize(new Dimension(120, 25));
        this.retriesData_JTextField.setMaximumSize(new Dimension(120, 25));
        this.retriesData_JTextField.setPreferredSize(new Dimension(120, 25));
        this.vmpsInfo_JPanel.add((Component)this.retriesData_JTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.reConfirmInterval_JLabel = new JLabel("Reconfirmation Interval: [1-120]");
        this.vmpsInfo_JPanel.add((Component)this.reConfirmInterval_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.intervalData_JTextField = new NumericTextField("60");
        this.intervalData_JTextField.setColumns(10);
        this.intervalData_JTextField.setMinimumSize(new Dimension(120, 25));
        this.intervalData_JTextField.setMaximumSize(new Dimension(120, 25));
        this.intervalData_JTextField.setPreferredSize(new Dimension(120, 25));
        this.vmpsInfo_JPanel.add((Component)this.intervalData_JTextField, gridBagConstraints);
        this.refresh_JPanel = new JPanel(new BorderLayout(0, 0));
        this.refresh_JPanel.setBorder(BorderFactory.createTitledBorder("Reconfirmation Status"));
        this.reconfirmStatusData_JLabel = new JLabel("No Dynamic Port Configured", 0);
        this.reconfirmStatusData_JLabel.setForeground(Color.black);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.reconfirmStatusData_JLabel, "Center");
        this.refresh_JPanel.add((Component)jPanel, "Center");
        this.refreshConfirmStatus_JButton = new JButton("Refresh");
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        jPanel2.setLayout(flowLayout);
        jPanel2.add(this.refreshConfirmStatus_JButton);
        this.refresh_JPanel.add((Component)jPanel2, "South");
        this.vmpsInfoMain_JPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.vmpsInfoMain_JPanel.add((Component)this.vmpsInfo_JPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        this.vmpsInfoMain_JPanel.add((Component)this.refresh_JPanel, gridBagConstraints);
        this.vmpsServer_JPanel = new JPanel();
        this.vmpsServer_JPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.vmpsIP_JPanel = new JPanel();
        this.vmpsIP_JPanel.setLayout(new BorderLayout());
        this.vmpsIP_JTextField = new JTextField(12);
        this.vmpsIP_JPanel.add((Component)this.vmpsIP_JTextField, "Center");
        this.vmpsIP_JPanel.setBorder(BorderFactory.createTitledBorder("New Server IP"));
        this.vmpsIP_JPanel.setMinimumSize(new Dimension(150, 25));
        this.vmpsServer_JPanel.add((Component)this.vmpsIP_JPanel, this.setGridBagConstraints(gridBagConstraints2, 0, 0, 0.0, 0.1, 2, 0, 0, 10, 20, 20, 20, 10, 1, 1));
        JPanel jPanel3 = new JPanel();
        GridLayout gridLayout = new GridLayout(3, 1);
        gridLayout.setVgap(6);
        gridLayout.setHgap(6);
        jPanel3.setLayout(gridLayout);
        this.addIcon = new ImageIcon(SVGetImages.rightArrow);
        this.add_JButton = new JButton("Add", this.addIcon);
        this.add_JButton.setHorizontalTextPosition(2);
        this.add_JButton.setMinimumSize(new Dimension(120, 25));
        this.add_JButton.setMaximumSize(new Dimension(120, 25));
        this.add_JButton.setPreferredSize(new Dimension(120, 25));
        jPanel3.add(this.add_JButton);
        this.remove_JButton = new JButton("Remove");
        this.remove_JButton.setBounds(185, 85, 116, 29);
        this.remove_JButton.setMinimumSize(new Dimension(120, 25));
        this.remove_JButton.setMaximumSize(new Dimension(120, 25));
        this.remove_JButton.setPreferredSize(new Dimension(120, 25));
        jPanel3.add(this.remove_JButton);
        this.primary_JButton = new JButton("Make Primary");
        this.primary_JButton.setMinimumSize(new Dimension(120, 25));
        this.primary_JButton.setMaximumSize(new Dimension(120, 25));
        this.primary_JButton.setPreferredSize(new Dimension(120, 25));
        jPanel3.add(this.primary_JButton);
        this.vmpsServer_JPanel.add((Component)jPanel3, this.setGridBagConstraints(gridBagConstraints2, 1, 0, 0.0, 0.0, 0, 0, 0, 10, 0, 10, 0, 0, 1, 1));
        this.vmpsCurrentServer_JPanel = new JPanel(new BorderLayout(0, 0));
        this.vmpsCurrentServer_JPanel.setBorder(BorderFactory.createTitledBorder("VMPS Server(s)"));
        this.vmpsServer_JList = new JList();
        this.vmpsServer_JList.setSelectionMode(0);
        this.vmpsServer_JList.setFixedCellHeight(15);
        this.vmpsServer_JList.setFixedCellWidth(80);
        JScrollPane jScrollPane = new JScrollPane(this.vmpsServer_JList, 20, 30);
        this.vmpsCurrentServer_JPanel.add((Component)jScrollPane, "Center");
        this.vmpsServer_JPanel.add((Component)this.vmpsCurrentServer_JPanel, this.setGridBagConstraints(gridBagConstraints2, 2, 0, 0.1, 0.0, 1, 0, 0, 10, 0, 20, 0, 0, 1, 1));
        this.vmps_TabbedPane = new JTabbedPane();
        this.vmps_TabbedPane.add("VMPS Info", this.vmpsInfoMain_JPanel);
        this.vmps_TabbedPane.add("VMPS Server", this.vmpsServer_JPanel);
        this.getContentPane().add((Component)this.vmps_TabbedPane, "Center");
        this.buttons_JPanel = new JPanel();
        this.buttons_JPanel.setLayout(new FlowLayout(1, 5, 5));
        this.ok_JButton = new JButton("OK");
        this.apply_JButton = new JButton("Apply");
        this.cancel_JButton = new JButton("Cancel");
        this.help_JButton = new JButton("Help");
        this.buttons_JPanel.add(this.ok_JButton);
        this.buttons_JPanel.add(this.apply_JButton);
        this.buttons_JPanel.add(this.cancel_JButton);
        this.buttons_JPanel.add(this.help_JButton);
        this.getContentPane().add((Component)this.buttons_JPanel, "South");
        this.ok_JButton.addActionListener(this);
        this.apply_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        this.add_JButton.addActionListener(this);
        this.remove_JButton.addActionListener(this);
        this.primary_JButton.addActionListener(this);
        this.refreshConfirmStatus_JButton.addActionListener(this);
        this.retriesData_JTextField.addActionListener(this);
        this.intervalData_JTextField.addActionListener(this);
        this.retriesData_JTextField.addActionListener(this);
        this.intervalData_JTextField.addActionListener(this);
        KeyPressHandler keyPressHandler = new KeyPressHandler();
        this.retriesData_JTextField.addKeyListener(keyPressHandler);
        this.intervalData_JTextField.addKeyListener(keyPressHandler);
        this.vmpsIP_JTextField.addActionListener(this);
        this.vmpsServer_JList.setModel(this.vmpsServerListModel);
        this.vmpsThread = new Thread((Runnable)this, "vmps");
        this.vmpsThread.start();
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(false);
        jApplet.setCursor(new Cursor(0));
    }

    public VMPS_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public VMPS_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            this.clickOK();
        } else if (object == this.cancel_JButton) {
            this.clickCancel();
        } else if (object == this.apply_JButton) {
            this.clickApply();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        } else if (object == this.add_JButton) {
            this.clickAdd();
        } else if (object == this.remove_JButton) {
            this.clickRemove();
        } else if (object == this.primary_JButton) {
            this.clickPrimary();
        } else if (object == this.refreshConfirmStatus_JButton) {
            this.clickRefreshConfirmStatus();
        } else if (object == this.retriesData_JTextField || object == this.intervalData_JTextField) {
            this.ok_JButton.setEnabled(true);
            this.apply_JButton.setEnabled(true);
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void clickAdd() {
        String string = this.switches[this.switchIndex].esn;
        String string2 = this.vmpsIP_JTextField.getText();
        if (string2.equals("")) {
            JOptionPane.showMessageDialog(this, "Please specify an IP Address", "VMPS Configuration", 0);
            return;
        }
        int n = 0;
        while (n < this.vmpsServerListModel.getSize()) {
            String string3 = (String)this.vmpsServerListModel.getElementAt(n);
            if (string2.equals(string3)) {
                JOptionPane.showMessageDialog(this, "The IP Address exists already.", "VMPS Configuration", 0);
                return;
            }
            ++n;
        }
        this.vmpsServerListModel.addElement(string2);
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
    }

    void clickApply() {
        boolean bl = this.setVmpsData();
        if (bl) {
            this.getCurrentPrimaryVmps();
            this.ok_JButton.setEnabled(true);
            this.apply_JButton.setEnabled(false);
        }
    }

    void clickCancel() {
        this.dispose();
    }

    void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"vmpscfg");
    }

    void clickOK() {
        boolean bl = this.setVmpsData();
        if (bl) {
            this.dispose();
        }
    }

    void clickPrimary() {
        String string = this.switches[this.switchIndex].esn;
        int n = this.vmpsServer_JList.getSelectedIndex();
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Please select the Primary VMPS Server.", "VMPS Configuration", 0);
            return;
        }
        this.userPrimaryVmps = (String)this.vmpsServerListModel.getElementAt(n);
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
    }

    void clickRefreshConfirmStatus() {
        String string = this.switches[this.switchIndex].esn;
        ((Component)this).setCursor(new Cursor(3));
        this.switches[this.switchIndex].Cli.setVmpsReconfirm(string);
        this.status = this.switches[this.switchIndex].Cli.getVmpsStatus(string);
        this.reconfirmStatusData_JLabel.setText(this.status);
        ((Component)this).setCursor(new Cursor(0));
    }

    void clickRemove() {
        String string = this.switches[this.switchIndex].esn;
        int n = this.vmpsServer_JList.getSelectedIndex();
        if (n == -1) {
            JOptionPane.showMessageDialog(this, "Please select a VMPS Server to remove.", "VMPS Configuration", 0);
            return;
        }
        this.vmpsServerListModel.remove(n);
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
    }

    void getCurrentPrimaryVmps() {
        String string = this.switches[this.switchIndex].esn;
        this.currentVmps = this.switches[this.switchIndex].Cli.getVmpsCurrent(string);
        this.currVMPSData_JLabel.setText(this.currentVmps);
        this.primaryVmps = this.switches[this.switchIndex].Cli.getVmpsPrimary(string);
        this.primVMPSData_JLabel.setText(this.primaryVmps);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    void retryIntervalTextField_keyPressed() {
        try {
            this.apply_JButton.setEnabled(true);
        }
        catch (Exception exception) {}
    }

    public void run() {
        String string = this.switches[this.switchIndex].esn;
        Runnable runnable = new Runnable(){

            public void run() {
                VMPS_JDialog.this.protocolVersionData_JLabel.setText(VMPS_JDialog.this.version);
            }
        };
        this.version = this.switches[this.switchIndex].Cli.getVmpsVersion(string);
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        Runnable runnable2 = new Runnable(){

            public void run() {
                VMPS_JDialog.this.currVMPSData_JLabel.setText(VMPS_JDialog.this.currentVmps);
                VMPS_JDialog.this.primVMPSData_JLabel.setText(VMPS_JDialog.this.primaryVmps);
            }
        };
        this.currentVmps = this.switches[this.switchIndex].Cli.getVmpsCurrent(string);
        this.primaryVmps = this.switches[this.switchIndex].Cli.getVmpsPrimary(string);
        try {
            SwingUtilities.invokeAndWait(runnable2);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        Runnable runnable3 = new Runnable(){

            public void run() {
                VMPS_JDialog.this.retriesData_JTextField.setText(VMPS_JDialog.this.retryCount);
                VMPS_JDialog.this.intervalData_JTextField.setText(VMPS_JDialog.this.reconfirmInterval);
                VMPS_JDialog.this.reconfirmStatusData_JLabel.setText(VMPS_JDialog.this.status);
            }
        };
        this.retryCount = this.switches[this.switchIndex].Cli.getVmpsRetryCount(string);
        this.reconfirmInterval = this.switches[this.switchIndex].Cli.getVmpsReconfirmInterval(string);
        this.status = this.switches[this.switchIndex].Cli.getVmpsStatus(string);
        try {
            SwingUtilities.invokeAndWait(runnable3);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        Runnable runnable4 = new Runnable(){

            public void run() {
                int n = 0;
                while (n < VMPS_JDialog.this.server.length) {
                    VMPS_JDialog.this.vmpsServerListModel.addElement(VMPS_JDialog.this.server[n]);
                    VMPS_JDialog.this.vmpsServerList.addElement(VMPS_JDialog.this.server[n]);
                    ++n;
                }
            }
        };
        this.server = this.switches[this.switchIndex].Cli.getVmpsServers(string);
        try {
            SwingUtilities.invokeAndWait(runnable4);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    public GridBagConstraints setGridBagConstraints(GridBagConstraints gridBagConstraints, int n, int n2, double d, double d2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n3;
        gridBagConstraints.gridheight = n11;
        gridBagConstraints.gridwidth = n12;
        gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    boolean setVmpsData() {
        String string;
        String string2;
        int n;
        Object object;
        String string3 = this.retriesData_JTextField.getText();
        if (string3.equals("")) {
            JOptionPane.showMessageDialog(this, "Number of Retries should be 1 to 10.", "VMPS Configuration", 0);
            return false;
        }
        int n2 = Integer.parseInt(string3);
        if (n2 < 1 || n2 > 10) {
            JOptionPane.showMessageDialog(this, "Number of Retries should be 1 to 10.", "VMPS Configuration", 0);
            return false;
        }
        String string4 = this.intervalData_JTextField.getText();
        if (string4.equals("")) {
            JOptionPane.showMessageDialog(this, "Reconfirm Interval should be 1 to 120.", "VMPS Configuration", 0);
            return false;
        }
        int n3 = Integer.parseInt(string4);
        if (n3 < 1 || n3 > 120) {
            JOptionPane.showMessageDialog(this, "Reconfirm Interval should be 1 to 120.", "VMPS Configuration", 0);
            return false;
        }
        ((Component)this).setCursor(new Cursor(3));
        int n4 = 0;
        while (n4 < this.switches.length) {
            if (!this.switches[n4].statusCode.equals("Down")) {
                String string5 = this.switches[n4].esn;
                if (!string3.equals(this.retryCount)) {
                    this.switches[n4].Cli.setVmpsRetry(string5, string3);
                }
                if (!string4.equals(this.reconfirmInterval)) {
                    this.switches[n4].Cli.setVmpsReconfirmInterval(string5, string4);
                }
            }
            ++n4;
        }
        boolean bl = false;
        Vector<Object> vector = new Vector<Object>(1);
        int n5 = 0;
        while (n5 < this.vmpsServerList.size()) {
            object = (String)this.vmpsServerList.elementAt(n5);
            bl = false;
            n = 0;
            while (n < this.vmpsServerListModel.getSize()) {
                string2 = (String)this.vmpsServerListModel.getElementAt(n);
                if (((String)object).equals(string2)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                int n6 = 0;
                while (n6 < this.switches.length) {
                    if (!this.switches[n6].statusCode.equals("Down")) {
                        string = this.switches[n6].esn;
                        this.switches[n6].Cli.removeVmpsServer(string, (String)object);
                    }
                    ++n6;
                }
            }
            vector.addElement(object);
            ++n5;
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            this.vmpsServerList.removeElement(object.nextElement());
        }
        n = 0;
        while (n < this.vmpsServerListModel.getSize()) {
            string2 = (String)this.vmpsServerListModel.getElementAt(n);
            bl = false;
            int n7 = 0;
            while (n7 < this.vmpsServerList.size()) {
                String string6 = (String)this.vmpsServerList.elementAt(n7);
                if (string2.equals(string6)) {
                    bl = true;
                    break;
                }
                ++n7;
            }
            if (!bl) {
                int n8 = 0;
                while (n8 < this.switches.length) {
                    if (!this.switches[n8].statusCode.equals("Down")) {
                        String string7 = this.switches[n8].esn;
                        String string8 = this.switches[n8].Cli.addVmpsServer(string7, string2);
                        if (string8.indexOf("VMPS table is full") != -1) {
                            JOptionPane.showMessageDialog(this, string8, "VMPS Configuration", 0);
                            return false;
                        }
                        if (string8.indexOf("Not a valid host address") != -1) {
                            JOptionPane.showMessageDialog(this, string8, "VMPS Configuration", 0);
                            return false;
                        }
                    }
                    ++n8;
                }
                this.vmpsServerList.addElement(string2);
            }
            ++n;
        }
        if (!this.userPrimaryVmps.equals("")) {
            int n9 = 0;
            while (n9 < this.switches.length) {
                if (!this.switches[n9].statusCode.equals("Down")) {
                    string = this.switches[n9].esn;
                    this.switches[n9].Cli.setVmpsPrimaryServer(string, this.userPrimaryVmps);
                }
                ++n9;
            }
        }
        ((Component)this).setCursor(new Cursor(0));
        return true;
    }

    class KeyPressHandler
    extends KeyAdapter {
        KeyPressHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            if (object == VMPS_JDialog.this.retriesData_JTextField || object == VMPS_JDialog.this.intervalData_JTextField) {
                VMPS_JDialog.this.retryIntervalTextField_keyPressed();
            }
        }
    }
}

