/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public final class VTPMgmt_JDialog
extends CustomMinimumSize_JDialog
implements ActionListener,
ItemListener,
Runnable {
    boolean frameSizeAdjusted = false;
    String vtpVersion;
    String revision;
    String maxVlan;
    String numOfVlan;
    String lastMod;
    JPanel deviceList_JPanel;
    JComboBox devices_JCombo;
    JButton ok_JButton;
    JButton apply_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JButton modify_JButton;
    JButton new_JButton;
    JButton remove_JButton;
    JPanel vtpInfo_JPanel;
    JPanel vtpConfig_JPanel;
    JPanel vlanConfig_JPanel;
    JTabbedPane vtp_TabbedPane;
    JLabel vtpVersion_JLabel;
    JLabel configRev_JLabel;
    JLabel maxVLAN_JLabel;
    JLabel currVLAN_JLabel;
    JLabel lastModif_JLabel;
    JLabel vtpVerData_JLabel;
    JLabel configRevData_JLabel;
    JLabel maxVLANData_JLabel;
    JLabel currVLANData_JLabel;
    JLabel lastModifData_JLabel;
    JLabel vtpV2_JLabel;
    JLabel vtpMode_JLabel;
    JLabel domainName_JLabel;
    JLabel vtpPass_JLabel;
    JLabel vtpPrun_JLabel;
    JComboBox vtpV2_JCombo;
    JComboBox vtpMode_JCombo;
    JComboBox vtpPrun_JCombo;
    JTextField domainName_JTextField;
    JTextField vtpPass_JTextField;
    JTable vtpVlan_JTable;
    VtpVlanTableModel vtpVlanTableModel;
    String vtpV2;
    String vtpMode;
    String vtpPrun;
    String domainName;
    String vtpPass;
    boolean dataModified = false;
    JLabel hostName_JLabel = new JLabel("Host Name:");
    JLabel hostName;
    JApplet theApplet;
    CommonSwitch[] switches;
    CommonSwitch theSwitch;
    int switchIndex;
    Thread tabThread;

    public VTPMgmt_JDialog(Frame frame, JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        super(frame);
        int n;
        this.theApplet = jApplet;
        this.switches = commonSwitchArray;
        this.theSwitch = commonSwitch;
        if (commonSwitch == null) {
            n = 0;
            while (n < commonSwitchArray.length) {
                if (commonSwitchArray[n].memberType.equals("CC") || commonSwitchArray[n].memberType.equals("AC")) {
                    commonSwitch = commonSwitchArray[n];
                    break;
                }
                ++n;
            }
        }
        if (commonSwitch == null) {
            commonSwitch = commonSwitchArray[0];
        }
        this.switchIndex = 0;
        n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n] == commonSwitch) {
                this.switchIndex = n;
                break;
            }
            ++n;
        }
        this.setTitle("VTP Management");
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        ((Component)this).setSize(473, 405);
        this.setVisible(false);
        this.deviceList_JPanel = new JPanel();
        this.deviceList_JPanel.setLayout(new FlowLayout(1, 5, 5));
        this.getContentPane().add("North", this.deviceList_JPanel);
        this.deviceList_JPanel.add(this.hostName_JLabel);
        this.devices_JCombo = new JComboBox();
        this.deviceList_JPanel.add(this.devices_JCombo);
        if (jApplet.getClass().getName().equalsIgnoreCase("DeviceManager")) {
            this.hostName = new JLabel("");
            this.hostName.setText(commonSwitchArray[0].switchName);
            this.deviceList_JPanel.add(this.hostName);
            this.devices_JCombo.setVisible(false);
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder(""));
        } else {
            this.deviceList_JPanel.setBorder(BorderFactory.createTitledBorder("Device List"));
        }
        int n2 = 0;
        while (n2 < commonSwitchArray.length) {
            if (commonSwitchArray[n2].getName().indexOf("C19") == -1 && commonSwitchArray[n2].getName().indexOf("C28") == -1 && commonSwitchArray[n2].enterpriseEdition) {
                this.devices_JCombo.addItem(commonSwitchArray[n2].switchName);
            }
            ++n2;
        }
        if (commonSwitch != null) {
            this.switchIndex = this.findDeviceIndex(commonSwitch.switchName);
            this.devices_JCombo.setSelectedItem(commonSwitch.switchName);
        } else {
            int n3 = 0;
            while (n3 < commonSwitchArray.length) {
                if (commonSwitchArray[n3].memberType.equals("CC") || commonSwitchArray[n3].memberType.equals("AC")) {
                    this.switchIndex = n3;
                    this.devices_JCombo.setSelectedItem(commonSwitchArray[n3].switchName);
                    break;
                }
                ++n3;
            }
        }
        this.vtpInfo_JPanel = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.vtpInfo_JPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 20, 5, 20);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.vtpVersion_JLabel = new JLabel("VTP Version:", 2);
        this.vtpVerData_JLabel = new JLabel("", 2);
        this.vtpVerData_JLabel.setForeground(Color.black);
        this.vtpInfo_JPanel.add((Component)this.vtpVersion_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.vtpInfo_JPanel.add((Component)this.vtpVerData_JLabel, gridBagConstraints);
        this.configRev_JLabel = new JLabel("Configuration Revision:", 2);
        this.configRevData_JLabel = new JLabel("", 2);
        this.configRevData_JLabel.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.vtpInfo_JPanel.add((Component)this.configRev_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.vtpInfo_JPanel.add((Component)this.configRevData_JLabel, gridBagConstraints);
        this.maxVLAN_JLabel = new JLabel("Maximum VLANs Supported Locally:", 2);
        this.maxVLANData_JLabel = new JLabel("", 2);
        this.maxVLANData_JLabel.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.vtpInfo_JPanel.add((Component)this.maxVLAN_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.vtpInfo_JPanel.add((Component)this.maxVLANData_JLabel, gridBagConstraints);
        this.currVLAN_JLabel = new JLabel("Number of Existing VLANs:", 2);
        this.currVLANData_JLabel = new JLabel("", 2);
        this.currVLANData_JLabel.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.vtpInfo_JPanel.add((Component)this.currVLAN_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.vtpInfo_JPanel.add((Component)this.currVLANData_JLabel, gridBagConstraints);
        this.lastModif_JLabel = new JLabel("Configuration Last Modified by:", 2);
        this.lastModifData_JLabel = new JLabel("", 2);
        this.lastModifData_JLabel.setForeground(Color.black);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.vtpInfo_JPanel.add((Component)this.lastModif_JLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.vtpInfo_JPanel.add((Component)this.lastModifData_JLabel, gridBagConstraints);
        this.vtpConfig_JPanel = new JPanel();
        this.vtpConfig_JPanel.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.vtpV2_JLabel = new JLabel("VTP V2 Mode:", 2);
        this.vtpConfig_JPanel.add((Component)this.vtpV2_JLabel, gridBagConstraints);
        Object[] objectArray = new Object[]{"Enabled", "Disabled"};
        this.vtpV2_JCombo = new JComboBox<Object>(objectArray);
        gridBagConstraints.gridx = 1;
        this.vtpConfig_JPanel.add((Component)this.vtpV2_JCombo, gridBagConstraints);
        this.vtpMode_JLabel = new JLabel("VTP Mode Control:", 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.vtpConfig_JPanel.add((Component)this.vtpMode_JLabel, gridBagConstraints);
        Object[] objectArray2 = new Object[]{"Server", "Client", "Transparent"};
        this.vtpMode_JCombo = new JComboBox<Object>(objectArray2);
        gridBagConstraints.gridx = 1;
        this.vtpConfig_JPanel.add((Component)this.vtpMode_JCombo, gridBagConstraints);
        this.vtpPrun_JLabel = new JLabel("VTP Pruning Mode:", 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.vtpConfig_JPanel.add((Component)this.vtpPrun_JLabel, gridBagConstraints);
        Object[] objectArray3 = new Object[]{"Enabled", "Disabled"};
        this.vtpPrun_JCombo = new JComboBox<Object>(objectArray3);
        gridBagConstraints.gridx = 1;
        this.vtpConfig_JPanel.add((Component)this.vtpPrun_JCombo, gridBagConstraints);
        if (commonSwitch.deviceType.indexOf("WS-C2950") != -1) {
            this.vtpPrun_JLabel.setVisible(false);
            this.vtpPrun_JCombo.setVisible(false);
        }
        this.domainName_JLabel = new JLabel("Domain Name:", 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.vtpConfig_JPanel.add((Component)this.domainName_JLabel, gridBagConstraints);
        this.domainName_JTextField = new JTextField();
        gridBagConstraints.gridx = 1;
        this.vtpConfig_JPanel.add((Component)this.domainName_JTextField, gridBagConstraints);
        this.vtpPass_JLabel = new JLabel("VTP Password:", 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        this.vtpConfig_JPanel.add((Component)this.vtpPass_JLabel, gridBagConstraints);
        this.vtpPass_JTextField = new JTextField();
        gridBagConstraints.gridx = 1;
        this.vtpConfig_JPanel.add((Component)this.vtpPass_JTextField, gridBagConstraints);
        this.tabThread = new Thread((Runnable)this, "tabTab");
        this.tabThread.start();
        this.vlanConfig_JPanel = new JPanel();
        this.vlanConfig_JPanel.setLayout(new BorderLayout());
        this.vtpVlanTableModel = new VtpVlanTableModel(commonSwitchArray, (String)this.devices_JCombo.getSelectedItem());
        this.vtpVlan_JTable = new JTable(this.vtpVlanTableModel);
        this.vtpVlan_JTable.setSelectionMode(0);
        this.vlanConfig_JPanel.add((Component)new JScrollPane(this.vtpVlan_JTable), "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.modify_JButton = new JButton("Modify ...");
        this.new_JButton = new JButton("New");
        this.remove_JButton = new JButton("Remove");
        jPanel.add(this.new_JButton);
        jPanel.add(this.modify_JButton);
        jPanel.add(this.remove_JButton);
        this.vlanConfig_JPanel.add((Component)jPanel, "South");
        this.modify_JButton.addActionListener(this);
        this.new_JButton.addActionListener(this);
        this.remove_JButton.addActionListener(this);
        this.vtp_TabbedPane = new JTabbedPane();
        this.vtp_TabbedPane.add("VTP Information", this.vtpInfo_JPanel);
        this.vtp_TabbedPane.add("VTP Configuration", this.vtpConfig_JPanel);
        this.vtp_TabbedPane.add("VLAN Configuration", this.vlanConfig_JPanel);
        this.getContentPane().add((Component)this.vtp_TabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(1, 5, 5));
        this.ok_JButton = new JButton("OK");
        this.apply_JButton = new JButton("Apply");
        this.cancel_JButton = new JButton("Cancel");
        this.help_JButton = new JButton("Help");
        this.ok_JButton.addActionListener(this);
        this.apply_JButton.addActionListener(this);
        this.cancel_JButton.addActionListener(this);
        this.help_JButton.addActionListener(this);
        jPanel2.add(this.ok_JButton);
        jPanel2.add(this.apply_JButton);
        jPanel2.add(this.cancel_JButton);
        jPanel2.add(this.help_JButton);
        this.getContentPane().add((Component)jPanel2, "South");
        this.devices_JCombo.addItemListener(this);
        this.vtpV2_JCombo.addItemListener(this);
        this.vtpMode_JCombo.addItemListener(this);
        this.vtpPrun_JCombo.addItemListener(this);
        this.domainName_JTextField.addActionListener(this);
        this.vtpPass_JTextField.addActionListener(this);
        KeyPressHandler keyPressHandler = new KeyPressHandler();
        this.domainName_JTextField.addKeyListener(keyPressHandler);
        this.vtpPass_JTextField.addKeyListener(keyPressHandler);
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(false);
    }

    public VTPMgmt_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray) {
        this(null, jApplet, commonSwitchArray, null);
    }

    public VTPMgmt_JDialog(JApplet jApplet, CommonSwitch[] commonSwitchArray, CommonSwitch commonSwitch) {
        this(null, jApplet, commonSwitchArray, commonSwitch);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok_JButton) {
            this.clickOK();
        } else if (object == this.cancel_JButton) {
            this.clickCancel();
        } else if (object == this.apply_JButton) {
            this.clickApply();
        } else if (object == this.help_JButton) {
            this.clickHelp();
        } else if (object == this.new_JButton) {
            this.clickNew();
        } else if (object == this.modify_JButton) {
            this.clickModify();
        } else if (object == this.remove_JButton) {
            this.clickRemove();
        } else if (object == this.devices_JCombo) {
            this.clickRemove();
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void clickApply() {
        this.setVtpConfigTab();
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(false);
        this.dataModified = false;
    }

    void clickCancel() {
        this.dispose();
    }

    void clickHelp() {
        HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"vtpwin");
    }

    void clickModify() {
        if (this.vtpMode.equals("Client")) {
            JOptionPane.showMessageDialog(this, "Cannot Modify VLAN when VTP Mode is <Client>.", "VTP VLAN Configuration", 0);
            return;
        }
        int[] nArray = this.vtpVlan_JTable.getSelectedRows();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select one VLAN to modify.", "VTP VLAN Configuration", 0);
            return;
        }
        if (nArray.length > 1) {
            JOptionPane.showMessageDialog(this, "Please select only one VLAN to modify.", "VTP VLAN Configuration", 0);
            return;
        }
        VTPMgmtNew_JDialog vTPMgmtNew_JDialog = new VTPMgmtNew_JDialog(this.switches, this, nArray[0]);
        vTPMgmtNew_JDialog.setModal(true);
        vTPMgmtNew_JDialog.show();
        this.vtpVlanTableModel.rebuildTable();
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
        this.dataModified = true;
    }

    void clickNew() {
        if (this.vtpMode.equals("Client")) {
            JOptionPane.showMessageDialog(this, "Cannot Create VLAN when VTP Mode is <Client>.", "VTP VLAN Configuration", 0);
            return;
        }
        VTPMgmtNew_JDialog vTPMgmtNew_JDialog = new VTPMgmtNew_JDialog(this.switches, this);
        vTPMgmtNew_JDialog.show();
        this.vtpVlanTableModel.rebuildTable();
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
        this.dataModified = true;
    }

    void clickOK() {
        this.clickApply();
        this.dispose();
    }

    void clickRemove() {
        if (this.vtpMode.equals("Client")) {
            JOptionPane.showMessageDialog(this, "Cannot Remove VLAN when VTP Mode is <Client>.", "VTP VLAN Configuration", 0);
            return;
        }
        int[] nArray = this.vtpVlan_JTable.getSelectedRows();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Please select one or more VLAN to remove.", "VTP VLAN Configuration", 0);
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.vtpVlanTableModel.getValueAt(nArray[n], 0);
            int n2 = new Integer(string);
            if (n2 == 1 || n2 == 1002 || n2 == 1003 || n2 == 1004 || n2 == 1005) {
                JOptionPane.showMessageDialog(this, "Default VLAN (1, 1002, 1003....) cannot be removed.", "VTP VLAN Configuration", 0);
                return;
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < nArray.length) {
            String string = (String)this.vtpVlanTableModel.getValueAt(nArray[nArray.length - 1 - n3], 0);
            this.switches[this.switchIndex].Cli.removeVtpVlan(this.switches[this.switchIndex].esn, string);
            this.vtpVlanTableModel.removeRow(nArray[nArray.length - 1 - n3]);
            ++n3;
        }
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
        this.dataModified = true;
    }

    void domainNamePasswordTextField_keyPressed() {
        try {
            this.apply_JButton.setEnabled(true);
        }
        catch (Exception exception) {}
    }

    int findDeviceIndex(String string) {
        int n = 0;
        while (n < this.switches.length) {
            if (this.switches[n].switchName.equals(string)) break;
            ++n;
        }
        return n;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.devices_JCombo) {
            if (this.dataModified) {
                int n = JOptionPane.showConfirmDialog(this, "Would you like to save the modified data before moving to another switch?", "VTP VLAN Configuration", 0);
                if (n == 0) {
                    this.clickApply();
                }
                this.ok_JButton.setEnabled(true);
                this.apply_JButton.setEnabled(false);
                this.dataModified = false;
            }
            JComboBox jComboBox = (JComboBox)object;
            String string = (String)jComboBox.getSelectedItem();
            int n = 0;
            while (n < this.switches.length) {
                if (this.switches[n].switchName.equals(string)) {
                    this.switchIndex = n;
                    break;
                }
                ++n;
            }
            if (this.switches[this.switchIndex].deviceType.indexOf("WS-C2950") != -1) {
                this.vtpPrun_JLabel.setVisible(false);
                this.vtpPrun_JCombo.setVisible(false);
            } else {
                this.vtpPrun_JLabel.setVisible(true);
                this.vtpPrun_JCombo.setVisible(true);
            }
            ((Component)this).setCursor(new Cursor(3));
            this.tabThread = new Thread((Runnable)this, "tabTab");
            this.tabThread.start();
            this.vtpVlanTableModel.setSelection(string);
            this.vtpVlan_JTable.sizeColumnsToFit(0);
            ((Component)this).setCursor(new Cursor(0));
            this.ok_JButton.setEnabled(true);
            this.apply_JButton.setEnabled(false);
            this.dataModified = false;
            return;
        }
        this.ok_JButton.setEnabled(true);
        this.apply_JButton.setEnabled(true);
        this.dataModified = true;
    }

    public static void main(String[] stringArray) {
    }

    public void run() {
        String string = this.switches[this.switchIndex].esn;
        Runnable runnable = new Runnable(){

            public void run() {
                VTPMgmt_JDialog.this.vtpVerData_JLabel.setText(VTPMgmt_JDialog.this.vtpVersion);
                VTPMgmt_JDialog.this.configRevData_JLabel.setText(VTPMgmt_JDialog.this.revision);
                VTPMgmt_JDialog.this.maxVLANData_JLabel.setText(VTPMgmt_JDialog.this.maxVlan);
                VTPMgmt_JDialog.this.currVLANData_JLabel.setText(VTPMgmt_JDialog.this.numOfVlan);
                VTPMgmt_JDialog.this.lastModifData_JLabel.setText(VTPMgmt_JDialog.this.lastMod);
                VTPMgmt_JDialog.this.ok_JButton.setEnabled(true);
                VTPMgmt_JDialog.this.apply_JButton.setEnabled(false);
                VTPMgmt_JDialog.this.dataModified = false;
            }
        };
        this.vtpVersion = this.switches[this.switchIndex].Cli.getVtpVersion(string);
        this.revision = this.switches[this.switchIndex].Cli.getVtpConfigRevision(string);
        this.maxVlan = this.switches[this.switchIndex].Cli.getMaxVlan(string);
        this.numOfVlan = this.switches[this.switchIndex].Cli.getNumOfVlan(string);
        this.lastMod = this.switches[this.switchIndex].Cli.getVtpLastModified(string);
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {}
        Runnable runnable2 = new Runnable(){

            public void run() {
                if (VTPMgmt_JDialog.this.vtpV2.equals("Enabled")) {
                    VTPMgmt_JDialog.this.vtpV2_JCombo.setSelectedItem("Enabled");
                } else {
                    VTPMgmt_JDialog.this.vtpV2_JCombo.setSelectedItem("Disabled");
                }
                if (VTPMgmt_JDialog.this.vtpMode.equals("Server")) {
                    VTPMgmt_JDialog.this.vtpMode_JCombo.setSelectedItem("Server");
                } else if (VTPMgmt_JDialog.this.vtpMode.equals("Client")) {
                    VTPMgmt_JDialog.this.vtpMode_JCombo.setSelectedItem("Client");
                } else if (VTPMgmt_JDialog.this.vtpMode.equals("Transparent")) {
                    VTPMgmt_JDialog.this.vtpMode_JCombo.setSelectedItem("Transparent");
                }
                if (VTPMgmt_JDialog.this.vtpMode.equals("Client")) {
                    VTPMgmt_JDialog.this.new_JButton.setEnabled(false);
                    VTPMgmt_JDialog.this.modify_JButton.setEnabled(false);
                    VTPMgmt_JDialog.this.remove_JButton.setEnabled(false);
                    VTPMgmt_JDialog.this.domainName_JTextField.setEnabled(false);
                    VTPMgmt_JDialog.this.vtpPass_JTextField.setEnabled(false);
                    VTPMgmt_JDialog.this.vtpV2_JCombo.setEnabled(false);
                    VTPMgmt_JDialog.this.vtpPrun_JCombo.setEnabled(false);
                } else {
                    VTPMgmt_JDialog.this.new_JButton.setEnabled(true);
                    VTPMgmt_JDialog.this.modify_JButton.setEnabled(true);
                    VTPMgmt_JDialog.this.remove_JButton.setEnabled(true);
                    VTPMgmt_JDialog.this.domainName_JTextField.setEnabled(true);
                    VTPMgmt_JDialog.this.vtpPass_JTextField.setEnabled(true);
                    VTPMgmt_JDialog.this.vtpV2_JCombo.setEnabled(true);
                    VTPMgmt_JDialog.this.vtpPrun_JCombo.setEnabled(true);
                }
                if (VTPMgmt_JDialog.this.vtpPrun.equals("Enabled")) {
                    VTPMgmt_JDialog.this.vtpPrun_JCombo.setSelectedItem("Enabled");
                } else {
                    VTPMgmt_JDialog.this.vtpPrun_JCombo.setSelectedItem("Disabled");
                }
                VTPMgmt_JDialog.this.domainName_JTextField.setText(VTPMgmt_JDialog.this.domainName);
                VTPMgmt_JDialog.this.ok_JButton.setEnabled(true);
                VTPMgmt_JDialog.this.apply_JButton.setEnabled(false);
                VTPMgmt_JDialog.this.dataModified = false;
            }
        };
        this.vtpV2 = this.switches[this.switchIndex].Cli.getVtpV2mode(string);
        this.vtpMode = this.switches[this.switchIndex].Cli.getVtpMode(string);
        this.vtpPrun = this.switches[this.switchIndex].Cli.getVtpPruningMode(string);
        this.domainName = this.switches[this.switchIndex].Cli.getVtpDomain(string);
        try {
            SwingUtilities.invokeAndWait(runnable2);
            if (this.switches[this.switchIndex].deviceType.indexOf("WS-C2950") != -1) {
                this.vtpPrun_JCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    void setVtpConfigTab() {
        String string;
        String string2;
        String string3;
        String string4 = this.switches[this.switchIndex].esn;
        String string5 = (String)this.vtpV2_JCombo.getSelectedItem();
        if (!string5.equals(this.vtpV2)) {
            this.switches[this.switchIndex].Cli.setVtpV2mode(string4, string5);
            this.vtpV2 = string5;
        }
        if (!(string3 = (String)this.vtpMode_JCombo.getSelectedItem()).equals(this.vtpMode)) {
            this.switches[this.switchIndex].Cli.setVtpMode(string4, string3);
            this.vtpMode = string3;
        }
        if (this.vtpMode.equals("Client")) {
            this.new_JButton.setEnabled(false);
            this.modify_JButton.setEnabled(false);
            this.remove_JButton.setEnabled(false);
            this.domainName_JTextField.setEnabled(false);
            this.vtpPass_JTextField.setEnabled(false);
            this.vtpV2_JCombo.setEnabled(false);
            this.vtpPrun_JCombo.setEnabled(false);
        } else {
            this.new_JButton.setEnabled(true);
            this.modify_JButton.setEnabled(true);
            this.remove_JButton.setEnabled(true);
            this.domainName_JTextField.setEnabled(true);
            this.vtpPass_JTextField.setEnabled(true);
            this.vtpV2_JCombo.setEnabled(true);
            this.vtpPrun_JCombo.setEnabled(true);
        }
        String string6 = (String)this.vtpPrun_JCombo.getSelectedItem();
        if (!string6.equals(this.vtpPrun)) {
            this.switches[this.switchIndex].Cli.setVtpPruningMode(string4, string6);
            this.vtpPrun = string6;
        }
        if (!(string2 = this.domainName_JTextField.getText()).equals(this.domainName)) {
            this.switches[this.switchIndex].Cli.setVtpDomain(string4, string2);
            this.domainName = string2;
        }
        if (!(string = this.vtpPass_JTextField.getText()).equals("")) {
            this.switches[this.switchIndex].Cli.setVtpPassword(string4, string);
        }
    }

    class KeyPressHandler
    extends KeyAdapter {
        KeyPressHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            Object object = keyEvent.getSource();
            if (object == VTPMgmt_JDialog.this.domainName_JTextField || object == VTPMgmt_JDialog.this.vtpPass_JTextField) {
                VTPMgmt_JDialog.this.domainNamePasswordTextField_keyPressed();
            }
        }
    }
}

