/*
 * Decompiled with CFR 0.152.
 */
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class PortConfigTableModel
extends DefaultTableModel
implements Runnable {
    CommonSwitch[] switches;
    PortConfig_JDialog configDialog;
    static final String[] columnName = new String[]{"Interface", "Status", "Ethernet Link", "Duplex", "Duplex", "Speed", "Speed", "Port Fast", "Description", "Flow Control", "802.1p Priority", "Power", "Power", "LRE Profile", "LRE Link", "LRE Upstream", "LRE Downstream", "Flow Control"};
    static String LONG_REACH_ETHERNET = "Long";
    String selection;
    int index;
    boolean support802;
    boolean supportTel;
    boolean supportVDSL;
    boolean supportFlowControl;
    static final int INTERFACE = 0;
    static final int ADMIN_STATUS = 1;
    static final int ACT_STATUS = 2;
    static final int ADMIN_DUPLEX = 3;
    static final int ACT_DUPLEX = 4;
    static final int ADMIN_SPEED = 5;
    static final int ACT_SPEED = 6;
    static final int PORT_FAST = 7;
    static final int PORT_NAME = 8;
    static final int FLOW_CONTROL = 9;
    static final int IEEE8021P = 10;
    static final int ADMIN_POWER = 11;
    static final int ACT_POWER = 12;
    static final int VDSL_PROFILE = 13;
    static final int VDSL_STATUS = 14;
    static final int VDSL_USTREAM = 15;
    static final int VDSL_DSTREAM = 16;
    static final int ACT_FLOW_CONTROL = 17;
    static final int TOTAL_COLUMNS = 17;
    String[] interfaceNames;
    int numOfPorts;
    Thread portConfigThread;
    String[] status;
    String[] statusAct;
    String[] duplex;
    String[] duplexAct;
    String[] speed;
    String[] speedAct;
    String[] portFast;
    String[] portDescription;
    String[] flowControl;
    String[] flowControlAct;
    String[] priority8021p;
    String[] power;
    String[] powerAct;
    String[] vdslProfile;
    String[] vdslStatus;
    String[] vdslUStream;
    String[] vdslDStream;
    static /* synthetic */ Class class$java$lang$String;

    public PortConfigTableModel(PortConfig_JDialog portConfig_JDialog, CommonSwitch[] commonSwitchArray, String string) {
        this.configDialog = portConfig_JDialog;
        this.switches = commonSwitchArray;
        this.selection = string;
        int n = 0;
        while (n < commonSwitchArray.length) {
            if (commonSwitchArray[n].switchName.equals(string)) {
                this.index = n;
                break;
            }
            ++n;
        }
        if (commonSwitchArray[this.index].support802Dot1p()) {
            this.support802 = true;
        }
        if (commonSwitchArray[this.index].supportTel()) {
            this.supportTel = true;
        }
        if (commonSwitchArray[this.index].supportFlowControl()) {
            this.supportFlowControl = true;
        }
        int n2 = 0;
        while (n2 < columnName.length) {
            this.addColumn(columnName[n2]);
            ++n2;
        }
        String string2 = commonSwitchArray[this.index].esn;
        this.interfaceNames = commonSwitchArray[this.index].Cli.getPortName(string2);
        if (this.interfaceNames == null) {
            return;
        }
        if (this.interfaceNames.length == 0) {
            return;
        }
        this.numOfPorts = this.interfaceNames.length;
        int n3 = 0;
        while (n3 < this.numOfPorts) {
            Object[] objectArray = new Object[17];
            objectArray[0] = this.interfaceNames[n3];
            this.addRow(objectArray);
            ++n3;
        }
        this.portConfigThread = new Thread((Runnable)this, "portConfig");
        this.portConfigThread.start();
    }

    private void adjustAdminSpeeds(String[] stringArray, String[] stringArray2) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("Gig") && this.switches[this.index].deviceType.indexOf("WS-C2950") == -1) {
                stringArray2[n] = "1000";
            }
            ++n;
        }
    }

    private void adjustPortSpeeds(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("Gig")) {
                stringArray3[n] = stringArray2[n].equals("UP") ? "1000" : "NA";
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void fillColumn(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < this.numOfPorts) {
            this.setValueAt(objectArray[n2], n2, n);
            ++n2;
        }
    }

    private void fillColumnForInterface(Object[] objectArray, int n, String string) {
        int n2 = -1;
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < this.numOfPorts) {
            if (this.interfaceNames[n4].indexOf(string) != -1) {
                n2 = n4;
                break;
            }
            this.setValueAt("NA", n4, n);
            ++n4;
        }
        if (n2 == -1) {
            return;
        }
        int n5 = n2 + n3;
        int n6 = n2;
        int n7 = 0;
        while (n6 < n5) {
            this.setValueAt(objectArray[n7], n6, n);
            ++n6;
            ++n7;
        }
        if (n5 < this.numOfPorts) {
            int n8 = n5;
            while (n8 < this.numOfPorts) {
                this.setValueAt("NA", n8, n);
                ++n8;
            }
        }
    }

    private String[] getActualFlowcontrol(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = stringArray[n2].lastIndexOf(",");
            stringArray2[n2] = n != -1 ? stringArray[n2].substring(n + 1) : stringArray[n2];
            n = -1;
            ++n2;
        }
        return stringArray2;
    }

    private String[] getAdminFlowcontrol(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = -1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            n = stringArray[n2].lastIndexOf(",");
            stringArray2[n2] = n != -1 ? stringArray[n2].substring(0, n) : stringArray[n2];
            n = -1;
            ++n2;
        }
        return stringArray2;
    }

    public Class getColumnClass(int n) {
        Vector vector = this.dataVector.elementAt(0);
        if (vector.elementAt(n) == null) {
            return class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PortConfigTableModel.class$("java.lang.String"));
        }
        return vector.elementAt(n).getClass();
    }

    public String getColumnName(int n) {
        return columnName[n];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void run() {
        this.configDialog.setWaitingCursor();
        this.configDialog.configTable.setEnabled(false);
        this.configDialog.actualTable.setEnabled(false);
        String string = this.switches[this.index].esn;
        this.portDescription = this.switches[this.index].Cli.getAllPortDescription(string);
        this.fillColumn(this.portDescription, 8);
        this.status = this.switches[this.index].Cli.getAllPortStatus(string);
        int n = 0;
        while (n < this.status.length) {
            this.status[n] = this.status[n].equalsIgnoreCase("checked") ? "Enabled" : "Disabled";
            ++n;
        }
        this.fillColumn(this.status, 1);
        if (this.switches[this.index].supportVDSL()) {
            this.vdslUStream = this.switches[this.index].Cli.getAllVdslUsRates(string);
            this.fillColumnForInterface(this.vdslUStream, 15, LONG_REACH_ETHERNET);
            this.vdslDStream = this.switches[this.index].Cli.getAllVdslDsRates(string);
            this.fillColumnForInterface(this.vdslDStream, 16, LONG_REACH_ETHERNET);
        }
        this.duplex = this.switches[this.index].Cli.getAllPortDuplex(string);
        this.fillColumn(this.duplex, 3);
        this.speed = this.switches[this.index].Cli.getAllPortSpeed(string);
        this.adjustAdminSpeeds(this.interfaceNames, this.speed);
        this.fillColumn(this.speed, 5);
        this.portFast = this.switches[this.index].Cli.getAllPortFastStatus(string);
        int n2 = 0;
        while (n2 < this.portFast.length) {
            this.portFast[n2] = this.portFast[n2].equalsIgnoreCase("checked") ? "Enabled" : "Disabled";
            ++n2;
        }
        this.fillColumn(this.portFast, 7);
        if (this.support802) {
            this.priority8021p = this.switches[this.index].Cli.getAllPort8021pPriority(string);
            this.fillColumn(this.priority8021p, 10);
        }
        if (this.supportFlowControl) {
            this.flowControl = this.switches[this.index].Cli.getAllPortFlowControl(string);
            this.fillColumn(this.getAdminFlowcontrol(this.flowControl), 9);
            this.flowControlAct = this.getActualFlowcontrol(this.flowControl);
            this.fillColumn(this.flowControlAct, 17);
        }
        if (this.switches[this.index].supportTel()) {
            this.power = this.switches[this.index].Cli.getAllPortPower(string);
            this.fillColumn(this.power, 11);
        }
        if (this.switches[this.index].supportVDSL()) {
            this.vdslStatus = this.switches[this.index].Cli.getAllVdslLinkStates(string);
            this.fillColumnForInterface(this.vdslStatus, 14, LONG_REACH_ETHERNET);
        }
        this.statusAct = this.switches[this.index].Cli.getAllPortStatusActual(string);
        this.fillColumn(this.statusAct, 2);
        this.duplexAct = this.switches[this.index].Cli.getAllPortDuplexActual(string);
        this.fillColumn(this.duplexAct, 4);
        this.speedAct = this.switches[this.index].Cli.getAllPortSpeedActual(string);
        this.adjustPortSpeeds(this.interfaceNames, this.statusAct, this.speedAct);
        this.fillColumn(this.speedAct, 6);
        if (this.switches[this.index].supportTel()) {
            this.powerAct = this.switches[this.index].Cli.getAllPortPowerActual(string);
            this.fillColumn(this.powerAct, 12);
        }
        this.configDialog.setDefaultCursor();
        this.configDialog.configTable.setEnabled(true);
        this.configDialog.actualTable.setEnabled(true);
    }

    public void sortByModelIndex(int n, boolean bl) {
        SorterComparator sorterComparator = new SorterComparator(n, bl);
        Vector<Vector> vector = this.getDataVector();
        Collections.sort(vector, sorterComparator);
        this.fireTableDataChanged();
    }

    void updatePort8021p(String string, String string2) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)this.getValueAt(n2, 0);
            if (string3.equals(string)) {
                this.setValueAt(string2, n2, 10);
                return;
            }
            ++n2;
        }
    }

    void updatePortDescription(String string, String string2) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)this.getValueAt(n2, 0);
            if (string3.equals(string)) {
                this.setValueAt(string2, n2, 8);
                return;
            }
            ++n2;
        }
    }

    void updatePortDuplex(String string, String string2, String string3) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)this.getValueAt(n2, 0);
            if (string4.equals(string)) {
                this.setValueAt(string2, n2, 3);
                this.setValueAt(string3, n2, 4);
                return;
            }
            ++n2;
        }
    }

    void updatePortFast(String string, String string2) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)this.getValueAt(n2, 0);
            if (string3.equals(string)) {
                this.setValueAt(string2, n2, 7);
                return;
            }
            ++n2;
        }
    }

    void updatePortFlowControl(String string, String string2) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string3 = (String)this.getValueAt(n2, 0);
            if (string3.equals(string)) {
                this.setValueAt(string2, n2, 9);
                return;
            }
            ++n2;
        }
    }

    void updatePortPower(String string, String string2, String string3) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)this.getValueAt(n2, 0);
            if (string4.equals(string)) {
                this.setValueAt(string2, n2, 11);
                this.setValueAt(string3, n2, 12);
                return;
            }
            ++n2;
        }
    }

    void updatePortSpeed(String string, String string2, String string3) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)this.getValueAt(n2, 0);
            if (string4.equals(string)) {
                this.setValueAt(string2, n2, 5);
                this.setValueAt(string3, n2, 6);
                return;
            }
            ++n2;
        }
    }

    void updatePortStatus(String string, String string2, String string3) {
        int n = this.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string4 = (String)this.getValueAt(n2, 0);
            if (string4.equals(string)) {
                this.setValueAt(string2, n2, 1);
                this.setValueAt(string3, n2, 2);
                return;
            }
            ++n2;
        }
    }

    class SorterComparator
    implements Comparator {
        private int colIndex;
        private boolean isAsc;
        private int result = 0;

        public SorterComparator(int n, boolean bl) {
            this.colIndex = n;
            this.isAsc = bl;
        }

        public int compare(Object object, Object object2) {
            Vector vector = (Vector)object;
            Vector vector2 = (Vector)object2;
            String string = (String)vector.get(this.colIndex);
            String string2 = (String)vector2.get(this.colIndex);
            switch (this.colIndex) {
                case 0: {
                    int n = string.indexOf(47);
                    int n2 = string2.indexOf(47);
                    if (n == -1 || n2 == -1) {
                        this.result = string.compareTo(string2);
                        break;
                    }
                    this.result = string.substring(0, n).compareTo(string2.substring(0, n2));
                    if (this.result != 0) break;
                    String string3 = string.substring(n + 1);
                    String string4 = string2.substring(n2 + 1);
                    try {
                        this.result = Integer.parseInt(string3) - Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.result = string3.compareTo(string4);
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 17: {
                    this.result = string.compareTo(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 15: 
                case 16: {
                    boolean bl = false;
                    Float f = null;
                    Float f2 = null;
                    try {
                        f = new Float(string);
                        f2 = new Float(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = true;
                    }
                    if (bl) {
                        this.result = string.compareTo(string2);
                        break;
                    }
                    this.result = f.compareTo(f2);
                    break;
                }
            }
            if (!this.isAsc) {
                this.result = -this.result;
            }
            return this.result;
        }
    }
}

