/*
 *------------------------------------------------------------------
 * fpv.js
 *
 * Copyright (c) 2005 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */
// Device constructor
function device() {
	this.name = "Switch";	// the host name
	this.type = "";			// the model
	this.noofports = 0;		// number of ports 
	this.x=0;				// device xcoordinate in the FPV area
	this.y=0;				// device ycoordinate in FPV area
	this.modes = new Array();	// list of modes supported by the device
	this.modeAliases = new Array();	// The mode string that should be displayed in the mode combo-box
	this.ports = new Array();	// list of ports
	this.labels = new Array();   // list of labels
	this.sysleds = new Array();	// list of system LEDs
	this.portLeds = new Array();	// list of port LEDs
	this.portDescrs = new Array();	// port description
	this.upTime = "";		// upTime of the device.
	this.ipAddress = "";		// ipAddress of the device
	this.macAddress = "";	// mac Address of device
	this.swVersion = "";		// running software version
	this.serialNo = "";		// serial number of the device
	this.hardLeds = new Array();	// The led details poarsed from show hardware led
	this.setMode = _setMode;		// the method to set the current selected mode
	this.refresh = _refreshDevice;	// the method to refresh the device details in FPV
	this.draw = _drawDevice;			// the method to create the string form which represents the device in HTML
	this.addPort = _addPortToDevice;	// the method to add a portto the port list.
	this.addLabel = _addLabelToDevice;	// the method to add a label to the label list.
}

// the setmode method for device
function _setMode(mode, frame) {
	if(frame == null) frame = top.topFrame.document;
	var x;
	for(x in this.modes) {
		var y = this.modes[x];		
		if(this.sysleds[y]) {
			if(y == mode) {
				this.sysleds[y].color = "GREEN";
			} else {
				this.sysleds[y].color = "BLACK";
			}
		}
	}
	for (i =0; i < this.ports.length; i++) {
		this.ports[i].color = this.hardLed[mode][i];
	}
	this.refresh(frame);
}

// the addPort method of devcie
function _addPortToDevice(port) {
	port.device = this;
	this.ports[this.ports.length] = port;
}

// method to add the labels to the device.
function _addLabelToDevice(label) {
	label.device = this;
	this.labels[this.labels.length] = label;
}

// the refresh method of devcie
function _refreshDevice(frame) {
	for (i =0; i < this.ports.length; i++) {
		this.ports[i].refresh(frame);
	}
	var sysled;
	for (sysled in this.sysleds) {
		this.sysleds[sysled].refresh(frame);
	}	
	for (var i=0; i < this.labels.length; i++) {
		this.labels[i].refresh(frame);
	}
}

// the draw method of device
function _drawDevice() {
	var str = "<img id='"+ this.id +"' style='position:absolute; left:" + this.x +"px; top:" + this.y + "px; z-index:300'";
	str += " src='" + this.image + "' name='" + this.name +"' border='0'>";
	return str;
}

// Mode button constructor
function modebtn(modeImage) {
	this.name = "";
	this.x = 0;
	this.y = 0;
	this.id = "";
	this.device = "";
	this.index = 0;
	this.image = modeImage;
	this.draw = _drawModeBtn;
}

// the draw method for mode button
function _drawModeBtn() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px;" 
	str += " cursor: pointer; cursor: hand; z-index:400' src=" + this.image + " name='" + this.id +"' border='0' onClick='updateDisplayMode();'";
	if(this.height)
		str += " width='" + this.width + "' height='" + this.height + "'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "&quot;].style.left=" + (this.device.x + this.x) + ";'";
	str += " title='Click this button to select a different Mode'>";
	return str;
}

// LED constructor
function led(ledImages) {
	this.name = "";		// name of the led
	this.x = 0;			// the xcoordinate of the led in FPV area
	this.y = 0;			// the ycoordinate of the led in FPV area
	this.id = "";		// the id to identify the image in the FPV
	this.color = "BLACK";	// the current color of led
	this.descr = "";		// the description // TBD: do we need this ?
	this.device = "";		// the device this led belongs to
	this.width = 7;			// Width of the LED image
	this.height = 3;		// Height of the LED image
	this.tooltip = "";
	this.images = ledImages;	// the images to be used to represent in different colors
	this.draw = _drawLed;	// the method to create the string form which represents the led in HTML
	this.refresh = _refreshLed;	// the method to refresh the port details in FPV
}

// refresh method of led
function _refreshLed(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
}

// draw method of led
function _drawLed() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showLedTooltip(&quot;" + this.tooltip + "&quot;);'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);'>";
	return str;
}
var ledImgs = null
// method to create the led images.
function ledImages() {
	if(ledImgs != null) return ledImgs;
	ledImgs = new frmWrkPortImages();
	ledImgs.img["BLACK"].src = "images/led_gray.gif";
	ledImgs.img["GREEN"].src = "images/led_green.gif";
	ledImgs.img["CYAN"].src = "images/led_cyan.gif";
	ledImgs.img["BROWN"].src = "images/led_brown.gif";
	ledImgs.img["YELLOW"].src = "images/led_yellow.gif";
	ledImgs.img["AMBER"].src = "images/led_amber.gif";
	ledImgs.img["BLINKGREEN"].src = "images/led_blinkgreen.gif";
	ledImgs.img["ALT_GREEN_BLACK"].src = "images/led_blinkgreen.gif";
	ledImgs.img["ALT_AMBER_BLACK"].src = "images/led_blinkamber.gif";
	ledImgs.img["BLINKGREEN_AMBER"].src = "images/led_blinkgreen_amber.gif";
	ledImgs.img["ALT_GREEN_AMBER"].src = "images/led_blinkgreen_amber.gif";
	ledImgs.img["BLINKAMBER"].src = "images/led_blinkamber.gif";
	return ledImgs;
}

// unknownDevice constructor
function unknownDevice() {
	var dev = new device();
	dev.draw = _drawUnknownDevice;
	return dev;
}

// draw method of unknownDevice
function _drawUnknownDevice() {
	var str = '<table align="center" bgcolor="#DADADA" width="100%" height="100%"><tr><td height="80" align="center" valign="middle" class="fpvcontentbold">Unsupported Device</td></tr></table>';
	return str;
}

function label(x, y, width, height, text) {
	this.x = x;
	this.y = y;
	this.width = width;
	this.height = height;
	this.text = "";
	if(text != null) 
		this.text = text;
	this.id = "";
	this.fontfamily = "Verdana, Arial, Helvetica, sans-serif";
	this.fontsize = "8pt";
	this.color = "#000000";
	this.device = null;
	this.draw = _drawLabel;
	this.refresh = _refreshLabel;
}

function _drawLabel() {
	var str = "<div id='"+ this.id +"' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px;";
	str += " width:" + this.width + "px; height=:" + this.height + "px; overflow: hidden; vertical-align: middle; font-family: " + this.fontfamily + ";";
	str += " font-size: " + this.fontsize + "; color: " + this.color + "; z-index:800;'>" + this.text + "</div>";
	return str;
}

function _refreshLabel(frame) {
	if(top.topFrame && top.topFrame.set_layercontent) {
		top.topFrame.set_layercontent(this.id, this.text);
	} else {
		frame.getElementById(this.id).innerHTML = this.text;
	}
}

// Ports constructor
function port(portImages) {
	this.name = "";	// the port name eg. Fastethernet0/1
	this.x = 0;		// the xcoordinate of the port 
	this.y = 0;		// the ycoordinate of the port
	this.id = "";	// the id which will be used to identify the port image object in FPV
	this.index = 0;	// the port index respective to the device
	this.color = "BLACK";	// the color code which used to display the image according to ports state
	this.descr = "";		// the port description, specified by the user.
	this.device = "";		// the device this port belongs to
	this.images = portImages;	// the list of images which will be used to display the status in different mode
	this.width = 19;		// the width of the port image; the default value is 19
	this.height = 15;		// the height of the port image; the default value is 15
	this.draw = _drawPort;		// the method to create the string form which represents the port in HTML
	this.refresh = _refreshPort;	// the method to refresh the port details in FPV
	this.setImage = _setImagePort;	// the method to change the image displayed for the port.
}

// the refresh method of port
function _refreshPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
}

// setImage method of port
function _setImagePort(image, frame) {
	frame.images[this.id].src = image;
}

// the draw method for port
function _drawPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ");'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);'>";
	return str;
}

function hbport(portImages, cType) {
	var p = new port(portImages);
	p.width = 11;		// the width of the port image; the default value is 11
	p.height = 11;		// the height of the port image; the default value is 11
	if(cType != null) {
		p.connType = cType;
	}
	return p;
}

// the RJ45 Port constructor
function rj45port(portImages) {
	var p = new port(portImages);
	return p;
}

// the inverted RJ45 Port constructor
function rj45portInv(portImages) {
	var p = new port(portImages);
	return p;
}

// the internalport constructor
function internalport(portImages) {
   var p = new port(portImages);
   return p;
}

// the sidePort constructor
function rj45portSide(portImages) {
   var p = new port(portImages);
   return p;
}

// the FX Port constructor
function fxport(portImages) {
	var p = new port(portImages);
	return p;
}

// the GBIC port constructor
// the images and other characteristics will change according to the connector plugged in
function GBICport(cType, images) {
	var p = new port(images);
	if (cType.indexOf ("1000BaseCX") != -1) {
		// construct GBIC Razor port
		p.images = GBIC_RazorImages();
		p.draw = _drawRazorPort;
		p.refresh = _refreshRazorPort;
		p.setImage = _setImageRazorPort;
		p.leftImg = GBIC_RazorConnectorImages();		
		p.rightImg = p.leftImg;
		p.connWidth = 14;
		p.connHeight = 9;
	} else if (cType.indexOf ("1000BaseTX") != -1) {
		// construct GBIC-T port
		p.images = GBIC_TImages();
	} else if (cType.indexOf ("1000BaseSX") != -1) {
		// construct GBIC SX port
		p.images = GBIC_FiberImages();
	} else if (cType.indexOf ("1000BaseLX") != -1) {
		// construct GBIC LX port
		p.images = GBIC_FiberImages();
	} else if (cType.indexOf ("1000BaseZX") != -1) {
		// construct GBIC ZX port
		p.images = GBIC_FiberImages();
	} else if (cType.toUpperCase().indexOf("10GBASE") != -1) {
		// construct GBIC 10Gig port
		p.images = GBIC_10GImages();
	} else if (cType.indexOf ("CWDM") != -1) {
		// construct GBIC CWDM port
		p.images = GBIC_CWDMImages();
		p.draw = _drawGBICCWDMPort;
		p.refresh = _refreshGBICCWDMPort;
		p.setImage = _setImageGBICCWDMPort;
		p.cwdmImages = GBIC_CWDMColorCodeImages();
	} else if (cType.indexOf ("DWDM") != -1) {
		// construct GBIC SX port
		p.images = GBIC_DWDMImages();
	} else if (cType.indexOf("unknown") != -1) {
		// construct GBIC Empty port
		p.images = GBIC_EmptyImages();
	} else {
		// All other type will be treated as Empty slot
		// construct GBIC Empty port
		p.images = GBIC_EmptyImages();
	}
	p.width = 36;
	p.height = 18;
	p.connType = cType;
	return p;
}

// refresh method for GBIC Razor port
function _refreshRazorPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
	frame.images[this.id + "_left"].src = this.leftImg.img[this.color].src;
	frame.images[this.id + "_right"].src = this.rightImg.img[this.color].src;
}

// setImage method for GBIC Razor port
function _setImageRazorPort(image, frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_left"].src = 'images/spacer.gif';
	frame.images[this.id + "_right"].src = 'images/spacer.gif';
}

// draw method for GBIC Razor port
function _drawRazorPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 4) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 21) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 3) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 20) +";'>";

	str += "<img id='"+ this.id +"_id_left' style='position:absolute; left:" + (this.device.x + this.x + 3) +"px; top:" + (this.device.y + this.y + 5) + "px; z-index:500'";
	str += " width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_left' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 4) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 21) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 3) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 20) +";'>";

	str += "<img id='"+ this.id +"_id_right' style='position:absolute; left:" + (this.device.x + this.x + 20) +"px; top:" + (this.device.y + this.y + 5) + "px; z-index:500'";
	str += " width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_right' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 4) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 6) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 21) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_left&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_left&quot;].style.left=" + (this.device.x + this.x + 3) +";";
	str += "document.images[&quot;" + this.id + "_right&quot;].style.top=" + (this.device.y + this.y + 5) +";document.images[&quot;" + this.id + "_right&quot;].style.left=" + (this.device.x + this.x + 20) +";'>";

	return str;
}

// refresh method for GBIC CWDM port
function _refreshGBICCWDMPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
	if(!this.cwdmImages[this.connType])
		this.connType = "other";
	frame.images[this.id + "_color"].src = this.cwdmImages[this.connType].src;
}

// setImage method for GBIC CWDM port
function _setImageGBICCWDMPort(image, frame) {
	frame.images[this.id].src = image;	
	frame.images[this.id + "_color"].src = 'images/spacer.gif';
}

// draw method for GBIC CWDM port
function _drawGBICCWDMPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	str += "<img id='"+ this.id +"_id_color' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:500'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"_color' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	return str;
}

// SFP port constructor
function SFPport(cType, images) {
	var p = new port(images);
	if (cType.indexOf ("1000BaseTX") != -1) {
		// construct SFP-T port
		p.images = SFP_TImages();
	} else if (cType.indexOf ("1000BaseSX") != -1) {
		// construct SFP-SX port
		p.images = SFP_SXImages();
	} else if (cType.indexOf ("1000BaseLX") != -1) {
		// construct SFP-LX port
		p.images = SFP_LXImages();
	} else if (cType.indexOf ("1000BaseZX") != -1) {
		// construct SFP-ZX port
		p.images = SFP_ZXImages();
	} else if (cType.indexOf ("1000BaseCX") != -1) {
                // construct SFP-CX port
                p.images = SFP_CXImages();
	} else if (cType.indexOf ("1000BaseBX") != -1) {
                p.images = SFP_BXImages();
	} else if (cType.indexOf ("100BaseBX-10D") != -1) {//Though 100BaseBX-10D SFP looks different, we intentionaly dsiplay the old SFPs only
                p.images = SFP_BXImages();
	} else if (cType.indexOf ("100BaseLX") != -1) {
		p.images = SFP_LXImages();
	} else if (cType.indexOf ("CWDM") != -1) {
		// construct SFP-CWDM port
		p.images = SFP_CWDMImages();
		p.draw = _drawSFPCWDMPort;
		p.refresh = _refreshSFPCWDMPort;
		p.setImage = _setImageSFPCWDMPort;
		p.cwdmImages = SFP_CWDMColorCodeImages();
	} else if (cType.indexOf ("100BaseFX SFP") != -1) {
		// construct SFP-FX100 port
		p.images = SFP_100FXImages();
	} else if (cType.indexOf ("100BaseFX-FE") != -1) {
		p.images = SFP_100FXImages();
	} else if (cType.indexOf("unknown") != -1) {
		// construct Empty port
		p.images = SFP_EmptyImages();
	} else {
	  	// any other type is considered as Empty	
		// construct Empty SFP port
		p.images = SFP_EmptyImages();
	}
	p.width = 21;
	p.height = 16;
	p.connType = cType;
	return p;
}


// SFP side port constructor
function SFPsideport(cType, images) {
	var p = new port(images);
	if (cType.indexOf ("1000BaseTX") != -1) {
		// construct side SFP-T port
		p.images = SFP_side_TImages();
	} else if (cType.indexOf ("1000BaseSX") != -1) {
		// construct side SFP-SX port
		p.images = SFP_side_SXImages();
	} else if (cType.indexOf ("1000BaseLX") != -1) {
		// construct side SFP-LX port
		p.images = SFP_side_LXImages();
	} else if (cType.indexOf ("1000BaseZX") != -1) {
		// construct side SFP-ZX port
		p.images = SFP_side_ZXImages();
	} else if (cType.indexOf ("1000BaseBX") != -1) {
                p.images = SFP_side_BXImages();
	} else if (cType.indexOf ("100BaseBX-10D") != -1) {
                p.images = SFP_side_BXImages();
	} else if (cType.indexOf ("100BaseLX") != -1) {
		p.images = SFP_side_LXImages();
	} else if (cType.indexOf ("CWDM") != -1) {
		//NOTE:For side ports this sector need to be changed
		// construct side SFP-CWDM port
		p.images = SFP_side_CWDMImages();
		p.draw = _drawSFPCWDMPort;
		p.refresh = _refreshSFPCWDMPort;
		p.setImage = _setImageSFPCWDMPort;
		p.cwdmImages = SFP_side_CWDMColorCodeImages();
	} else if (cType.indexOf ("100BaseFX SFP") != -1) {
		// construct side SFP-FX100 port
		p.images = SFP_side_100FXImages();
	} else if (cType.indexOf ("100BaseFX-FE") != -1) {
		p.images = SFP_side_100FXImages();
	} else if (cType.indexOf("unknown") != -1) {
		// construct side Empty port
		p.images = SFP_side_EmptyImages();
	} else {
	  	// any other type is considered as Empty	
		// construct Empty SFP port
		p.images = SFP_side_EmptyImages();
	}
	p.width = 16;
	p.height = 21;
	p.connType = cType;
	return p;
}

// refresh method for SFP CWDM port
function _refreshSFPCWDMPort(frame) {
	frame.images[this.id].src = this.images.img[this.color].src;
	var type = this.connType;
	if(type.indexOf("SFP") != -1) {
		type = type.substring(0,type.indexOf("SFP")).replace(/^\s+/,'').replace(/\s+$/,'');
	}
	if(!this.cwdmImages[type])
		type = "other";
	frame.images[this.id + "_color"].src = this.cwdmImages[type].src;
}

// setImage method for SFP CWDM port
function _setImageSFPCWDMPort(image,frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_color"].src = 'images/spacer.gif';
}

// draw method for SFP CWDM port
function _drawSFPCWDMPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	str += "<img id='"+ this.id +"_id_color' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:500'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"_color' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y + 1) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_color&quot;].style.top=" + (this.device.y + this.y) +";document.images[&quot;" + this.id + "_color&quot;].style.left=" + (this.device.x + this.x) +";'>";

	return str;
}

// the RJ45 composite Port constructor
function rj45Compositeport(cType, portImages,rj45IsFirst) {
	var p = new port(portImages);
	p.connType = cType;
	p.width = 21;
	p.height = 33;
	p.baseImage = "images/spacer.gif";
	if(cType.indexOf("-") != -1) 
	{
		cType = cType.substring(0,cType.lastIndexOf("-"));
		p.connType = p.connType.substring(p.connType.lastIndexOf("-") + 1);
	} 
	else 
	{
		if(cType.indexOf("unsupported") != -1)
		{
			cType = "Unsupported";
			p.connType = "10/100/1000BaseTX";
		}
		if(cType.indexOf("unknown") != -1)
		{
			cType = "UnKnown";
			p.connType = "10/100/1000BaseTX";
		}
		else if(cType.indexOf("Not Present") != -1)
		{
			cType = "Empty";
			p.connType = "10/100/1000BaseTX";
		} 
		else
		{
			cType = "Empty";
		}
	}

	if(rj45IsFirst)
		p.connType = p.connType + "-" + cType;
	else
		p.connType = cType + "-" + p.connType;
	if ( cType.indexOf("SFP") != -1 ) cType = cType.substring(0, cType.indexOf("SFP")).replace(/^\s+/,'').replace(/\s+$/,'');
	var sfpPort = new SFPport(cType,portImages);
	p.sfpPort = sfpPort;
	p.draw = _drawrj45CompositePort;
	p.refresh = _refreshrj45CompositePort;
	p.setImage = _setImagerj45CompositePort;
	p.sfpx = 0; // default coordinates for 2950 LRE. other devices may override.
	p.sfpy = 0;
	p.rj45x = 1;
	p.rj45y = 17;
	p.rj45Width = 19;
	p.rj45Height = 15;
	p.sfpWidth = 21;
	p.sfpHeight = 16;
	return p;
}

// refresh method for RJ45 composite port

function _refreshrj45CompositePort(frame) {
	frame.images[this.id].src = this.baseImage;
	if(this.color.indexOf("-") != -1) {
		var colors = this.color.split("-");
		this.sfpColor = colors[0];
		this.rj45Color = colors[1];
	} else {
		this.rj45Color = this.color;
		this.sfpColor = this.color;
	}
	frame.images[this.id + "_rj45"].src = this.images.img[this.rj45Color].src;
	frame.images[this.id + "_sfp"].src = this.sfpPort.images.img[this.sfpColor].src;
	if(frame.images[this.id + "_sfp_color"]) {
		frame.images[this.id + "_sfp_color"].src = this.sfpPort.cwdmImages[this.sfpPort.connType].src; 
	}
}

// setImage method for RJ45 composite port
function _setImagerj45CompositePort(image, frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_rj45"].src = 'images/spacer.gif';
	frame.images[this.id + "_sfp"].src = 'images/spacer.gif';
}

// draw method for RJ45 composite port
function _drawrj45CompositePort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.width + "' height='" + this.height + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + this.rj45y + 1) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + this.rj45x + 1) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + this.sfpy + 1) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + this.sfpx + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + this.rj45y) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + this.rj45x) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + this.sfpy) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + this.sfpx) +";'>";

	str += "<img id='"+ this.id +"_id_rj45' style='position:absolute; left:" + (this.device.x + this.x + this.rj45x) +"px; top:" + (this.device.y + this.y + this.rj45y) + "px; z-index:500'";
	str += " width='" + this.rj45Width + "' height='" + this.rj45Height + "' name='" + this.id +"_rj45' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + "); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + this.rj45y + 1) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + this.rj45x + 1) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + this.sfpy + 1) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + this.sfpx + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + this.rj45y) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + this.rj45x) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + this.sfpy) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + this.sfpx) +";'>";

	str += "<img id='"+ this.id +"_id_sfp' style='position:absolute; left:" + (this.device.x + this.x + this.sfpx) +"px; top:" + (this.device.y + this.y + this.sfpy) + "px; z-index:500'";
	str += " width='" + this.sfpWidth + "' height='" + this.sfpHeight + "' name='" + this.id +"_sfp' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + "); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + this.rj45y + 1) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + this.rj45x + 1) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + this.sfpy + 1) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + this.sfpx + 1) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000); ";
	str += "document.images[&quot;" + this.id + "_rj45&quot;].style.top=" + (this.device.y + this.y + this.rj45y) +";document.images[&quot;" + this.id + "_rj45&quot;].style.left=" + (this.device.x + this.x + this.rj45x) +";";
	str += "document.images[&quot;" + this.id + "_sfp&quot;].style.top=" + (this.device.y + this.y + this.sfpy) +";document.images[&quot;" + this.id + "_sfp&quot;].style.left=" + (this.device.x + this.x + this.sfpx) +";'>";
	
	if(this.sfpPort.cwdmImages) {
		str += "<img id='"+ this.id +"_id_sfp_color' style='position:absolute; left:" + (this.device.x + this.x + this.sfpx) +"px; top:" + (this.device.y + this.y + this.sfpy) + "px; z-index:600'";
		str += " width='" + this.sfpWidth + "' height='" + this.sfpHeight + "' name='" + this.id +"_sfp_color' border='0' onClick='handleClick(" + this.index + ")'";
		str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");'";
		str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);'>";
	}
	return str;
}

// the 10Gig Port constructor
function tenGigport(cType, portImages) {
	var p = new port(portImages);
	if(cType.indexOf("10GBase-LR Xenpak") != -1) {
		p.baseImg = "images/10gig_base.gif";
		p.images = GBIC_10GImages();
		p.draw = _draw10GigPort;
		p.refresh = _refresh10GigPort;
		p.setImage = _setImage10GigPort;
		p.baseWidth = 47;
		p.baseHeight = 26;
		p.connWidth = 31;
		p.connHeight = 14;
	} else {
		p.images = GBIC_10GEmptyImages();
		p.width = 47;
		p.height = 26;
	}
	p.connType = cType;
	return p;
}

// refresh method for 10Gig  port
function _refresh10GigPort(frame) {
	frame.images[this.id].src = this.baseImg;
	frame.images[this.id + "_connector"].src = this.images.img[this.color].src;
}

// setImage method for 10Gig  port
function _setImage10GigPort(image, frame) {
	frame.images[this.id].src = image;
	frame.images[this.id + "_connector"].src = 'images/spacer.gif';
}

// draw method for 10Gig port
function _draw10GigPort() {
	var str = "<img id='"+ this.id +"_id' style='position:absolute; left:" + (this.device.x + this.x) +"px; top:" + (this.device.y + this.y) + "px; z-index:400'";
	str += " width='" + this.baseWidth + "' height='" + this.baseHeight + "' name='" + this.id +"' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 10) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 8) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 9) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 7) +";'>";

	str += "<img id='"+ this.id +"_connector_id' style='position:absolute; left:" + (this.device.x + this.x + 7) +"px; top:" + (this.device.y + this.y + 9) + "px; z-index:500'";
	str += " width='" + this.connWidth + "' height='" + this.connHeight + "' name='" + this.id +"_connector' border='0' onClick='handleClick(" + this.index + ")'";
	str += " onMouseOver='document.images[&quot;" + this.id + "&quot;].border=1; showTooltip(" + this.index + ");";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 10) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 8) +";'";
	str += " onMouseOut='document.images[&quot;" + this.id + "&quot;].border=0; resetPort(); hideLayerWrapper(2000);";
	str += "document.images[&quot;" + this.id + "_connector&quot;].style.top=" + (this.device.y + this.y + 9) +";document.images[&quot;" + this.id + "_connector&quot;].style.left=" + (this.device.x + this.x + 7) +";'>";

	return str;
}

// function to create Port images
function frmWrkPortImages() {
	this.img = new Array();
	this.img["BLACK"] = new Image();
	this.img["GREEN"] = new Image();
	this.img["CYAN"] = new Image();
	this.img["BROWN"] = new Image();
	this.img["YELLOW"] = new Image();
	this.img["AMBER"] = new Image();
	this.img["BLINKGREEN"] = new Image();
	this.img["ALT_GREEN_BLACK"] = new Image();
	this.img["ALT_AMBER_BLACK"] = new Image();
	this.img["BLINKGREEN_AMBER"] = new Image();
	this.img["ALT_GREEN_AMBER"] = new Image();
	this.img["BLINKAMBER"] = new Image();
	this.img["ALT_AMBER_BLACK"] = new Image();
}

var hbportImgs = null;
// method to create RJ45 port images
function hbportImages() {
	if(hbportImgs != null) return hbportImgs;
	hbportImgs = new frmWrkPortImages();
	hbportImgs.img["BLACK"].src = "images/hb_gray.gif";
	hbportImgs.img["GREEN"].src = "images/hb_green.gif";
	hbportImgs.img["CYAN"].src = "images/hb_cyan.gif";
	hbportImgs.img["BROWN"].src = "images/hb_brown.gif";
	hbportImgs.img["YELLOW"].src = "images/hb_yellow.gif";
	hbportImgs.img["AMBER"].src = "images/hb_amber.gif";
	hbportImgs.img["BLINKGREEN"].src = "images/hb_blinkgreen.gif";
	hbportImgs.img["ALT_GREEN_BLACK"].src = "images/hb_blinkgreen.gif";
	hbportImgs.img["BLINKGREEN_AMBER"].src = "images/hb_blinkgreen_amber.gif";
	hbportImgs.img["ALT_GREEN_AMBER"].src = "images/hb_blinkgreen_amber.gif";
	return hbportImgs;
}

var rj45Imgs = null;
// method to create RJ45 port images
function rj45portImages() {
	if(rj45Imgs != null) return rj45Imgs;
	rj45Imgs = new frmWrkPortImages();
	rj45Imgs.img["BLACK"].src = "images/gray.gif";
	rj45Imgs.img["GREEN"].src = "images/green.gif";
	rj45Imgs.img["CYAN"].src = "images/cyan.gif";
	rj45Imgs.img["BROWN"].src = "images/brown.gif";
	rj45Imgs.img["YELLOW"].src = "images/yellow.gif";
	rj45Imgs.img["AMBER"].src = "images/amber.gif";
	rj45Imgs.img["BLINKGREEN"].src = "images/blinkgreen.gif";
	rj45Imgs.img["ALT_GREEN_BLACK"].src = "images/blinkgreen.gif";
	rj45Imgs.img["BLINKGREEN_AMBER"].src = "images/blinkgreen_amber.gif";
	rj45Imgs.img["ALT_GREEN_AMBER"].src = "images/blinkgreen_amber.gif";
	rj45Imgs.img["BLINKAMBER"].src = "images/blinkamber.gif";
	rj45Imgs.img["ALT_AMBER_BLACK"].src = "images/blinkamber.gif";
	return rj45Imgs;
}

var rj45InvImgs = null;
// method to create inverted RJ45 port images
function rj45portInvImages() {
	if(rj45InvImgs != null) return rj45InvImgs;
	rj45InvImgs = new frmWrkPortImages();
	rj45InvImgs.img["BLACK"].src = "images/inv_gray.gif";
	rj45InvImgs.img["GREEN"].src = "images/inv_green.gif";
	rj45InvImgs.img["CYAN"].src = "images/inv_cyan.gif";
	rj45InvImgs.img["BROWN"].src = "images/inv_brown.gif";
	rj45InvImgs.img["YELLOW"].src = "images/inv_yellow.gif";
	rj45InvImgs.img["AMBER"].src = "images/inv_amber.gif";
	rj45InvImgs.img["BLINKGREEN"].src = "images/inv_blinkgreen.gif";
	rj45InvImgs.img["ALT_GREEN_BLACK"].src = "images/inv_blinkgreen.gif";
	rj45InvImgs.img["BLINKGREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	rj45InvImgs.img["ALT_GREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	rj45InvImgs.img["BLINKAMBER"].src = "images/inv_blinkamber.gif";
	rj45InvImgs.img["ALT_AMBER_BLACK"].src = "images/inv_blinkamber.gif";
	return rj45InvImgs;
}
var internalImages = null;
// method to create Internalport images
function internalportImages(){
	if(internalImages != null) return internalImages;
	var internalImages = new frmWrkPortImages();
	internalImages.img["BLACK"].src = "images/internal_gray.gif";
	internalImages.img["GREEN"].src = "images/internal_green.gif";
	internalImages.img["BROWN"].src = "images/internal_brown.gif";
	internalImages.img["AMBER"].src = "images/internal_amber.gif";
	internalImages.img["YELLOW"].src = "images/internal_yellow.gif";
	internalImages.img["BLINKGREEN"].src = "images/internal_blinkgreen.gif";
	internalImages.img["ALT_GREEN_BLACK"].src = "images/internal_blinkgreen.gif";
	internalImages.img["BLINKGREEN_AMBER"].src = "images/internal_blinkgreen_amber.gif";
	internalImages.img["ALT_GREEN_AMBER"].src = "images/internal_blinkgreen_amber.gif";
	return internalImages;
}

var rj45sideImgs = null;
// method to create side RJ45 port images
function rj45portSideImages() {
	if(rj45sideImgs != null) return rj45sideImgs;
	var rj45sideImgs = new frmWrkPortImages();
	rj45sideImgs.img["BLACK"].src = "images/side_gray.gif";
	rj45sideImgs.img["GREEN"].src = "images/side_green.gif";
	rj45sideImgs.img["BROWN"].src = "images/side_brown.gif";
	rj45sideImgs.img["AMBER"].src = "images/side_amber.gif";
	rj45sideImgs.img["YELLOW"].src = "images/side_yellow.gif";
	rj45sideImgs.img["BLINKGREEN"].src = "images/inv_blinkgreen.gif";
	rj45sideImgs.img["ALT_GREEN_BLACK"].src = "images/inv_blinkgreen.gif";
	rj45sideImgs.img["BLINKGREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	rj45sideImgs.img["ALT_GREEN_AMBER"].src = "images/inv_blinkgreen_amber.gif";
	return rj45sideImgs;
}


var fxPortImgs = null;
// method to create FX port images
function fxportImages() {
	if(fxPortImgs != null) return fxPortImgs;
	fxPortImgs = new frmWrkPortImages();
	fxPortImgs.img["BLACK"].src = "images/fx_gray.gif";
	fxPortImgs.img["GREEN"].src = "images/fx_green.gif";
	fxPortImgs.img["CYAN"].src = "images/fx_cyan.gif";
	fxPortImgs.img["BROWN"].src = "images/fx_brown.gif";
	fxPortImgs.img["AMBER"].src = "images/fx_amber.gif";
	fxPortImgs.img["YELLOW"].src = "images/fx_yellow.gif";
	fxPortImgs.img["BLINKGREEN"].src = "images/fx_blinkgreen.gif";
	fxPortImgs.img["ALT_GREEN_BLACK"].src = "images/fx_blinkgreen.gif";
	fxPortImgs.img["BLINKGREEN_AMBER"].src = "images/fx_blinkgreen_amber.gif";
	fxPortImgs.img["ALT_GREEN_AMBER"].src = "images/fx_blinkgreen_amber.gif";
	fxPortImgs.img["BLINKAMBER"].src = "images/fx_blinkamber.gif";
	fxPortImgs.img["ALT_AMBER_BLACK"].src = "images/fx_blinkamber.gif";
	return fxPortImgs;
}

var gbicEmptyImgs = null;
// method to create Empty GBIC port images
function GBIC_EmptyImages() {
	if(gbicEmptyImgs != null) return gbicEmptyImgs;
	gbicEmptyImgs = new frmWrkPortImages();
	gbicEmptyImgs.img["BLACK"].src = "images/gbic_empty.gif";
	gbicEmptyImgs.img["GREEN"].src = "images/gbic_empty_green.gif";
	gbicEmptyImgs.img["CYAN"].src = "images/gbic_empty_cyan.gif";
	gbicEmptyImgs.img["BROWN"].src = "images/gbic_empty_brown.gif";
	gbicEmptyImgs.img["YELLOW"].src = "images/gbic_empty_yellow.gif";
	gbicEmptyImgs.img["AMBER"].src = "images/gbic_empty_amber.gif";
	gbicEmptyImgs.img["BLINKGREEN"].src = "images/gbic_empty_blinkgreen.gif";
	gbicEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_empty_blinkgreen.gif";
	gbicEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_empty_greenamber.gif";
	gbicEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_empty_greenamber.gif";
	return gbicEmptyImgs;
}

var gbicRzrImgs = null;
// method to create GBIC Razor port images
function GBIC_RazorImages() {
	if(gbicRzrImgs != null) return gbicRzrImgs;
	gbicRzrImgs = new frmWrkPortImages();
	gbicRzrImgs.img["BLACK"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["GREEN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["CYAN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["BROWN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["YELLOW"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["AMBER"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["BLINKGREEN"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_base.gif";
	gbicRzrImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_base.gif";
	return gbicRzrImgs;
}

var gbicRzrConnImgs = null;
// method to create GBIC Razor connector images
function GBIC_RazorConnectorImages() {
	if(gbicRzrConnImgs != null) return gbicRzrConnImgs;
	gbicRzrConnImgs = new frmWrkPortImages();
	gbicRzrConnImgs.img["BLACK"].src = "images/gbic_rzr_gray.gif";
	gbicRzrConnImgs.img["GREEN"].src = "images/gbic_rzr_green.gif";
	gbicRzrConnImgs.img["CYAN"].src = "images/gbic_rzr_cyan.gif";
	gbicRzrConnImgs.img["BROWN"].src = "images/gbic_rzr_brown.gif";
	gbicRzrConnImgs.img["YELLOW"].src = "images/gbic_rzr_yellow.gif";	
	gbicRzrConnImgs.img["AMBER"].src = "images/gbic_rzr_amber.gif";
	gbicRzrConnImgs.img["BLINKGREEN"].src = "images/gbic_rzr_blinkgreen.gif";
	gbicRzrConnImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_rzr_blinkgreen.gif";
	gbicRzrConnImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_rzr_green_amber.gif";
	gbicRzrConnImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_rzr_green_amber.gif";
	gbicRzrConnImgs.img["BLINKAMBER"].src = "images/gbic_rzr_blinkamber.gif";
	gbicRzrConnImgs.img["ALT_AMBER_BLACK"].src = "images/gbic_rzr_blinkamber.gif";
	return gbicRzrConnImgs;
}

var gbicTImgs = null;
// method to create GBIC-T port images
function GBIC_TImages() {
	if(gbicTImgs != null) return gbicTImgs;
	gbicTImgs = new frmWrkPortImages();
	gbicTImgs.img["BLACK"].src = "images/gbic_t_gray.gif";
	gbicTImgs.img["GREEN"].src = "images/gbic_t_green.gif";
	gbicTImgs.img["CYAN"].src = "images/gbic_t_cyan.gif";
	gbicTImgs.img["BROWN"].src = "images/gbic_t_brown.gif";
	gbicTImgs.img["YELLOW"].src = "images/gbic_t_yellow.gif";
	gbicTImgs.img["AMBER"].src = "images/gbic_t_amber.gif";
	gbicTImgs.img["BLINKGREEN"].src = "images/gbic_t_blinkgreen.gif";
	gbicTImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_t_blinkgreen.gif";
	gbicTImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_t_green_amber.gif";
	gbicTImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_t_green_amber.gif";
	gbicTImgs.img["BLINKAMBER"].src = "images/gbic_t_blinkamber.gif";
	gbicTImgs.img["ALT_AMBER_BLACK"].src = "images/gbic_t_blinkamber.gif";
	return gbicTImgs;
}

var gbicFbrImgs = null;
// method to create GBIC Fiber port images (used by SX, LX and ZX ports)
function GBIC_FiberImages() {
	if(gbicFbrImgs != null) return gbicFbrImgs;
	gbicFbrImgs = new frmWrkPortImages();
	gbicFbrImgs.img["BLACK"].src = "images/gbic_lx_gray.gif";
	gbicFbrImgs.img["GREEN"].src = "images/gbic_lx_green.gif";
	gbicFbrImgs.img["CYAN"].src = "images/gbic_lx_cyan.gif";
	gbicFbrImgs.img["BROWN"].src = "images/gbic_lx_brown.gif";
	gbicFbrImgs.img["YELLOW"].src = "images/gbic_lx_yellow.gif";
	gbicFbrImgs.img["AMBER"].src = "images/gbic_lx_amber.gif";
	gbicFbrImgs.img["BLINKGREEN"].src = "images/gbic_lx_blinkgreen.gif";
	gbicFbrImgs.img["ALT_GREEN_BLACK"].src = "images/gbic_lx_blinkgreen.gif";
	gbicFbrImgs.img["BLINKGREEN_AMBER"].src = "images/gbic_lx_green_amber.gif";
	gbicFbrImgs.img["ALT_GREEN_AMBER"].src = "images/gbic_lx_green_amber.gif";
	gbicFbrImgs.img["BLINKAMBER"].src = "images/gbic_lx_blinkamber.gif";
	gbicFbrImgs.img["ALT_AMBER_BLACK"].src = "images/gbic_lx_blinkamber.gif";
	return gbicFbrImgs;
}

// method to create GBIC CWDM port images
function GBIC_CWDMImages() {
	return GBIC_FiberImages();
}

// method to create GBIC DWDM port images
function GBIC_DWDMImages() {
	return GBIC_FiberImages();
}

var cwdm_led = null;
// method to create GBIC CCWDM port wave length color code images
function GBIC_CWDMColorCodeImages() {
// CWDM-1470, CWDM-1490, CWDM-1510, CWDM-1530, CWDM-1550, CWDM-1570, CWDM-1590, CWDM-1610
	if(cwdm_led != null) return cwdm_led;
	cwdm_led = new Array();
	cwdm_led["CWDM-1470"] = new Image(); cwdm_led["CWDM-1470"].src = "images/gbic_cwdm_gray.gif";
	cwdm_led["CWDM-1490"] = new Image(); cwdm_led["CWDM-1490"].src = "images/gbic_cwdm_violet.gif";
	cwdm_led["CWDM-1510"] = new Image(); cwdm_led["CWDM-1510"].src = "images/gbic_cwdm_blue.gif";
	cwdm_led["CWDM-1530"] = new Image(); cwdm_led["CWDM-1530"].src = "images/gbic_cwdm_green.gif";	
	cwdm_led["CWDM-1550"] = new Image(); cwdm_led["CWDM-1550"].src = "images/gbic_cwdm_yellow.gif";
	cwdm_led["CWDM-1570"] = new Image(); cwdm_led["CWDM-1570"].src = "images/gbic_cwdm_orange.gif";
	cwdm_led["CWDM-1590"] = new Image(); cwdm_led["CWDM-1590"].src = "images/gbic_cwdm_red.gif";
	cwdm_led["CWDM-1610"] = new Image(); cwdm_led["CWDM-1610"].src = "images/gbic_cwdm_brown.gif";
	cwdm_led["other"] = new Image(); cwdm_led["other"].src = "images/spacer.gif";
	return cwdm_led;
}

var sfpTImgs = null;
// method to create SFP-T port images
function SFP_TImages() {
	if(sfpTImgs != null) return sfpTImgs;
	sfpTImgs = new frmWrkPortImages();
	sfpTImgs.img["BLACK"].src = "images/sfp_tx_gray.gif";
	sfpTImgs.img["GREEN"].src = "images/sfp_tx_green.gif";
	sfpTImgs.img["CYAN"].src = "images/sfp_tx_cyan.gif";
	sfpTImgs.img["BROWN"].src = "images/sfp_tx_brown.gif";
	sfpTImgs.img["YELLOW"].src = "images/sfp_tx_yellow.gif";
	sfpTImgs.img["AMBER"].src = "images/sfp_tx_amber.gif";
	sfpTImgs.img["BLINKGREEN"].src = "images/sfp_tx_blinkgreen.gif";
	sfpTImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_tx_blinkgreen.gif";
	sfpTImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_tx_blinkgreen_amber.gif";
	sfpTImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_tx_blinkgreen_amber.gif";
	sfpTImgs.img["BLINKAMBER"].src = "images/sfp_tx_blinkamber.gif";
	sfpTImgs.img["ALT_AMBER_BLACK"].src = "images/sfp_tx_blinkamber.gif";
	return sfpTImgs;
}


var sfpsideTImgs = null;
// method to create SFP-T port images
function SFP_side_TImages() {
	if(sfpsideTImgs != null) return sfpsideTImgs;
	sfpsideTImgs = new frmWrkPortImages();
	sfpsideTImgs.img["BLACK"].src = "images/sfp_side_tx_gray.gif";
	sfpsideTImgs.img["GREEN"].src = "images/sfp_side_tx_green.gif";
	sfpsideTImgs.img["CYAN"].src = "images/sfp_side_tx_cyan.gif";
	sfpsideTImgs.img["BROWN"].src = "images/sfp_side_tx_brown.gif";
	sfpsideTImgs.img["YELLOW"].src = "images/sfp_side_tx_yellow.gif";
	sfpsideTImgs.img["AMBER"].src = "images/sfp_side_tx_amber.gif";
	sfpsideTImgs.img["BLINKGREEN"].src = "images/sfp_side_tx_blinkgreen.gif";
	sfpsideTImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_side_tx_blinkgreen.gif";
	sfpsideTImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_side_tx_blinkgreen_amber.gif";
	sfpsideTImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_side_tx_blinkgreen_amber.gif";
	sfpsideTImgs.img["BLINKAMBER"].src = "images/sfp_side_tx_blinkamber.gif";
	sfpsideTImgs.img["ALT_AMBER_BLACK"].src = "images/sfp_side_tx_blinkamber.gif";
	return sfpsideTImgs;
}

var sfpSXImgs = null;
// method to create SFP-SX port images
function SFP_SXImages() {
	if(sfpSXImgs != null) return sfpSXImgs;
	sfpSXImgs = new frmWrkPortImages();
	sfpSXImgs.img["BLACK"].src = "images/sfp_gray.gif";
	sfpSXImgs.img["GREEN"].src = "images/sfp_green.gif";
	sfpSXImgs.img["CYAN"].src = "images/sfp_cyan.gif";
	sfpSXImgs.img["BROWN"].src = "images/sfp_brown.gif";
	sfpSXImgs.img["YELLOW"].src = "images/sfp_yellow.gif";
	sfpSXImgs.img["AMBER"].src = "images/sfp_amber.gif";
	sfpSXImgs.img["BLINKGREEN"].src = "images/sfp_blinkgreen.gif";
	sfpSXImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_blinkgreen.gif";
	sfpSXImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_blinkgreen_amber.gif";
	sfpSXImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_blinkgreen_amber.gif";
	sfpSXImgs.img["BLINKAMBER"].src = "images/sfp_blinkamber.gif";
	sfpSXImgs.img["ALT_AMBER_BLACK"].src = "images/sfp_blinkamber.gif";
	return sfpSXImgs;
}


var sfpsideSXImgs = null;
// method to create side SFP-SX port images
function SFP_side_SXImages() {
	if(sfpsideSXImgs != null) return sfpsideSXImgs;
	sfpsideSXImgs = new frmWrkPortImages();
	sfpsideSXImgs.img["BLACK"].src = "images/sfp_side_gray.gif";
	sfpsideSXImgs.img["GREEN"].src = "images/sfp_side_green.gif";
	sfpsideSXImgs.img["CYAN"].src = "images/sfp_side_cyan.gif";
	sfpsideSXImgs.img["BROWN"].src = "images/sfp_side_brown.gif";
	sfpsideSXImgs.img["YELLOW"].src = "images/sfp_side_yellow.gif";
	sfpsideSXImgs.img["AMBER"].src = "images/sfp_side_amber.gif";
	sfpsideSXImgs.img["BLINKGREEN"].src = "images/sfp_side_blinkgreen.gif";
	sfpsideSXImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_side_blinkgreen.gif";
	sfpsideSXImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_side_blinkgreen_amber.gif";
	sfpsideSXImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_side_blinkgreen_amber.gif";
	sfpsideSXImgs.img["BLINKAMBER"].src = "images/sfp_side_blinkamber.gif";
	sfpsideSXImgs.img["ALT_AMBER_BLACK"].src = "images/sfp_side_blinkamber.gif";
	return sfpsideSXImgs;
}


// method to create SFP-LX port images
function SFP_LXImages() {
	return SFP_SXImages();
}

// method to create SFP-ZX port images
function SFP_ZXImages() {
	return SFP_SXImages();
}

//method to create 1000BaseCX SFP cable port images
//this module is supported only on the 3560 devices.
function SFP_CXImages() {
        return SFP_SXImages();
}

//method to create 1000BaseBX10-D SFP port images
function SFP_BXImages() {
        return SFP_SXImages();
}

// method to create SFP-CWDM port images
function SFP_CWDMImages() {
	return SFP_SXImages();
}

// method to create SFP-FX100 port images
function SFP_100FXImages() {
	return SFP_SXImages();
}

// method to create side SFP-LX port images
function SFP_side_LXImages() {
	return SFP_side_SXImages();
}

// method to create side SFP-ZX port images
function SFP_side_ZXImages() {
	return SFP_side_SXImages();
}

// method to create side 1000BaseBX10-D port images
function SFP_side_BXImages() {
        return SFP_side_SXImages();
}

// method to create side SFP-CWDM port images
function SFP_side_CWDMImages() {
	return SFP_side_SXImages();
}

// method to create side SFP-FX100 port images
function SFP_side_100FXImages() {
	return SFP_side_SXImages();
}



var sfpEmptyImgs = null;
// method to create SFP Empty port images
function SFP_EmptyImages() {
	if(sfpEmptyImgs != null) return sfpEmptyImgs;
	sfpEmptyImgs = new frmWrkPortImages();
	sfpEmptyImgs.img["BLACK"].src = "images/sfp_empty_gray.gif";
	sfpEmptyImgs.img["GREEN"].src = "images/sfp_empty_green.gif";
	sfpEmptyImgs.img["CYAN"].src = "images/sfp_empty_cyan.gif";
	sfpEmptyImgs.img["BROWN"].src = "images/sfp_empty_brown.gif";
	sfpEmptyImgs.img["YELLOW"].src = "images/sfp_empty_yellow.gif";
	sfpEmptyImgs.img["AMBER"].src = "images/sfp_empty_amber.gif";
	sfpEmptyImgs.img["BLINKGREEN"].src = "images/sfp_empty_blinkgreen.gif";
	sfpEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_empty_blinkgreen.gif";
	sfpEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_empty_greenamber.gif";
	sfpEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_empty_greenamber.gif";
	sfpEmptyImgs.img["BLINKAMBER"].src = "images/sfp_empty_blinkamber.gif";
	sfpEmptyImgs.img["ALT_AMBER_BLACK"].src = "images/sfp_empty_blinkamber.gif";
	return sfpEmptyImgs;
}


var sfpsideEmptyImgs = null;
// method to create side SFP Empty port images
function SFP_side_EmptyImages() {
	if(sfpsideEmptyImgs != null) return sfpsideEmptyImgs;
	sfpsideEmptyImgs = new frmWrkPortImages();
	sfpsideEmptyImgs.img["BLACK"].src = "images/sfp_side_empty_gray.gif";
	sfpsideEmptyImgs.img["GREEN"].src = "images/sfp_side_empty_green.gif";
	sfpsideEmptyImgs.img["CYAN"].src = "images/sfp_side_empty_cyan.gif";
	sfpsideEmptyImgs.img["BROWN"].src = "images/sfp_side_empty_brown.gif";
	sfpsideEmptyImgs.img["YELLOW"].src = "images/sfp_side_empty_yellow.gif";
	sfpsideEmptyImgs.img["AMBER"].src = "images/sfp_side_empty_amber.gif";
	sfpsideEmptyImgs.img["BLINKGREEN"].src = "images/sfp_side_empty_blinkgreen.gif";
	sfpsideEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/sfp_side_empty_blinkgreen.gif";
	sfpsideEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/sfp_side_empty_greenamber.gif";
	sfpsideEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/sfp_side_empty_greenamber.gif";
	sfpsideEmptyImgs.img["BLINKAMBER"].src = "images/sfp_side_empty_blinkamber.gif";
	sfpsideEmptyImgs.img["ALT_AMBER_BLACK"].src = "images/sfp_side_empty_blinkamber.gif";
	return sfpsideEmptyImgs;
}

var cwdm_sfp_led = null;
// method to create SFP CCWDM port wave length color code images
function SFP_CWDMColorCodeImages() {
// CWDM-1470, CWDM-1490, CWDM-1510, CWDM-1530, CWDM-1550, CWDM-1570, CWDM-1590, CWDM-1610
	if(cwdm_sfp_led != null) return cwdm_sfp_led;
	cwdm_sfp_led = new Array();
	cwdm_sfp_led["CWDM-1470"] = new Image(); cwdm_sfp_led["CWDM-1470"].src = "images/cwdm_gray.gif";
	cwdm_sfp_led["CWDM-1490"] = new Image(); cwdm_sfp_led["CWDM-1490"].src = "images/cwdm_violet.gif";
	cwdm_sfp_led["CWDM-1510"] = new Image(); cwdm_sfp_led["CWDM-1510"].src = "images/cwdm_blue.gif";
	cwdm_sfp_led["CWDM-1530"] = new Image(); cwdm_sfp_led["CWDM-1530"].src = "images/cwdm_green.gif";	
	cwdm_sfp_led["CWDM-1550"] = new Image(); cwdm_sfp_led["CWDM-1550"].src = "images/cwdm_yellow.gif";
	cwdm_sfp_led["CWDM-1570"] = new Image(); cwdm_sfp_led["CWDM-1570"].src = "images/cwdm_orange.gif";
	cwdm_sfp_led["CWDM-1590"] = new Image(); cwdm_sfp_led["CWDM-1590"].src = "images/cwdm_red.gif";
	cwdm_sfp_led["CWDM-1610"] = new Image(); cwdm_sfp_led["CWDM-1610"].src = "images/cwdm_brown.gif";
	cwdm_sfp_led["other"] = new Image(); cwdm_sfp_led["other"].src = "images/spacer.gif";
	return cwdm_sfp_led;
}


var cwdm_side_sfp_led = null;
// method to create SFP CCWDM port wave length color code images
function SFP_side_CWDMColorCodeImages() {
// CWDM-1470, CWDM-1490, CWDM-1510, CWDM-1530, CWDM-1550, CWDM-1570, CWDM-1590, CWDM-1610
	if(cwdm_side_sfp_led != null) return cwdm_side_sfp_led;
	cwdm_side_sfp_led = new Array();
	cwdm_side_sfp_led["CWDM-1470"] = new Image(); cwdm_sfp_led["CWDM-1470"].src = "images/cwdm_side_gray.gif";
	cwdm_side_sfp_led["CWDM-1490"] = new Image(); cwdm_sfp_led["CWDM-1490"].src = "images/cwdm_side_violet.gif";
	cwdm_side_sfp_led["CWDM-1510"] = new Image(); cwdm_sfp_led["CWDM-1510"].src = "images/cwdm_side_blue.gif";
	cwdm_side_sfp_led["CWDM-1530"] = new Image(); cwdm_sfp_led["CWDM-1530"].src = "images/cwdm_side_green.gif";	
	cwdm_side_sfp_led["CWDM-1550"] = new Image(); cwdm_sfp_led["CWDM-1550"].src = "images/cwdm_side_yellow.gif";
	cwdm_side_sfp_led["CWDM-1570"] = new Image(); cwdm_sfp_led["CWDM-1570"].src = "images/cwdm_side_orange.gif";
	cwdm_side_sfp_led["CWDM-1590"] = new Image(); cwdm_sfp_led["CWDM-1590"].src = "images/cwdm_side_red.gif";
	cwdm_side_sfp_led["CWDM-1610"] = new Image(); cwdm_sfp_led["CWDM-1610"].src = "images/cwdm_side_brown.gif";
	cwdm_side_sfp_led["other"] = new Image(); cwdm_side_sfp_led["other"].src = "images/spacer.gif";
	return cwdm_side_sfp_led;
}



var gbic10GImgs = null;
// method to create GBIC 10Gig port images
function GBIC_10GImages() {
	if(gbic10GImgs != null) return gbic10GImgs;
	gbic10GImgs = new frmWrkPortImages();
	gbic10GImgs.img["BLACK"].src = "images/10gig_gray.gif";
	gbic10GImgs.img["GREEN"].src = "images/10gig_green.gif";
	gbic10GImgs.img["CYAN"].src = "images/10gig_cyan.gif";
	gbic10GImgs.img["BROWN"].src = "images/10gig_brown.gif";
	gbic10GImgs.img["YELLOW"].src = "images/10gig_yellow.gif";
	gbic10GImgs.img["AMBER"].src = "images/10gig_amber.gif";
	gbic10GImgs.img["BLINKGREEN"].src = "images/10gig_blinkgreen.gif";
	gbic10GImgs.img["ALT_GREEN_BLACK"].src = "images/10gig_blinkgreen.gif";
	gbic10GImgs.img["BLINKGREEN_AMBER"].src = "images/10gig_blinkgreen_amber.gif";
	gbic10GImgs.img["ALT_GREEN_AMBER"].src = "images/10gig_blinkgreen_amber.gif";
	gbic10GImgs.img["BLINKAMBER"].src = "images/10gig_blinkamber.gif";
	gbic10GImgs.img["ALT_AMBER_BLACK"].src = "images/10gig_blinkamber.gif";
	return gbic10GImgs;
}

var gbic10GEmptyImgs = null;
// method to create GBIC 10Gig Empty port images
function GBIC_10GEmptyImages() {
	if(gbic10GEmptyImgs != null) return gbic10GEmptyImgs;
	gbic10GEmptyImgs = new frmWrkPortImages();
	gbic10GEmptyImgs.img["BLACK"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["GREEN"].src = "images/10gig_empty_green.gif";
	gbic10GEmptyImgs.img["CYAN"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["BROWN"].src = "images/10gig_empty_brown.gif";
	gbic10GEmptyImgs.img["YELLOW"].src = "images/10gig_empty_yellow.gif";	
	gbic10GEmptyImgs.img["AMBER"].src = "images/10gig_empty_amber.gif";
	gbic10GEmptyImgs.img["BLINKGREEN"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["ALT_GREEN_BLACK"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["BLINKGREEN_AMBER"].src = "images/10gig_empty.gif";
	gbic10GEmptyImgs.img["ALT_GREEN_AMBER"].src = "images/10gig_empty.gif";
	return gbic10GEmptyImgs;
}
