/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import cisco.dsbu.cms.boot.internal.ClassFile;
import cisco.dsbu.cms.boot.internal.Package;
import cisco.dsbu.cms.boot.internal.VersionXml;
import cisco.dsbu.cms.boot.internal.ccl.ClassData;
import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import cisco.dsbu.cms.boot.internal.xmllite.Handler;
import cisco.dsbu.cms.boot.internal.xmllite.ParseException;
import cisco.dsbu.cms.boot.internal.xmllite.Parser;

class Component
implements Handler,
VersionXml,
ClassData {
    private static final byte NOT_LOADED = 0;
    private static final byte LOADED = 1;
    private static final byte NOT_FOUND = 2;
    private Package container;
    private String name;
    private boolean isSigned;
    private int version;
    private int size;
    private String markedSuper;
    private boolean isLatest = false;
    private byte loadState = 0;
    private byte[] contents;
    private CharString currElem;

    Component(Package package_) {
        this.container = package_;
    }

    String getName() {
        return this.name;
    }

    int getSize() {
        return this.size;
    }

    Package getPackage() {
        return this.container;
    }

    boolean isLatest() {
        return this.isLatest;
    }

    void setLatest(boolean bl) {
        if (this.isLatest != bl) {
            this.isLatest = bl;
            this.container.updateNumLatest(bl);
        }
    }

    String getMarkedSuper() {
        return this.markedSuper;
    }

    String getClassName() {
        return ClassFile.getClassName(this.name);
    }

    synchronized void setContents(byte[] byArray) {
        this.contents = byArray;
        this.loadState = 1;
        this.notifyAll();
    }

    synchronized void setContentsNotFound() {
        if (!this.isLatest) {
            return;
        }
        this.loadState = (byte)2;
        this.notifyAll();
    }

    synchronized boolean isContentsLoaded() {
        return this.loadState == 1;
    }

    synchronized boolean isContentsNotFound() {
        return this.loadState == 2;
    }

    public synchronized byte[] getContents() {
        return this.contents;
    }

    synchronized void setSigned(boolean bl) {
        this.isSigned = bl;
    }

    public synchronized boolean isSigned() {
        return this.isSigned;
    }

    boolean isNewerThan(Component component) {
        return this.name.equals(component.name) && this.version > component.version;
    }

    public boolean equals(Object object) {
        Component component;
        if (object == null) {
            return false;
        }
        try {
            component = (Component)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.name.equals(component.name)) {
            return false;
        }
        return this.version == component.version;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString charString) throws ParseException {
        this.currElem = null;
        if (charString.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (charString.equals(VersionXml.VERSION)) {
            this.currElem = VersionXml.VERSION;
        } else if (charString.equals(VersionXml.SIZE)) {
            this.currElem = VersionXml.SIZE;
        } else if (charString.equals(VersionXml.MARKED_SUPER)) {
            this.currElem = VersionXml.MARKED_SUPER;
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString charString) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = charString.toString();
        } else if (this.currElem == VersionXml.VERSION) {
            this.version = charString.toInt();
        } else if (this.currElem == VersionXml.SIZE) {
            this.size = charString.toInt();
        } else if (this.currElem == VersionXml.MARKED_SUPER) {
            this.markedSuper = charString.toString();
        }
    }

    public void endElement(Parser parser, CharString charString) throws ParseException {
        if (charString.equals(VersionXml.COMPONENT)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }
}

