/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal;

import com.cisco.cpnm.boot.internal.SignatureVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class SgzReader {
    private static final String SIG_FILENAME = "SIG";
    private InflaterInputStream gis;
    private byte[] buf;
    private String elementName;
    private int elementSize;
    private SignatureVerifier verifier;
    private boolean firstExternalCall;
    private byte[] elementData;
    private int elementStatus;

    public SgzReader(InputStream in) throws IOException {
        this.gis = new GZIPInputStream(in);
        this.buf = new byte[1024];
        this.initSignature();
        this.firstExternalCall = true;
    }

    public String getNextElement() throws IOException {
        if (this.firstExternalCall) {
            this.firstExternalCall = false;
            return this.elementName;
        }
        this.readNextElementInfo();
        this.verifier.advance();
        return this.elementName;
    }

    private void readNextElementInfo() throws IOException {
        this.skipElementData();
        if (this.read(this.buf, 0, 2) != 2) {
            this.elementName = null;
            this.elementSize = -1;
            this.elementData = null;
            return;
        }
        int fnlen = this.get2(0);
        if (this.buf.length < fnlen) {
            int newlen = this.buf.length;
            while (newlen < fnlen) {
                newlen *= 2;
            }
            this.buf = new byte[newlen];
        }
        if (this.read(this.buf, 0, fnlen) != fnlen) {
            this.elementName = null;
            this.elementSize = -1;
            this.elementData = null;
            return;
        }
        this.elementName = new String(this.buf, 0, fnlen);
        if (this.read(this.buf, 0, 4) != 4) {
            this.elementName = null;
            this.elementSize = -1;
            this.elementData = null;
            return;
        }
        this.elementSize = (int)this.get4(0);
        this.elementData = null;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public byte[] getElementData() throws IOException {
        if (this.elementData != null) {
            return this.elementData;
        }
        this.elementData = new byte[this.elementSize];
        if (this.read(this.elementData, 0, this.elementSize) != this.elementSize) {
            return null;
        }
        return this.elementData;
    }

    public int getElementStatus() throws IOException {
        int status = this.verifier.verify(this.getElementData());
        if (status == 2) {
            System.out.println("Signature error for " + this.elementName);
        }
        return status;
    }

    public void close() throws IOException {
        this.gis.close();
    }

    private void initSignature() throws IOException {
        this.verifier = new SignatureVerifier();
        this.readNextElementInfo();
        if (this.elementName == null || !this.elementName.equals(SIG_FILENAME)) {
            return;
        }
        this.verifier.init(this.getElementData());
        this.readNextElementInfo();
    }

    private void skipElementData() throws IOException {
        if (this.elementData != null) {
            return;
        }
        if (this.elementSize == 0) {
            return;
        }
        this.skip(this.elementSize);
    }

    private long skip(long nofBytes) throws IOException {
        long bytesRead = 0L;
        while (nofBytes > 0L) {
            long n = this.gis.skip(nofBytes);
            if (n < 0L) break;
            bytesRead += n;
            nofBytes -= n;
        }
        return bytesRead;
    }

    private int read(byte[] buffer, int ofs, int nofBytes) throws IOException {
        int bytesRead = 0;
        while (nofBytes > 0) {
            int n = this.gis.read(buffer, ofs, nofBytes);
            if (n < 0) break;
            bytesRead += n;
            ofs += n;
            nofBytes -= n;
        }
        return bytesRead;
    }

    private int get2(int ofs) {
        return this.buf[ofs] & 0xFF | (this.buf[ofs + 1] & 0xFF) << 8;
    }

    private long get4(int ofs) {
        return (long)(this.buf[ofs] & 0xFF | (this.buf[ofs + 1] & 0xFF) << 8) | (long)(this.buf[ofs + 2] & 0xFF) << 16 | (long)(this.buf[ofs + 3] & 0xFF) << 24;
    }
}

