<!-- Copyright (c) 2005 by Cisco Systems, Inc. -->
// smartports.js - Will create the ports panel for Pilsner devices.
// <include a list of SKUs here>
/*
	WS-C2960G-24TC-L 	:	20G ports + 4G TX
	WS-C2960-24TC-L 	:	24 ports + 2G TX
	WS-C2960-24TT-L		:	48 ports + 2G
	WS-C2960-48TC-L		:	48 ports + 2G TX
	WS-C2960-48TT-L		:	24 ports + 2G
	WS-C2960G-48TC-L	:	44 ports + 4G TX
	WS-C2960-8TC-L		:   8 ports  + 1G 
	WS-C2960G-8TC-L     :   7 ports  +1G 
 */

function createDevice(deviceType, uiPortDataArr) {
	var device = null;
	if(deviceType == null)
		return device;	
	if(deviceType == "WS-C2960G-24TC-L") {
		device = new WSC2960G24TCL(uiPortDataArr);
	} else if(deviceType == "WS-C2960-24TC-L" || deviceType == "WS-C2960-24TT-L") {
		device = new WSC296024TCL(uiPortDataArr);
	} else if(deviceType == "WS-C2960-48TC-L" || deviceType == "WS-C2960-48TT-L") {
		device = new WSC296048TCL(uiPortDataArr);
	} else if(deviceType == "WS-C2960G-48TC-L") {
		device = new WSC2960G48TCL(uiPortDataArr);
	}else if (deviceType == "WS-C2960-8TC-L" || deviceType == "WS-C2960G-8TC-L"){
		device = new WSC29608_1_composite(uiPortDataArr);	
	}
}

function WSC2960G24TCL(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	document.writeln('<tr>');
	//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId=0; portId<portCount-4; portId++) {
  		// This is extra space between port groups
		if(portId == 10) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if (portId % 2 == 0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}
		
		
		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();
		document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();
		writeSpaceCell();
		document.writeln('</tr>');
		
		document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4"></td></tr>');
		document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4"></td></tr>');
		
		//Second row ports
		document.writeln('<tr>');
		writeSpaceCell();writeSpaceCell();writeSpaceCell();
		//document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		
		
		for (var portId=0; portId<portCount-4; portId++) {
			// This is extra space between port groups
			if(portId == 10) {
				document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
			}
			//Even numbered ports in second row
			if (portId % 2 != 0) {
				document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			}
		}				  

		document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
		
		//Gigabit port at the end of second row
		for (var portId=portCount-4; portId<portCount; portId++) {
			document.writeln('\
					<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
					face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
					</font><a href="javascript:void(0)"\
					onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
					onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
					onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
					onMouseUp="window.status=\'\'; return true"\
					onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
					src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
					border="0"\
				    width="21" height="21" name="cell', '_', portId, '"></a></td>');
			writeSpaceCell();writeSpaceCell();
		}
		writeSpaceCell();
		document.writeln('</tr>');
		document.writeln('<tr><td colspan= "30" height="5" bgcolor="#f4f4f4">');
    	document.writeln('</td></tr>');
}

function WSC296024TCL(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "28" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if( portId == 11) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Odd numbered ports in first row
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	
	//Empty rows for padding
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4"></td></tr>');	
	document.writeln('<tr><td colspan= "28" height="3" bgcolor="#f4f4f4"></td></tr>');
	
	//Second row ports
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
	for (var portId=0; portId<portCount-2; portId++) {
		//Space between port groups
		if( portId == 12) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();

	for (var portId = portCount-2; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();
	}
	
	//writeSpaceCell();	writeSpaceCell();
	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC296048TCL(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
  		// This is extra space between port groups
		if(portId == 11 || portId == 23 || portId == 35) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "42" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-2; portId++) {
		// This is extra space between port groups
		if(portId == 12 || portId == 24 || portId == 36) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-2; portId<portCount ; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "42" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC2960G48TCL(uiPortDataArr) {
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	//First row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-4; portId++) {
  		// This is extra space between port groups
		if(portId == 15 || portId == 31) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}

		//Odd numbered ports in first row		
		if ( portId % 2 ==0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	
	//Cells to compensate for Gigabit ports in second row
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	document.writeln('<td nowrap width="21" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
		
	//Padding rows
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4"></td></tr>');
	document.writeln('<tr><td colspan= "50" height="3" bgcolor="#f4f4f4"></td></tr>');
		
	//Second row ports
	document.writeln('<tr>');
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');writeSpaceCell();writeSpaceCell();writeSpaceCell();//writeSpaceCell();
	for (var portId=0; portId<portCount-4; portId++) {
		// This is extra space between port groups
		if(portId == 16 || portId == 32) {
			document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
		}
		//Even numbered ports in second row
		if ( portId % 2 !=0) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
		}
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');

	//Gigabit ports in second row
	for (var portId = portCount-4; portId<portCount ; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
				writeSpaceCell();writeSpaceCell();writeSpaceCell();
	}
		
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();	writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "50" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function WSC29608_1_composite(uiPortDataArr){
	portCount = uiPortDataArr.length;
	document.writeln('<tr><td colspan= "30" height="3" bgcolor="#f4f4f4">');
   	document.writeln('</td></tr>');
	
	document.writeln('<tr>');
	writeSpaceCell();writeSpaceCell();writeSpaceCell();writeSpaceCell();
	
		for (var portId=0; portId<portCount-1; portId++) {
			document.writeln('\
				<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
				face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
				</font><a href="javascript:void(0)"\
				onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
				onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
				onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
				onMouseUp="window.status=\'\'; return true"\
				onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
				src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
				border="0"\
				width="21" height="21" name="cell', '_', portId, '"></a></td>');
	}
	
	document.writeln('<td nowrap width="10" bgcolor="#f4f4f4">&nbsp;</td>');
	writeSpaceCell();	writeSpaceCell();
	for (var portId = portCount-1; portId < portCount ; portId++) {
		document.writeln('\
		<td align="center" width="21" bgcolor="#f4f4f4"><font style="font-size:9px"\
		face="Helvetica">', getPortLabel(uiPortDataArr[portId].portName), '<br>\
		</font><a href="javascript:void(0)"\
		onMouseOver="showPortInfo(\'', portId, '\', \'', uiPortDataArr[portId].portName, '\', \'', uiPortDataArr[portId].vlan, '\')"\
		onMouseOut="resetPort(); hideLayerWrapper(2000); raise(\'', portId, '\')"\
		onMouseDown="lower(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\')"\
		onMouseUp="window.status=\'\'; return true"\
		onClick="toggle(\'', portId, '\', \'', uiPortDataArr[portId].macro, '\'); return false"><img\
		src="', cellImages[0][uiPortDataArr[portId].macro].src, '"\
		border="0"\
		width="21" height="21" name="cell', '_', portId, '"></a></td>');
		writeSpaceCell();writeSpaceCell();
	}
	
	writeSpaceCell();writeSpaceCell();
	document.writeln('</tr>');
	document.writeln('<tr><td colspan= "28" height="5" bgcolor="#f4f4f4">');
	document.writeln('</td></tr>');
}

function getPortLabel(intName) {
	var tmpStr = intName.substring(intName.indexOf('/')+1);
	var intNumber = tmpStr.substring(tmpStr.indexOf('/')+1);
	return parseInt(intNumber)
}

function isExtVlanSupported() {
	return true;
}

function getMaxVlans() {
  	return 250;	
}