<!-- Copyright (c) 2009-2013, 2016 by Cisco Systems, Inc. -->
// discover.js - for C2960S devices.
/*Support added for Stout devices :
Updated PIDs.
	Murphys : WS-C2960S-48FPD-L,WS-C2960S-48LPD-L,WS-C2960S-24PD-L,WS-C2960S-48TD-L,WS-C2960S-24TD-L
	Guinness: WS-C2960S-48FPS-L,WS-C2960S-48LPS-L,WS-C2960S-24PS-L,WS-C2960S-48TS-L,WS-C2960S-24TS-L
	Beamish	: WS-C2960S-48TS-S,WS-C2960S-24TS-S
StoutFE PIDS.
	Guinness: WS-C2960S-F48FPS-L,WS-C2960S-F48LPS-L,WS-C2960S-F24PS-L,WS-C2960S-F48TS-L,WS-C2960S-F24TS-L
	Beamish	: WS-C2960S-F48TS-S,WS-C2960S-F24TS-S	
Porter PIDS.	
	Fullers : WS-C2960X-48FPD-L,WS-C2960X-48LPD-L,WS-C2960X-48TD-L,WS-C2960X-24PD-L,WS-C2960X-24TD-L
    Sierra  : WS-C2960X-48FPS-L,WS-C2960X-48LPS-L,WS-C2960X-24PS-L,WS-C2960X-48TS-L,WS-C2960X-24TS-L,WS-C2960X-24PSK-L( Not supported in porter release )
    Alaskan : WS-C2960X-48TS-LL,WS-C2960X-24TS-LL,WS-C2960X-24PS-S( Not supported in porter release ),WS-C2960X-48LPS-S( Not supported in porter release )
KingFisher PIDS.	
	Fullers : WS-C2960XR-48FPD-I,WS-C2960XR-48LPD-I,WS-C2960XR-48TD-I,WS-C2960XR-24PD-I,WS-C2960XR-24TD-I
			  WS-C2960XR-48FPD-L,WS-C2960XR-48LPD-L,WS-C2960XR-48TD-L,WS-C2960XR-24PD-L,WS-C2960XR-24TD-L
	Sierra  : WS-C2960XR-48LPS-I,WS-C2960XR-48FPS-I,WS-C2960XR-48TS-I,WS-C2960XR-24PS-I,WS-C2960XR-24TS-I
			  WS-C2960XR-48LPS-L,WS-C2960XR-48FPS-L,WS-C2960XR-48TS-L,WS-C2960XR-24PS-L,WS-C2960XR-24TS-L
*/
//////////////////////////////////////////////////////////////////////////////////////////////

function addLabel( dev, label1 )
{	
	
	var image1 = "images/port_label_"+label1+".gif";
	switch (label1)
	{
		case 1:
			// Adding the ten gb port label1
			var portlbtl = new top.portLabel(565, 67, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 2:
			// Adding the ten gb port label2
			var portlbtl = new top.portLabel(602, 67, 7, 5, image1);
			portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;

		case 25:
			 var portlbtl = new top.portLabel(563, 67, 7, 5, image1);
	 	     portlbtl.id = "portlbtl1";
			dev.addPortLabel(portlbtl);
			break;
		case 26:
			var portlbtl = new top.portLabel(600, 67, 7, 5, image1);
			portlbtl.id = "portlbtl1";
		    dev.addPortLabel(portlbtl); 
			break;
		case 49:
			var portlbl = new top.portLabel(565, 67, 7, 5, image1);
	      	portlbl.id = "portlbl1";
	        dev.addPortLabel(portlbl);
			break;
		case 50:
			var portlbl = new top.portLabel(602, 67, 7, 5, image1);
	        portlbl.id = "portlbl1";
		    dev.addPortLabel(portlbl);
			break;
	}
}

function construct_Murphys_Guinnes_PoE_Leds(dev) {
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 22;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 34;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 41;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 53;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 59;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;

	//construct Power LEDs
	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 64;
	tempLed.id = "poe_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;

	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

		
}
function construct_Murphys_Guinnes_Leds(dev) {
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 22;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 34;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 41;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 47;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 53;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9;
	tempLed.y = 59;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;


	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;

		
}
function construct_Beamish_Leds(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 22;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 28;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 40;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 46;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 9; //8;
	tempLed.y = 52;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;

	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
	
}

//Start of Stout devices
function WS_C2960XS_48PD_L(int_status, media_type, deviceType) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	if(deviceType=="WS-C2960S-48FPD-L") { 
		dev.type= "WS-C2960S-48FPD-L"; 
		dev.image = "images/C2960XS_48FPD_L.gif";	
		}
	else if (deviceType=="WS-C2960S-48LPD-L") { 
		dev.type="WS-C2960S-48LPD-L";
		dev.image = "images/C2960XS_48LPD_L.gif"; 
	}
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/49") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,49);
	}
	
	if (interfaces.indexOf("0/50") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//606;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,50);
	}
	
	if (interfaces.indexOf("0/49") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);
	}
		if (interfaces.indexOf("0/50") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,2);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}

function WS_C5260S_48PD_L(int_status, media_type, deviceType) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	if(deviceType=="SW-5260S-48FPD-L") { 
		dev.type= "SW-5260S-48FPD-L"; 
		dev.image = "images/C5260S_48FPD_L.gif";	
		}
	else if (deviceType=="SW-5260S-48LPD-L") { 
		dev.type="SW-5260S-48LPD-L";
		dev.image = "images/C5260S_48LPD_L.gif"; 
	}
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/49") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,49);
	}
	
	if (interfaces.indexOf("0/50") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//606;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,50);
	}
	
	if (interfaces.indexOf("0/49") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);
	}
		if (interfaces.indexOf("0/50") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,2);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}


function WS_C2960XS_48TD_L(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.type="WS-C2960S-48TD-L";
	dev.image = "images/C2960XS_48TD_L.gif";	
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);
	 
	 // Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/49") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,49);
	}
	
	if (interfaces.indexOf("0/50") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//606;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,50);
	}
	
	if (interfaces.indexOf("0/49") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);
	}
		if (interfaces.indexOf("0/50") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,2);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
	
}

function WS_C5260S_48TD_L(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.type="SW-5260S-48TD-L";
	dev.image = "images/C5260S_48TD_L.gif";	
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);
	 
	 // Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 48;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/49") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,49);
	}
	
	if (interfaces.indexOf("0/50") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//606;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,50);
	}
	
	if (interfaces.indexOf("0/49") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 559;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);
	}
		if (interfaces.indexOf("0/50") == -1) {
		// Add the 2 SFP ports.
		xPortCoord = 595;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,2);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
	
}


function WS_C2960XS_24PD_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.type="WS-C2960S-24PD-L";
	dev.image = "images/C2960XS_24PD_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 301;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/25") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,25);
	}
	
	if (interfaces.indexOf("0/26") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 593;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,26);
	}
	
	if (interfaces.indexOf("0/25") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 557;
		yPortCoord = 47;	
		for(i=portInd; i<portInd+1; i++) {
		port = new top.SFPplusport(int_status[i][6], portImages);
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);

	}
	if (interfaces.indexOf("0/26") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 593;
		yPortCoord = 47;	
		for(i=portInd; i<portInd+1; i++) {
		port = new top.SFPplusport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		}
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	return dev;
}

function WS_C5260S_24PD_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.type="SW-5260S-24PD-L";
	dev.image = "images/C5260S_24PD_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 301;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/25") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,25);
	}
	
	if (interfaces.indexOf("0/26") != -1) {
		// Add the 2 SFP ports.
		xPortCoord = 593;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,26);
	}
	
	if (interfaces.indexOf("0/25") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 557;
		yPortCoord = 47;	
		for(i=portInd; i<portInd+1; i++) {
		port = new top.SFPplusport(int_status[i][6], portImages);
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);

	}
	if (interfaces.indexOf("0/26") == -1)
	{
		// Add the 1 10G X2 module
		xPortCoord = 593;
		yPortCoord = 47;	
		for(i=portInd; i<portInd+1; i++) {
		port = new top.SFPplusport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = portInd;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + portInd;
		dev.addPort(port);
		}
		addLabel(dev,2);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	return dev;
}

function WS_C2960XS_24TD_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.type="WS-C2960S-24TD-L";
	dev.image = "images/C2960XS_24TD_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 301;//292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/25") != -1) {
		// Add the 1G (SFP) ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,25);
	} 
	if (interfaces.indexOf("0/26") != -1) {
		// Add the 1G SFP ports.
		xPortCoord = 593;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,26);
	} 
	
	if (interfaces.indexOf("0/25") == -1) {
		// Add the SFP+ (Te1) ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);
	}
	
	if (interfaces.indexOf("0/26") == -1) {	
		// Add the SFP+ (Te2) port.
		xPortCoord = 593;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,2);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}

function WS_C5260S_24TD_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.type="SW-5260S-24TD-L";
	dev.image = "images/C5260S_24TD_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 301;//292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	var intNames = new Array();
	var portInd = 24;
	for (i=0; i< int_status.length; i++) intNames[i] = int_status[i][0];
	var interfaces = "#"+intNames.join('#')+"#";

	if (interfaces.indexOf("0/25") != -1) {
		// Add the 1G (SFP) ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,25);
	} 
	if (interfaces.indexOf("0/26") != -1) {
		// Add the 1G SFP ports.
		xPortCoord = 593;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,26);
	} 
	
	if (interfaces.indexOf("0/25") == -1) {
		// Add the SFP+ (Te1) ports.
		xPortCoord = 557;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,1);
	}
	
	if (interfaces.indexOf("0/26") == -1) {	
		// Add the SFP+ (Te2) port.
		xPortCoord = 593;//551;//589;
		xPortGap = 3;//13;
		yPortCoord = 47;//23;
		for(i=portInd; i<portInd+1; i++) {
			port = new top.SFPplusport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
		portInd+=1;
		addLabel(dev,2);
	}
	
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}


function WS_C2960XS_48PS_L(int_status, media_type, deviceType) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960S-48FPS-L") dev.image = "images/C2960XS_48FPS_L.gif";	
	else if (deviceType == "WS-C2960S-48LPS-L") dev.image = "images/C2960XS_48LPS_L.gif";
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//560;
	xPortGap = 5;//13;
	yPortCoord = 48;//23;
	for(i=48; i<52; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}
function WS_C5260S_48PS_L(int_status, media_type, deviceType) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	if(deviceType == "SW-5260S-48FPS-L") dev.image = "images/C5260S_48FPS_L.gif";	
	else if (deviceType == "SW-5260S-48LPS-L") dev.image = "images/C5260S_48LPS_L.gif";
	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//560;
	xPortGap = 5;//13;
	yPortCoord = 48;//23;
	for(i=48; i<52; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}
function WS_C2960XS_24PS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_24PS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 604;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 552;//589;
	xPortGap = 5;//13;
	yPortCoord = 49;//23;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}
function WS_C5260S_24PS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C5260S_24PS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_PoE_Leds(dev);
	
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 604;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 552;//589;
	xPortGap = 5;//13;
	yPortCoord = 49;//23;
	for(i=24; i<28; i++) {
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");
	return dev;
}

function WS_C2960XS_24TS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_24TS_L.gif";	
    	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 605;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;
	var xPortStartPos = 292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 553;//589;
	xPortGap = 5;//13;
	yPortCoord = 49;//23;
	for(i=24; i<28; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
function WS_C5260S_24TS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 28;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C260S_24TS_L.gif";	
    	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 605;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;
	var xPortStartPos = 292;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 553;//589;
	xPortGap = 5;//13;
	yPortCoord = 49;//23;
	for(i=24; i<28; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}


function WS_C2960X_48TS_S(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960X_48TS_S.gif";	
	// Construct the mode button and the system LEDs
	construct_Beamish_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//551;//589;
	xPortGap = 25;//13;
	yPortCoord = 48;//23;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
	
}

function WS_C5260_48TS_S(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 50;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C5260_48TS_S.gif";	
	// Construct the mode button and the system LEDs
	construct_Beamish_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 611;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
	
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 49;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//551;//589;
	xPortGap = 25;//13;
	yPortCoord = 48;//23;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}
	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
	
}


function WS_C2960X_24TS_S(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960X_24TS_S.gif";
	// Construct the mode button and the system LEDs
	construct_Beamish_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 302;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 24;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 40;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//589;
	xPortGap = 26;//13;
	yPortCoord = 47;//23;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}
function WS_C5260_24TS_S(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 26;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C5260_24TS_S.gif";
	// Construct the mode button and the system LEDs
	construct_Beamish_Leds(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 302;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 24;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 40;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//589;
	xPortGap = 26;//13;
	yPortCoord = 47;//23;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	return dev;
}


function WS_C2960XS_48TS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C2960XS_48TS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;//23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;
	var xPortStartPos = 49;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35)
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//589;
	xPortGap = 5;//13;
	yPortCoord = 48;//23;
	for(i=48; i<52; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
// End of Stout Family
function WS_C5260S_48TS_L(int_status, media_type) {
    var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	dev.image = "images/C5260S_48TS_L.gif";	

	// Construct the mode button and the system LEDs
	construct_Murphys_Guinnes_Leds(dev);

	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 612;
	tempLed.y = 24;//23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;
	var xPortStartPos = 49;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35)
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 558;//589;
	xPortGap = 5;//13;
	yPortCoord = 48;//23;
	for(i=48; i<52; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	return dev;
}
//Start of Stout devices
function createLEDS(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 10; //8;
	tempLed.y = 23;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;
	if(dev.type == "WS-C2960S-F48FPS-L" ||  dev.type == "WS-C2960S-F48LPS-L" || dev.type == "WS-C2960S-F24PS-L" 
		|| dev.type == "WS-C2960S-F24TS-L" ||  dev.type == "WS-C2960S-F48TS-L" 
|| dev.type == "SW-5260S-F48FPS-L" 
||  dev.type == "SW-5260S-F48LPS-L" 
|| dev.type == "SW-5260S-F24PS-L" 
|| dev.type == "SW-5260S-F24TS-L" 
||  dev.type == "SW-5260S-F48TS-L" )// || dev.deviceType == "WS-C2960S-F48TS-L" || dev.deviceType == "WS-C2960S-F48FPS-L" ||  dev.deviceType == "WS-C2960S-F48LPS-L"
	{
	
		tempLed = new top.led(ledImages);
		tempLed.x = 10; //8;
		tempLed.y = 28;
		tempLed.id = "master_led";
		tempLed.device = dev;
		dev.sysleds["MASTER"] = tempLed;
	}
	
	tempLed = new top.led(ledImages);
	tempLed.x = 10; //8;
	tempLed.y = 35;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10; //8;
	tempLed.y = 41;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 10; //8;
	tempLed.y = 47;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	if(dev.type == "WS-C2960S-F48FPS-L" ||  dev.type == "WS-C2960S-F48LPS-L" || dev.type == "WS-C2960S-F24PS-L" || dev.type == "WS-C2960S-F24TS-L" ||  dev.type == "WS-C2960S-F48TS-L"
	  || dev.type == "SW-5260S-F48FPS-L" 
	  ||  dev.type == "SW-5260S-F48LPS-L" 
	  || dev.type == "SW-5260S-F24PS-L" 
	  || dev.type == "SW-5260S-F24TS-L" 
	  ||  dev.type == "SW-5260S-F48TS-L")
	{
		tempLed = new top.led(ledImages);
		tempLed.x = 10; //8;
		tempLed.y = 53;
		tempLed.id = "stack_led";
		tempLed.device = dev;
		dev.sysleds["STACK"] = tempLed;
	} 	
	if(dev.type == "WS-C2960S-F48FPS-L" ||  dev.type == "WS-C2960S-F48LPS-L" || dev.type == "WS-C2960S-F24PS-L"
	|| dev.type == "SW-5260S-F48FPS-L" 
	||  dev.type == "SW-5260S-F48LPS-L" 
	|| dev.type == "SW-5260S-F24PS-L" )// || dev.deviceType == "WS-C2960S-F48TS-L" || dev.deviceType == "WS-C2960S-F48FPS-L" ||  dev.deviceType == "WS-C2960S-F48LPS-L"
	{
		tempLed = new top.led(ledImages);
		tempLed.x = 10; //8;
		tempLed.y = 59;
		tempLed.id = "poe_led";
		tempLed.device = dev;
		dev.sysleds["POWER"] = tempLed;
	}
	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 29;//42;
	modeBtn.y = 66;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
	
}

function stoutFE_48ports(int_status, media_type, deviceType) {

	var dev = new top.device();
	dev.type = deviceType;
	dev.x=0;
	dev.y=0
	if(deviceType == "WS-C2960S-F48TS-S")
	{
		dev.image = "images/WS-C2960S-F48TS-S.gif";
		dev.noofports = 50;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	}
	else if(deviceType == "WS-C2960S-F48TS-L")
	{
		dev.image = "images/WS-C2960S-F48TS-L.gif";
		dev.noofports = 52;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	}
	else if(deviceType == "WS-C2960S-F48FPS-L")
	{
		dev.image = "images/WS-C2960S-F48FPS-L.gif";
		dev.noofports = 52;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	}
	else if(deviceType == "WS-C2960S-F48LPS-L")
	{
		dev.image = "images/WS-C2960S-F48LPS-L.gif";
		dev.noofports = 52;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	}
	// Construct the mode button and the system LEDs
	createLEDS(dev);
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 609;
	tempLed.y = 24;//23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 5;//18;
	var xPortStartPos = 52;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35)
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	// Add the 2 SFP ports.
	xPortCoord = 555;//589;
	xPortGap = 3;//13;
	yPortCoord = 48;//23;
	portWidth  = 21;
	if(dev.noofports == 50)
	{
		xPortGap = 15;
	}
	
	for(i=48; i<dev.noofports; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}	
	
	return dev;
}

function stoutFE5260_48ports(int_status, media_type, deviceType) {

	var dev = new top.device();
	dev.type = deviceType;
	dev.x=0;
	dev.y=0
	if(deviceType == "SW-5260S-F48TS-S")
	{
		dev.image = "images/WS-C5260S-F48TS-S.gif";
		dev.noofports = 50;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	}
	else if(deviceType == "SW-5260S-F48TS-L")
	{
		dev.image = "images/WS-C5260S-F48TS-L.gif";
		dev.noofports = 52;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	}
	else if(deviceType == "SW-5260S-F48FPS-L")
	{
		dev.image = "images/WS-C5260S-F48FPS-L.gif";
		dev.noofports = 52;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	}
	else if(deviceType == "SW-5260S-F48LPS-L")
	{
		dev.image = "images/WS-C5260S-F48LPS-L.gif";
		dev.noofports = 52;	
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	}
	// Construct the mode button and the system LEDs
	createLEDS(dev);
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 609;
	tempLed.y = 24;//23;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 5;//18;
	var xPortStartPos = 52;//247;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<48; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35)
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}
	
	// Add the 2 SFP ports.
	xPortCoord = 555;//589;
	xPortGap = 3;//13;
	yPortCoord = 48;//23;
	portWidth  = 21;
	if(dev.noofports == 50)
	{
		xPortGap = 15;
	}
	
	for(i=48; i<dev.noofports; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}	
	
	return dev;
}


function stoutFE_24ports(int_status, media_type,deviceType) {
    var dev = new top.device();
	dev.type = deviceType;
	dev.noofports = 26;	
	dev.x=0;
	dev.y=0
	if(deviceType == "WS-C2960S-F24TS-S")
	{
		dev.image = "images/WS-C2960S-F24TS-S.gif";
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	}
	else if(deviceType == "WS-C2960S-F24TS-L")
	{
		dev.image = "images/WS-C2960S-F24TS-L.gif";
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	}
	else if(deviceType == "WS-C2960S-F24PS-L")
	{
		dev.image = "images/WS-C2960S-F24PS-L.gif";
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	}
	
	// Construct the mode button and the system LEDs
	createLEDS(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 609;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 5;//18;//20;
	var xPortStartPos = 300;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 555;//589;
	xPortGap = 15;//13;
	yPortCoord = 48;//23;
	portWidth  = 21;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	return dev;
}

function stoutFE5260_24ports(int_status, media_type,deviceType) {
    var dev = new top.device();
	dev.type = deviceType;
	dev.noofports = 26;	
	dev.x=0;
	dev.y=0
	if(deviceType == "SW-5260S-F24TS-S")
	{
		dev.image = "images/WS-C5260S-F24TS-S.gif";
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED");	
	}
	else if(deviceType == "SW-5260S-F24TS-L")
	{
		dev.image = "images/WS-C5260S-F24TS-L.gif";
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK");	
	}
	else if(deviceType == "SW-5260S-F24PS-L")
	{
		dev.image = "images/WS-C5260S-F24PS-L.gif";
		dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK","PoE");	
	}
	
	// Construct the mode button and the system LEDs
	createLEDS(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 609;
	tempLed.y = 24;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;

	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 5;//18;//20;
	var xPortStartPos = 300;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 26;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 42;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	xPortCoord = 555;//589;
	xPortGap = 15;//13;
	yPortCoord = 48;//23;
	portWidth  = 21;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
	}

	return dev;
}
 
 
// Porter Supoort Started 
function createPorterLEDS(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 76; //8;
	tempLed.y = 3;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 76; //8;
	tempLed.y = 9;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 107; //8;
	tempLed.y = 3;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;
	
	// Porter relese WS-C2960X-24PSK-L  is not supportted from Platform
	if( dev.type != "WS-C2960X-48TS-LL" && dev.type != "WS-C2960X-24TS-LL")
	{
		tempLed = new top.led(ledImages);
		tempLed.x = 107; //8;
		tempLed.y = 9;
		tempLed.id = "stack_led";
		tempLed.device = dev;
		dev.sysleds["STACK"] = tempLed;
	}
	
	tempLed = new top.led(ledImages);
	tempLed.x = 136; //8;
	tempLed.y = 3;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	if( dev.type == "WS-C2960X-48TS-LL" || dev.type == "WS-C2960X-24TS-LL")
	{
		tempLed = new top.led(ledImages);
		tempLed.x = 107; //8;
		tempLed.y = 9;
		tempLed.id = "rps_led";
		tempLed.device = dev;
		dev.sysleds["RPS"] = tempLed;
	}
	else
	{	
		tempLed = new top.led(ledImages);
		tempLed.x = 136; //8;
		tempLed.y = 9;
		tempLed.id = "rps_led";
		tempLed.device = dev;
		dev.sysleds["RPS"] = tempLed;
	}
	if(dev.type == "WS-C2960X-48FPD-L" ||  dev.type == "WS-C2960X-48LPD-L" || dev.type == "WS-C2960X-24PD-L" || 
	   dev.type == "WS-C2960X-48FPS-L" || dev.type == "WS-C2960X-48LPS-L" || dev.type == "WS-C2960X-24PS-L" ) //|| dev.type == "WS-C2960X-24PS-S" || dev.type == "WS-C2960X-48LPS-S" 
	{
		tempLed = new top.led(ledImages);
		tempLed.x = 161; //8;
		tempLed.y = 3;
		tempLed.id = "poe_led";
		tempLed.device = dev;
		dev.sysleds["POWER"] = tempLed;
	}
	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 38;//42;
	modeBtn.y = 0;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}
 
function porter_48ports(int_status, media_type,deviceType) {
	var dev = new top.device();
	dev.type = deviceType;
	dev.x=0;
	dev.y=0;
	if(deviceType == "WS-C2960X-48FPD-L")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960X-48FPD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960X-48LPD-L")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960X-48LPD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960X-48TD-L")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960X-48TD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	/*else if(deviceType == "WS-C2960X-48LPS-S")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960X-48LPS-S.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}*/
	
	else if(deviceType == "WS-C2960X-48TS-LL")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960X-48TS-S.gif";
		dev.modeAliases = new Array ("STATUS","SPEED");	
	}
	else if(deviceType == "WS-C2960X-48FPS-L")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960X-48FPS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960X-48LPS-L")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960X-48LPS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}	
	else if(deviceType == "WS-C2960X-48TS-L")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960X-48TS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	// Construct the mode button and the system LEDs
	createPorterLEDS(dev);
	
	// Create Fa0 LED
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 11;
	tempLed.y = 27;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
		
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 39;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add SFP ports.
	if(deviceType == "WS-C2960X-48FPD-L" || deviceType == "WS-C2960X-48LPD-L" || deviceType == "WS-C2960X-48TD-L")
	{
		xPortCoord = 570;//551;//589;
		xPortGap = 13;//13;
		yPortCoord = 42;//23;
		for(i=48; i<50; i++) {       
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
	}
	else if(deviceType == "WS-C2960X-48TS-LL") //deviceType == "WS-C2960X-48LPS-S" || 
	{
	xPortCoord = 603;//589;
	xPortGap = 12;//13;
	yPortCoord = 26;//23;
	portWidth  = 21;
	for(i=48; i<50; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		if(i>48)
			yPortCoord = 46;
			
		port.y = yPortCoord;
		port.id = "port_" + i;
		//xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
		}	
	}
	else if(deviceType == "WS-C2960X-48FPS-L"  || deviceType == "WS-C2960X-48TS-L" || deviceType == "WS-C2960X-48LPS-L")
	{
		xPortCoord = 570;//551;//589;
		xPortGap = 13;//13;
		yPortCoord = 26;//23;
		
		for(i=48; i<52; i++) {
			yPortCoord = ((i%2) == 0 ?  26 : 46);
			if (i==50){
				xPortCoord += portWidth + xPortGap;
			}
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			
			dev.addPort(port);
		}
	}
	
	
	return dev;
	
}
 
function porter_24ports(int_status, media_type,deviceType) {
    var dev = new top.device();
	dev.type = deviceType;
	dev.x=0;
	dev.y=0
	//Alaskan
	if(deviceType == "WS-C2960X-24TS-LL")
	{
	dev.noofports = 26;
	dev.image = "images/WS-C2960X-24TS-S.gif";
	dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	/*else if(deviceType == "WS-C2960X-24PS-S")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960X-24PS-S.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	*/
	// Fullers
	else if(deviceType == "WS-C2960X-24TD-L")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960X-24TD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960X-24PD-L")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960X-24PD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}//Seeria
	else if(deviceType == "WS-C2960X-24TS-L")
	{
	    dev.noofports = 28;
		dev.image = "images/WS-C2960X-24TS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960X-24PS-L")
	{
	    dev.noofports = 28;
		dev.image = "images/WS-C2960X-24PS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	/*else if(deviceType == "WS-C2960X-24PSK-L")
	{
	    dev.noofports = 28;
		dev.image = "images/WS-C2960X-24PSK-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","POWER");	
	}*/
	// Construct the mode button and the system LEDs
	createPorterLEDS(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 11;
	tempLed.y = 27;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;


	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 295;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	
	if(deviceType == "WS-C2960X-24PD-L" || deviceType == "WS-C2960X-24TD-L")
	{
		xPortCoord = 570;//589;
		xPortGap = 12;//13;
		yPortCoord = 42;//23;
		portWidth  = 21;
		for(i=24; i<26; i++) {       
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
	}
	else if(deviceType == "WS-C2960X-24TS-LL")//deviceType == "WS-C2960X-24PS-S"
	{
	xPortCoord = 599;//589;
	xPortGap = 12;//13;
	yPortCoord = 26;//23;
	portWidth  = 21;
	for(i=24; i<26; i++) {       
		port = new top.SFPport(int_status[i][6], portImages);
		port.index = i;
		port.x = xPortCoord;
		if(i>24)
		yPortCoord = 46
		port.y = yPortCoord;
		port.id = "port_" + i;
		//xPortCoord += portWidth + xPortGap;
		dev.addPort(port);
						}
	}
    else if(deviceType == "WS-C2960X-24PS-L"  || deviceType == "WS-C2960X-24TS-L")
	{
		xPortCoord = 569;//551;//589;
		xPortGap = 14;//13;
		yPortCoord = 26;//23;
		
		for(i=24; i<28; i++) {
			yPortCoord = ((i%2) == 0 ?  26 : 46);
			if (i==26){
				xPortCoord += portWidth + xPortGap;
			}
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			
			dev.addPort(port);
		}
	}
	/*
	else if(deviceType == "WS-C2960X-24PSK-L")
	{
		xPortCoord = 555;//551;//589;
		xPortGap = 7;//13;
		yPortCoord = 45;//23;
		
		for(i=24; i<28; i++) {
			
			if(i < 26)
			{
				port = new top.rj45portInv(int_status[i][6], portImages);
				port.index = i;
				port.x = xPortCoord;
				port.y = yPortCoord;
				port.id = "port_" + i;
			}
			else
			{
				port = new top.SFPport(int_status[i][6], portImages);
				port.index = i;
				port.x = xPortCoord;
				port.y = yPortCoord;
				port.id = "port_" + i;
			}
			
			xPortCoord += portWidth + xPortGap;
			
			dev.addPort(port);
		}
	}
	*/
	return dev;
}
//Porter Support Ended 
 
// Kingfisher Supoort Started 
function createKingfisherLEDS(dev) 
{
	//Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 76; //8;
	tempLed.y = 3;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 107; //8;
	tempLed.y = 3;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 76; //8;
	tempLed.y = 9;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 107; //8;
	tempLed.y = 9;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 136; //8;
	tempLed.y = 3;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 161; //8;
	tempLed.y = 3;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;

	if(dev.type == "WS-C2960XR-48FPD-I" || dev.type == "WS-C2960XR-48LPD-I" || dev.type == "WS-C2960XR-48FPD-L" || dev.type == "WS-C2960XR-48LPD-L" ||
	   dev.type == "WS-C2960XR-48LPS-I" || dev.type == "WS-C2960XR-48FPS-I" || dev.type == "WS-C2960XR-48LPS-L" || dev.type == "WS-C2960XR-48FPS-L" ||
	   dev.type == "WS-C2960XR-24PD-I" || dev.type == "WS-C2960XR-24PD-L" || dev.type == "WS-C2960XR-24PS-I" || dev.type == "WS-C2960XR-24PS-L")
	{
		tempLed = new top.led(ledImages);
		tempLed.x = 136; //8;
		tempLed.y = 9;
		tempLed.id = "poe_led";
		tempLed.device = dev;
		dev.sysleds["POWER"] = tempLed;
	}
	// Create the Mode Btn
	//var modeBtn = new top.modebtn("images/pilsner2_mode.gif");
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 38;//42;
	modeBtn.y = 0;//66;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;
	
}

function kingfisher_48ports(int_status, media_type,deviceType) {
	var dev = new top.device();
	dev.type = deviceType;
	dev.x=0;
	dev.y=0;
	 
	//Fuller
	if(deviceType == "WS-C2960XR-48FPD-I")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960XR-48FPD-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48LPD-I")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960XR-48LPD-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48TD-I")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960XR-48TD-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960XR-48FPD-L")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960XR-48FPD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48LPD-L")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960XR-48LPD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48TD-L")
	{
		dev.noofports = 50;
		dev.image = "images/WS-C2960XR-48TD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	} //Serria 
	else if(deviceType == "WS-C2960XR-48LPS-I")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960XR-48LPS-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}	
	else if(deviceType == "WS-C2960XR-48FPS-I")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960XR-48FPS-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48TS-I")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960XR-48TS-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960XR-48LPS-L")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960XR-48LPS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48FPS-L")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960XR-48FPS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-48TS-L")
	{
		dev.noofports = 52;
		dev.image = "images/WS-C2960XR-48TS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	
	
	// Construct the mode button and the system LEDs
	createKingfisherLEDS(dev);
	
	// Create Fa0 LED
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 11;
	tempLed.y = 27;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;
		
	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;
	var xPortStartPos = 39;//69;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 !=0 ) {
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 || i==35 ){
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add SFP ports.
	if(deviceType == "WS-C2960XR-48FPD-I" || deviceType == "WS-C2960XR-48LPD-I" || deviceType == "WS-C2960XR-48TD-I" || deviceType == "WS-C2960XR-48FPD-L" || deviceType == "WS-C2960XR-48LPD-L" || deviceType == "WS-C2960XR-48TD-L")
	{
		xPortCoord = 570;
		xPortGap = 13;
		yPortCoord = 42;
		for(i=48; i<50; i++) {       
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
	}
	else 
	{
		xPortCoord = 570;
		xPortGap = 13;
		yPortCoord = 26;
		
		for(i=48; i<52; i++) {
			yPortCoord = ((i%2) == 0 ?  26 : 46);
			if (i==50){
				xPortCoord += portWidth + xPortGap;
			}
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			
			dev.addPort(port);
		}
	}
		
	return dev;
}

function kingfisher_24ports(int_status, media_type,deviceType) {
    var dev = new top.device();
	dev.type = deviceType;
	dev.x=0;
	dev.y=0
	
	//Fuller
	if(deviceType == "WS-C2960XR-24TD-I")
	{
		dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24TD-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960XR-24TD-L")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24TD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960XR-24PD-L")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24PD-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-24PD-I")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24PD-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}//Seeria
	if(deviceType == "WS-C2960XR-24TS-I")
	{
		dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24TS-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960XR-24TS-L")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24TS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK");	
	}
	else if(deviceType == "WS-C2960XR-24PS-L")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24PS-L.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	else if(deviceType == "WS-C2960XR-24PS-I")
	{
	    dev.noofports = 26;
		dev.image = "images/WS-C2960XR-24PS-I.gif";
		dev.modeAliases = new Array ("STATUS","SPEED","STACK","POWER");	
	}
	// Construct the mode button and the system LEDs
	createKingfisherLEDS(dev);
	
	// Create Fa0 LED
	var fa0_rj45portImage = top.rj45portInvImages();
	tempLed = new top.led(fa0_rj45portImage);
	tempLed.x = 11;
	tempLed.y = 27;
	tempLed.id = "fa_0";
	tempLed.width = 19;
	tempLed.height = 15;
	tempLed.device = dev;
	tempLed.showPopup = true;
	dev.sysleds["FA0"] = tempLed;


	// Create the Ports.
	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 9;//18;//20;
	var xPortStartPos = 295;//292;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 24 FastEthernet ports in 2 groups of 12 each.
	for(i=0; i<24; i++) 
	{
		if(i%2 == 0) 
		{
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} 
		else
		{
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if( i%2 !=0 ) 
		{
			xPortCoord += portWidth + xPortGap;
		}
		if ( i==11 || i == 23 )
		{
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
	}

	// Add the 2 SFP ports.
	if(deviceType == "WS-C2960XR-24PD-I" || deviceType == "WS-C2960XR-24TD-I" || deviceType == "WS-C2960XR-24PD-L" || deviceType == "WS-C2960XR-24TD-L")
	{
		xPortCoord = 570;//589;
		xPortGap = 12;//13;
		yPortCoord = 42;//23;
		portWidth  = 21;
		for(i=24; i<26; i++) {       
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			xPortCoord += portWidth + xPortGap;
			dev.addPort(port);
		}
	}
	else if(deviceType == "WS-C2960XR-24PS-I" || deviceType == "WS-C2960XR-24TS-I" || deviceType == "WS-C2960XR-24PS-L" || deviceType == "WS-C2960XR-24TS-L")
	{
		xPortCoord = 569;//551;//589;
		xPortGap = 14;//13;
		yPortCoord = 26;//23;
		
		for(i=24; i<28; i++) {
			yPortCoord = ((i%2) == 0 ?  26 : 46);
			if (i==26){
				xPortCoord += portWidth + xPortGap;
			}
			port = new top.SFPport(int_status[i][6], portImages);
			port.index = i;
			port.x = xPortCoord;
			port.y = yPortCoord;
			port.id = "port_" + i;
			
			dev.addPort(port);
		}
	}
	
	return dev;
}
// Kingfisher Supoort Ended
function createDevice(int_status, media_type, deviceType) {
	var device = null;
	if(deviceType == null) 
		return device;
	//Panda Support
	if(deviceType == "SW-5260S-48TS-L"){
		device = new WS_C5260S_48TS_L(int_status, media_type); 
	}else if(deviceType == "SW-5260S-24TS-L"){ 
		device = new WS_C5260S_24TS_L(int_status, media_type); 
	}else if(deviceType == "SW-5260S-48FPS-L" || deviceType == "SW-5260S-48LPS-L"  ){ 
		device = new WS_C5260S_48PS_L(int_status, media_type, deviceType); 
	}else if(deviceType == "SW-5260S-24PS-L"){ 
		device = new WS_C5260S_24PS_L(int_status, media_type); 
	}else if(deviceType == "SW-5260S-48TS-S"){ 
		device = new WS_C5260_48TS_S(int_status, media_type); 
	}else if(deviceType == "SW-5260S-24TS-S"){ 
		device = new WS_C5260_24TS_S(int_status, media_type); 
	}else if(deviceType == "SW-5260S-48TD-L"){ 
		device = new WS_C5260S_48TD_L(int_status, media_type); 
	}else if(deviceType == "SW-5260S-24TD-L"){ 
		device = new WS_C5260S_24TD_L(int_status, media_type); 
	}else if(deviceType == "SW-5260S-48FPD-L" || deviceType == "SW-5260S-48LPD-L"){   
		device = new WS_C5260S_48PD_L(int_status, media_type, deviceType); 
	}else if(deviceType == "SW-5260S-24PD-L"){ 
		device = new WS_C5260S_24PD_L(int_status, media_type); 
	}else if(deviceType == "SW-5260S-F24TS-S" || deviceType == "SW-5260S-F24TS-L" || deviceType == "SW-5260S-F24PS-L"){   
		device = new stoutFE5260_24ports(int_status, media_type, deviceType); 
	}else if(deviceType == "SW-5260S-F48TS-S" || deviceType == "SW-5260S-F48TS-L" || deviceType == "SW-5260S-F48FPS-L" ||  deviceType == "SW-5260S-F48LPS-L"){  
		device = new stoutFE5260_48ports(int_status, media_type, deviceType); 
	}
	// Stout Support
	else if(deviceType == "WS-C2960S-48FPD-L" || deviceType == "WS-C2960S-48LPD-L"){ //Murphys48FullPWR & Murphys48PWR  
		device = new WS_C2960XS_48PD_L(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960S-48TD-L"){ //Murphys48
		device = new WS_C2960XS_48TD_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24PD-L"){ //Murphys24PWR
		device = new WS_C2960XS_24PD_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24TD-L"){ //Murphys24
		device = new WS_C2960XS_24TD_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-48FPS-L" || deviceType == "WS-C2960S-48LPS-L"){ //Guinness48FullPWR & Guinness48PWR 
		device = new WS_C2960XS_48PS_L(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960S-48TS-L"){//Guinness48
		device = new WS_C2960XS_48TS_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24PS-L"){ //Guinness24PWR
		device = new WS_C2960XS_24PS_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24TS-L"){ //Guinness24
		device = new WS_C2960XS_24TS_L(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-48TS-S"){ //Beamish48
		device = new WS_C2960X_48TS_S(int_status, media_type); 
	}
	else if(deviceType == "WS-C2960S-24TS-S"){ //Beamish24
		device = new WS_C2960X_24TS_S(int_status, media_type); 
	}
	// StoutFE Support
	else if(deviceType == "WS-C2960S-F48TS-S" || deviceType == "WS-C2960S-F48TS-L" || deviceType == "WS-C2960S-F48FPS-L" ||  deviceType == "WS-C2960S-F48LPS-L"){ //Murphys48FullPWR & Murphys48PWR  
		device = new stoutFE_48ports(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960S-F24TS-S" || deviceType == "WS-C2960S-F24TS-L" || deviceType == "WS-C2960S-F24PS-L"){ //Murphys48FullPWR & Murphys48PWR  
		device = new stoutFE_24ports(int_status, media_type, deviceType); 
	}
	else if(deviceType == "WS-C2960X-48LPD-L" || deviceType =="WS-C2960X-48FPD-L" || deviceType == "WS-C2960X-48TD-L" || deviceType =="WS-C2960X-48FPS-L" || deviceType == "WS-C2960X-48LPS-L" || deviceType =="WS-C2960X-48TS-L" || deviceType =="WS-C2960X-48TS-LL")//|| deviceType == "WS-C2960X-48LPS-S" 
	{ //Sierra48
		device = new porter_48ports(int_status, media_type,deviceType); 
	}
	else if(deviceType == "WS-C2960X-24PD-L" || deviceType =="WS-C2960X-24TD-L" || deviceType == "WS-C2960X-24PS-L" || deviceType =="WS-C2960X-24TS-L"  || deviceType == "WS-C2960X-24TS-LL") //|| deviceType == "WS-C2960X-24PSK-L" || deviceType =="WS-C2960X-24PS-S" 
	{
	   device = new porter_24ports(int_status, media_type, deviceType);
	}
	else if(deviceType == "WS-C2960XR-48FPD-I" || deviceType == "WS-C2960XR-48LPD-I" || deviceType == "WS-C2960XR-48TD-I" || deviceType == "WS-C2960XR-48FPD-L" || deviceType == "WS-C2960XR-48LPD-L" || deviceType == "WS-C2960XR-48TD-L" ||
			deviceType == "WS-C2960XR-48LPS-I" || deviceType == "WS-C2960XR-48FPS-I" || deviceType == "WS-C2960XR-48TS-I" || deviceType == "WS-C2960XR-48LPS-L" || deviceType == "WS-C2960XR-48FPS-L" || deviceType == "WS-C2960XR-48TS-L")
	{ // Kingfisher 48 ports
		device = new kingfisher_48ports(int_status, media_type,deviceType); 
	}
	else if(deviceType == "WS-C2960XR-24PD-I" || deviceType == "WS-C2960XR-24TD-I" || deviceType == "WS-C2960XR-24PD-L" || deviceType == "WS-C2960XR-24TD-L" ||
			deviceType == "WS-C2960XR-24PS-I" || deviceType == "WS-C2960XR-24TS-I" || deviceType == "WS-C2960XR-24PS-L" || deviceType == "WS-C2960XR-24TS-L")
	{	// Kingfisher 24 ports 
		   device = new kingfisher_24ports(int_status, media_type, deviceType);
	}
	
	if(device != null) {
		device.type = deviceType;
		if(deviceType.indexOf("C2960S-F")!= -1)
			device.family ="2960-S-F";
		else if(deviceType.indexOf("C2960S-")!= -1)
			device.family ="2960-S";
		else if(deviceType.indexOf("C2960X-")!= -1)
			device.family ="2960-X";
		else if(deviceType.indexOf("C2960XR-")!= -1)
			device.family ="2960-XR";		
		else if(deviceType.indexOf("5260S-")!= -1)
			device.family ="5260-S";	
	}
	return device;
}
