<!-- Copyright (c) 2008 by Cisco Systems, Inc. -->
// discover.js - Will discover 2975 devices.

//////////////////////////////////////////////////////////////////////////////////////////////


function WSC2975GS_48PS_L(int_status, media_type) {
	var dev = new top.device();
	dev.noofports = 52;
	dev.x=0;
	dev.y=0;
	//dev.image = "images/c375048_4.gif";	
	dev.image = "images/c2975_48_4.gif";	

    drawLeds(dev);	

	var port;
	var portWidth = 19;
	var portImages = top.rj45portImages();
	var portInvImages = top.rj45portInvImages();
	var xPortGap = 1;
	var xPortGroupGap = 11;
	var xPortStartPos = 72;
	var xPortCoord = xPortStartPos;
	var yPortCoord;

	// Add the 48 FastEthernet ports in 4 groups of 12 each.
	for(i=0; i<48; i++) {       
		if(i%2 == 0) {
			yPortCoord = 27;
			port = new top.rj45portInv(portInvImages);
		} else {
			yPortCoord = 43;
			port = new top.rj45port(portImages);
		}
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 != 0) {
			xPortCoord += (portWidth + xPortGap);
		}
		if(i==15 || i == 31) {
			xPortCoord += (xPortGroupGap - xPortGap);
		}
		dev.addPort(port);
    }

	// Add the 4 SFP ports.
	xPortCoord = 587;
	xPortGap = 14;
	yPortCoord = 27;
	portWidth = 21;
	for(i=48; i<52; i++) {
		port = new top.SFPport(int_status[i][6], portImages); // pass the module type plugged-in the SFP slot
		port.index = i;
		port.x = xPortCoord;
		port.y = yPortCoord;
		port.id = "port_" + i;
		if(i%2 == 0) {
			yPortCoord = 49;//47;			
		} else {
			yPortCoord = 27;//25;
			xPortCoord += (portWidth + xPortGap);
		}

		dev.addPort(port);
	}	

	dev.modeAliases = new Array ("STATUS", "DUPLEX", "SPEED", "STACK", "PoE");	

	return dev;
}

//This should be reworked with the actual prototype
function drawLeds(dev) {

	// Create the Mode Btn
	var modeBtn = new top.modebtn("images/C9260_phase2_modebutton.gif");
	modeBtn.x = 42;//35;
	modeBtn.y = 67;//67;
	modeBtn.id = "mode_btn";
	modeBtn.device = dev;
	dev.modebtn = modeBtn;		

	// Create System LEDs
	var ledImages = top.ledImages();
	var tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 20;
	tempLed.id = "system_led";
	tempLed.device = dev;
	dev.sysleds["SYSTEM"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 26;
	tempLed.id = "rps_led";
	tempLed.device = dev;
	dev.sysleds["RPS"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 32;
	tempLed.id = "master_led";
	tempLed.device = dev;
	dev.sysleds["MASTER"] = tempLed;
		
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 38;
	tempLed.id = "status_led";
	tempLed.device = dev;
	dev.sysleds["STATUS"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 44;
	tempLed.id = "duplex_led";
	tempLed.device = dev;
	dev.sysleds["DUPLEX"] = tempLed;

	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 50;
	tempLed.id = "speed_led";
	tempLed.device = dev;
	dev.sysleds["SPEED"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 56;
	tempLed.id = "stack_led";
	tempLed.device = dev;
	dev.sysleds["STACK"] = tempLed;
	
	tempLed = new top.led(ledImages);
	tempLed.x = 13;
	tempLed.y = 62;
	tempLed.id = "power_led";
	tempLed.device = dev;
	dev.sysleds["POWER"] = tempLed;
}

function createDevice(int_status, media_type, deviceType) 
{
	var device = null;
	
	if(deviceType == null) 
		return device;

	if(deviceType == "WS-C2975GS-48PS-L") {
		device = new WSC2975GS_48PS_L(int_status, media_type);
	}
		
	if(device != null) {
		device.type = deviceType;
		device.family = "2975";
	}

	return device;
}
