/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableModel;

public class PortSecurityChild_JDialog
extends JDialog
implements ActionListener,
Runnable {
    boolean frameSizeAdjusted = false;
    JTextField JTextField1 = new JTextField();
    String[] status = new String[]{" ", "Enable", "Disable"};
    JPanel security_JPanel;
    JPanel security1_JPanel;
    JPanel security2_JPanel;
    JPanel violation_JPanel;
    JPanel trap_JPanel;
    JPanel shutdown_JPanel;
    JPanel address_JPanel;
    JPanel button_JPanel;
    JLabel status_JLabel;
    JLabel maxAddress_JLabel;
    JLabel sendTrap_JLabel;
    JLabel shutdown_JLabel;
    JTextField maxAddress_JTextField;
    JButton ok_JButton;
    JButton cancel_JButton;
    JButton help_JButton;
    JComboBox security_JCombo;
    JComboBox trap_JCombo;
    JComboBox shutdown_JCombo;
    CommonSwitch selectedSwitch;
    Thread psThread;
    Vector selectedPorts;
    Vector selectedDevices;
    boolean calledFromPortPopup = false;
    String[] modeSettings;
    PortSecurity_JDialog ps_JDialog;
    TableModel ps_TableModel;
    String initialSecurity = " ";
    String initialTrap = " ";
    String initialShutdown = " ";
    String initialAddressCount = "132";
    Hashtable settingInfo;
    Hashtable modeInfo;
    int index = 0;
    String[] portSettings = null;
    boolean updateIsNeeded = false;
    JApplet theApplet;

    public PortSecurityChild_JDialog(JApplet jApplet, PortSecurity_JDialog portSecurity_JDialog, Vector vector, Vector vector2) {
        this(jApplet, null);
        this.ps_JDialog = portSecurity_JDialog;
        this.selectedPorts = vector;
        this.selectedDevices = vector2;
        this.psThread = new Thread((Runnable)this, "ps");
        this.calledFromPortPopup = false;
        this.psThread.start();
    }

    public PortSecurityChild_JDialog(JApplet jApplet, Frame frame) {
        super(frame);
        this.theApplet = jApplet;
        this.setDefaultCloseOperation(2);
        this.setTitle("Port Security Configuration");
        this.getContentPane().setLayout(new GridLayout(4, 1, 0, 0));
        ((Component)this).setSize(320, 295);
        this.setVisible(false);
        this.security_JPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.security_JPanel.setBorder(BorderFactory.createTitledBorder("Port Security"));
        this.status_JLabel = new JLabel("Status:");
        this.security_JPanel.add((Component)this.status_JLabel, this.setGridBagConstraints(gridBagConstraints, 0, 0, 0.1, 0.1, 0, 0, 0, 17, 0, 0, 0, 0, 1, 1));
        this.security_JCombo = new JComboBox<String>(this.status);
        this.security_JCombo.addActionListener(this);
        this.security_JPanel.add((Component)this.security_JCombo, this.setGridBagConstraints(gridBagConstraints, 1, 0, 0.1, 0.0, 0, 0, 0, 13, 0, 0, 0, 0, 1, 1));
        this.getContentPane().add(this.security_JPanel);
        this.violation_JPanel = new JPanel(new GridBagLayout());
        this.violation_JPanel.setBorder(BorderFactory.createTitledBorder("Violation Action"));
        this.sendTrap_JLabel = new JLabel("Send Trap:");
        this.violation_JPanel.add((Component)this.sendTrap_JLabel, this.setGridBagConstraints(gridBagConstraints, 0, 0, 0.1, 0.1, 0, 0, 0, 17, 0, 0, 0, 0, 1, 1));
        this.trap_JCombo = new JComboBox<String>(this.status);
        this.trap_JCombo.addActionListener(this);
        this.violation_JPanel.add((Component)this.trap_JCombo, this.setGridBagConstraints(gridBagConstraints, 1, 0, 0.1, 0.1, 0, 0, 0, 13, 0, 0, 0, 0, 1, 1));
        this.shutdown_JLabel = new JLabel("Shutdown Port:");
        this.violation_JPanel.add((Component)this.shutdown_JLabel, this.setGridBagConstraints(gridBagConstraints, 0, 1, 0.1, 0.1, 0, 0, 0, 17, 0, 0, 0, 0, 1, 1));
        this.shutdown_JCombo = new JComboBox<String>(this.status);
        this.shutdown_JCombo.addActionListener(this);
        this.violation_JPanel.add((Component)this.shutdown_JCombo, this.setGridBagConstraints(gridBagConstraints, 1, 1, 0.1, 0.1, 0, 0, 0, 13, 0, 0, 0, 0, 1, 1));
        this.getContentPane().add(this.violation_JPanel);
        this.address_JPanel = new JPanel(new GridBagLayout());
        this.maxAddress_JLabel = new JLabel("Maximum Address Count (1-132):");
        this.address_JPanel.add((Component)this.maxAddress_JLabel, this.setGridBagConstraints(gridBagConstraints, 0, 0, 0.1, 0.1, 0, 0, 0, 17, 0, 0, 0, 0, 1, 1));
        this.maxAddress_JTextField = new JTextField(this.initialAddressCount, 8);
        this.address_JPanel.add((Component)this.maxAddress_JTextField, this.setGridBagConstraints(gridBagConstraints, 1, 0, 0.1, 0.1, 0, 0, 0, 13, 0, 0, 0, 0, 1, 1));
        this.getContentPane().add(this.address_JPanel);
        this.button_JPanel = new JPanel();
        this.ok_JButton = new JButton("OK");
        this.ok_JButton.addActionListener(this);
        this.button_JPanel.add(this.ok_JButton);
        this.cancel_JButton = new JButton("Cancel");
        this.cancel_JButton.addActionListener(this);
        this.button_JPanel.add(this.cancel_JButton);
        this.help_JButton = new JButton("Help");
        this.help_JButton.addActionListener(this);
        this.button_JPanel.add(this.help_JButton);
        this.getContentPane().add(this.button_JPanel);
    }

    public PortSecurityChild_JDialog(JApplet jApplet, Vector vector, Vector vector2) {
        this(jApplet, null);
        this.selectedPorts = vector;
        this.selectedDevices = vector2;
        this.psThread = new Thread((Runnable)this, "ps");
        this.calledFromPortPopup = true;
        this.psThread.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = 0;
        this.settingInfo = new Hashtable();
        this.modeInfo = new Hashtable();
        if (object == this.ok_JButton) {
            ((Component)this).setCursor(new Cursor(3));
            String string = this.maxAddress_JTextField.getText();
            if (!this.initialAddressCount.equals(string)) {
                try {
                    n = new Integer(string);
                    if (n < 1 || n > 132) {
                        JOptionPane.showMessageDialog(this, "Invalid Max Address Count value.\nPlease enter an integer between 1 to 132", "Error: Port Security", 0);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(this, "Invalid Max Address Count value.\nPlease enter an integer between 1 to 132", "Error: Port Security", 0);
                    return;
                }
            }
            int n2 = 0;
            while (n2 < this.selectedPorts.size()) {
                this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n2);
                if (this.security_JCombo.getSelectedItem().equals("Disable") && this.initialSecurity.indexOf((String)this.security_JCombo.getSelectedItem()) == -1) {
                    this.selectedSwitch.Cli.setPortSecurityStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                    this.updateIsNeeded = true;
                } else if (this.shutdown_JCombo.getSelectedItem().equals("Enable") && this.initialShutdown.indexOf((String)this.shutdown_JCombo.getSelectedItem()) == -1) {
                    this.getSettings();
                    if (!(this.checkForPortMonitor(n2) || this.checkForNetworkPort(n2) || this.checkForGroupPort(n2) || this.isPortMultiVlan(n2) || this.isPortTrunk(n2) || this.isPortDynamicAccess(n2))) {
                        this.selectedSwitch.Cli.setPortSecurityShutdownStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Enable");
                        this.selectedSwitch.Cli.setPortSecurityTrapStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Enable");
                        if (this.trap_JCombo.getSelectedItem().equals("Disable") && (this.initialTrap.equals(" ") || this.initialTrap.indexOf((String)this.trap_JCombo.getSelectedItem()) != -1)) {
                            this.selectedSwitch.Cli.setPortSecurityTrapStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                        }
                        this.updateIsNeeded = true;
                    }
                } else if (this.security_JCombo.getSelectedItem().equals("Disable") && this.initialSecurity.indexOf((String)this.security_JCombo.getSelectedItem()) == -1) {
                    this.selectedSwitch.Cli.setPortSecurityStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                    this.updateIsNeeded = true;
                } else if (this.security_JCombo.getSelectedItem().equals("Enable") && this.initialSecurity.indexOf((String)this.security_JCombo.getSelectedItem()) == -1) {
                    this.getSettings();
                    if (!(this.checkForPortMonitor(n2) || this.checkForNetworkPort(n2) || this.checkForGroupPort(n2) || this.isPortMultiVlan(n2) || this.isPortTrunk(n2) || this.isPortDynamicAccess(n2))) {
                        this.selectedSwitch.Cli.setPortSecurityStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Enable");
                        if (this.trap_JCombo.getSelectedItem().equals("Disable") && (this.initialTrap.equals(" ") || this.initialTrap.indexOf((String)this.trap_JCombo.getSelectedItem()) != -1)) {
                            this.selectedSwitch.Cli.setPortSecurityTrapStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                        }
                        if (this.shutdown_JCombo.getSelectedItem().equals("Disable") && (this.initialShutdown.equals(" ") || this.initialShutdown.indexOf((String)this.shutdown_JCombo.getSelectedItem()) != -1)) {
                            this.selectedSwitch.Cli.setPortSecurityShutdownStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                        }
                        this.updateIsNeeded = true;
                    }
                } else if (this.trap_JCombo.getSelectedItem().equals("Enable") && this.initialTrap.indexOf((String)this.trap_JCombo.getSelectedItem()) == -1) {
                    this.selectedSwitch.Cli.setPortSecurityTrapStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Enable");
                    this.updateIsNeeded = true;
                } else if (this.trap_JCombo.getSelectedItem().equals("Disable") && this.initialTrap.indexOf((String)this.trap_JCombo.getSelectedItem()) == -1) {
                    this.selectedSwitch.Cli.setPortSecurityTrapStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                    this.updateIsNeeded = true;
                } else if (this.shutdown_JCombo.getSelectedItem().equals("Disable") && this.initialShutdown.indexOf((String)this.shutdown_JCombo.getSelectedItem()) == -1) {
                    this.selectedSwitch.Cli.setPortSecurityShutdownStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), "Disable");
                    this.updateIsNeeded = true;
                }
                if (!this.initialAddressCount.equals(string)) {
                    this.selectedSwitch.Cli.setPortSecurityMaxSecCnt(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(n2), n);
                    this.updateIsNeeded = true;
                }
                ++n2;
            }
            if (this.updateIsNeeded && !this.calledFromPortPopup) {
                this.updateTableModel();
                this.updateIsNeeded = false;
            }
            ((Component)this).setCursor(new Cursor(0));
            this.dispose();
        } else if (object == this.cancel_JButton) {
            this.dispose();
        } else if (object == this.help_JButton) {
            HelpDialog.Factory.showHelp((JApplet)this.theApplet, (String)"prtsecdg");
        } else if (object == this.security_JCombo) {
            if (((String)this.security_JCombo.getSelectedItem()).equals("Enable")) {
                this.trap_JCombo.setSelectedItem("Enable");
            } else {
                this.trap_JCombo.setSelectedItem("Disable");
                this.shutdown_JCombo.setSelectedItem("Disable");
            }
        } else if (object == this.trap_JCombo) {
            if (((String)this.trap_JCombo.getSelectedItem()).equals("Enable")) {
                this.security_JCombo.setSelectedItem("Enable");
            }
        } else if (object == this.shutdown_JCombo && ((String)this.shutdown_JCombo.getSelectedItem()).equals("Enable")) {
            this.security_JCombo.setSelectedItem("Enable");
            this.trap_JCombo.setSelectedItem("Enable");
        }
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    boolean checkForGroupPort(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("g")) {
            this.index = this.getTruePortIndex(n);
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a group port.\n" + "Group Port can not be a secured port.", "Error: Port Security", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean checkForNetworkPort(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("n") || this.portSettings[this.index - 1].equals("ng")) {
            this.index = this.getTruePortIndex(n);
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a network port.\n" + "Network Port can not be a secured port.", "Error: Port Security", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean checkForPortMonitor(int n) {
        this.index = this.getTruePortIndex(n);
        this.portSettings = (String[])this.settingInfo.get(this.selectedSwitch);
        if (this.portSettings[this.index - 1].equals("m")) {
            this.index = this.getTruePortIndex(n);
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a monitor port.\n" + "Monitor port can not be a secured port.", "Error: Port Security", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    void getSettings() {
        if (!this.settingInfo.isEmpty()) {
            if (!this.settingInfo.containsKey(this.selectedSwitch)) {
                this.settingInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllPortsSetting(this.selectedSwitch.esn));
                this.modeInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllVLANsMode(this.selectedSwitch.esn));
            }
        } else {
            this.settingInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllPortsSetting(this.selectedSwitch.esn));
            this.modeInfo.put(this.selectedSwitch, this.selectedSwitch.Cli.getAllVLANsMode(this.selectedSwitch.esn));
        }
    }

    public int getTruePortIndex(int n) {
        int n2 = 0;
        this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(n);
        if (((String)this.selectedPorts.elementAt(n)).indexOf("0/") != -1) {
            if (((String)this.selectedPorts.elementAt(n)).indexOf("gig") != -1) {
                if (this.selectedSwitch.getName().indexOf("3508") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
                } else if (this.selectedSwitch.getName().indexOf("3512") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 12;
                } else if (this.selectedSwitch.getName().indexOf("3524") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 24;
                } else if (this.selectedSwitch.getName().indexOf("3548") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 48;
                } else if (this.selectedSwitch.getName().indexOf("2950T") != -1) {
                    n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1))) + 24;
                }
            } else {
                n2 = new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
            }
        } else if (((String)this.selectedPorts.elementAt(n)).indexOf("1/") != -1) {
            n2 = this.selectedSwitch.slot0PortNumbers + new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
        } else if (((String)this.selectedPorts.elementAt(n)).indexOf("2/") != -1) {
            n2 = this.selectedSwitch.slot0PortNumbers + this.selectedSwitch.slot1PortNumbers + new Integer(new String(((String)this.selectedPorts.elementAt(n)).substring(((String)this.selectedPorts.elementAt(n)).indexOf("/") + 1)));
        }
        return n2;
    }

    boolean isPortDynamicAccess(int n) {
        this.index = this.getTruePortIndex(n);
        this.modeSettings = (String[])this.modeInfo.get(this.selectedSwitch);
        if (this.modeSettings[this.index - 1].indexOf("Dynamic") != -1) {
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a dynamic access port.\n" + "Dynamic access port can not be a secured port.\n", "Error: Port Security", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean isPortMultiVlan(int n) {
        this.index = this.getTruePortIndex(n);
        this.modeSettings = (String[])this.modeInfo.get(this.selectedSwitch);
        if (this.modeSettings[this.index - 1].equals("Multi-VLAN")) {
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  has Multi-VLAN mode.\n" + "Multi-VLAN port can not be a secured port.\n", "Error: Port Security", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    boolean isPortTrunk(int n) {
        this.index = this.getTruePortIndex(n);
        this.modeSettings = (String[])this.modeInfo.get(this.selectedSwitch);
        if (this.modeSettings[this.index - 1].indexOf("Trunk") != -1) {
            JOptionPane.showMessageDialog(this, "Port " + (String)this.selectedPorts.elementAt(n) + " on Device '" + ((CommonSwitch)this.selectedDevices.elementAt((int)n)).switchName + "',  is a Trunk.\n" + "Trunk port can not be a secured port.\n", "Error: Port Security", 0);
            ((Component)this).setCursor(new Cursor(3));
            return true;
        }
        return false;
    }

    public void run() {
        ((Component)this).setCursor(new Cursor(3));
        if (this.selectedPorts.size() == 1) {
            if (this.calledFromPortPopup) {
                this.selectedSwitch = (CommonSwitch)this.selectedDevices.elementAt(0);
                this.initialSecurity = this.selectedSwitch.Cli.getPortSecurityStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(0));
                this.initialTrap = this.selectedSwitch.Cli.getPortSecurityTrapStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(0));
                this.initialShutdown = this.selectedSwitch.Cli.getPortSecurityShutdownStatus(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(0));
                this.initialAddressCount = this.selectedSwitch.Cli.getPortSecurityMaxSecCnt(this.selectedSwitch.esn, (String)this.selectedPorts.elementAt(0));
            } else {
                this.ps_TableModel = this.ps_JDialog.portSecurity_JTable.getModel();
                int n = 0;
                while (n < this.ps_TableModel.getRowCount()) {
                    if (((String)this.ps_TableModel.getValueAt(n, 0)).equals(this.selectedPorts.elementAt(0))) {
                        this.initialSecurity = (String)this.ps_TableModel.getValueAt(n, 1);
                        this.initialTrap = (String)this.ps_TableModel.getValueAt(n, 2);
                        this.initialShutdown = (String)this.ps_TableModel.getValueAt(n, 3);
                        this.initialAddressCount = (String)this.ps_TableModel.getValueAt(n, 5);
                    }
                    ++n;
                }
            }
            this.security_JCombo.removeItem(" ");
            this.trap_JCombo.removeItem(" ");
            this.shutdown_JCombo.removeItem(" ");
            this.security_JCombo.setSelectedItem(this.initialSecurity.indexOf("Enable") != -1 ? "Enable" : "Disable");
            this.trap_JCombo.setSelectedItem(this.initialTrap.indexOf("Enable") != -1 ? "Enable" : "Disable");
            this.shutdown_JCombo.setSelectedItem(this.initialShutdown.indexOf("Enable") != -1 ? "Enable" : "Disable");
            this.maxAddress_JTextField.setText(this.initialAddressCount);
        }
        ((Component)this).setCursor(new Cursor(0));
    }

    public GridBagConstraints setGridBagConstraints(GridBagConstraints gridBagConstraints, int n, int n2, double d, double d2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        gridBagConstraints.anchor = n6;
        gridBagConstraints.fill = n3;
        gridBagConstraints.gridheight = n11;
        gridBagConstraints.gridwidth = n12;
        gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        return gridBagConstraints;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void updateTableModel() {
        this.ps_JDialog.portSecurity_CustomModel.getDataFromDevice(this.selectedSwitch);
        this.ps_JDialog.portSecurity_JTable.sizeColumnsToFit(-1);
    }
}

