/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.cpnm.boot.internal.compression.decoder;

import com.cisco.cpnm.boot.internal.ArchiveReader;
import com.cisco.cpnm.boot.internal.SgzReader;
import com.cisco.cpnm.boot.internal.compression.codec.HuffmanEncoder_0th_Order;
import com.cisco.cpnm.boot.internal.compression.codec.ICodec1_7;
import com.cisco.cpnm.boot.internal.compression.codec.StartStepStopEncoder;
import com.cisco.cpnm.boot.internal.compression.codec.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class Decoder1_7
implements ICodec1_7,
ArchiveReader {
    private ArchiveReader mDelegate;

    public Decoder1_7(InputStream in) throws IOException {
        this.mDelegate = new Inner_SgzReader(in);
    }

    public byte[] getElementData() throws IOException {
        return this.mDelegate.getElementData();
    }

    public int getElementStatus() throws IOException {
        return this.mDelegate.getElementStatus();
    }

    public String getNextElement() throws IOException {
        return this.mDelegate.getNextElement();
    }

    public int getElementSize() {
        return this.mDelegate.getElementSize();
    }

    public void close() throws IOException {
        this.mDelegate.close();
    }

    private static class Inner_SgzReader
    extends SgzReader {
        private ByteArrayInputStream mEncodingTableBais;
        private ByteArrayInputStream mUtf8DeltasTableBais;
        private ByteArrayInputStream mUtf8IndicesTableBais;
        private ByteArrayInputStream mMethodsLengthsTableBais;
        private ByteArrayInputStream mMethodsPositionsTableBais;
        private ByteArrayInputStream mMethodsBais;
        private DataInputStream mMethodsDis;
        private boolean mIsReadyToReadClassfileElements;
        private final int mBufSize = 512;
        public int mHeadersCombinedStatus = 1;
        private boolean mNumUTF8ConstantsIsShort = true;
        private HuffmanEncoder_0th_Order mUtf8DeltasEncoder;
        private StartStepStopEncoder mMethodPositionsSSSEncoder = null;
        private StartStepStopEncoder mMethodLengthsSSSEncoder = null;
        private int[][] mMethodsPosLenTable;
        private int[][] mUtf8PosIdxTable;
        private int[] mUtf8DeltaPosIdx_2_tuplesOffset;
        private int[] mMethodsPosLen_2_tuplesOffset;
        private byte[][] mUtf8Table;
        private byte[] vBuffer;
        private ByteArrayOutputStream vBaos;
        private Object[] vMutableArguments;
        private boolean vIsPolymorphic_getElementData;
        private byte[] vLast_super_getElementData;
        private byte[] vLast_getElementData;

        private static boolean status1IsLessThanStatus2(int status1, int status2) {
            int statusOrder1 = -1;
            switch (status1) {
                case 2: {
                    statusOrder1 = 0;
                    break;
                }
                case 0: {
                    statusOrder1 = 1;
                    break;
                }
                case 1: {
                    statusOrder1 = 2;
                    break;
                }
            }
            int statusOrder2 = -1;
            switch (status2) {
                case 2: {
                    statusOrder2 = 0;
                    break;
                }
                case 0: {
                    statusOrder2 = 1;
                    break;
                }
                case 1: {
                    statusOrder2 = 2;
                    break;
                }
            }
            return statusOrder1 < statusOrder2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Inner_SgzReader(InputStream in) throws IOException {
            super(in);
            try {
                this.mMethodLengthsSSSEncoder = new StartStepStopEncoder(5, 2, 17);
                this.mMethodPositionsSSSEncoder = new StartStepStopEncoder(5, 2, 17);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            this.mUtf8DeltaPosIdx_2_tuplesOffset = new int[]{0};
            this.mMethodsPosLen_2_tuplesOffset = new int[]{0};
            this.vBuffer = new byte[512];
            this.vBaos = new ByteArrayOutputStream();
            this.vMutableArguments = null;
            this.vIsPolymorphic_getElementData = true;
            this.vLast_super_getElementData = null;
            this.vLast_getElementData = null;
            try {
                try {
                    int minStatus = this.mHeadersCombinedStatus;
                    byte[] encodingTableData = this.getExpectedData("$0Encoding_Table");
                    int status = this.getElementStatus();
                    if (Inner_SgzReader.status1IsLessThanStatus2(status, minStatus)) {
                        minStatus = status;
                    }
                    this.mEncodingTableBais = new ByteArrayInputStream(encodingTableData);
                    byte[] utf8DeltasTableData = this.getExpectedData("$1UTF_Deltas");
                    status = this.getElementStatus();
                    if (Inner_SgzReader.status1IsLessThanStatus2(status, minStatus)) {
                        minStatus = status;
                    }
                    this.mUtf8DeltasTableBais = new ByteArrayInputStream(utf8DeltasTableData);
                    byte[] utf8IndicesTableData = this.getExpectedData("$2UTF_Indexes");
                    status = this.getElementStatus();
                    if (Inner_SgzReader.status1IsLessThanStatus2(status, minStatus)) {
                        minStatus = status;
                    }
                    this.mUtf8IndicesTableBais = new ByteArrayInputStream(utf8IndicesTableData);
                    byte[] methodsLengthsTableData = this.getExpectedData("$3Method_Lengths");
                    status = this.getElementStatus();
                    if (Inner_SgzReader.status1IsLessThanStatus2(status, minStatus)) {
                        minStatus = status;
                    }
                    this.mMethodsLengthsTableBais = new ByteArrayInputStream(methodsLengthsTableData);
                    byte[] methodsPositionsTableData = this.getExpectedData("$4Method_Positions");
                    status = this.getElementStatus();
                    if (Inner_SgzReader.status1IsLessThanStatus2(status, minStatus)) {
                        minStatus = status;
                    }
                    this.mMethodsPositionsTableBais = new ByteArrayInputStream(methodsPositionsTableData);
                    byte[] methodsData = this.getExpectedData("$5Methods");
                    status = this.getElementStatus();
                    if (Inner_SgzReader.status1IsLessThanStatus2(status, minStatus)) {
                        minStatus = status;
                    }
                    this.mMethodsBais = new ByteArrayInputStream(methodsData);
                    this.mMethodsDis = new DataInputStream(this.mMethodsBais);
                    this.mIsReadyToReadClassfileElements = true;
                    this.mHeadersCombinedStatus = minStatus;
                    this.mMethodsPosLenTable = this.getMethodsPosLen_2_tuples();
                    this.vMutableArguments = new Object[1];
                    this.mUtf8Table = this.readEncodingTable(this.vMutableArguments);
                    HuffmanEncoder_0th_Order mUtf8DeltasEncoder = (HuffmanEncoder_0th_Order)this.vMutableArguments[0];
                    this.mUtf8PosIdxTable = this.getUtf8DeltaPosIdx_2_tuples(mUtf8DeltasEncoder, this.mNumUTF8ConstantsIsShort);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    Object var12_15 = null;
                }
                Object var12_14 = null;
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                throw throwable;
            }
        }

        public byte[] getElementData() throws IOException {
            if (this.isPolymorphic_getElementData()) {
                byte[] rv = null;
                byte[] super_getElementData = super.getElementData();
                if (this.mIsReadyToReadClassfileElements) {
                    if (super_getElementData == this.vLast_super_getElementData) {
                        rv = this.vLast_getElementData;
                    } else {
                        byte[] codedClassfileBytes = super_getElementData;
                        rv = this.decodeClassfileBytes(codedClassfileBytes, this.mUtf8Table, this.mUtf8PosIdxTable, this.mUtf8DeltaPosIdx_2_tuplesOffset, this.mMethodsDis, this.mMethodsPosLenTable, this.mMethodsPosLen_2_tuplesOffset);
                    }
                } else {
                    rv = super_getElementData;
                }
                this.vLast_super_getElementData = super_getElementData;
                this.vLast_getElementData = rv;
                return rv;
            }
            return super.getElementData();
        }

        public int getElementStatus() throws IOException {
            this.setPolymorphic_getElementData(false);
            int rv = super.getElementStatus();
            this.setPolymorphic_getElementData(true);
            if (this.mIsReadyToReadClassfileElements && Inner_SgzReader.status1IsLessThanStatus2(this.mHeadersCombinedStatus, rv)) {
                rv = this.mHeadersCombinedStatus;
            }
            return rv;
        }

        protected void setPolymorphic_getElementData(boolean b) {
            this.vIsPolymorphic_getElementData = b;
        }

        protected boolean isPolymorphic_getElementData() {
            return this.vIsPolymorphic_getElementData;
        }

        public String getNextElement() throws IOException {
            String rv = null;
            String codeName = super.getNextElement();
            if (codeName == null) {
                this.mIsReadyToReadClassfileElements = false;
            }
            if (codeName != null && this.mIsReadyToReadClassfileElements) {
                int codeNameInt = -1;
                try {
                    codeNameInt = Integer.decode(codeName);
                    rv = Util.constant_Utf8_InfoToString(this.mUtf8Table[codeNameInt]);
                    rv = rv.substring(rv.indexOf("-") + 1) + ".class";
                }
                catch (Exception e) {
                    throw new IOException("ERROR in getNextElement(), could not match the codename to a classfile name.");
                }
                this.getElementData();
            } else {
                rv = codeName;
            }
            return rv;
        }

        private int[][] getMethodsPosLen_2_tuples() throws IOException, Exception {
            int[][] rv = new int[][]{};
            int[] positionsText = null;
            int[] lengthsText = null;
            positionsText = this.mMethodPositionsSSSEncoder.decode(Util.toByteArray(this.mMethodsPositionsTableBais, this.vBuffer));
            lengthsText = this.mMethodLengthsSSSEncoder.decode(Util.toByteArray(this.mMethodsLengthsTableBais, this.vBuffer));
            this.mMethodsPositionsTableBais.reset();
            this.mMethodsLengthsTableBais.reset();
            rv = new int[positionsText.length][];
            int i = 0;
            while (i < positionsText.length) {
                rv[i] = new int[]{positionsText[i], lengthsText[i]};
                ++i;
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int[][] getPosIdxOrLen_2_tuples(byte[] codedClassfileBytes, int[][] utf8DeltaPosIdx_2_tuples, int[] rv3Utf8DeltaPosIdx_2_tuplesOffset, int[] rv2PreambleLength, int[][] methodsPosLen_2_tuples, int[] rv4MethodsPosLen_2_tuplesOffset) {
            int[][] rv = new int[][]{};
            ByteArrayInputStream bais = null;
            DataInputStream dis = null;
            int numUTF8s = 0;
            int numMethods = 0;
            try {
                bais = new ByteArrayInputStream(codedClassfileBytes);
                dis = new DataInputStream(bais);
                numUTF8s = dis.readInt();
                numMethods = dis.readInt();
                rv2PreambleLength[0] = codedClassfileBytes.length - bais.available();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                System.exit(1);
            }
            finally {
                if (bais != null) {
                    try {
                        Object var16_21;
                        try {
                            bais.close();
                        }
                        catch (Exception e) {
                            var16_21 = null;
                            bais = null;
                        }
                        var16_21 = null;
                        bais = null;
                    }
                    catch (Throwable throwable) {
                        Object var16_22 = null;
                        bais = null;
                        throw throwable;
                    }
                }
            }
            int[][] posIdxs = new int[numUTF8s][];
            int i = 0;
            while (i < numUTF8s) {
                posIdxs[i] = utf8DeltaPosIdx_2_tuples[rv3Utf8DeltaPosIdx_2_tuplesOffset[0] + i];
                if (i > 0) {
                    int[] nArray = posIdxs[i];
                    nArray[0] = nArray[0] + posIdxs[i - 1][0];
                }
                ++i;
            }
            rv = new int[numUTF8s + numMethods][];
            System.arraycopy(posIdxs, 0, rv, 0, numUTF8s);
            System.arraycopy(methodsPosLen_2_tuples, rv4MethodsPosLen_2_tuplesOffset[0], rv, numUTF8s, numMethods);
            int i2 = numUTF8s;
            while (i2 < rv.length) {
                rv[i2][1] = -rv[i2][1];
                ++i2;
            }
            Arrays.sort(rv, new Comparator(this){
                private final /* synthetic */ Inner_SgzReader this$0;
                {
                    this.this$0 = this$0;
                }

                public int compare(Object obj1, Object obj2) {
                    int pos1 = ((int[])obj1)[0];
                    int pos2 = ((int[])obj2)[0];
                    return pos1 - pos2;
                }
            });
            rv3Utf8DeltaPosIdx_2_tuplesOffset[0] = rv3Utf8DeltaPosIdx_2_tuplesOffset[0] + numUTF8s;
            rv4MethodsPosLen_2_tuplesOffset[0] = rv4MethodsPosLen_2_tuplesOffset[0] + numMethods;
            return rv;
        }

        private byte[][] readEncodingTable(Object[] mutableArguments) throws IOException, Exception {
            byte[][] rv = new byte[][]{};
            DataInputStream dis = new DataInputStream(this.mEncodingTableBais);
            this.mEncodingTableBais.reset();
            HuffmanEncoder_0th_Order positionDeltasHuffmanEncoder = HuffmanEncoder_0th_Order.readTable(dis, 4);
            mutableArguments[0] = positionDeltasHuffmanEncoder;
            int numconstants = dis.readInt();
            rv = new byte[numconstants][];
            HuffmanEncoder_0th_Order lengthsHuffmanEncoder = HuffmanEncoder_0th_Order.readTable(dis, 2);
            int codedLengthsNumBytes = dis.readInt();
            byte[] codedLengths = new byte[codedLengthsNumBytes];
            int i = 0;
            while (i < codedLengthsNumBytes) {
                codedLengths[i] = dis.readByte();
                ++i;
            }
            byte[][] lengths = lengthsHuffmanEncoder.unnormalize(lengthsHuffmanEncoder.getHuffmanTable().decode(codedLengths));
            int i2 = 0;
            while (i2 < numconstants) {
                byte length1 = lengths[i2][0];
                byte length2 = lengths[i2][1];
                int length = (int)Util.unsignedLong(length1, length2);
                rv[i2] = new byte[length + 3];
                rv[i2][0] = 1;
                rv[i2][1] = length1;
                rv[i2][2] = length2;
                int j = 3;
                while (j < rv[i2].length) {
                    rv[i2][j] = dis.readByte();
                    ++j;
                }
                ++i2;
            }
            return rv;
        }

        private byte[][] partiallyReadMethodsTable(DataInputStream methodsDis, int[] methodLengths) throws IOException {
            byte[][] rv = new byte[methodLengths.length][];
            int i = 0;
            while (i < methodLengths.length) {
                rv[i] = new byte[methodLengths[i]];
                int j = 0;
                while (j < rv[i].length) {
                    rv[i][j] = methodsDis.readByte();
                    ++j;
                }
                ++i;
            }
            return rv;
        }

        /*
         * Unable to fully structure code
         */
        private int[][] getUtf8DeltaPosIdx_2_tuples(HuffmanEncoder_0th_Order positionDeltasEncoder, boolean numConstantsIsShort) throws IOException, Exception {
            block10: {
                block9: {
                    rv = new int[][]{};
                    codedPositionDeltasText = null;
                    indicesText = null;
                    dis = new DataInputStream(this.mUtf8DeltasTableBais);
                    codedDeltaAL = new ArrayList<Byte>();
                    block4: while (true) {
                        try {
                            codedDeltaAL.add(new Byte(dis.readByte()));
                        }
                        catch (EOFException eof) {
                            this.mUtf8DeltasTableBais.reset();
                            codedPositionDeltasText = new byte[codedDeltaAL.size()];
                            i = 0;
lbl15:
                            // 2 sources

                            while (i < codedPositionDeltasText.length) {
                                break block4;
                            }
                            break block9;
                        }
                    }
                    codedPositionDeltasText[i] = (Byte)codedDeltaAL.get(i);
                    ++i;
                    ** GOTO lbl15
                }
                codedDeltaAL.clear();
                dis = new DataInputStream(this.mUtf8IndicesTableBais);
                indicesAL = new ArrayList<Integer>();
                block6: while (true) {
                    try {
                        tempLong = 0L;
                        tempLong = numConstantsIsShort != false ? Util.unsignedLong(dis.readShort()) : Util.unsignedLong(dis.readInt());
                        indicesAL.add(new Integer((int)tempLong));
                    }
                    catch (EOFException eof) {
                        this.mUtf8IndicesTableBais.reset();
                        indicesText = new int[indicesAL.size()];
                        i = 0;
lbl37:
                        // 2 sources

                        while (i < indicesText.length) {
                            break block6;
                        }
                        break block10;
                    }
                }
                indicesText[i] = (Integer)indicesAL.get(i);
                ++i;
                ** GOTO lbl37
            }
            indicesAL.clear();
            positions = positionDeltasEncoder.unnormalize(positionDeltasEncoder.getHuffmanTable().decode(codedPositionDeltasText));
            rv = new int[positions.length][];
            i = 0;
            while (i < positions.length) {
                text = positions[i];
                tempInt = Util.fromTextToInt(text[0], text[1], text[2], text[3]);
                rv[i] = new int[]{tempInt, indicesText[i]};
                ++i;
            }
            return rv;
        }

        private byte[] getExpectedData(String expectedElementName) throws IOException {
            String elementName = this.getNextElement();
            if (!elementName.equals(expectedElementName)) {
                throw new IOException("Expected to read " + expectedElementName + " but found " + elementName + " instead.");
            }
            return this.getElementData();
        }

        private byte[] decodeClassfileBytes(byte[] encodedClassfileBytes, byte[][] utf8Table, int[][] utf8DeltaPosIdx_2_tuples, int[] rvUtf8DeltaPosIdx_2_tuplesOffset, DataInputStream methodsDis, int[][] methodsPosLenTable, int[] rvMethodsPosLen_2_tuplesOffset) throws IOException {
            byte[] rvDecodedClassfileBytes = null;
            int[] encodedBytesMinusPreambleOffset = new int[1];
            int[][] posIdxOrLen_2_tuples = this.getPosIdxOrLen_2_tuples(encodedClassfileBytes, utf8DeltaPosIdx_2_tuples, rvUtf8DeltaPosIdx_2_tuplesOffset, encodedBytesMinusPreambleOffset, methodsPosLenTable, rvMethodsPosLen_2_tuplesOffset);
            int numMethods = 0;
            int i = 0;
            while (i < posIdxOrLen_2_tuples.length) {
                if (posIdxOrLen_2_tuples[i][1] < 0) {
                    ++numMethods;
                }
                ++i;
            }
            int[] methodLengths = new int[numMethods];
            int i2 = 0;
            int k = 0;
            while (i2 < posIdxOrLen_2_tuples.length) {
                if (posIdxOrLen_2_tuples[i2][1] < 0) {
                    methodLengths[k] = -posIdxOrLen_2_tuples[i2][1];
                    ++k;
                }
                ++i2;
            }
            byte[][] methodsBytcodes = this.partiallyReadMethodsTable(methodsDis, methodLengths);
            int length = encodedClassfileBytes.length - encodedBytesMinusPreambleOffset[0];
            int i3 = 0;
            while (i3 < posIdxOrLen_2_tuples.length) {
                length = posIdxOrLen_2_tuples[i3][1] >= 0 ? (length += utf8Table[posIdxOrLen_2_tuples[i3][1]].length) : (length -= posIdxOrLen_2_tuples[i3][1]);
                ++i3;
            }
            rvDecodedClassfileBytes = new byte[length];
            int i4 = 0;
            int methodIdx = 0;
            int sourceOffset = encodedBytesMinusPreambleOffset[0];
            int curLength = 0;
            while (curLength < rvDecodedClassfileBytes.length) {
                byte[] byteSequence = null;
                int startPos = rvDecodedClassfileBytes.length;
                if (i4 < posIdxOrLen_2_tuples.length) {
                    if (posIdxOrLen_2_tuples[i4][1] >= 0) {
                        byteSequence = utf8Table[posIdxOrLen_2_tuples[i4][1]];
                    } else {
                        byteSequence = methodsBytcodes[methodIdx];
                        ++methodIdx;
                    }
                    int endPosExclusive = posIdxOrLen_2_tuples[i4][0];
                    startPos = endPosExclusive - byteSequence.length;
                }
                int lengthToCopyFromSource = startPos - curLength;
                System.arraycopy(encodedClassfileBytes, sourceOffset, rvDecodedClassfileBytes, curLength, lengthToCopyFromSource);
                sourceOffset += lengthToCopyFromSource;
                curLength += lengthToCopyFromSource;
                if (i4 < posIdxOrLen_2_tuples.length) {
                    System.arraycopy(byteSequence, 0, rvDecodedClassfileBytes, curLength, byteSequence.length);
                    curLength += byteSequence.length;
                }
                ++i4;
            }
            return rvDecodedClassfileBytes;
        }
    }
}

