/*
 *------------------------------------------------------------------
 * toolbar.js
 *
 * Copyright (c) 2003-2006 by cisco Systems, Inc.
 * All rights reserved.
 *------------------------------------------------------------------
 */

// constants used for aligning the toolbar icons.
var LEFT = 1;
var RIGHT = 2;

// preloading the cisco logo.
// The other toolbar icons need to be preloaded in their respective pages.
var tb_logo_off = new Image();  tb_logo_off.src = "images/logo.gif";

// The icon constructor
function Icon(name, tip, fn, url, align) {
	this.name = name;	// The unique name of the icon.
	this.tooltip = tip;	// The tooltip that needs to be displayed for this icon
	this.action = fn;	// The method that needs to be executed on clicking this icon
	this.url = url;		// TBD: 
	this.align = align;	// The alignment of the icon LEFT or RIGHT.
	this.id = 0;		// The index of this icon in the Toolbar icons array.
	this.draw = _drawIcon;	// Method to draw this icon.
}

// handlTbClick method will be called on clicking on any of the toolbar
// icons.
function handleTbClick(id) {
	if(toolbar.frozen) {
		alert(toolbar.freezeReason);
		return;
	}
	if((id != null) && (toolbar.icons[id].action)) {
		toolbar.icons[id].action();
	}
}

// _drawIcon returns the html code for displaying the icons.
function _drawIcon() {
	var str ="<td border='0' cellpadding='0' cellspacing='0'>";
	str += "<table id='tb"+this.id+"' border='0' cellpadding='0' cellspacing='0' onMouseOver='makeButton(&quot;tb"+this.id+"&quot;);' onmouseout='clearButton(&quot;tb"+this.id+"&quot;);' onMouseDown='makeButtonDown(&quot;tb"+this.id+"&quot;);' onClick='handleTbClick(" + this.id + ");'>";
	str += "<tr>";
	str += "<td width='3' border='1'><img name='tb"+this.id+"left' src='/images/toolbarGradient3px.gif' width='3' height='38' alt=''></td>";
	if (this.name == "forward")
	{
		str += "<td nowrap class='cuesToolbarCell' id='tb"+this.id+"center' >"+this.tooltip+"<img class='cuesToolbarIconright'   src='/images/toolbar_"+this.name+".gif'  width='15' height='24' border='0' alt='' ></td>";
	}
	else if (this.name == "back")
	{
		str += "<td nowrap class='cuesToolbarCell' id='tb"+this.id+"center' ><img class='cuesToolbarIconleft' src='/images/toolbar_"+this.name+".gif' width='15' height='24' border='0' alt=''>"+this.tooltip+"</td>";
	}
	else if (this.name == "help")
	{
		str += "<td nowrap class='cuesToolbarCell' id='tb"+this.id+"center' ><img class='cuesToolbarIconleft' src='/images/toolbar_"+this.name+".gif' width='16' height='24' border='0' alt=''>"+this.tooltip+"</td>";
	}
	else if (this.name == "legend")
	{
		str += "<td nowrap class='cuesToolbarCell' id='tb"+this.id+"center' ><img class='cuesToolbarIconleft' src='/images/toolbar_"+this.name+".gif' width='17' height='24' border='0' alt=''>"+this.tooltip+"</td>";
	}
	else
	{
		str += "<td nowrap class='cuesToolbarCell' id='tb"+this.id+"center' ><img class='cuesToolbarIconleft' src='/images/toolbar_"+this.name+".gif'  width='24' height='24' border='0' alt=''>"+this.tooltip+"</td>";
	}
	str += "<td width='3'><img name='tb"+this.id+"right' src='/images/toolbarGradient3px.gif' width='3' height='38' alt='' ></td>";
	str += "</tr>";
	str += "</table>";
	str += "</td>";
	return str;
}

// The toolbar constructor.
function Toolbar() {
	this.icons = new Array();	// The icons in this toolbar
	this.addIcon = _addTbIcon;	// The method to add the toolbar icon.
	this.draw = _drawToolbar;	// Method to draw the toolbar.
	this.leftIcons = 0;			// The count of icons that need to be aligned to the left
	this.freeze = _freezeToolbar;	// Method to freeze the toolbar
	this.unFreeze = _unFreezeToolbar;	// Method to unfreeze the toolbar
	this.frozen = false;		// Variable to store the freeze state.
	this.freezeReason = null;	// The reason for freezing the toolbar.
}

// _freezeToolbar method will freeze the toolbar. No action will
// be performed on clicking the toolbar icons.
function _freezeToolbar(reason) {
	if(reason == null)
		return;
	this.freezeReason = reason;
	this.frozen = true;
}

// _unFreezeToolbar method will freeze the toolbar.
function _unFreezeToolbar() {
	this.freezeReason = null;
	this.frozen = false;
}

// Function to add the toolbar icon.
function _addTbIcon(icon) {
	icon.id = this.icons.length;
	this.icons[this.icons.length] = icon;
	if(icon.align == LEFT) this.leftIcons++;
}

function spacer() {
	var str = "<td width='5'><img width='5' src='images/spacer.gif'></img></td>"
	return str;
}

// Function to draw the cisco logo
function drawLogo() {
	var str = "";
	/*var	deviceType = find_string(/bytes of memory./," ",1, document.forms[0].SHOW_VERSION.value);
	if(deviceType == "WS-CE500-24TT" || deviceType == "WS-CE500-24LC" || deviceType == "WS-CE500G-12TC" || deviceType == "WS-CE500-24PC") {
		str += "<td width='110' valign='middle' nowrap>";
		str += "<input type='button' value='Register Now' onclick='regSubmit();'>&nbsp;&nbsp;";
		str += "</td>";
	}*/
	str += "<td width='70' nowrap>";
	str += "<a href='http://www.cisco.com' target='_cisco'><img src='" + tb_logo_off.src + "' height='34' title='' onClick='' style='border:none'></img></a>";
	str += "</td>";
	return str;
}

var toolbarObject = null;
// Function to draw the toolbar
function _drawToolbar() {
	toolbarObject = this;
	var str = "<table border='0' cellspacing='0' cellpadding='0' height='34' width=100% id='toolTable'><tr>";
	for (var i=0; i<this.icons.length; i++) {
		str += this.icons[i].draw();
//		if (i == (this.leftIcons-1)) {	// Ignore the alignment specified. Draw all icons to the left
		if (i == (this.icons.length-1)) {
			str += "<td width='100%'>&nbsp;</td>";
		}
	}
	str += drawLogo();
	str += "</tr></table>";
	return str;
}

/* Creates toolbar button effect on rollover, to be called in onMouseOver and onMouseUp event */
function makeButton(id) {
var idR = id+'right';
var idL = id+'left';
var idC = id+'center';
newImage = "url(/images/toolbar_button_tile.gif)";
document.getElementById(id).style.backgroundImage = newImage;
document[idL].src='/images/toolbar_button_left.gif';
document[idR].src='/images/toolbar_button_right.gif';
document.getElementById(idC).style.color = "#000000";
}

/* Creates toolbar button down on mouse click, to be called in onMouseDown event */
function makeButtonDown(id) {
var idR = id+'right';
var idL = id+'left';
var idC = id+'center';
newImage = "url(/images/toolbarButtonDownTile.gif)";
document.getElementById(id).style.backgroundImage = newImage;
document[idL].src='/images/toolbarButtonDownLeft.gif';
document[idR].src='/images/toolbarButtonDownRight.gif';
document.getElementById(idC).style.color = "#FFFFFF";
}

/* Returns toolbar button to original state on mouse out, to be called in onMouseOut event */
function clearButton(id) {
var idR = id+'right';
var idL = id+'left';
var idC = id+'center';
newImage = "url(/images/toolbarGradient.gif)";
document.getElementById(id).style.backgroundImage = newImage;
document[idL].src='/images/toolbarGradient3px.gif';
document[idR].src='/images/toolbarGradient3px.gif';
document.getElementById(idC).style.color = "#000000";
}
